<?php
/*
 *  Prestashop (http://prestashop.com)
 *  Credit Card Module - Allows currently running stores to
 *  	accept creditcard information through their online
 * 		shop. The information is then stored in the database
 * 		in an encrypted form.  It can then be decrypted at a
 * 		later time for charges through an existing gateway
 * 		(ie. a cash register).
 *
 * 	This module was originally adapted from the BankWire module that comes
 * 	standard with Prestashop. It has since been COMPLETELY and TOTALLY redesigned.
 *  The only remaining parts from the BankWire module are the Currencies functions.
 * 
 * 	7/09/2008 - Kevin Klika (Ox40)
 */
 
class CreditCard extends PaymentModule
{	
	private $_html = '';
	private $_postErrors = array();
	public  $currencies, $bf, $path;
	public 	$requireCVC;

	function __construct()
	{
		$this->name = 'creditcard';
		$this->displayName = 'creditcard';
		$this->tab = 'Payment';
		$this->version = 2.05;
		
		$this->idOrderState = Configuration::get('CREDIT_CARD_ID_ORDER_STATE');
		$this->curVersionFileURL = 'http://Ox40.us/cc_Current.txt';
		$this->bf = new Blowfish(_COOKIE_KEY_, _COOKIE_IV_);			//Create Blowfish Object for Encryption

		if (!Configuration::get('CREDIT_CARD_CURRENCIES'))				//If, for some reason, there are no currencies, make them
			$this->_makeCurrencies();
		
		$config = Configuration::get('CREDIT_CARD_CURRENCIES');
		$this->currencies 	= isset($config['CREDIT_CARD_CURRENCIES']) ? $config['CREDIT_CARD_CURRENCIES'] : null;

		$this->requireCVC = Configuration::get('CREDIT_CARD_REQUIRE_CVC');
		parent::__construct();

		/* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Credit Card');
		$this->description = $this->l('Accept offline payments by credit card');
		$this->path = $this->_path;
	}

	/**
	*	install()
	*	Called when 'Install' is clicked on module
	*/
	function install()
	{
		if(parent::install())
		{
			$this->registerHook('payment');				//Register Payment Hooks with Prestashop
			$this->registerHook('paymentReturn');
			$this->registerHook('invoice');
			
			$this->_makeCurrencies();					//Create Default Currencies
			
			$this->_makeOrderState();					//Create Credit Card Order State
			
			Configuration::updateValue('CREDIT_CARD_REQUIRE_CVC', 'TRUE');
			
			/**
			*	Create the table to store credit card data
			*/
			$db = Db::getInstance();
			$result = $db->Execute("show table status like `"._DB_PREFIX_."`");
			if($result == "")
			{
				$query = "CREATE TABLE `"._DB_PREFIX_."order_credit_data` (
					`id_record` INT NOT NULL AUTO_INCREMENT PRIMARY KEY ,
					`id_order` INT NOT NULL ,
					`data_string` TEXT NOT NULL ,
					`date_add` DATE ,
					`date_upd` DATE
					) ENGINE = MYISAM ";
				$db->Execute($query);
			}
		}
		else
			return false;
	}

	function uninstall()
	{
		Configuration::deleteByName('CREDIT_CARD_CURRENCIES');
		Configuration::deleteByname('CREDIT_CARD_REQUIRE_CVC');
		parent::uninstall();
	}

	/**
	*	getContent()
	*	Called in Back Office when user clicks "Configure"
	*/
	function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';		//Display Header
		
		if (!empty($_POST)){
			$this->_postValidation();
			if (!sizeof($this->_postErrors))
				$this->_postProcess();
			else
				foreach ($this->_postErrors AS $err)
					$this->_html .= "<div class='alert error'>{$err}</div>";
		} else
			$this->_html .= "<br />";

		$this->_displayCreditCard();
		$this->_displayForm();

		return $this->_html;
	}

	/**
	*	execPayment($cart)
	*	Called from payment.php
	*/
	function execPayment($cart)
	{
		$errName = '0';
		$errNumber = '0';
		$errCVC = '0';
		
		if(isset($_POST['paymentSubmit']))
		{
			$cardName       	= $_POST['cardName'];
        	$cardNumber     	= $_POST['cardNumber'];
        	$cardCVC     		= $_POST['cardCVC'];
        	$cardFromDate_mo     = $_POST['fromDate_Month'];
        	$cardFromDate_yr     = $_POST['fromDate_Year'];
        	$cardexpDate_mo     = $_POST['expDate_Month'];
        	$cardexpDate_yr     = $_POST['expDate_Year'];
        	$issue_num     = $_POST['issue_num'];
			
			if($cardName == "" || !Validate::isName($cardName))
				$errName = '1';
			if(!$this->validateCard($cardNumber))
				$errNumber = '1';
			if(strlen($cardCVC) < 2 || strlen($cardCVC) > 4)
				$errCVC = '1';
				
			if($errName == '1' || $errNumber == '1' || $errCVC == '1')
			{
				global $cookie, $smarty;
		
				$currencies = Currency::getCurrencies();
				$authorized_currencies = array_flip(explode(',', $this->currencies));
				$currencies_used = array();
				foreach ($currencies as $key => $currency)
					if (isset($authorized_currencies[$currency['id_currency']]))
						$currencies_used[] = $currencies[$key];
							
					$smarty->assign(array(
						'errName'			=> $errName,
						'errNumber'			=> $errNumber,
						'errCVC'			=> $errCVC,
						'cardName'			=> $cardName,
						'cardNumber'		=> $cardNumber,
						'cardCVC'			=> $cardCVC,
						'currency_default' 	=> new Currency(Configuration::get('PS_CURRENCY_DEFAULT')),
						'currencies' 		=> $currencies_used,
						'total' 			=> number_format($cart->getOrderTotal(true, 3), 2, '.', ''),
						'requireCVC'		=> Configuration::get('CREDIT_CARD_REQUIRE_CVC'),
						'this_path' 		=> $this->_path,
						'this_path_ssl' 	=> Configuration::get('PS_FO_PROTOCOL').$_SERVER['HTTP_HOST'].__PS_BASE_URI__."modules/{$this->name}/"));
		
				return $this->display(__FILE__, 'payment_execution.tpl');
			}
			else
			{
				/* Create Necessary variables for order placement */	
					$cardString = "Name: {$cardName} <br/>";
					$cardString .= " Card Number: {$cardNumber} <br/>";
					$cardString .= $this->requireCVC == "TRUE" ? "Card CVC: {$cardCVC} <br/>" : "";
					$cardString .= " Card Frm: {$cardFromDate_mo} / {$cardFromDate_yr} <br/>";
					$cardString .= " Card Exp: {$cardexpDate_mo} / {$cardexpDate_yr}<br />";
					$cardString .= " Issue: {$issue_num}";
					$cardString = pSQL($this->bf->encrypt($cardString), true);
					
					$currency = new Currency(intval(isset($_POST['currency_payement']) ? $_POST['currency_payement'] : $cookie->id_currency));
					$total = floatval(number_format($cart->getOrderTotal(true, 3), 2, '.', ''));
				
					$this->validateOrder($cart->id, $this->idOrderState, $total, $this->displayName, null, $currency->id);
					
				/* Insert Credit Card String into the database for the current order.*/
					$order = new Order($this->currentOrder);
					$this->addDataString($order->id, $cardString);
					
				/* Once complete, redirect to order-confirmation.php */	
					Tools::redirectLink(__PS_BASE_URI__."order-confirmation.php?id_cart={$cart->id}&id_module={$this->id}&id_order={$this->currentOrder}&key={$order->secure_key}");
			}
		}
		else
		{
			global $cookie, $smarty;
	
			$currencies = Currency::getCurrencies();
			$authorized_currencies = array_flip(explode(',', $this->currencies));
			$currencies_used = array();
			foreach ($currencies as $key => $currency)
				if (isset($authorized_currencies[$currency['id_currency']]))
					$currencies_used[] = $currencies[$key];
						
				$smarty->assign(array(
					'currency_default' 	=> new Currency(Configuration::get('PS_CURRENCY_DEFAULT')),
					'currencies' 		=> $currencies_used,
					'total' 			=> number_format($cart->getOrderTotal(true, 3), 2, '.', ''),
					'requireCVC'		=> Configuration::get('CREDIT_CARD_REQUIRE_CVC'),
					'this_path' 		=> $this->_path,
					'this_path_ssl' 	=> Configuration::get('PS_FO_PROTOCOL').$_SERVER['HTTP_HOST'].__PS_BASE_URI__."modules/{$this->name}/"));
	
			return $this->display(__FILE__, 'payment_execution.tpl');
		}
	}

	/**
	*	hookPayment($params)
	*	Called in Front Office at Payment Screen
	*/
	function hookPayment($params)
	{
		global $smarty;
		
		$smarty->assign(array(
            'this_path' 		=> $this->_path,
            'this_path_ssl' 	=> Configuration::get('PS_FO_PROTOCOL').$_SERVER['HTTP_HOST'].__PS_BASE_URI__."modules/{$this->name}/"));
			
		return $this->display(__FILE__, 'payment.tpl');
	}
	
	/**
	*	hookInvoice($params)
	*	Called in Back Office upon Order Review
	*	Note: Only return data if an order is a Credit Card order.
	*/
	function hookInvoice($params)
	{
		$id_order = $params['id_order'];
		if($this->isCreditCardOrder($id_order))		
		{
			if(intval($_GET['remData']) == 1)
				$this->removeDataString($id_order);
				
			global $smarty;
			$data_string = $this->getDataString($id_order);
			$smarty->assign(array(
				'ccDataString' 		=> $this->bf->decrypt($data_string),
				'id_order'			=> $id_order,
				'this_page'			=> $_SERVER['REQUEST_URI'],
				'this_path' 		=> $this->_path,
            	'this_path_ssl' 	=> Configuration::get('PS_FO_PROTOCOL').$_SERVER['HTTP_HOST'].__PS_BASE_URI__."modules/{$this->name}/"));
			return $this->display(__FILE__, 'invoice_block.tpl');
		}
		else
			return "";
	}

	/**
	*	hookPaymentReturn($params)
	*	Called in Front Office upon order placement
	*/
	function hookPaymentReturn($params)
	{
		global $smarty;
		
		$state = $params['objOrder']->getCurrentState();
		
		if ($state == _PS_OS_OUTOFSTOCK_ or $state == $this->idOrderState)
			$smarty->assign(array(
				'total_to_pay' 	=> Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false, false),
				'status' 		=> 'ok',
				'id_order' 		=> $params['objOrder']->id
			));
		else
			$smarty->assign('status', 'failed');

		return $this->display(__FILE__, 'payment_return.tpl');
	}

	/**
	*	_postValidation()
	*	Called upon module configuration submit
	*/
	private function _postValidation()
	{
		if (isset($_POST['currenciesSubmit']))
		{
			$currencies = Currency::getCurrencies();
			$authorized_currencies = array();
			foreach ($currencies as $currency)
				if (isset($_POST['currency_'.$currency['id_currency']]) AND $_POST['currency_'.$currency['id_currency']])
					$authorized_currencies[] = $currency['id_currency'];
			if (!sizeof($authorized_currencies))
				$this->_postErrors[] = $this->l('At least one currency is required.');
		}
	}

	/**
	*	_postProcess()
	*	Called upon successful module configuration validation
	*/
	private function _postProcess()
	{
		if (isset($_POST['currenciesSubmit']))
		{
			$currencies = Currency::getCurrencies();
			$authorized_currencies = array();
			foreach ($currencies as $currency)
				if (isset($_POST['currency_'.$currency['id_currency']]) AND $_POST['currency_'.$currency['id_currency']])
					$authorized_currencies[] = $currency['id_currency'];
			Configuration::updateValue('CREDIT_CARD_CURRENCIES', implode(',', $authorized_currencies));
			
			/*Lang Variables*/ $modOk = $this->l('Ok'); $modUpdated = $this->l('Settings Updated Successfully');
			$this->_html .= "<div class='conf confirm'><img src='../img/admin/ok.gif' alt='{$modOk}' />{$modUpdated}</div>";
		}
		else if(isset($_POST['noupdate']))
		{
			Tools::redirectLink('http://Ox40.us/');
		}
		else if(isset($_POST['update']))
		{
			/*Lang Variables*/ $modError = $this->l('Error'); $modNoFunction = $this->l('Function Not Utilized Yet. Updates Must be Performed Manually');
			$this->_html .= "<div class='alert error'><img src='../img/admin/ok.gif' alt='{$modError}' />{$modNoFunction}</div>";
		}
		else if(isset($_POST['configSubmit']))
		{
			Configuration::updateValue('CREDIT_CARD_REQUIRE_CVC', strtoupper($_POST['requireCVC']) == 'TRUE' ? "TRUE" : "FALSE");
		}
		else if(isset($_POST['paymentSubmit']))
		{
			//asdf
		}
	}

	/**
	*	_displayCreditCard()
	*	Called in Back Office during Module Configuration
	*/
	private function _displayCreditCard()
	{
		$modDesc 	= $this->l('This module allows you to accept payments by credit card.');
		$modStatus	= $this->l('If the client chooses this payment type, the order status will change to \'Awaiting Credit Card Validation\'.');
		$modConfirm	= $this->l('Therefore, you will need to manually confirm the order as soon as you receive restitution.');
		$this->_html .= "<img src='../modules/creditcard/creditcard.jpg' style='float:left; margin-right:15px;' />
						<b>{$modDesc}</b><br /><br />
						{$modStatus}<br />
						{$modConfirm}<br /><br /><br />";
	}

	/**
	*	_displayForm()
	*	Called in Back Office during Module Configuration
	*/
	private function _displayForm()
	{
		global $smarty;
		$currencies_string = "";
		$currencies = Currency::getCurrencies();
		$authorized_currencies = array_flip(explode(',', Configuration::get('CREDIT_CARD_CURRENCIES')));
		foreach ($currencies as $currency)
		{
				$currencies_string .= '<label style="float:none; "><input type="checkbox" value="true" name="currency_'.$currency['id_currency'].'"'.(isset($authorized_currencies[$currency['id_currency']]) ? ' checked="checked"' : '').' />&nbsp;<span style="font-weight:bold;">'.$currency['name'].'</span> ('.$currency['sign'].')</label><br />';
		}
		$currentVersion = function_exists('file_get_contents') ? file_get_contents($this->curVersionFileURL) : "0.0 Website Unavailable";
		$smarty->assign(array(
				'currencies' => $currencies_string,
				'version' => $this->version,
				'current_version' => $currentVersion,
				'requireCVC' => Configuration::get('CREDIT_CARD_REQUIRE_CVC') ));				
        
		$this->_html .= $this->display(__FILE__,'admin_form.tpl');
	}
	
	/**
	*	makeCurrencies()
	*	Called from within creditcard.php if no default currencies exist
	*/
	public function _makeCurrencies()
	{
			$currencies = Currency::getCurrencies();
			$authorized_currencies = array();
			foreach ($currencies as $currency)
				$authorized_currencies[] = $currency['id_currency'];
			return Configuration::updateValue('CREDIT_CARD_CURRENCIES', implode(',', $authorized_currencies));
	}
	
	/**
	*	makeOrderState()
	*	An order state is necessary for this module to function.
	*	The id number of the order state is stored in a global configuration variable for use later
	*/
	private function _makeOrderState()
	{
		if(!(Configuration::get('CREDIT_CARD_ID_ORDER_STATE') > 0))
		{				
			$os = new OrderState();
			$os->name = array_fill(0,10,"Awaiting Credit Card Validation");	//Fill with english language translation
			$os->send_mail = 0;
			$os->template = "";
			$os->invoice = 0;
			$os->color = "#33FF99";
			$os->unremovable = false;
			$os->logable = 0;		
			$os->add();
			Configuration::updateValue('CREDIT_CARD_ID_ORDER_STATE',$os->id);
		}
	}
		
	/**
	*	isCreditCardOrder($id_order)
	*	Checks DB to see if an order used a creditcard
	*/
	public function isCreditCardOrder($id_order)
	{
		$db = Db::getInstance();
		$result = $db->getRow('
			SELECT * FROM `'._DB_PREFIX_.'order_credit_data`
			WHERE `id_order` = "'.$id_order.'"');

		return intval($result["id_order"]) != 0 ? true : false;
		
	}
	
	/**
	*	removeDataString($id_order)
	*	Removes credit card data from database upon order completion.
	*/
	public function removeDataString($id_order)
	{
		$removedString = pSQL($this->bf->encrypt("Credit Card Information Has Been Removed."), true);
		$db = Db::getInstance();
		$result = $db->Execute('
		UPDATE `'._DB_PREFIX_.'order_credit_data`
		SET `data_string` = "'.$removedString.'"
		WHERE `id_order` = "'.intval($id_order).'"');
	}
	
	/**
	*	addDataString($id_order, $data_string)
	*	Adds a data string to the database
	*/
	public function addDataString($id_order, $data_string)
	{
		$db = Db::getInstance();
		$result = $db->Execute('
		INSERT INTO `'._DB_PREFIX_.'order_credit_data`
		( `id_order`, `data_string` )
		VALUES
		("'.intval($id_order).'","'.$data_string.'")');
	}
	
	/**
	*	getDataString($id_order)
	*	Returns the associated credit card string from the database
	*/
	public function getDataString($id_order)
	{
		$db = Db::getInstance();
		$result = $db->ExecuteS('
		SELECT `data_string` FROM `'._DB_PREFIX_.'order_credit_data`
		WHERE `id_order` ="'.intval($id_order).'";');
		return $result[0]['data_string'];
	}
	
	/*
	 *	validateCard($cardnumber)
	 * 	Checks mod10 check digit of card, returns true if valid
	 */
	function validateCard($cardnumber)
	{
		$cardnumber = preg_replace("/\D|\s/", "", $cardnumber);  # strip any non-digits
		$cardlength = strlen($cardnumber);
		if ($cardlength != 0)
		{
			$parity = $cardlength % 2;
			$sum = 0;
			for ($i = 0; $i < $cardlength; $i++)
			{
				$digit = $cardnumber[$i];
				if ($i % 2 == $parity) $digit = $digit * 2;
					if ($digit > 9) $digit = $digit-9;
						$sum = $sum + $digit;
			}
			$valid = ($sum % 10 == 0);
			return $valid;
		}
		return false;
	}
}

?>
