<?php

class GoogleBase extends Module
{
	private $_html = '';
	private $_directory;
	private $_filename;
	private $_filename_http;
	private $_postErrors = array();
	private $_cookie;
	
	public function __construct()
	{
		global $cookie;
		$this->_cookie = $cookie;
		$this->name = 'googlebase';
		$this->tab = 'Tools';
		$this->version = 0.3;
		
		$this->_directory = dirname(__FILE__).'/../../';
		$this->_filename = $this->_directory.strtolower(Language::getIsoById($this->_cookie->id_lang)).'_googlebase.xml';
		$this->_filename_http = 'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.strtolower(Language::getIsoById($this->_cookie->id_lang)).'_googlebase.xml';
		
		parent::__construct();
		
		/* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Google Base Feed Products');
		$this->description = $this->l('Generate your products feed for Google Base. www.ecartservice.net');
	}
	
	public function uninstall()
	{
		foreach(Language::getLanguages() as $lang)
		{
			@unlink($this->_directory.strtolower($lang['iso_code']).'_googlebase.xml');
		}
		
		parent::uninstall();
	}
	
	private function _postValidation()
	{
		@unlink($this->_filename);
		$fp = fopen($this->_filename, 'wb');
		fclose($fp);
		if (!file_exists($this->_filename))
		{
			$this->_postErrors[] = $this->l('Cannot write').' '.realpath($this->_filename);
		}
	}
	
	private function _addToFeed($str)
	{
		if(file_exists($this->_filename))
		{
			$fp = fopen($this->_filename, 'ab');
			fwrite($fp, $str, strlen($str));
			fclose($fp);
		}
	}
	
	private function _postProcess()
	{
		$link = new Link();
		$Products = Product::getProducts(intval($this->_cookie->id_lang), 0, NULL, 'id_product', 'ASC');
		
		if($Products)
		{
			$this->_addToFeed("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
			$this->_addToFeed("\n");
			$this->_addToFeed("<rss version =\"2.0\" xmlns:g=\"http://base.google.com/ns/1.0\">
\n");
			$this->_addToFeed("\n");
            $this->_addToFeed("<channel>\n");
	        $this->_addToFeed("<title>Google Base feed for ".$_SERVER['HTTP_HOST']."</title>\n");
	        $this->_addToFeed("<description>Our fantastic range of products</description>\n");
	        $this->_addToFeed("<link>http://".$_SERVER['HTTP_HOST']."</link>\n");
			$this->_addToFeed("\n");

			foreach ($Products AS $Product)
			{
			  if ($Product['active']) {
				$image = Image::getImages(intval($this->_cookie->id_lang), $Product['id_product']);
				$this->_addToFeed("<item>\n");
				$this->_addToFeed("<title>".stripslashes(htmlspecialchars($Product['name']))."</title>\n");
				$this->_addToFeed("<g:brand>".stripslashes(htmlspecialchars($Product['manufacturer_name']))."</g:brand>\n"); 
				$this->_addToFeed("<g:condition>new</g:condition>\n");
				$this->_addToFeed("<description>".stripslashes(htmlspecialchars($Product['description_short']))."</description>\n");
				$expire_date = date('Y-m-d', strtotime("+30 days"));

                $this->_addToFeed("<g:expiration_date>$expire_date</g:expiration_date>\n"); 
				$this->_addToFeed("<g:id>"."pc".strtolower(Language::getIsoById($this->_cookie->id_lang))."-".$Product['id_product']."</g:id>\n");
				$this->_addToFeed("<guid>"."pc".strtolower(Language::getIsoById($this->_cookie->id_lang))."-".$Product['id_product']."</guid>\n");
				$this->_addToFeed("<g:image_link>".'http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__.'img/p/'.$image[0]['id_product'].'-'.$image[0]['id_image'].'-large.jpg'."</g:image_link>\n");
				$this->_addToFeed("<link>".'http://'.$_SERVER['HTTP_HOST'].htmlspecialchars($link->getProductLink($Product['id_product'], $Product['link_rewrite']))."</link>\n");
				$this->_addToFeed("<g:price>".Product::getPriceStatic(intval($Product['id_product']))."</g:price>\n");
				$this->_addToFeed("</item>\n");
				$this->_addToFeed("\n");
			  }
			}
			$this->_addToFeed("</channel>\n");
			$this->_addToFeed("</rss>\n");
		}
		
		$res = file_exists($this->_filename);
		$this->_html .= '<h3 class="'. ($res ? 'conf confirm' : 'alert error') .'" style="margin-bottom: 20px">';
		$this->_html .= $res ? $this->l('Feed file successfully generated') : $this->l('Error while creating feed file');
		$this->_html .= '</h3>';
	}
	
	private function _displayFeed()
	{
		if(file_exists($this->_filename))
		{
			$fp = fopen($this->_filename, 'rb');
			$fstat = fstat($fp);
			fclose($fp);
			
			$this->_html .= '<p>'.$this->l('Your Google Base feed file is online at the following address:').'<br /><a href="'.$this->_filename_http.'"><b>'.$this->_filename_http.'</b></a></p><br />';
			
			$this->_html .= $this->l('Update:').' <b>'.date('m.d.y G:i:s', $fstat['mtime']).'</b><br />';
		}
	}
	
	private function _displayForm()
	{
		$this->_html .=
			'<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
				<input name="btnSubmit" class="button" value="'.((!file_exists($this->_filename)) ? $this->l('Generate feed file') : $this->l('Update feed file')).'" type="submit" />
			</form>';
	}
	
	function getContent()
	{
		$this->_html .= '<h2>'.$this->l('Google Base Products Feed').'</h2>';
		
		if (!empty($_POST))
		{
			$this->_postValidation();
			if (!count($this->_postErrors))
			{
				$this->_postProcess();
			}
			else
			{
				foreach ($this->_postErrors AS $err)
				{
					$this->_html .= '<div class="error">'.$err.'</div>';
				}
			}
		}
 		else
		{
			$this->_html .= '<br />';
		}
			
		$this->_displayFeed();
		$this->_html .= '<br />';
		$this->_displayForm();
		
		return $this->_html;
	}
}
?>