<?php 

class LastOrders extends Module
{
	private $_html = '';
	private $_postErrors = array();

	function __construct()
	{
		$this->name = 'lastorders';
		$this->tab = 'Blocks';
		$this->version = 2.0;

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Last Orders 2.0');
		$this->description = $this->l('Displays last orders in a block-www.catalogo-onlinersi.com.ar');
	}

	function install()
	{
		if (!Configuration::updateValue('LAST_ORDERS_NBR', 10) OR !parent::install() OR !$this->registerHook('rightColumn'))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_SKIP_CAT', 1))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_NBR2', 1))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_COLOR', 'yes'))
			return false;
				if (!Configuration::updateValue('LAST_ORDERS_COLOR2', 'yes'))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_COLOR3', 'yes'))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_WIDTH', '180'))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_HEIGHT', '240'))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_ALIGN', '1'))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_NUMBER', '5'))
			return false;
			if (!Configuration::updateValue('LAST_ORDERS_SORT', 'DESC'))
			return false;
		return true;
		
	}

	public function getContent()
	{
		
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitLastOrders'))
		{
			$nbr = intval(Tools::getValue('nbr'));
			$skipcat = Tools::getValue('skipcat');
			$nbr2 = Tools::getValue('nbr2');
			$color = Tools::getValue('color');
				$color2 = Tools::getValue('color2');
				$color3 = Tools::getValue('color3');
			$number = Tools::getValue('number');
			$width = Tools::getValue('width');
			$height = Tools::getValue('height');
			$align = Tools::getValue('align');
			$sort = Tools::getValue('sort');
			if (!$nbr OR $nbr <= 0 OR !Validate::isInt($nbr))
				$errors[] = $this->l('Invalid number of products');
			else
				Configuration::updateValue('LAST_ORDERS_NBR', $nbr);
				Configuration::updateValue('LAST_ORDERS_NBR2', $nbr2);
				Configuration::updateValue('LAST_ORDERS_COLOR', $color);
					Configuration::updateValue('LAST_ORDERS_COLOR2', $color2);
							Configuration::updateValue('LAST_ORDERS_COLOR3', $color3);
				Configuration::updateValue('LAST_ORDERS_ALIGN', $align);
				Configuration::updateValue('LAST_ORDERS_WIDTH', $width);
				Configuration::updateValue('LAST_ORDERS_HEIGHT', $height);
				Configuration::updateValue('LAST_ORDERS_NUMBER', $number);
				Configuration::updateValue('LAST_ORDERS_SORT', $sort);
				
		if (!empty($skipcat))
				Configuration::updateValue('LAST_ORDERS_SKIP_CAT', implode(',',$skipcat));

	
			if (isset($errors) AND sizeof($errors))
				$output .= $this->displayError(implode('<br />', $errors));
				
			else
				$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
		
$xml2 = fopen ("../modules/lastorders/style.css", "w");
 
      fwrite ($xml2, '
#marqueecontainer{
position: relative;
width: '.$width.'px; /*marquee width */
height: '.$height.'px; /*marquee height */
overflow: hidden;
/*border: 3px solid orange;*/
padding: 2px;
padding-left: 4px;
}
');
fwrite ($xml2, "");
		return $output.$this->displayForm();
	}
	function recurseCategory($categories, $current, $id_category = 1, $selectids_array)
	{
		global $currentIndex;		

		echo '<option value="'.$id_category.'"'.(in_array($id_category,$selectids_array) ? ' selected="selected"' : '').'>'.
		str_repeat('&nbsp;', $current['infos']['level_depth'] * 5) . preg_replace('/^[0-9]+\./', '', stripslashes($current['infos']['name'])) . '</option>';
		if (isset($categories[$id_category]))
			foreach ($categories[$id_category] AS $key => $row)
				$this->recurseCategory($categories, $categories[$id_category][$key], $key, $selectids_array);
	}

	public function displayForm()
	{
		global $cookie,$currentIndex;
		$output = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset><legend><img src="'.$this->_path.'order.jpg" alt="" title="" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Number of orders to display').'</label>
				<div class="margin-form">
					<input type="text" size="5" name="nbr" value="'.Tools::getValue('nbr', Configuration::get('LAST_ORDERS_NBR')).'" />
					<p class="clear">'.$this->l('The number of orders to display (default: 10)').'</p>
					
				
		</div>
			<label>'.$this->l('Region').'</label>
				<div class="margin-form">
					<select name="color3" id="color3">
					<option value="'.Tools::getValue('color3', Configuration::get('LAST_ORDERS_COLOR3')).'" selected="selected" >'.Tools::getValue('color3', Configuration::get('LAST_ORDERS_COLOR3')).'</option>
						<option value="yes">yes</option>
						<option value="no">no</option>
	
					</select>
					<p class="clear">'.$this->l('show the region, country of delivery').'</p>
					
				
		</div>
			<label>'.$this->l('Speed').'</label>
				<div class="margin-form">
					<input type="text" size="5" name="nbr2" value="'.Tools::getValue('nbr2', Configuration::get('LAST_ORDERS_NBR2')).'" />
					<p class="clear">'.$this->l('Speed of the scroll (1 to 10)').'</p>
					
				
		</div>
		<label>'.$this->l('Date').'</label>
				<div class="margin-form">
					
					<select name="color" id="color">
					<option value="'.Tools::getValue('color', Configuration::get('LAST_ORDERS_COLOR')).'" selected="selected" >'.Tools::getValue('color', Configuration::get('LAST_ORDERS_COLOR')).'</option>
						<option value="yes">yes</option>
						<option value="no">no</option>
	
					</select>
					<p class="clear">'.$this->l('Show date').'</p>
					
					
				
		</div>
		
			<label>'.$this->l('Total').'</label>
				<div class="margin-form">
					
					<select name="color2" id="color2">
					<option value="'.Tools::getValue('color2', Configuration::get('LAST_ORDERS_COLOR2')).'" selected="selected" >'.Tools::getValue('color2', Configuration::get('LAST_ORDERS_COLOR2')).'</option>
						<option value="yes">yes</option>
						<option value="no">no</option>
	
					</select>
					<p class="clear">'.$this->l('Show total price').'</p>
					
					
				
		</div>
		
		<label>'.$this->l('Display order more than').'</label>
				<div class="margin-form">
					<input type="text" size="5" name="align" value="'.Tools::getValue('align', Configuration::get('LAST_ORDERS_ALIGN')).'" />
					<p class="clear">'.$this->l('The minimum value to display a order').'</p>
					
				
		</div>	
		
		<label>'.$this->l('Width').'</label>
				<div class="margin-form">
					<input type="text" size="5" name="width" value="'.Tools::getValue('width', Configuration::get('LAST_ORDERS_WIDTH')).'" />
					<p class="clear">'.$this->l('Width of the block (default 180)').'</p>
					
				
		</div>
		<label>'.$this->l('Height').'</label>
				<div class="margin-form">
					<input type="text" size="5" name="height" value="'.Tools::getValue('height', Configuration::get('LAST_ORDERS_HEIGHT')).'" />
					<p class="clear">'.$this->l('Height of the module(default 240)').'</p>
					
				
		</div>
		
				   <label>'.$this->l('Choice of sort').'</label>
				<div class="margin-form">
					<select name="sort" id="sort">
						<option value="ASC" '.(Configuration::get('LAST_ORDERS_SORT') == 'ASC' ? 'selected' : '').'>'.$this->l('ASC').'</option>
						<option value="DESC" '.(Configuration::get('LAST_ORDERS_SORT') == 'DESC' ? 'selected' : '').'>'.$this->l('DESC').'</option>
				<option value="RAND()" '.(Configuration::get('LAST_ORDERS_SORT') == 'RAND()' ? 'selected' : '').'>'.$this->l('RAND()').'</option>
					</select>
				</div>
				<center><input type="submit" name="submitLastOrders" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>						
		</form>';
		return $output;
	}

public function getProductscath($idcat, $id_lang, $p, $n, $orderBy = NULL, $orderWay = NULL)
	{
		global $cookie;
	
		

	
		if (empty($idcat))
		{
			return false;
		}

		if ($p < 1) $p = 1;
		if (empty($orderBy))
			$orderBy = 'position';
		if (empty($orderWay))
			$orderWay = 'ASC';
		if ($orderBy == 'id_product' OR	$orderBy == 'price' OR	$orderBy == 'date_add')
			$orderByPrefix = 'p';
		elseif ($orderBy == 'name')
			$orderByPrefix = 'pl';
		elseif ($orderBy == 'manufacturer')
		{
			$orderByPrefix = 'm';
			$orderBy = 'name';
		}
		elseif ($orderBy == 'position')
			$orderByPrefix = 'cp';

		$sql = '
		SELECT p.*, pa.`id_product_attribute`, pl.`description`, pl.`description_short`, pl.`available_now`, pl.`available_later`, pl.`link_rewrite`, pl.`meta_description`, pl.`meta_keywords`, pl.`meta_title`, pl.`name`, i.`id_image`, il.`legend`, m.`name` AS manufacturer_name, tl.`name` AS tax_name, t.`rate`, cl.`name` AS category_default, DATEDIFF(p.`date_add`, DATE_SUB(NOW(), INTERVAL '.(Validate::isUnsignedInt(Configuration::get('PS_NB_DAYS_NEW_PRODUCT')) ? Configuration::get('PS_NB_DAYS_NEW_PRODUCT') : 20).' DAY)) > 0 AS new
		            
		FROM `'._DB_PREFIX_.'category_product` cp
		LEFT JOIN `'._DB_PREFIX_.'product` p ON p.`id_product` = cp.`id_product`
		LEFT JOIN `'._DB_PREFIX_.'product_attribute` pa ON (p.`id_product` = pa.`id_product` AND default_on = 1)
		LEFT JOIN `'._DB_PREFIX_.'category_lang` cl ON (p.`id_category_default` = cl.`id_category` AND cl.`id_lang` = '.intval($id_lang).')
		LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product` AND pl.`id_lang` = '.intval($id_lang).')
		LEFT JOIN `'._DB_PREFIX_.'image` i ON (i.`id_product` = p.`id_product` AND i.`cover` = 1)
		LEFT JOIN `'._DB_PREFIX_.'image_lang` il ON (i.`id_image` = il.`id_image` AND il.`id_lang` = '.intval($id_lang).')
		LEFT JOIN `'._DB_PREFIX_.'tax` t ON (t.`id_tax` = p.`id_tax`)
		LEFT JOIN `'._DB_PREFIX_.'tax_lang` tl ON (t.`id_tax` = tl.`id_tax` AND tl.`id_lang` = '.intval($id_lang).')
		LEFT JOIN `'._DB_PREFIX_.'manufacturer` m ON (m.`id_manufacturer` = p.`id_manufacturer`)
		WHERE cp.`id_category` IN ('.$idcat.') AND p.`active` = 1
		GROUP BY cp.`id_product`
		ORDER BY '.(isset($orderByPrefix) ? $orderByPrefix.'.' : '').'`'.pSQL($orderBy).'` '.pSQL($orderWay).'
		LIMIT '.((intval($p) - 1) * intval($n)).','.intval($n);
		
		$result = Db::getInstance()->ExecuteS($sql);
		
		if ($orderBy == 'price')
			Tools::orderbyPrice($result, $orderWay);
		if (!$result)
			return false;

		/* Modify SQL result */
		return Product::getProductsProperties($id_lang, $result);
	}

	function hookRightColumn($params)
	{
		global $smarty;
$category = new Category($skipcategory);
$nb = intval(Configuration::get('LAST_ORDERS_NBR'));
$langs = 1;
$nbr2 = Configuration::get('LAST_ORDERS_nbr2');
$color = Configuration::get('LAST_ORDERS_COLOR');
$color2 = Configuration::get('LAST_ORDERS_COLOR2');
$color3 = Configuration::get('LAST_ORDERS_COLOR3');
$number = Configuration::get('LAST_ORDERS_NUMBER');
$width = Configuration::get('LAST_ORDERS_WIDTH');
$height = Configuration::get('LAST_ORDERS_HEIGHT');
$align = Configuration::get('LAST_ORDERS_ALIGN');
$sort = Configuration::get('LAST_ORDERS_SORT');
		
//crear XML//
	global $smarty, $cookie, $link;
		
		$orders = Db::getInstance()->ExecuteS('
		SELECT  o.id_order, o.id_customer, od.product_name, o.date_upd, p.id_product , od.product_id, p.id_category_default, pl.name AS productname, pl.link_rewrite, a.id_state, a.id_country, s.name AS state_name, c.name AS country_name, o.total_paid ,o.id_currency, cu.sign
		FROM '._DB_PREFIX_.'orders o
		LEFT JOIN '._DB_PREFIX_.'order_detail od ON (od.id_order = o.id_order)
		LEFT JOIN '._DB_PREFIX_.'currency cu ON (cu.id_currency = o.id_currency)
		LEFT JOIN '._DB_PREFIX_.'product p ON (p.id_product = od.product_id)
		LEFT JOIN '._DB_PREFIX_.'product_lang pl ON (pl.id_product = p.id_product)
		LEFT JOIN '._DB_PREFIX_.'category_lang cl ON (id_category = p.id_category_default)
		LEFT JOIN '._DB_PREFIX_.'address a ON (a.id_customer = o.id_customer)
		LEFT JOIN '._DB_PREFIX_.'country_lang c ON (c.id_country = a.id_country and c.id_lang = '.intval($cookie->id_lang).')
		LEFT JOIN '._DB_PREFIX_.'state s ON (s.id_state = a.id_state)
		WHERE  o.total_paid > '.$align.' 
		GROUP BY o.id_order 
		ORDER BY  o.id_order '.$sort.'
		LIMIT '.$nb.'
		'); 


	  





			$smarty->assign(array(
		'orders' => $orders,
			'name' => $name,
			'link2' => $link2,
			'nbr2' => $nbr2,
				'color2' => $color2,
			'color3' => $color3,
			'color' => $color,
			'state2' => $state2,
			'country2' => $country2
			));
		return $this->display(__FILE__, 'lastorders.tpl');
	}
	function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}

}
?>