<?php

/******************************
*    Module StatTrackVisits   *
*    Author: Raphael Havez    *
*    www.coffret-intime.fr    *
*   You like this Module?     *
*  You can make a Donation!   *
* If you want, and if you can,*
*    with Paypal to email     *
* paiement@coffret-intime.fr  *
*          Thanks :)          *
******************************/
  
class StatsTrackVisits extends Module
{
    private $_html = '';

    function __construct()
    {
        $this->name = 'statstrackvisits';
        $this->tab = 'Stats';
        $this->version = 1.1;
		$this->page = basename(__FILE__, '.php');
			
		parent::__construct();
		
        $this->displayName = $this->l('Tracking visitors');
        $this->description = $this->l('Allows you to track your visitors on your website, and see her origin.');
    }
	
	public function install()
	{
		return (parent::install() AND $this->registerHook('AdminStatsModules'));
	}
	
	private function getPageView($id_connections)
	{
		return Db::getInstance()->ExecuteS('
		SELECT pt.name, cp.time_start, p.id_object, p.id_page
		FROM `'._DB_PREFIX_.'connections` c
		LEFT JOIN `'._DB_PREFIX_.'connections_page` cp ON c.id_connections = cp.id_connections
		INNER JOIN `'._DB_PREFIX_.'page` p ON cp.id_page = p.id_page
		INNER JOIN `'._DB_PREFIX_.'page_type` pt ON pt.id_page_type = p.id_page_type
		WHERE '.( ereg("^1.1", _PS_VERSION_ ) ? 'c.`date_add` LIKE \''.pSQL(ModuleGraph::getDateLike()).'\'' : '(c.`date_add` BETWEEN '.ModuleGraph::getDateBetween().')' ).'
		AND c.id_connections = '.$id_connections.'
		ORDER BY cp.time_start');
	}
	
	private function getComeBack($ip_address,$id_guest)
	{
		return Db::getInstance()->ExecuteS('
		SELECT *
		FROM `'._DB_PREFIX_.'connections` c
		WHERE '.( ereg("^1.1", _PS_VERSION_ ) ? 'c.`date_add` LIKE \''.pSQL(ModuleGraph::getDateLike()).'\'' : '(c.`date_add` BETWEEN '.ModuleGraph::getDateBetween().')' ).'
		AND (c.ip_address = '.$ip_address.' OR c.id_guest = '.$id_guest.')
		');
	}
	
	private function ShowName($name, $id_object,$id_lang,$id_page)
	{		
		switch ($name) 
		{
			case 'index.php':
				return '<b>'.$this->l('Homepage').'</b>';
				break;
			case 'product.php':
				$sql = Db::getInstance()->ExecuteS('
				SELECT name
				FROM `'._DB_PREFIX_.'product_lang`
				WHERE id_product = '.$id_object.'
				AND id_lang = '.$id_lang.'
				');
				return '<b>'.$this->l('Product :').'</b> '.$sql[0]['name'];
				break;
			case 'category.php':
				$sql = Db::getInstance()->ExecuteS('
				SELECT name
				FROM `'._DB_PREFIX_.'category_lang`
				WHERE id_category = '.$id_object.'
				AND id_lang = '.$id_lang.'
				');
				return '<b>'.$this->l('Category :').'</b> '.$sql[0]['name'];
				break;
			case 'order.php':
				$sql = Db::getInstance()->ExecuteS('
				SELECT id_object
				FROM `'._DB_PREFIX_.'page`
				WHERE id_page = '.$id_page.'
				');
				$showname = $sql[0]['id_object'] == 0 ? '1 - '.$this->l('Cart'): $showname;
				$showname = $sql[0]['id_object'] == 1 ? '2 - '.$this->l('Address'): $showname;
				$showname = $sql[0]['id_object'] == 2 ? '3 - '.$this->l('Transport and GCS'): $showname;
				$showname = $sql[0]['id_object'] == 3 ? '4 - '.$this->l('Payment options'): $showname;
				return '<b style="color: green;">'.$this->l('Order :').'</b> '.$showname;
				break;
			case '404.php':
				return '<b style="color: red;">'.$this->l('Error : Page 404.php').'</b> ';		
				break;
			case 'my-account.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('Homepage');
				break;
			case 'history.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My orders');
				break;
			case 'order-slip.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My credits');
				break;
			case 'address.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My addresses');
				break;
			case 'identity.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My personal information');
				break;
			case 'discount.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My vouchers');
				break;
			case 'authentication.php':
				return '<b style="color: blue;">'.$this->l('Authentication or subscription').'</b> ';
				break;
			case 'modules/cheque/payment.php':
				return '<b style="color: green;">'.$this->l('Order :').'</b> 5 - '.$this->l('Cheque payment');
				break;
			case 'modules/bankwire/payment.php':
				return '<b style="color: green;">'.$this->l('Order :').'</b> 5 - '.$this->l('Bank wire payment');
				break;
			case 'modules/cashondelivery/validation.php':
				return '<b style="color: green;">'.$this->l('Order :').'</b> 5 - '.$this->l('Payment on delivery');
				break;
			case 'manufacturer.php':
				return '<b>'.$this->l('Manufacturer').'</b>';
				break;
			case 'best-sales.php':
				return '<b>'.$this->l('Best sales').'</b>';
				break;
			case 'sitemap.php':
				return '<b>'.$this->l('Sitemap').'</b>';
				break;
			case 'prices-drop.php':
				return '<b>'.$this->l('Specials').'</b>';
				break;
			case 'contact-form.php':
				return '<b>'.$this->l('Contact form').'</b>';
				break;
			case 'search.php':
				return '<b>'.$this->l('Search').'</b>';
				break;
			case 'cms.php':
				return '<b>'.$this->l('CMS pages :').'</b> '.$this->l('GCS, legal,...');
				break;
			case 'new-products.php':
				return '<b>'.$this->l('New products').'</b>';
				break;
			case 'modules/sendtoafriend/sendtoafriend-form.php':
				return '<b>'.$this->l('Send to a friend').'</b>';
				break;
			case 'modules/productquestion/productquestion-form.php':
				return '<b>'.$this->l('Product question form').'</b>';
				break;
			default:
				return $name;
		}
	}
	
	private function getCustomers($resultperpage,$page, $limit, $orderby, $orderbyobject, $http_referer, $showstep)
	{
		return Db::getInstance()->ExecuteS('
		SELECT u.id_customer, u.firstname, u.lastname, c.ip_address, c.date_add, c.http_referer, c.id_connections, c.id_guest
		FROM `'._DB_PREFIX_.'connections` c
		LEFT JOIN `'._DB_PREFIX_.'connections_page` cp ON c.id_connections = cp.id_connections
		INNER JOIN `'._DB_PREFIX_.'guest` g ON c.id_guest = g.id_guest
		INNER JOIN `'._DB_PREFIX_.'customer` u ON u.id_customer = g.id_customer
		INNER JOIN `'._DB_PREFIX_.'page` p ON p.id_page = cp.id_page
		WHERE '.( ereg("^1.1", _PS_VERSION_ ) ? 'c.`date_add` LIKE \''.pSQL(ModuleGraph::getDateLike()).'\'' : '(c.`date_add` BETWEEN '.ModuleGraph::getDateBetween().')' ).'
		'.( $http_referer ? 'AND c.http_referer LIKE \''.$http_referer.'\'' : '' ).'
		'. ( $showstep == 'error' ? 'AND p.id_page_type = 8' : ( $showstep == 'anypage' ? '' : 'AND p.id_page_type = 3 AND p.'.$showstep.'' )) .'
		GROUP BY c.id_connections
		ORDER BY '.$orderbyobject.' '.$orderby.'
		'.($limit == 1 ? 'LIMIT '.(($page*$resultperpage)-$resultperpage).', '.$resultperpage : '').''
		);
	}
	
	private function getVisitors($resultperpage, $page, $limit, $orderby, $orderbyobject, $http_referer, $showstep)
	{
		return Db::getInstance()->ExecuteS('
		SELECT c.id_guest, c.ip_address, c.date_add, c.http_referer, c.id_connections, c.id_guest
		FROM `'._DB_PREFIX_.'connections` c
		LEFT JOIN `'._DB_PREFIX_.'connections_page` cp ON c.id_connections = cp.id_connections
		INNER JOIN `'._DB_PREFIX_.'guest` g ON c.id_guest = g.id_guest
		INNER JOIN `'._DB_PREFIX_.'page` p ON p.id_page = cp.id_page
		WHERE (g.id_customer IS NULL OR g.id_customer = 0)
		AND '.( ereg("^1.1", _PS_VERSION_ ) ? 'c.`date_add` LIKE \''.pSQL(ModuleGraph::getDateLike()).'\'' : '(c.`date_add` BETWEEN '.ModuleGraph::getDateBetween().')' ).'
		'.( $http_referer ? 'AND c.http_referer LIKE \''.$http_referer.'\'' : '' ).'
		'. ( $showstep == 'error' ? 'AND p.id_page_type = 8' : ( $showstep == 'anypage' ? '' : 'AND p.id_page_type = 3 AND p.'.$showstep.'' )) .'
		GROUP BY c.id_connections
		ORDER BY '.($orderbyobject == 'c.id_guest' ? 'c.ip_address' : $orderbyobject).' '.$orderby.'
		'.($limit == 1 ? 'LIMIT '.(($page*$resultperpage)-$resultperpage).', '.$resultperpage : '').''
		);
	}
	
	public function hookAdminStatsModules($params)
	{
		global $cookie;
		
		if (!empty($_POST['submitStatstrackvisits_save']))
		{
			$settingfile = '../modules/'.$this->name.'/setting.inc.php';
			
			$settingfileOpen = fopen($settingfile,"w");
			
			fwrite($settingfileOpen,
				'<?' . "\n" .
				'$setting = \''.$_POST['setting'].'\';' . "\n" .
				'$resultperpage = \''.$_POST['resultperpage'].'\';' . "\n" .
				'$orderbyobject = \''.$_POST['orderbyobject'].'\';' . "\n" .
				'$orderby = \''.$_POST['orderby'].'\';' . "\n" .
				'$show = \''.$_POST['show'].'\';' . "\n" .
				'$keyword = \''.$_POST['keyword'].'\';' . "\n" .
				'$showstep = \''.$_POST['showstep'].'\';' . "\n" .
				'$verif = \''.($_POST['verif']+1).'\';' . "\n" .
				'?>'
				);
				
			fclose($settingfileOpen);
		}
		
		require('../modules/'.$this->name.'/setting.inc.php');
		$page = !empty($_POST['page']) ? $_POST['page'] : '1';
		$setting = !empty($_POST['setting']) ? $_POST['setting'] : $setting;
		$resultperpage = !empty($_POST['resultperpage']) ? $_POST['resultperpage'] : $resultperpage;
		$orderbyobject = !empty($_POST['orderbyobject']) ? $_POST['orderbyobject'] : $orderbyobject;
		$orderby = !empty($_POST['orderby']) ? $_POST['orderby'] : $orderby;
		$show = !empty($_POST['show']) ? $_POST['show'] : $show;
		$keyword = !empty($_POST['keyword']) ? $_POST['keyword'] : $keyword;
		$http_referer = $keyword ? '%'. str_replace(' ','%', $keyword). '%' : '';
		$showstep = !empty($_POST['showstep']) ? $_POST['showstep'] : $showstep;
		
		$customers = $this->getCustomers($resultperpage, $page, 0, $orderby, $orderbyobject, $http_referer, $showstep);
		$totalCustomers = Db::getInstance()->NumRows();
		$visitors = $this->getVisitors($resultperpage, $page, 0, $orderby, $orderbyobject, $http_referer, $showstep);
		$totalVisitors = Db::getInstance()->NumRows();
		$totalpageCustomers = ceil($totalCustomers/$resultperpage);
		$totalpageVisitors = ceil($totalVisitors/$resultperpage);
		
		if($show == 'members')
		{
			$totalpage = $totalpageCustomers;
		}
		elseif($show == 'visitors')
		{
			$totalpage = $totalpageVisitors;
		}
		else
		{
			$totalpage = $totalpageVisitors >= $totalpageCustomers ? $totalpageVisitors : $totalpageCustomers ;
		}
		
		$totalpage = $totalpage == 0 ? 1 : $totalpage ;
		
		$this->_html = '<script type="text/javascript" src="../modules/'.$this->name.'/statstrackvisits.js"></script>
		<form name="submitStatstrackvisits" method="post" action="index.php?tab=AdminStatsModules&token='.Tools::getValue('token').'&module='.$this->name.'">
			<fieldset class="width3"><legend><img src="../modules/'.$this->name.'/img/setting.gif" /> '.$this->l('Option').'</legend>
				<p style="cursor: pointer; text-align: left;" onclick="javascript:openCloseLayerTr(\'viewsetting\');">
					<img src="../modules/'.$this->name.'/img/more.gif" />'.$this->l('Click here for show or hide Option').'
				</p>';
				if(!empty($_POST['submitStatstrackvisits_save']))
				{
					$this->_html .= ($verif == ($_POST['verif'])+1 ? '<p style="color: green; font-weight: bold ;">'.$this->l('Saving of default options successful!').'</p>' : '<p style="color: red; font-weight: bold ;">'.$this->l('Error to write File: Please check for sufficient write file permissions for file').' "../modules/'.$this->name.'/setting.inc.php"</p>');
				}
				$this->_html .= '
				<p>
					<strong>'.$this->l('Search by keyword in the URL of origin').'</strong>
					<br/>
					<input type="text" value="'.$keyword.'" name="keyword" style="width: 150px;"/>
				</p>
				<p>
					<strong>'.$this->l('View only members and visitors have visited the page:').'</strong>
					<br/>
					<select name="showstep">
						<option '.($showstep == 'anypage' ? 'selected="selected" ': '').'value="anypage">'.$this->l('Any page').'</option>
						<option '.($showstep == 'id_object = 0' ? 'selected="selected" ': '').'value="id_object = 0">'.$this->l('Order :').' '.$this->l('Cart').'</option>
						<option '.($showstep == 'id_object = 1' ? 'selected="selected" ': '').'value="id_object = 1">'.$this->l('Order :').' '.$this->l('Address').'</option>
						<option '.($showstep == 'id_object = 2' ? 'selected="selected" ': '').'value="id_object = 2">'.$this->l('Order :').' '.$this->l('Transport and GCS').'</option>
						<option '.($showstep == 'id_object = 3' ? 'selected="selected" ': '').'value="id_object = 3">'.$this->l('Order :').' '.$this->l('Payment options').'</option>
						<option '.($showstep == 'error' ? 'selected="selected" ': '').'value="error">'.$this->l('Error : Page 404.php').'</option>
					</select>
				</p>
				<p>
					<input class="button" type="submit" name="submitStatstrackvisits" value="'.$this->l('Search').'"/>
				</p>
			<div id="viewsetting" style="display: none;">
				<p>
					<strong>'.$this->l('Full display of the original URL?').'</strong>
					<br/>'.$this->l('(Allows you to see key words)').'
					<br/>
					<select name="setting">
						<option '.($setting == 'yes' ? 'selected="selected" ': '').'value="yes"> '.$this->l('Yes').' </option>
						<option '.($setting == 'no' ? 'selected="selected" ': '').'value="no"> '.$this->l('No').' </option>
					</select>
				</p>
				<p>
					<strong>'.$this->l('Order by:').'</strong>
					<br/>
					<select name="orderbyobject">
						<option '.($orderbyobject == 'c.date_add' ? 'selected="selected" ': '').'value="c.date_add"> '.$this->l('Date & Hour').' </option>
						<option '.($orderbyobject == 'c.id_guest' ? 'selected="selected" ': '').'value="c.id_guest"> '.$this->l('ID Members or IP Visitors').' </option>
					</select>
					<select name="orderby">
						<option '.($orderby == 'ASC' ? 'selected="selected" ': '').'value="ASC"> '.$this->l('Ascending').' </option>
						<option '.($orderby == 'DESC' ? 'selected="selected" ': '').'value="DESC"> '.$this->l('Descending').' </option>
					</select>
				</p>
				<p>
					<strong>'.$this->l('Number of results per page and per table:').'</strong>
					<br/>
					<select name="resultperpage">
						<option '.($resultperpage == '20' ? 'selected="selected "': '').'value="20">20</option>
						<option '.($resultperpage == '50' ? 'selected="selected "': '').'value="50">50</option>
						<option '.($resultperpage == '100' ? 'selected="selected "': '').'value="100">100</option>
					</select>
				</p>
				<p>
					<strong>'.$this->l('Show').'</strong>
					<br/>
					<select name="show">
						<option '.($show == 'all' ? 'selected="selected "': '').'value="all">'.$this->l('All').'</option>
						<option '.($show == 'members' ? 'selected="selected "': '').'value="members">'.$this->l('Members only').'</option>
						<option '.($show == 'visitors' ? 'selected="selected "': '').'value="visitors">'.$this->l('Visitors only').'</option>
					</select>
				</p>
				<p>
					<input class="button" type="submit" name="submitStatstrackvisits_save" value="'.$this->l('Save these settings as default settings').'"/>
					<input type="hidden" name="verif" value="'.$verif.'">
				</p>
				<p>
					<input class="button" type="submit" name="submitStatstrackvisits" value="'.$this->l('Search').'"/>
				</p>
			</div>
			</fieldset>
			<fieldset class="width3 space"><legend><img src="../modules/'.$this->name.'/img/setting.gif" /> '.$this->l('Pagination').'</legend>
				<p>
					'.$this->l('Go directly to page').' 
					<select onChange="submit();" name="page">
						';
						for ($i = 1 ; $i <= $totalpage ; $i++)
						{
							$this->_html .='<option '.($i == $page ? 'selected="selected "': '').'value="'.$i.'">&nbsp;'.$i.'&nbsp;</option>';
						} 
						$this->_html .= '
					</select> / '.$totalpage.'
				</p>
				<p style="text-align: center; display: block; width:600px; border-top: 7px;">
					<input '.($page <= 1 ? 'style="display: none" ' : '').'name="page" type="image" onclick="submit();" value="1" src="../modules/'.$this->name.'/img/list-prev2.gif"/>
					&nbsp;<input '.($page <= 1 ? 'style="display: none" ' : '').'name="page" type="image" onclick="submit();" value="'.($page-1).'" src="../modules/'.$this->name.'/img/list-prev.gif"/>
					&nbsp;'.$this->l('Page').' '.$page.' / '.$totalpage.'
					&nbsp;<input '.($page >= $totalpage ? 'style="display: none" ' : '').'name="page" type="image" onclick="submit();" value="'.($page+1).'" src="../modules/'.$this->name.'/img/list-next.gif"/>
					&nbsp;<input '.($page >= $totalpage ? 'style="display: none" ' : '').'name="page" type="image" onclick="submit();" value="'.$totalpage.'" src="../modules/'.$this->name.'/img/list-next2.gif"/>
				</p>
			</fieldset>';
		
		$customers = $this->getCustomers($resultperpage, $page, 0, $orderby, $orderbyobject, $http_referer, $showstep);
		$totalCustomers = Db::getInstance()->NumRows();
		$customers = $this->getCustomers($resultperpage, $page, 1, $orderby, $orderbyobject, $http_referer, $showstep);
		$visitors = $this->getVisitors($resultperpage, $page, 0, $orderby, $orderbyobject, $http_referer, $showstep);
		$totalVisitors = Db::getInstance()->NumRows();
		$visitors = $this->getVisitors($resultperpage, $page, 1, $orderby, $orderbyobject, $http_referer, $showstep);
		$irow = 0;

	if ($show == 'all' OR $show == 'members')
	{
		$this->_html .= '<fieldset class="width3 space"><legend><img src="../modules/'.$this->name.'/img/logo.gif" /> '.$this->l('Member(s)').'</legend>';
		if ($totalCustomers)
		{
			$this->_html .= $this->l('Total:').' '.intval($totalCustomers).'
			<table cellpadding="0" cellspacing="0" class="table space">
				<tr><th style="text-align: center;">'.$this->l('Details').'</th><th style="text-align: center;">'.$this->l('ID').'</th><th style="text-align: center;">'.$this->l('IP').'</th><th style="width: 150px; text-align: center;">'.$this->l('Name').'</th><th style="text-align: center;">'.$this->l('View page(s)').'</th><th style="text-align: center;">'.$this->l('Number of visits').'</th><th style="text-align: center;">'.$this->l('Date & Hour').'</th><th style="text-align: center;">'.$this->l('Member page').'</th><th style="text-align: left;">'.$this->l('Origin').'</th></tr>';
			foreach ($customers as $customer)
			{
				$nbpageview = $this->getPageView($customer['id_connections']);
				$totalNbpageview = Db::getInstance()->NumRows();
				$comeback = $this->getComeBack($customer['ip_address'],$customer['id_guest']);
				$totalComeback = Db::getInstance()->NumRows();
				$this->_html .= '
				<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');"><img src="../modules/'.$this->name.'/img/more.gif" /></td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.$customer['id_customer'].'</td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.long2ip($customer['ip_address']).'</td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.$customer['firstname'].' '.$customer['lastname'].'</td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.$totalNbpageview.'</td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.intval($totalComeback).'</td>
					<td style="cursor: pointer; text-align: right;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.Tools::displayDate($customer['date_add'], intval($cookie->id_lang), true).'</td>
					<td style="cursor: pointer; text-align: center;">
						<a href="index.php?tab=AdminCustomers&id_customer='.$customer['id_customer'].'&viewcustomer&token='.Tools::getAdminToken('AdminCustomers'.intval(Tab::getIdFromClassName('AdminCustomers')).intval($cookie->id_employee)).'" target="_blank">
							<img src="../modules/'.$this->name.'/img/logo.gif" />
						</a>
					</td>
					<td style="text-align: left;">'.(empty($customer['http_referer']) ? $this->l('None') : '<a href="'.$customer['http_referer'].'" target="_blank" style=" color: #996633;"><b>'.parse_url($customer['http_referer'], PHP_URL_HOST).'</b> <img src="../modules/'.$this->name.'/img/link.gif" />').($setting == 'yes' ? str_replace('http://'.parse_url($customer['http_referer'], PHP_URL_HOST),'<br />',$customer['http_referer']): '').'</a>';
					$this->_html .= '</td>
				</tr>
				<tr id="pviewby'.$customer['id_connections'].'" style="display: none;">
					<td colspan="9">
						<table cellpadding="0" cellspacing="0" style="margin-bottom: 10px; color: black;" class="table space">
							<tr><th style="width: 25px;">'.$this->l('ID').'</th><th style="width: 400px;">'.$this->l('View page(s)').'</th><th style="width: 150px;">'.$this->l('Date & Hour').'</th></tr>';
						$num = 0;
						$irow2 = 0;
						foreach ($nbpageview as $nbpageview)
						{
							$num = $num+1;
							$showname = $this->ShowName($nbpageview['name'], $nbpageview['id_object'], $cookie->id_lang, $nbpageview['id_page']);
							$this->_html .= '
							<tr'.($irow2++ % 2 ? ' class="alt_row"' : '').'>
								<td>'.$num.'</td>
								<td>'.$showname.'</td>
								<td>'.$nbpageview['time_start'].'</td>
							</tr>';
						}
						$this->_html .= '</table>
					</td>
				</tr>';
			}
			$this->_html .= '</table>';
		}
		else
			$this->_html .= $this->l('No Member has connected during the period chosen or with the criteria you selected.');
		$this->_html .= '</fieldset>';
	}
	if ($show == 'all' OR $show == 'visitors')
	{
		$this->_html .= '<fieldset class="width3 space"><legend><img src="../modules/'.$this->name.'/img/logo.gif" /> '.$this->l('Visitor(s)').'</legend>';
		if ($totalVisitors)
		{
			$this->_html .= $this->l('Total:').' '.intval($totalVisitors).'
			<table cellpadding="0" cellspacing="0" class="table space">
				<tr><th style="text-align: center;">'.$this->l('Details').'</th><th style="text-align: center;">#</th><th style="text-align: center;">'.$this->l('IP').'</th><th style="text-align: center;">'.$this->l('View page(s)').'</th><th style="text-align: center;">'.$this->l('Number of visits').'</th><th style="text-align: center;">'.$this->l('Date & Hour').'</th><th style="text-align: left;">'.$this->l('Origin').'</th></tr>';
			foreach ($visitors as $visitor)
			{
				$nbpageview = $this->getPageView($visitor['id_connections']);
				$totalNbpageview = Db::getInstance()->NumRows();
				$comeback = $this->getComeBack($visitor['ip_address'],$visitor['id_guest']);
				$totalComeback = Db::getInstance()->NumRows();
				$this->_html .= '
					<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');"><img src="../modules/'.$this->name.'/img/more.gif" /></td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.$visitor['id_guest'].'</td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.long2ip($visitor['ip_address']).'</td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.$totalNbpageview.'</td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.intval($totalComeback).'</td>
						<td style="cursor: pointer; text-align: right;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.Tools::displayDate($visitor['date_add'], intval($cookie->id_lang), true).'</td>
						<td style="text-align: left;">'.(empty($visitor['http_referer']) ? $this->l('None') : '<a href="'.$visitor['http_referer'].'" target="_blank" style=" color: #996633;"><b>'.parse_url($visitor['http_referer'], PHP_URL_HOST).'</b> <img src="../modules/'.$this->name.'/img/link.gif" />').($setting == 'yes' ? str_replace('http://'.parse_url($visitor['http_referer'], PHP_URL_HOST),'<br />',$visitor['http_referer']) : '').'</a>';
						$this->_html .= '</td>
					</tr>
					<tr id="pviewby'.$visitor['id_connections'].'" style="display: none;">
						<td colspan="7">
							<table cellpadding="0" cellspacing="0" style="margin-bottom: 10px; color: black;" class="table space">
								<tr><th style="width: 25px;">'.$this->l('ID').'</th><th style="width: 400px;">'.$this->l('View page(s)').'</th><th style="width: 150px;">'.$this->l('Date & Hour').'</th></tr>';
							$num = 0;
							$irow2 = 0;
							foreach ($nbpageview as $nbpageview)
							{
								$num = $num+1;
								$showname = $this->ShowName($nbpageview['name'], $nbpageview['id_object'], $cookie->id_lang, $nbpageview['id_page']);
								$this->_html .= '
								<tr'.($irow2++ % 2 ? ' class="alt_row"' : '').'>
									<td>'.$num.'</td>
									<td>'.$showname.'</td>
									<td>'.$nbpageview['time_start'].'</td>
								</tr>';
							}
							$this->_html .= '</table>
						</td>
					</tr>';
			}
			$this->_html .= '</table>';
		}
		else
			$this->_html .= $this->l('No Visitor has connected during the period chosen or with the criteria you selected.');
			$this->_html .= '</fieldset>';
	}
		$this->_html .= '
			<fieldset class="width3 space"><legend><img src="../modules/'.$this->name.'/img/setting.gif" /> '.$this->l('Pagination').'</legend>
				<p style="text-align: center; display: block; width:600px; border-top: 7px;">
					<input '.($page <= 1 ? 'style="display: none" ' : '').'name="page" type="image" onclick="submit();" value="1" src="../modules/'.$this->name.'/img/list-prev2.gif"/>
					&nbsp;<input '.($page <= 1 ? 'style="display: none" ' : '').'name="page" type="image" onclick="submit();" value="'.($page-1).'" src="../modules/'.$this->name.'/img/list-prev.gif"/>
					&nbsp;'.$this->l('Page').' '.$page.' / '.$totalpage.'
					&nbsp;<input '.($page >= $totalpage ? 'style="display: none" ' : '').'name="page" type="image" onclick="submit();" value="'.($page+1).'" src="../modules/'.$this->name.'/img/list-next.gif"/>
					&nbsp;<input '.($page >= $totalpage ? 'style="display: none" ' : '').'name="page" type="image" onclick="submit();" value="'.$totalpage.'" src="../modules/'.$this->name.'/img/list-next2.gif"/>
				</p>
			</fieldset>
		</form>';
		return $this->_html;
	}
}

?>
