<?php

/* SSL Management */
$useSSL = true;

include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/paypal.php');

global $smarty;
	
// We arrive here with all the paypal form details filled out
// Because Paypal is asynchronous, we need to get the order started just before we go to paypal.
$paypal = new Paypal();
$cart = new Cart(intval($_POST['cart_id']));
$total = number_format($cart->getOrderTotal(true, 3), 2, '.', '');

$valid_order=$paypal->validateOrder(intval($cart->id), Configuration::get('PS_PAYPALPROCESS'), floatval($total), $paypal->displayName, $paypal->getL('to_paypal'));

$address = new Address(intval($cart->id_address_invoice));
$customer = new Customer(intval($cart->id_customer));
$business = Configuration::get('PAYPAL_BUSINESS');

if (Configuration::get('PAYPAL_CURRENCY') == 'customer')
	$id_currency = intval($cart->id_currency);
else
	$id_currency = intval(Configuration::get('PS_CURRENCY_DEFAULT'));

$currency = new Currency(intval($id_currency));

if (!Validate::isEmail($business))
	die($paypal->l('Paypal error: (invalid or undefined business account email)'));

if (!Validate::isLoadedObject($address) OR !Validate::isLoadedObject($customer) OR !Validate::isLoadedObject($currency))
	die($paypal->l('Paypal error: (invalid address or customer)'));
			
$products = $cart->getProducts();
		
foreach ($products as $key => $product)
{
	$products[$key]['name'] = str_replace('"', '\'', $product['name']);
	if (isset($product['attributes']))
		$products[$key]['attributes'] = str_replace('"', '\'', $product['attributes']);
	$products[$key]['name'] = htmlentities(utf8_decode($product['name']));
	$products[$key]['paypalAmount'] = number_format(Tools::convertPrice($product['price_wt'], $currency), 2, '.', '');
}

$order = new Order($paypal->currentOrder);
				
$smarty->assign(array(
	'address' => $address,
	'country' => new Country(intval($address->id_country)),
	'customer' => $customer,
	'business' => $business,
	'currency' => $currency,
	'paypalUrl' => $paypal->getPaypalUrl(),
	'amount' => number_format(Tools::convertPrice($cart->getOrderTotal(true, 4), $currency), 2, '.', ''),
	'shipping' =>  number_format(Tools::convertPrice($cart->getOrderShippingCost(), $currency), 2, '.', ''),
	'discounts' => $cart->getDiscounts(),
	'products' => $products,
	'total' => number_format(Tools::convertPrice($cart->getOrderTotal(true, 3), $currency), 2, '.', ''),
	'id_cart' => intval($cart->id),
	'goBackUrl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'order-confirmation.php?id_cart='.intval($cart->id).'&id_module='.intval($paypal->id).'&id_order='.$paypal->currentOrder.'&key='.$order->secure_key,
	'returnUrl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/paypal/validation.php'
));

echo $paypal->display(__FILE__, 'paypal.tpl');		
echo '<script type="text/javascript">var formToSend = document.getElementById("paypal_form"); formToSend.submit();</script>';
?>