<?php
// modified from v 1.0.0.8 14 August 2008
// 2.0beta2 paulc010: www.ecartservice.net
// 2.1beta1 Didier Hermes: April 2009 - www.dietibox.com

// Activate or De-activate local file debugging of PayPal validation module.
$ValidDbg = false;
// ------------------------------------------------------------------------

include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/paypal.php');

if (isset($_POST['test_ipn']))  {
	// This came from the SANDBOX, if we're not set up for SANDBOX mode, then get out of here!
	if (!Configuration::get('PAYPAL_SANDBOX')) {
		die($paypal->getL('Sandbox'));
	}
}

$errors = '';
$paypal = new Paypal();
// Status messages associated with IPN event types
$paypal_status = array('Completed' => _PS_OS_PAYMENT_,
                       'Cancelled_Reversal' => _PS_OS_PAYMENT_,
					   'Pending'=> _PS_OS_PREPARATION_,
					   'In-Progress'=> _PS_OS_PREPARATION_,
					   'Processed' => _PS_OS_PREPARATION_,
					   'Reversed' => _PS_OS_CANCELED_,
					   'Voided' => _PS_OS_CANCELED_,
					   'Refunded' => _PS_OS_REFUND_,
					   'Partially_Refunded' => _PS_OS_REFUND_,
					   'Denied' => _PS_OS_CANCELED_,
					   'Expired'=> _PS_OS_CANCELED_,
					   'Failed' => _PS_OS_CANCELED_
					   );

$params = 'cmd=_notify-validate';
foreach ($_POST AS $key => $value)
	$params .= '&'.$key.'='.urlencode(stripslashes($value));
	
$paypalServer = 'www.'.(Configuration::get('PAYPAL_SANDBOX') ? 'sandbox.' : '').'paypal.com';

// This code is a little convoluted, mainly so all the paths can be tested!!
$fsocket = false;
$curl = false;
$result = false;


// Test for curl support on the server
if (function_exists('curl_exec')) {
    $curl = true;
}

// Try a secure fsockopen connection and if not, then the worst case insecure fsockopen
// only use the insecure method if nothing else (secure fsockopen or curl) works!
// The insecure sock should be removed for production servers.
if ( (PHP_VERSION >= 4.3) && ($fp = fsockopen('ssl://' . $paypalServer, 443, $errno, $errstr, 30)) ) {
    $fsocket = true;
} elseif ( ($fp = fsockopen($paypalServer, 80, $errno, $errstr, 30)) && (!$curl) ) {
 	$fsocket = true;
} elseif (!$curl) {
    $errors = $paypal->getL('connect'). $paypal->getL('notransport');
}

// ***************To debug curl when fsockopen works, uncomment the two lines below
//$fsocket=false;
//if ($fp) fclose($fp);

// Try verifying using the fsockopen handle we got earlier (secure or insecure if curl isn't available)
if ($fsocket == true) {
    $header = 'POST /cgi-bin/webscr HTTP/1.0' . "\r\n" .
 	          'Host: ' . $paypalServer . "\r\n" .
 	          'Content-Type: application/x-www-form-urlencoded' . "\r\n" .
 	          'Content-Length: ' . Tools::strlen($params) . "\r\n" .
 	          'Connection: close' . "\r\n\r\n";
 	
 	fputs($fp, $header . $params);
 	
 	$read = '';
 	while (!feof($fp)) {
		$reading = trim(fgets($fp, 1024));
		$read .= $reading;
		if ( ($reading == 'VERIFIED') || ($reading == 'INVALID') )
		{
		 	$result = $reading;
			break;
		}
 	}
 	
	// If we got something, but not what we want, flag the error and include the response.
	if ($result!='VERIFIED') $errors .= $paypal->getL('socketmethod').$result.'<br />';
 	fclose($fp);
} elseif ($curl == true) {
    $ch = curl_init('https://' . $paypalServer . '/cgi-bin/webscr');
    
	// If the above fails, then try the url with a trailing slash (fixes problems on some servers)
 	if (!$ch) $ch = curl_init('https://' . $paypalServer . '/cgi-bin/webscr/');
	
	// Error checking
	if (!$ch) $errors .= $paypal->getL('connect').$paypal->getL('cURLFail');
	
	// Don't try this if the handle returned from the init is invalid
	if ($ch) {
 	    curl_setopt($ch, CURLOPT_POST, true);
 	    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
 	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
 	    curl_setopt($ch, CURLOPT_HEADER, false);
 	    curl_setopt($ch, CURLOPT_TIMEOUT, 30);
 	    curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
 	
 	    $result = curl_exec($ch);
		
		// Check we got what we expected and if not flag the error and include the response and error detail.
  	    if ($result!='VERIFIED') $errors .= $paypal->getL('curlmethod').$result.' cURL error:'.curl_error($ch).'<br />';
		curl_close($ch);
	}
}

if ($ValidDbg==true) {
$debugdata = date("d/m/y : H:i:s", time());
$debugdata .= ' _POST[payment_status] is "'.strval($_POST['payment_status']).'"';
$debugdata .= ' _POST[txn_id] is "'.strval($_POST['txn_id']).'"';
$debugdata .= ' _POST[payment_type] is "'.strval($_POST['payment_type']).'"';
$debugdata .= Chr(13).Chr(10);
file_put_contents('debug-PayPal.txt', $debugdata, FILE_APPEND);
}
	  	
if ($result == 'VERIFIED') {
  $message = ''; // IPN specific message to log against the order. Blank uses default handler.
  $notifyCustomer = true; // Turn off customer notification for certain IPN updates ON by default
  
  switch (strval($_POST['payment_status'])) {
    // Validate the data for each spedific IPN type, just to make absolutely sure!
    case 'Cancelled_Reversal':
		$message = $paypal->getL('Cancelled_Reversal');
		$notifyCustomer = false;
	break;
	
	case 'Completed':
		$message = $paypal->getL('Completed').strval($_POST['txn_id']).' / '.strval($_POST['payment_type']);
	break;
	
	case 'Denied':
		$message = $paypal->getL('Denied');
	break;
	
	case 'Expired':
		$message = $paypal->getL('Expired').strval($_POST['txn_id']).' / ' . strval($_POST['payment_type']);
	break;
	
	case 'Failed':
		$message = $paypal->getL('Failed');
	break;
	
	case 'Pending':
	case 'In-Progress':	
		$message = $paypal->getL('Pending').strval($_POST['payment_type']).' / '.strval($_POST['pending_reason']);
	break;
	
	case 'Processed':
		$message = $paypal->getL('Processed').strval($_POST['txn_id']).' / ' .strval($_POST['payment_type']);
		$notifyCustomer = false;
	break;
	
	case 'Refunded':
	case 'Partially_Refunded':
		$message = $paypal->getL('Refunded').strval($_POST['txn_id']) . ' / '.strval($_POST['reason_code']);
	break;
	
	case 'Reversed':
		$message = $paypal->getL('Reversed').strval($_POST['reason_code']);
		$notifyCustomer = false;
	break;
	
	case 'Voided':
		$message = $paypal->getL('Voided');
	break;
		
    default:
	  // Either there's no payment_status, or we don't know how to handle it
	  if (!isset($_POST['payment_status']))
		  $errors .= $paypal->getL('payment_status').'<br />';
	  else
		  $errors .= $paypal->getL('payment').strval($_POST['payment_status']).'<br />';
	break;
  } // end IPN type switch
  if (empty($errors))
  {
  
if ($ValidDbg==true) {
$debugdata = date("d/m/y : H:i:s", time());
$debugdata .= ' _POST[custom] = "'.strval($_POST['custom']).'"';
$debugdata .= Chr(13).Chr(10);
file_put_contents('debug-PayPal.txt', $debugdata, FILE_APPEND);
}
  
	$cart = new Cart(intval($_POST['custom']));
	if (!$cart->id)
		die($errors . $paypal->getL('cart'));
	elseif ($id_IPNOrder=Order::getOrderByCartId(intval($_POST['custom']))) {
		// Let's go and update the status, if appropriate

if ($ValidDbg==true) {
$debugdata = date("d/m/y : H:i:s", time());
$debugdata .= ' id_IPNOrder = "'.$id_IPNOrder.'"';
// $debugdata .= ' notifyCustomer = "'.$notifyCustomer.'"';
if ($notifyCustomer==true) { $debugdata .= ' notifyCustomer = true'; } else {$debugdata .= ' notifyCustomer = false';}
$debugdata .= ' payment_status = "'.strval($_POST['payment_status']).'"';
$debugdata .= Chr(13).Chr(10);
file_put_contents('debug-PayPal.txt', $debugdata, FILE_APPEND);
}

	    IPN_Status_Update($id_IPNOrder, strval($_POST['payment_status']), $notifyCustomer);
	} else {
		// This order doesn't exist  , even though it appears it should so log the error
		die($paypal->getL('InvaldIPN').strval($_POST['custom']).' '.strval($_POST['payment_status']).' '.strval($_POST['mc_gross']). ' '. strval($_POST['txn_id']));
	}
  }
} else {
	$errors .= $paypal->getL('verified');
}
	
if (!empty($errors) AND isset($_POST['custom']))
	   $paypal->validateOrder(intval($_POST['custom']), _PS_OS_ERROR_,   0,           $paypal->displayName,       $errors);

if ($ValidDbg==true) {
$debugdata = Chr(13).Chr(10);
file_put_contents('debug-PayPal.txt', $debugdata, FILE_APPEND);
}
	
function IPN_Status_Update($idIPNOrder, $Status, $notify) {
	global $paypal_status, $message, $paypal, $ValidDbg;
	
	// The order already exists, so we need to update the order history.
	$lastIPNOrderStatus = OrderHistory::getLastOrderState($idIPNOrder);
	if (!Validate::isLoadedObject($lastIPNOrderStatus))
		die(Tools::displayError());

	$history = new OrderHistory();
	$history->id_order = $idIPNOrder;
	$history->changeIdOrderState(intval($paypal_status[$Status]), intval($idIPNOrder));

  if ($ValidDbg==true) {
  $debugdata = date("d/m/y : H:i:s", time());
  if ($notify==true) { $debugdata .= ' notify = true'; } else {$debugdata .= ' notify = false';}
  $debugdata .= ' paypal_status[Status] = "'.$paypal_status[$Status].'"';
  $debugdata .= ' lastIPNOrderStatus->id_order_state = "'.$lastIPNOrderStatus->id_order_state.'"';
  $debugdata .= Chr(13).Chr(10);
  file_put_contents('debug-PayPal.txt', $debugdata, FILE_APPEND);
  }
  
	if (($notify==true) && ($paypal_status[$Status]!=$lastIPNOrderStatus->id_order_state)) {
		if (!$history->addWithemail())
			$paypal->_errors[] = Tools::displayError($paypal->getL('emailnotsent'));
	} else {
		$history->add();
	}
	// Update the message in the BackOffice log too; handy for error checking
	// $message will contain detail specific to the IPN, and is set in the switch code block above
	if ($message=='') $message = 'Payment status change received: '.$Status;
	$msg = new Message();
	if (!Validate::isMessage($message))
		$message = $paypal->l('Payment message is not valid, please check your module!');
	$msg->message = $message;
	$msg->id_order = intval($idIPNOrder);
	$msg->private = 1;
	$msg->add();
}
?>