<?php

/**
 * This modulo allow send questions about products. 1.1
 * @category admin
 * @colaborator Star [Member Forum Prestashop]
 * @author Odlanier de Souza <master_odlanier@hotmail.com>
 * @copyright prestashopbr.com
 * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
 * @version 0.1
 *
 */

class productquestion extends Module
{
	
	//Configuration::get('PS_SHOP_EMAIL')
	
 	function __construct()
 	{
 	 	$this->name = 'productquestion';
 	 	$this->version = '1.1';
 	 	$this->tab = 'Products';
		
		parent::__construct();
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Send to Own Question');
		$this->description = $this->l('This modulo allow send questions about products.');
 	}

	function install()
	{
	 	if (!parent::install())
	 		return false;
	 	return $this->registerHook('extraLeft');
	}
	
	function hookExtraLeft($params)
	{
		global $smarty;
		$smarty->assign('this_path', $this->_path);
		return $this->display(__FILE__, 'product_page.tpl');
	}

	public function displayFrontForm()
	{
		global $smarty;
		$error = false;
		$confirm = false;
		
		if (isset($_POST['submitQuestion']))
		{
			global $cookie, $link;
			/* Product informations */
			$product 		= new Product(intval(Tools::getValue('id_product')), false, intval($cookie->id_lang));
			$productLink 	= $link->getProductLink($product);
			$backToProduct 	= '<a href="'.$productLink.'" class="bold">'.$this->l('Back to').' "'.$product->name.'"</a>';
			$smarty->assign('backToProduct', $backToProduct);
						
			/* Fields verifications */
			if (!$cookie->logged && empty($_POST['email']) OR !$cookie->logged && empty($_POST['name']) OR !$cookie->logged && empty($_POST['message']) )
				$error = $this->l('You must fill all fields.');
			elseif (!$cookie->logged AND !Validate::isEmail($_POST['email']))
				$error = $this->l('Your email is invalid.');
			elseif (!$cookie->logged AND !Validate::isName($_POST['name']))
				$error = $this->l('Your name is invalid.');
			elseif (!isset($_GET['id_product']) OR !is_numeric($_GET['id_product']))
				$error = $this->l('An error occurred during the process.');
			else
			{
				/* Email generation */
				$subject = ($cookie->customer_firstname ? $cookie->customer_firstname.' '.$cookie->customer_lastname : $this->l('A customer')).' '.$this->l('send question about').' '.$product->name;
				$templateVars = array(
					'{product}' 	 => $product->name,
					'{product_link}' => 'http://'.htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').$productLink,
					'{customer}' 	 => ($cookie->customer_firstname ? $cookie->customer_firstname.' '.$cookie->customer_lastname : $this->l('A visitor')),
					'{name}' 		 => ($cookie->customer_firstname ? $cookie->customer_firstname.' '.$cookie->customer_lastname : Tools::safeOutput($_POST['name']) ),
					'{email}'		 => ($cookie->email ? $cookie->email : Tools::safeOutput($_POST['email']) ),
					'{message}'		 => $_POST['message']
					
				);
				
				/* Email sending */
				if (!Mail::Send(intval($cookie->id_lang), 'send_question', $subject, $templateVars, Configuration::get('PS_SHOP_EMAIL'), NULL, NULL, NULL, NULL, NULL, dirname(__FILE__).'/mails/'))
					$error 		= $this->l('An error occurred during the process.');
				else
					$confirm 	= $this->l('An email has been sent successfully!');
			}
		}
		else
		{
			global $cookie, $link;
			/* Product informations */
			$product = new Product(intval(Tools::getValue('id_product')), false, intval($cookie->id_lang));
			$productLink = $link->getProductLink($product);
		}
		
		/* Image */
		$images = $product->getImages(intval($cookie->id_lang));
		foreach ($images AS $k => $image)
			if ($image['cover'])
			{
				$cover['id_image'] = intval($product->id).'-'.intval($image['id_image']);
				$cover['legend'] = $image['legend'];
			}
		
		if (!isset($cover))
			$cover = array('id_image' => Language::getIsoById(intval($cookie->id_lang)).'-default', 'legend' => 'No picture');

		$smarty->assign(array(
			'validate_login' => $cookie->logged,
			'cover' => $cover,
			'errors' => $error,
			'confirm' => $confirm,
			'product' => $product,
			'productLink' => $productLink 
		));

		return $this->display(__FILE__, 'productquestion.tpl');
	}
}
?>
