<?php
/*
* Module that shows real traffic from keywords. Developed since SEKeywords was not working optimally.
* This module is based on Prestashops own SEKeywords and is thus prohibited for sale.
* Developed by Gamers United (http://www.gamersunited.se) and released free at http://www.prestashop.com/forums/ on 2011-07-14.
*/

if (!defined('_CAN_LOAD_FILES_'))
	exit;

class realkeywords extends ModuleGraph
{
    private $_html = '';
	private $_query = '';
	private $_query2 = '';

    function __construct()
    {
        $this->name = 'realkeywords';
        $this->tab = 'analytics_stats';
        $this->version = 0.1;
		$this->author = 'Gamersunited.se';
		
		$this->_query = '
		SELECT `keywords`, COUNT(TRIM(`keywords`)) as occurences
		FROM `'._DB_PREFIX_.'connections_source`
		WHERE `keywords` > ""
		AND `date_add` BETWEEN ';
		$this->_query2 = '
		GROUP BY TRIM(`keywords`)
		HAVING occurences > 0
		ORDER BY occurences DESC';

        parent::__construct();
		
        $this->displayName = $this->l('Real Keywords');
        $this->description = $this->l('Show the keywords visitors came in through.');
    }

	function install()
	{
		if (!parent::install() OR !$this->registerHook('AdminStatsModules'))
			return false;
	}
	
    function uninstall()
    {
        if (!parent::uninstall())
			return false;
    }
		
	function hookAdminStatsModules()
	{
		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($this->_query.ModuleGraph::getDateBetween().$this->_query2);
		$total = count($result);
		$this->_html = '<fieldset class="width3"><legend><img src="../modules/'.$this->name.'/logo.gif" /> '.$this->displayName.'</legend>
		'.$total.' '.($total == 1 ? $this->l('keyword used to reach your shop.') : $this->l('different keywords used to reach your shop.')).'<div class="clear">&nbsp;</div>';
		if ($result AND $total)
		{
			$table = '
			<div>
			<table class="table" border="0" cellspacing="0" cellspacing="0" style="width:100%">
			<thead>
				<tr><th style="width:400px;">'.$this->l('Keywords').'</th>
				<th style="width:50px; text-align: right">'.$this->l('Occurrences').'</th></tr>
			</thead><tbody>';
			foreach ($result as $index => $row)
			{
				$keyword =& $row['keywords'];
				$occurences =& $row['occurences'];
				$table .= '<tr><td>'.$keyword.'</td><td style="text-align: right">'.$occurences.'</td></tr>';
			}
			$table .= '</tbody></table></div>';
			$this->_html .= '<center>'.ModuleGraph::engine(array('type' => 'pie')).'</center>
			<br class="clear" />'.$table;
		}
		else
			$this->_html .= '<p><strong>'.$this->l('No keywords').'</strong></p>';

		$this->_html .= '</fieldset><br class="clear" />
		<fieldset class="width3"><legend><img src="../img/admin/comment.gif" /> '.$this->l('Guide').'</legend>
			<h2>'.$this->l('Significance of keywords').'</h2>
			<p>'.$this->l('In order to progress with SEO and make your site more visible in Google, it\'s a must to see your current biggest keywords. It is also a great way to get more suggestions and inspirations for new keywords to optimize your site for.').'</p><br />
		</fieldset>';
		return $this->_html;
	}
	

	
	protected function getData($layers)
	{
		$this->_titles['main'] = $this->l('10 first keywords');
		$totalResult = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($this->_query.$this->getDate().$this->_query2);
		$total = 0;
		$total2 = 0;
		foreach ($totalResult as $totalRow)
			$total += $totalRow['occurences'];
		$result = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($this->_query.$this->getDate().$this->_query2.' LIMIT 9');
		foreach ($result as $row)
		{
			$this->_legend[] = $row['keywords'];
			$this->_values[] = $row['occurences'];
			$total2 += $row['occurences'];
		}
		if ($total >= $total2)
		{
			$this->_legend[] = $this->l('Others');
			$this->_values[] = $total - $total2;
		}
	}
}


