<?php
	/***********************************************************************************
	* V1.0 - 26/08/2009
	* File Name			: jpt_geoip.class.php
	* Usage				: geolocalization class to find a country from the IP
	* Author			: Fabien LAHAULLE (fabien.lahaulle@gmail.com)
	* Author WebSite 	: www.mariage-tranquille.fr
	* Contact Website	: contact@mariage-tranquille.fr
	* GeoIP Database (GeoIP.dat) provided freely by www.maxmind.com
	***********************************************************************************/

class JPT_GeoIP{
	var $_installPath 	= "";
	
	var $IP;
	var $IP2;
	var $_countryCode 	= "";
	var $_countryCode3C = "";
	var $_countryName 	= "";
	
	var $_found			= false;
	var $_useFlag 		= false;
	var $_flagFileName 	= "";

	var $_flagsDirectory = "flags";
	var $_GeoIpCountryFile = "GeoIP.dat";
	var $_GeoIpCityFile = "GeoLiteCity.dat";
	
	//-------------------------------------------
	/* FUNCTIONS */
	//-------------------------------------------
	function JPT_GeoIP($installPath){
		$this->_installPath = $installPath;
	}
	function useFlag($value){$this->_useFlag = $value;}

	function searchIP($IP){
			
		$this->IP = $IP;
		$result = "";
		$this->getDataFromFile($IP);

		if (($this->_found) && ($this->_useFlag))
			$this->getFlagImage();
	}
	function toString(){
		return $this->IP . " (" . $this->IP2 . ") : " . $this->_countryName ;
	}
	function getCountryCode()	{ return $this->_countryCode;}
	function getCountryCode3C()	{ return $this->_countryCode3C;}
	function getCountryName()	{ return $this->_countryName;}
	function getRegion()		{ return $this->_region;}
	function getCityName()		{ return $this->_city;}
	function getPostalCode()	{ return $this->_postal_code;}
	function getLatitude()		{ return $this->_latitude;}
	function getLongitude()		{ return $this->_longitude;}
	function getDmaCode()		{ return $this->_dma_code;}
	function getAreaCode()		{ return $this->_area_code;}
	function getFlagFileName()	{ return $this->_flagFileName;}

	//-------------------------------------------
	/* FUNCTIONS */
	//-------------------------------------------
	function getFlagImage(){
		if (is_dir($this->_installPath . "/" . $this->_flagsDirectory)){
			//get Country Flag in the "flags" subdirectory
			$filename = $this->_installPath . "/" . $this->_flagsDirectory . "/" . strtolower($this->_countryCode) . ".gif";
			if (file_exists($filename))
				$this->_flagFileName = $filename;
		}
	}
	function getDataFromFile($IP){
		include("geoip.inc");
		include("geoipregionvars.php");

		$this->_found = false;

		$gi = geoip_open($this->_installPath . "/" . $this->_GeoIpCountryFile, GEOIP_STANDARD);
		$this->_countryCode = geoip_country_code_by_addr($gi, $IP);
		$this->_countryName = geoip_country_name_by_addr($gi, $IP);
		geoip_close($gi);

		if ($this->_countryCode != "") $this->_found = true;
	}
	function getCountryDataFromFile($IP){
		$this->_found = false;
		$IPnum = $this->IPAddress2IPNumber($IP);
		$this->IP2 = $IPnum;
		$row = 1;
		
		$handle = fopen($this->_IP2CountryFileName, "r");
		while (($data = fgetcsv($handle, 1000, ",")) !== FALSE) {
		    $num = count($data);
		    $row++;
		    if ($IPnum >= $data[0] and $IPnum <= $data[1]){
				//IP range found !
				$this->_found = true;
				fclose($handle);
				$this->_countryCode = $data[2];
				$this->_countryCode3C = $data[3];
				$this->_countryName = $data[4];
				return;
			}
		}
		fclose($handle);	
	}
	
    function IpAddress2IpNumber($address)
    {
        $pattern = "([0-9]+).([0-9]+).([0-9]+).([0-9]+)";
        if (ereg($pattern, $address, $regs))
            return $number = $regs[1] * 256 * 256 * 256 + $regs[2] * 256 * 256 + $regs[3] * 256 + $regs[4];
        else
            return false;
    }
	
	function IPNumber2IPAddress($number) {
		$a = ($number/16777216)%256;
		$b = ($number/65536)%256;
		$c = ($number/256)%256;
		$d = ($number)%256;

		$Nombre = $number;  			// grand nombre divis par 256
		$div = $Nombre / 256;    		// $div = rsultat de la division
		$frac = $div - floor( $div );   // $frac = partie aprs la virgule
		$d = ceil($frac * 256);   		// Modulo ! 		

		$dotted = $a.".".$b.".".$c.".".$d;

		return $dotted;
	}

	function found(){
		return $this->_found;
	}
}

?>