<?php
	/***********************************************************************************
	* V1.0 - 26/08/2009
	* File Name			: iplocator.php
	* Usage				: used to locate ip for the prestashop StatsTracksVisits module
	* Author			: Fabien LAHAULLE (fabien.lahaulle@gmail.com)
	* Author WebSite 	: www.mariage-tranquille.fr
	* Contact Website	: contact@mariage-tranquille.fr
	* 
	***********************************************************************************/

	include(dirname(__FILE__)."/geoip/jpt_geoip.class.php");
	$imgpath ="";
	$imgCountryName ="";
	$logVisitor=null;
	
	if (isset($_GET['visitorip'])){
		$logVisitor = findCountryFromIP($_GET['visitorip']);
		$imgpath = $logVisitor->_flagFileName;
		$imgCountryName = $logVisitor->_countryName;
	}
	else
		exit;
	


	$source = imagecreatefromgif(dirname(__FILE__)."/". $imgpath); //on ouvre l'image source
	$w = imagesx($source);
	$h = imagesy($source); 

	$destination = imagecreate(150, $h);
	$background_color = imagecolorallocate($destination, 255, 255, 255);
	imagecolortransparent($destination,$background_color);
	$text_color = imagecolorallocate($destination, 255, 0, 0);
	imagecopy($destination,$source, 0,0,0,0,$w,$h); 
	imagestring  ( $destination  , 3  , $w+5  , 0  , $imgCountryName  , $text_color );

	header("Content-type: image/png"); //on envoie les infos au navigateur
	imagepng($destination);
	imagedestroy($destination, $source);

	
	//------------------------------------------
	function findCountryFromIP($IP){
		global $imgpath;
		global $imgtitle;
		if ($IP != ''){
			$logVisitor = new Visitor();
			$logVisitor->enableCountrySearch(true);
			$logVisitor->Analyze($IP);
			return $logVisitor;
		}

	}
	//------------------------------------------
	
class Visitor{
	private $_useCountry = false;
	private $_useHostName = false;
	
	public $_proxyIP = "";
	public $_IP = "";
	public $_hostname = "";
	public $_date = "";
	public $_hour = "";
	public $_timestamp = "";
	
	public $_countryName 	= "";
	public $_countryCode 	= "";
	public $_flagFileName 	= "";
	
	//-------------------------------------------
	/* PUBLIC FUNCTIONS */
	//-------------------------------------------
	public function Analyze($IP=""){
		$hostname = "";
		$this->getDate();
		$this->getHour();
		$this->getTimeStamp();
	
		//IP
		if ($IP == "") 
			$this->getIPs();
		else 
			$this->_IP = $IP;
			
		$this->getTimeStamp();
		
		//COUNTRY
		$countryName = "";
		$countryCode = "";
		$flagFileName = "";
		if ($this->_useCountry){
			$geo = new JPT_GeoIP("geoip");
			$geo->useFlag(true);
			if ($this->_proxyIP != "") 
				$geo->searchIP($this->_proxyIP);
			else
				$geo->searchIP($this->_IP);
			
			if ($geo->found()){
				$this->_countryName = $geo->getCountryName();
				$this->_countryCode = $geo->getCountryCode();
				$this->_flagFileName = $geo->getFlagFileName();
			}
			unset($geo);
		}
		if ($this->_useHostName){
			if ($this->_proxyIP != "") 
				$_hostname = $this->getHostName($this->_proxyIP);
			else
				$_hostname = $this->getHostName($this->_IP);
		}
	}
	public function enableCountrySearch($value){$this->_useCountry = $value;}
	public function enableHostNameSearch($value){$this->_useHostName = $value;}
	
	//-------------------------------------------
	/* PRIVATE FUNCTIONS */
	//-------------------------------------------
	private function getDate(){  $this->_date = date("Y-m-d"); return $this->_date; }
	private function getHour(){  $this->_hour = date("H:i:s"); return $this->_hour;}
	private function getTimeStamp(){ $this->_timestamp = time(); return $this->_timestamp; }

	function getIPs() {
		if ($_SERVER["HTTP_X_FORWARDED_FOR"]) {
		   if ($_SERVER["HTTP_CLIENT_IP"]) {
		    $this->_proxyIP = $_SERVER["HTTP_CLIENT_IP"];
		  } else {
		    $this->_proxyIP = $_SERVER["REMOTE_ADDR"];
		  }
		  $this->_IP = $_SERVER["HTTP_X_FORWARDED_FOR"];
		} else {
		  if ($_SERVER["HTTP_CLIENT_IP"]) {
		    $this->_IP = $_SERVER["HTTP_CLIENT_IP"];
		  } else {
		    $this->_IP = $_SERVER["REMOTE_ADDR"];
		  }
		}	
	} 	
	
	public function getBrowser(){ if (isset($_SERVER['HTTP_USER_AGENT'])) return $_SERVER['HTTP_USER_AGENT']; }
	public function getPreviousPage(){ if (isset($_SERVER['HTTP_REFERRER'])) return $_SERVER['HTTP_REFERRER']; }
	public function getCurrentPage(){ if (isset($_SERVER['PHP_SELF'])) return $_SERVER['PHP_SELF']; }
	public function getHostName($IP){ $this->_hostname = gethostbyaddr($IP); return $this->_hostname;}
}
	//-------------------------------------------------------------------------------------------------------------------------------------
	// FUNCTIONS TO LOG THE EXECUTION OF THE SCRIPT
	//-------------------------------------------------------------------------------------------------------------------------------------
	function initTrace(){
		global $fpLog;
		if (LOG_BACKUP == 1){
			if (LOG_BACKUP_FILE == 1){
				//open file to store the log
				$fpLog = fopen("backuplog.txt", "a");
			}
		}
	}
	function endTrace(){
		global $fpLog;
		if (LOG_BACKUP == 1){
			if (LOG_BACKUP_FILE == 1){
				//close file log
				fclose($fpLog);
			}
		}
	}
	function Trace($msg){
		global $fpLog;
		if (LOG_BACKUP == 1){
			if (LOG_BACKUP_FILE == 0)
				echo "<br/>" . $msg;
			else
				fwrite($fpLog, $msg . "\r\n");
		}		
	}
?>