<?php

/****************************************
*         Module StatTrackVisits		*
*         Author: Raphael Havez			*
*         www.coffret-intime.fr			*
*         You like this Module?			*
*        You can make a Donation!		*
*      If you want, and if you can,		*
*          with Paypal to email			*
*       paiement@coffret-intime.fr		*
*			or go to URL				*
* http://www.coffret-intime.fr/don.htm	*
*               Thanks :)				*
****************************************/
  
/*****************************************************************************
* V1.2.2 - 26/08/2009
* Evolution 		: added geolocalization in this module, so as to display
*					the country flag of the visitor on the website.
* Modified files 	: ./statstrackvisits.php (you can search for $imgCountry)
* Added files 		: ./iplocator.php		(to get CountryFlag/CountryName)
* Added folders 	: ./geoip				(All the geolocalization part)
* Author			: Fabien LAHAULLE (fabien.lahaulle@gmail.com)
* Author WebSite 	: www.mariage-tranquille.fr
*****************************************************************************/

class StatsTrackVisits extends Module
{
    private $_html = '';

    function __construct()
    {
        $this->name = 'statstrackvisits';
        $this->tab = 'Stats';
        $this->version = '1.2.3';
		$this->page = basename(__FILE__, '.php');
			
		parent::__construct();
		
        $this->displayName = $this->l('Tracking visitors');
        $this->description = $this->l('Allows you to track your visitors on your website, and see her origin.');
    }
	
	public function install()
	{
		return (parent::install() AND $this->registerHook('AdminStatsModules'));
	}
	
	private function getPageView($id_connections)
	{
		return Db::getInstance()->ExecuteS('
		SELECT pt.name, cp.time_start, p.id_object, p.id_page
		FROM `'._DB_PREFIX_.'connections` c
		LEFT JOIN `'._DB_PREFIX_.'connections_page` cp ON c.id_connections = cp.id_connections
		INNER JOIN `'._DB_PREFIX_.'page` p ON cp.id_page = p.id_page
		INNER JOIN `'._DB_PREFIX_.'page_type` pt ON pt.id_page_type = p.id_page_type
		WHERE '.( preg_match("/^1.1/", _PS_VERSION_ ) ? 'c.`date_add` LIKE \''.pSQL(ModuleGraph::getDateLike()).'\'' : '(c.`date_add` BETWEEN '.ModuleGraph::getDateBetween().')' ).'
		AND c.id_connections = '.$id_connections.'
		ORDER BY cp.time_start');
	}
	
	private function getComeBack($ip_address,$id_guest)
	{
		return Db::getInstance()->ExecuteS('
		SELECT *
		FROM `'._DB_PREFIX_.'connections` c
		WHERE '.( preg_match("/^1.1/", _PS_VERSION_ ) ? 'c.`date_add` LIKE \''.pSQL(ModuleGraph::getDateLike()).'\'' : '(c.`date_add` BETWEEN '.ModuleGraph::getDateBetween().')' ).'
		AND (c.ip_address = '.$ip_address.' OR c.id_guest = '.$id_guest.')
		');
	}
	
	private function ShowName($name, $id_object,$id_lang,$id_page)
	{		
		switch ($name) 
		{
			case 'index.php':
				return '<b>'.$this->l('Homepage').'</b>';
				break;
			case 'product.php':
				$sql = Db::getInstance()->ExecuteS('
				SELECT name
				FROM `'._DB_PREFIX_.'product_lang`
				WHERE id_product = '.$id_object.'
				AND id_lang = '.$id_lang.'
				');
				return '<b>'.$this->l('Product :').'</b> '.$sql[0]['name'];
				break;
			case 'category.php':
				$sql = Db::getInstance()->ExecuteS('
				SELECT name
				FROM `'._DB_PREFIX_.'category_lang`
				WHERE id_category = '.$id_object.'
				AND id_lang = '.$id_lang.'
				');
				return '<b>'.$this->l('Category :').'</b> '.$sql[0]['name'];
				break;
			case 'order.php':
				$sql = Db::getInstance()->ExecuteS('
				SELECT id_object
				FROM `'._DB_PREFIX_.'page`
				WHERE id_page = '.$id_page.'
				');
				$showname = $sql[0]['id_object'] == 0 ? '1 - '.$this->l('Cart'): $showname;
				$showname = $sql[0]['id_object'] == 1 ? '2 - '.$this->l('Address'): $showname;
				$showname = $sql[0]['id_object'] == 2 ? '3 - '.$this->l('Transport and GCS'): $showname;
				$showname = $sql[0]['id_object'] == 3 ? '4 - '.$this->l('Payment options'): $showname;
				return '<b style="color: green;">'.$this->l('Order :').'</b> '.$showname;
				break;
			case '404.php':
				return '<b style="color: red;">'.$this->l('Error : Page 404.php').'</b> ';		
				break;
			case 'my-account.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('Homepage');
				break;
			case 'history.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My orders');
				break;
			case 'order-slip.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My credits');
				break;
			case 'address.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My addresses');
				break;
			case 'identity.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My personal information');
				break;
			case 'discount.php':
				return '<b>'.$this->l('My Account :').'</b> '.$this->l('My vouchers');
				break;
			case 'authentication.php':
				return '<b style="color: blue;">'.$this->l('Authentication or subscription').'</b> ';
				break;
			case 'modules/cheque/payment.php':
				return '<b style="color: green;">'.$this->l('Order :').'</b> 5 - '.$this->l('Cheque payment');
				break;
			case 'modules/bankwire/payment.php':
				return '<b style="color: green;">'.$this->l('Order :').'</b> 5 - '.$this->l('Bank wire payment');
				break;
			case 'modules/cashondelivery/validation.php':
				return '<b style="color: green;">'.$this->l('Order :').'</b> 5 - '.$this->l('Payment on delivery');
				break;
			case 'modules/paypalapi/payment/submit.php':
				return '<b style="color: green;">'.$this->l('Order :').'</b> 5 - '.$this->l('Payment Paypal API');
				break;
			case 'order-confirmation.php':
				return '<b style="color: green;">'.$this->l('Order :').'</b> 6 - '.$this->l('Order confirmation');
				break;
			case 'manufacturer.php':
				return '<b>'.$this->l('Manufacturer').'</b>';
				break;
			case 'best-sales.php':
				return '<b>'.$this->l('Best sales').'</b>';
				break;
			case 'sitemap.php':
				return '<b>'.$this->l('Sitemap').'</b>';
				break;
			case 'prices-drop.php':
				return '<b>'.$this->l('Specials').'</b>';
				break;
			case 'contact-form.php':
				return '<b>'.$this->l('Contact form').'</b>';
				break;
			case 'search.php':
				return '<b>'.$this->l('Search').'</b>';
				break;
			case 'cms.php':
				return '<b>'.$this->l('CMS pages :').'</b> '.$this->l('GCS, legal,...');
				break;
			case 'new-products.php':
				return '<b>'.$this->l('New products').'</b>';
				break;
			case 'modules/sendtoafriend/sendtoafriend-form.php':
				return '<b>'.$this->l('Send to a friend').'</b>';
				break;
			case 'modules/productquestion/productquestion-form.php':
				return '<b>'.$this->l('Product question form').'</b>';
				break;
			default:
				return $name;
		}
	}
	
	private function getCustomers($resultperpage,$page, $limit, $orderby, $orderbyobject, $http_referer, $showstep, $showcart, $employee, $timeofflinemin, $timeofflinesec, $ipfilter)
	{
		return Db::getInstance()->ExecuteS('
		SELECT u.id_customer, u.firstname, u.lastname, c.ip_address, c.date_add, c.http_referer, c.id_connections, c.id_guest, clp.time_start, cu.id_customer AS new, (TIMEDIFF(MAX(cp.`time_start`), MIN(cp.`time_start`))) AS duration'.( preg_match("/^1.1/", _PS_VERSION_ ) ? '' : ', ct.id_cart, o.id_order' ).'
		FROM `'._DB_PREFIX_.'connections` c
		LEFT JOIN `'._DB_PREFIX_.'connections_page` cp ON c.id_connections = cp.id_connections
		INNER JOIN `'._DB_PREFIX_.'guest` g ON c.id_guest = g.id_guest
		INNER JOIN `'._DB_PREFIX_.'customer` u ON u.id_customer = g.id_customer
		INNER JOIN `'._DB_PREFIX_.'page` p ON p.id_page = cp.id_page
		LEFT JOIN `'._DB_PREFIX_.'connections_page` clp ON ( c.id_connections = clp.id_connections AND TIME_TO_SEC(TIMEDIFF(NOW(), clp.`time_start`)) < '.(($timeofflinemin * 60) + $timeofflinesec).')
		LEFT JOIN `'._DB_PREFIX_.'customer` cu ON ( cu.id_customer = g.id_customer AND TIME_TO_SEC(TIMEDIFF(NOW(), cu.date_add)) < 86400 )
		'.( preg_match("/^1.1/", _PS_VERSION_ ) ? '' : '
			LEFT JOIN `'._DB_PREFIX_.'cart` ct ON ( ct.id_customer = u.id_customer AND ct.`date_upd` BETWEEN c.date_add AND (SELECT MAX(time_start) FROM `'._DB_PREFIX_.'connections_page` WHERE id_connections = c.id_connections))
			LEFT JOIN `'._DB_PREFIX_.'orders` o ON o.id_cart = ct.id_cart
		' ).'
		WHERE '.( preg_match("/^1.1/", _PS_VERSION_ ) ? 'c.`date_add` LIKE \''.pSQL(ModuleGraph::getDateLike()).'\'' : '(c.`date_add` BETWEEN '.ModuleGraph::getDateBetween().')' ).'
		'.( $http_referer ? 'AND c.http_referer LIKE \''.$http_referer.'\'' : '' ).'
		'. ( $showstep == 'error' ? 'AND p.id_page_type = 8' : ( $showstep == 'anypage' ? '' : 'AND p.id_page_type = 3 AND p.'.$showstep.'' )) .'
		'. ( $ipfilter ? 'AND c.ip_address NOT IN ( '. implode(',',array_values($ipfilter)).' )' : '' ).'
		'.(( !preg_match("/^1.1/", _PS_VERSION_ ) AND $showcart ) ? 'AND ct.id_cart != 0' : '' ).'
		GROUP BY c.id_connections
		'.($limit == 1 ? '
			ORDER BY '.$orderbyobject.' '.$orderby.'
			LIMIT '.(($page*$resultperpage)-$resultperpage).', '.$resultperpage 
		: '').''
		);
	}
	
	private function getVisitors($resultperpage, $page, $limit, $orderby, $orderbyobject, $http_referer, $showstep, $showcart, $employee, $timeofflinemin, $timeofflinesec, $ipfilter)
	{
		return Db::getInstance()->ExecuteS('
		SELECT c.id_guest, c.ip_address, c.date_add, c.http_referer, c.id_connections, c.id_guest, clp.time_start, (TIMEDIFF(MAX(cp.`time_start`), MIN(cp.`time_start`))) AS duration'.( preg_match("/^1.1/", _PS_VERSION_ ) ? '' : ', ct.id_cart' ).'
		FROM `'._DB_PREFIX_.'connections` c
		LEFT JOIN `'._DB_PREFIX_.'connections_page` cp ON c.id_connections = cp.id_connections
		INNER JOIN `'._DB_PREFIX_.'guest` g ON c.id_guest = g.id_guest
		INNER JOIN `'._DB_PREFIX_.'page` p ON p.id_page = cp.id_page
		LEFT JOIN `'._DB_PREFIX_.'connections_page` clp ON ( c.id_connections = clp.id_connections AND TIME_TO_SEC(TIMEDIFF(NOW(), clp.`time_start`)) < '.(($timeofflinemin * 60) + $timeofflinesec).')
		'.( preg_match("/^1.1/", _PS_VERSION_ ) ? '' : 'LEFT JOIN `'._DB_PREFIX_.'cart` ct ON ( ct.id_guest = c.id_guest AND ct.`date_upd` BETWEEN c.date_add AND (SELECT MAX(time_start) FROM `'._DB_PREFIX_.'connections_page` WHERE id_connections = c.id_connections))' ).'
		WHERE (g.id_customer IS NULL OR g.id_customer = 0)
		AND '.( preg_match("/^1.1/", _PS_VERSION_ ) ? 'c.`date_add` LIKE \''.pSQL(ModuleGraph::getDateLike()).'\'' : '(c.`date_add` BETWEEN '.ModuleGraph::getDateBetween().')' ).'
		'.( $http_referer ? 'AND c.http_referer LIKE \''.$http_referer.'\'' : '' ).'
		'. ( $showstep == 'error' ? 'AND p.id_page_type = 8' : ( $showstep == 'anypage' ? '' : 'AND p.id_page_type = 3 AND p.'.$showstep.'' )) .'
		'. ( $ipfilter ? 'AND c.ip_address NOT IN ( '. implode(',',array_values($ipfilter)).' )' : '' ).'
		'.(( !preg_match("/^1.1/", _PS_VERSION_ ) AND $showcart ) ? 'AND ct.id_cart != 0' : '' ).'
		GROUP BY c.id_connections
		'.($limit == 1 ? '
			ORDER BY '.($orderbyobject == 'c.id_guest' ? 'c.ip_address' : $orderbyobject).' '.$orderby.'
			LIMIT '.(($page*$resultperpage)-$resultperpage).', '.$resultperpage 
		: '').''
		);
	}
	
	public function hookAdminStatsModules($params)
	{
		global $cookie;
		
		$employee = !preg_match("/^1.1/", _PS_VERSION_ ) ? new Employee(intval($cookie->id_employee)) : '';
		
		if ((empty($employee->stats_date_from) OR empty($employee->stats_date_to)) AND !preg_match("/^1.1/", _PS_VERSION_ ))
		{
			if (empty($employee->stats_date_from))
				$employee->stats_date_from = date('Y').'-01-01';
			if (empty($employee->stats_date_to))
				$employee->stats_date_to = date('Y').'-12-31';
			$employee->update();
		}
		
		if (!empty($_POST['submitStatstrackvisits_save']))
		{
			$settingfile = '../modules/'.$this->name.'/setting.inc.php';
			
			$settingfileOpen = fopen($settingfile,"w");
			
			fwrite($settingfileOpen,
				'<?php' . "\n" .
				'$setting = \''.$_POST['setting'].'\';' . "\n" .
				'$resultperpage = \''.$_POST['resultperpage'].'\';' . "\n" .
				'$orderbyobject = \''.$_POST['orderbyobject'].'\';' . "\n" .
				'$orderby = \''.$_POST['orderby'].'\';' . "\n" .
				'$show = \''.$_POST['show'].'\';' . "\n" .
				'$keyword = \''.$_POST['keyword'].'\';' . "\n" .
				'$showstep = \''.$_POST['showstep'].'\';' . "\n" .
				'$showcart = \''.$_POST['showcart'].'\';' . "\n" .
				'$timeofflinemin = \''.intval($_POST['timeofflinemin']).'\';' . "\n" .
				'$timeofflinesec = \''.intval($_POST['timeofflinesec']).'\';' . "\n" .
				'$showipmember = \''.$_POST['showipmember'].'\';' . "\n" .
				'$nbipfilter = \''.$_POST['nbipfilter'].'\';' . "\n" .
				'$ipfilter = Array ('
				);
			
			$i = 0;
			foreach ($_POST['ipfilter'] as $ipfilter)
			{
				$i++;
				fwrite($settingfileOpen,
					' '.$i.' => "'.intval(ip2long($ipfilter)).'",'
					);
			}
			
			fwrite($settingfileOpen,
				' "end" => "0" );' . "\n" .
				'$verif = \''.($_POST['verif']+1).'\';' . "\n" .
				'?>'
				);
			
				
			fclose($settingfileOpen);
		}
		
		require('../modules/'.$this->name.'/setting.inc.php');
		
		$page = !empty($_POST['page']) ? $_POST['page'] : '1';
		
		if (!empty($_POST['firstpage_x']))
			$page = 1;
		elseif (!empty($_POST['pagedown_x']))
			$page = $page - 1;
		elseif (!empty($_POST['pageup_x']))
			$page = $page + 1;
		elseif (!empty($_POST['lastpage_x']))
			$page = $_POST['nblastpage'];
		else
			$page = $page;
			
		$setting = !empty($_POST['setting']) ? $_POST['setting'] : $setting;
		$resultperpage = !empty($_POST['resultperpage']) ? $_POST['resultperpage'] : $resultperpage;
		$orderbyobject = !empty($_POST['orderbyobject']) ? $_POST['orderbyobject'] : $orderbyobject;
		$orderby = !empty($_POST['orderby']) ? $_POST['orderby'] : $orderby;
		$show = !empty($_POST['show']) ? $_POST['show'] : $show;
		$keyword = !empty($_POST['keyword']) ? $_POST['keyword'] : $keyword;
		$http_referer = $keyword ? '%'. str_replace(' ','%', $keyword). '%' : '';
		$showstep = !empty($_POST['showstep']) ? $_POST['showstep'] : $showstep;
		$showcart = !empty($_POST['showcart']) ? $_POST['showcart'] : $showcart;
		$timeofflinemin = !empty($_POST['timeofflinemin']) ? intval($_POST['timeofflinemin']) : intval($timeofflinemin);
		$timeofflinemin = !empty($timeofflinemin) ? intval($timeofflinemin) : '00';
		$timeofflinesec = !empty($_POST['timeofflinesec']) ? intval($_POST['timeofflinesec']) : intval($timeofflinesec);
		$timeofflinesec = !empty($timeofflinesec) ? intval($timeofflinesec) : '00';
		$showipmember = !empty($_POST['showipmember']) ? $_POST['showipmember'] : $showipmember;
		$nbipfilter = !empty($_POST['nbipfilter']) ? intval($_POST['nbipfilter']) : intval($nbipfilter);
		
		if (!empty($_POST['ipfilter']))
		{
			$ipfilter = Array ( 1 => 1);
			$i = 0;
			foreach ($_POST['ipfilter'] as $ipfilters)
			{
				$i++;
				$ipfilter[$i] = intval(ip2long($ipfilters));
			}
		}
		
		if ($show == 'all' OR $show == 'members')
		{
			$customers = $this->getCustomers($resultperpage, $page, 0, $orderby, $orderbyobject, $http_referer, $showstep, $showcart, $employee, $timeofflinemin, $timeofflinesec, $ipfilter);
			$totalCustomers = Db::getInstance()->NumRows();
		}
		else
			$totalCustomers = 1;
		
		if ($show == 'all' OR $show == 'visitors')
		{
			$visitors = $this->getVisitors($resultperpage, $page, 0, $orderby, $orderbyobject, $http_referer, $showstep, $showcart, $employee, $timeofflinemin, $timeofflinesec, $ipfilter);
			$totalVisitors = Db::getInstance()->NumRows();
		}
		else
			$totalVisitors = 1;
			
		$totalpageCustomers = ceil($totalCustomers/$resultperpage);
		$totalpageVisitors = ceil($totalVisitors/$resultperpage);
		
		if($show == 'members')
			$totalpage = $totalpageCustomers;
		elseif($show == 'visitors')
			$totalpage = $totalpageVisitors;
		else
			$totalpage = $totalpageVisitors >= $totalpageCustomers ? $totalpageVisitors : $totalpageCustomers ;
		
		$totalpage = $totalpage == 0 ? 1 : $totalpage ;
		
		$this->_html = '<script type="text/javascript" src="../modules/'.$this->name.'/statstrackvisits.js"></script>
		<form name="submitStatstrackvisits" method="post" action="index.php?tab=AdminStatsModules&token='.Tools::getValue('token').'&module='.$this->name.'">
			<fieldset class="width3"><legend><img src="../modules/'.$this->name.'/img/setting.gif" /> '.$this->l('Option').'</legend>
				';
				if(!empty($_POST['submitStatstrackvisits_save']))
				{
					$this->_html .= ($verif == ($_POST['verif'])+1 ? '<p style="color: green; font-weight: bold ;">'.$this->l('Saving of default options successful!').'</p>' : '<p style="color: red; font-weight: bold ;">'.$this->l('Error to write File: Please check for sufficient write file permissions for file').' "../modules/'.$this->name.'/setting.inc.php"</p>');
				}
				$this->_html .= '
				<p>
					<strong>'.$this->l('Search by keyword in the URL of origin').'</strong>
					<br />
					<input type="text" value="'.$keyword.'" name="keyword" style="width: 150px;"/>
				</p>
				<p>
					<strong>'.$this->l('View only members and visitors have visited the page:').'</strong>
					<br />
					<select name="showstep">
						<option '.($showstep == 'anypage' ? 'selected="selected" ': '').'value="anypage">'.$this->l('Any page').'</option>
						<option '.($showstep == 'id_object = 0' ? 'selected="selected" ': '').'value="id_object = 0">'.$this->l('Order :').' '.$this->l('Cart').'</option>
						<option '.($showstep == 'id_object = 1' ? 'selected="selected" ': '').'value="id_object = 1">'.$this->l('Order :').' '.$this->l('Address').'</option>
						<option '.($showstep == 'id_object = 2' ? 'selected="selected" ': '').'value="id_object = 2">'.$this->l('Order :').' '.$this->l('Transport and GCS').'</option>
						<option '.($showstep == 'id_object = 3' ? 'selected="selected" ': '').'value="id_object = 3">'.$this->l('Order :').' '.$this->l('Payment options').'</option>
						<option '.($showstep == 'error' ? 'selected="selected" ': '').'value="error">'.$this->l('Error : Page 404.php').'</option>
					</select>
				</p>
				<p>
					<label for="showcart" style="float:none; font-weight:normal; padding:0; text-align:left; width:auto;">
						<input type="checkbox" name="showcart" value="yes" id="showcart" '.($showcart == 'yes' ? 'checked="checked"' : '').'/>
						'.$this->l('View only members and/or visitors with a Cart. ( With Prestashop 1.2.X )').'
					</label>
				</p>
				<p>
					<input class="button" type="submit" name="submitStatstrackvisits" value="'.$this->l('Search').'"/>
				</p>
				<p style="cursor: pointer; text-align: left;" onclick="javascript:openCloseLayerTr(\'viewsetting\');">
					<img src="../modules/'.$this->name.'/img/more.gif" />'.$this->l('Click here for show or hide more options.').'
				</p>
			<div id="viewsetting" style="display: none;">
				<p>
					<strong>'.$this->l('Exclude these IP addresses').'</strong>
					<br />
					<strong>'.$this->l('Number of IP address to exclude?').'</strong> <input type="text" value="'.$nbipfilter.'" name="nbipfilter" style="width: 20px;"/>
					<br />';
					for ($i = 1 ; $i <= $nbipfilter ; $i++)
						{
							$this->_html .= '<input type="text" value="'.long2ip($ipfilter[$i]).'" name="ipfilter['.$i.']" maxlength="15" style="width: 110px;"/>&nbsp;';
						}
				$this->_html .= '
				</p>
				<p>
					<strong>'.$this->l('Full display of the original URL?').'</strong>
					<br />'.$this->l('(Allows you to see key words)').'
					<br />
					<select name="setting">
						<option '.($setting == 'yes' ? 'selected="selected" ': '').'value="yes"> '.$this->l('Yes').' </option>
						<option '.($setting == 'no' ? 'selected="selected" ': '').'value="no"> '.$this->l('No').' </option>
					</select>
				</p>
				<p>
					<strong>'.$this->l('Order by:').'</strong>
					<br />
					<select name="orderbyobject">
						<option '.($orderbyobject == 'c.date_add' ? 'selected="selected" ': '').'value="c.date_add"> '.$this->l('Date & Hour').' </option>
						<option '.($orderbyobject == 'c.id_guest' ? 'selected="selected" ': '').'value="c.id_guest"> '.$this->l('ID Members or IP Visitors').' </option>
					</select>
					<select name="orderby">
						<option '.($orderby == 'ASC' ? 'selected="selected" ': '').'value="ASC"> '.$this->l('Ascending').' </option>
						<option '.($orderby == 'DESC' ? 'selected="selected" ': '').'value="DESC"> '.$this->l('Descending').' </option>
					</select>
				</p>
				<p>
					<strong>'.$this->l('Number of results per page and per table:').'</strong>
					<br />
					<select name="resultperpage">
						<option '.($resultperpage == '10' ? 'selected="selected "': '').'value="10">10</option>
						<option '.($resultperpage == '20' ? 'selected="selected "': '').'value="20">20</option>
						<option '.($resultperpage == '50' ? 'selected="selected "': '').'value="50">50</option>
						<option '.($resultperpage == '100' ? 'selected="selected "': '').'value="100">100</option>
					</select>
				</p>
				<p>
					<strong>'.$this->l('Show').'</strong>
					<br />
					<select name="show">
						<option '.($show == 'all' ? 'selected="selected "': '').'value="all">'.$this->l('All').'</option>
						<option '.($show == 'members' ? 'selected="selected "': '').'value="members">'.$this->l('Members only').'</option>
						<option '.($show == 'visitors' ? 'selected="selected "': '').'value="visitors">'.$this->l('Visitors only').'</option>
					</select>
				</p>
				<p>
					<strong>'.$this->l('Inactivity time before considering a person offline?').'</strong>
					<br />
					<input type="text" value="'.$timeofflinemin.'" name="timeofflinemin" maxlength="3" style="width: 30px; text-align: right;"/> '.$this->l('min').'
					<input type="text" value="'.$timeofflinesec.'" name="timeofflinesec" maxlength="2" style="width: 20px;"/> '.$this->l('sec').'
				</p>
				<p>
					<label for="showipmember" style="float:none; font-weight:normal; padding:0; text-align:left; width:auto;">
						<input type="checkbox" name="showipmember" value="yes" id="showipmember" '.($showipmember == 'yes' ? 'checked="checked"' : '').'/>
						'.$this->l('Show ip Members').'
					</label>
				</p>
				<p>
					<input class="button" type="submit" name="submitStatstrackvisits_save" value="'.$this->l('Save these settings as default settings').'"/>
					<input type="hidden" name="verif" value="'.$verif.'">
				</p>
				<p>
					<input class="button" type="submit" name="submitStatstrackvisits" value="'.$this->l('Search').'"/>
				</p>
			</div>
			</fieldset>
			<fieldset class="width3 space"><legend><img src="../modules/'.$this->name.'/img/setting.gif" /> '.$this->l('Pagination').'</legend>
				<p>
					'.$this->l('Go directly to page').' 
					<select onChange="submit();" name="page">
						';
						for ($i = 1 ; $i <= $totalpage ; $i++)
						{
							$this->_html .='<option '.($i == $page ? 'selected="selected "': '').'value="'.$i.'">&nbsp;'.$i.'&nbsp;</option>';
						} 
						$this->_html .= '
					</select> / '.$totalpage.'
				</p>
				<p style="text-align: center; display: block; width:600px; border-top: 7px;">
					<input '.($page <= 1 ? 'style="display: none" ' : '').'name="firstpage" type="image" onclick="submit();" src="../modules/'.$this->name.'/img/list-prev2.gif"/>
					&nbsp;<input '.($page <= 1 ? 'style="display: none" ' : '').'name="pagedown" type="image" onclick="submit();" src="../modules/'.$this->name.'/img/list-prev.gif"/>
					&nbsp;'.$this->l('Page').' '.$page.' / '.$totalpage.'
					&nbsp;<input '.($page >= $totalpage ? 'style="display: none" ' : '').'name="pageup" type="image" onclick="submit();" src="../modules/'.$this->name.'/img/list-next.gif"/>
					&nbsp;<input '.($page >= $totalpage ? 'style="display: none" ' : '').'name="lastpage" type="image" onclick="submit();" src="../modules/'.$this->name.'/img/list-next2.gif"/>
					<input type="hidden" name="nblastpage" value="'.$totalpage.'">
				</p>
			</fieldset>';
		
		$irow = 0;

	if ($show == 'all' OR $show == 'members')
	{
		$customers = $this->getCustomers($resultperpage, $page, 1, $orderby, $orderbyobject, $http_referer, $showstep, $showcart, $employee, $timeofflinemin, $timeofflinesec , $ipfilter);
		$this->_html .= '<fieldset class="width3 space"><legend><img src="../modules/'.$this->name.'/img/logo.gif" /> '.$this->l('Member(s)').'</legend>';
		if ($totalCustomers)
		{
			$this->_html .= $this->l('Total:').' '.intval($totalCustomers).'
			<table cellpadding="0" cellspacing="0" class="table space">
				<tr><th style="text-align: center;">'.$this->l('Details').'</th><th style="text-align: center;">'.$this->l('ID').'</th>'.($showipmember == 'yes' ? '<th style="text-align: center;">'.$this->l('IP').'</th>' : '' ).'<th style="width: 150px; text-align: center;">'.$this->l('Name').'</th><th style="text-align: center;">'.$this->l('Online?').'<br />'.$this->l('(duration)').'</th><th style="text-align: center;">'.$this->l('View page(s)').'</th><th style="text-align: center;">'.$this->l('Number of visits').'</th><th style="text-align: center;">'.$this->l('Date & Hour').'</th>'.( preg_match("/^1.1/", _PS_VERSION_ ) ? '' : '<th style="text-align: center;">'.$this->l('Cart').'</th>' ).'<th style="text-align: center;">'.$this->l('Member page').'</th><th style="text-align: left;">'.$this->l('Origin').'</th></tr>';
			foreach ($customers as $customer)
			{
				global $cart;
				$nbpageview = $this->getPageView($customer['id_connections']);
				$totalNbpageview = Db::getInstance()->NumRows();
				$comeback = $this->getComeBack($customer['ip_address'],$customer['id_guest']);
				$totalComeback = Db::getInstance()->NumRows();

				//Fabien LAHAULLE - 26/08/2009 - geolocalization addon
				$imgCountry= '<img src="'. $this->_path .'iplocator.php?visitorip='.long2ip($customer['ip_address']) .'" alt="" title="" /><br />';
				//End
				$this->_html .= '
				<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');"><img src="../modules/'.$this->name.'/img/more.gif" /></td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.$customer['id_customer'].'</td>
					'.($showipmember == 'yes' ? '<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.long2ip($customer['ip_address']).'</td>' : '' ).'
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.( $customer['new'] ? '<img src="../modules/'.$this->name.'/img/new.gif" /><br />' : '' ).$customer['firstname'].' '.$customer['lastname'].'</td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.( $customer['time_start'] ? '<img src="../modules/'.$this->name.'/img/online.gif" />' : '<img src="../modules/'.$this->name.'/img/offline.gif" />' ).'<br />('.$customer['duration'].')</td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.$totalNbpageview.'</td>
					<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.intval($totalComeback).'</td>
					<td style="cursor: pointer; text-align: right;" onclick="javascript:openCloseLayerTr(\'pviewby'.$customer['id_connections'].'\');">'.Tools::displayDate($customer['date_add'], intval($cookie->id_lang), true).'</td>
					'.( preg_match("/^1.1/", _PS_VERSION_ ) ? '' : '<td style="text-align: center;">'.(empty($customer['id_cart']) ? '' : '<a href="index.php?tab=AdminCarts&id_cart='.$customer['id_cart'].'&viewcart&token='.Tools::getAdminToken('AdminCarts'.intval(Tab::getIdFromClassName('AdminCarts')).intval($cookie->id_employee)).'" target="_blank" style="color: '.( $customer['id_order'] ? 'green' : 'red' ).'; font-weight:bold;"><img src="../modules/'.$this->name.'/img/cart.gif" />'));
					if ( !preg_match("/^1.1/", _PS_VERSION_ ) AND !empty($customer['id_cart']) )
						$this->_html .= Cart::getTotalCart($customer['id_cart']).'</a>';
					$this->_html .= '<td style="cursor: pointer; text-align: center;">
						<a href="index.php?tab=AdminCustomers&id_customer='.$customer['id_customer'].'&viewcustomer&token='.Tools::getAdminToken('AdminCustomers'.intval(Tab::getIdFromClassName('AdminCustomers')).intval($cookie->id_employee)).'" target="_blank">
							<img src="../modules/'.$this->name.'/img/logo.gif" />
						</a>
					</td>
					<td style="text-align: left;">'.$imgCountry.(empty($customer['http_referer']) ? $this->l('None') : '<a href="'.$customer['http_referer'].'" target="_blank" style=" color: #996633;"><b>'.parse_url($customer['http_referer'], PHP_URL_HOST).'</b> <img src="../modules/'.$this->name.'/img/link.gif" />').($setting == 'yes' ? str_replace('http://'.parse_url($customer['http_referer'], PHP_URL_HOST),'<br />',$customer['http_referer']): '').'</a>';
					$this->_html .= '</td>
				</tr>
				<tr id="pviewby'.$customer['id_connections'].'" style="display: none;">
					<td colspan="9">
						<table cellpadding="0" cellspacing="0" style="margin-bottom: 10px; color: black;" class="table space">
							<tr><th style="width: 25px;">'.$this->l('ID').'</th><th style="width: 400px;">'.$this->l('View page(s)').'</th><th style="width: 150px;">'.$this->l('Date & Hour').'</th></tr>';
						$num = 0;
						$irow2 = 0;
						foreach ($nbpageview as $nbpageview)
						{
							$num = $num+1;
							$showname = $this->ShowName($nbpageview['name'], $nbpageview['id_object'], $cookie->id_lang, $nbpageview['id_page']);
							$this->_html .= '
							<tr'.($irow2++ % 2 ? ' class="alt_row"' : '').'>
								<td>'.$num.'</td>
								<td>'.$showname.'</td>
								<td>'.$nbpageview['time_start'].'</td>
							</tr>';
						}
						$this->_html .= '</table>
					</td>
				</tr>';
			}
			$this->_html .= '</table>';
		}
		else
			$this->_html .= $this->l('No Member has connected during the period chosen or with the criteria you selected.');
		$this->_html .= '</fieldset>';
	}
	if ($show == 'all' OR $show == 'visitors')
	{
		$visitors = $this->getVisitors($resultperpage, $page, 1, $orderby, $orderbyobject, $http_referer, $showstep, $showcart, $employee, $timeofflinemin, $timeofflinesec, $ipfilter);
		$this->_html .= '<fieldset class="width3 space"><legend><img src="../modules/'.$this->name.'/img/logo.gif" /> '.$this->l('Visitor(s)').'</legend>';
		if ($totalVisitors)
		{
			$this->_html .= $this->l('Total:').' '.intval($totalVisitors).'
			<table cellpadding="0" cellspacing="0" class="table space">
				<tr><th style="text-align: center;">'.$this->l('Details').'</th><th style="text-align: center;">#</th><th style="text-align: center;">'.$this->l('IP').'</th><th style="text-align: center;">'.$this->l('Online?').'<br />'.$this->l('(duration)').'</th><th style="text-align: center;">'.$this->l('View page(s)').'</th><th style="text-align: center;">'.$this->l('Number of visits').'</th><th style="text-align: center;">'.$this->l('Date & Hour').'</th>'.( preg_match("/^1.1/", _PS_VERSION_ ) ? '' : '<th style="text-align: center;">'.$this->l('Cart').'</th>' ).'<th style="text-align: left;">'.$this->l('Origin').'</th></tr>';
			foreach ($visitors as $visitor)
			{
				$nbpageview = $this->getPageView($visitor['id_connections']);
				$totalNbpageview = Db::getInstance()->NumRows();
				$comeback = $this->getComeBack($visitor['ip_address'],$visitor['id_guest']);
				$totalComeback = Db::getInstance()->NumRows();

				//Fabien LAHAULLE - 26/08/2009 - geolocalization addon
				$imgCountry= '<img src="'. $this->_path .'iplocator.php?visitorip='.long2ip($visitor['ip_address']) .'" alt="" title="" /><br />';

				$this->_html .= '
					<tr'.($irow++ % 2 ? ' class="alt_row"' : '').'>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');"><img src="../modules/'.$this->name.'/img/more.gif" /></td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.$visitor['id_guest'].'</td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.long2ip($visitor['ip_address']).'</td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.( $visitor['time_start'] ? '<img src="../modules/'.$this->name.'/img/online.gif" />' : '<img src="../modules/'.$this->name.'/img/offline.gif" />' ).'<br />('.$visitor['duration'].')</td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.$totalNbpageview.'</td>
						<td style="cursor: pointer; text-align: center;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.intval($totalComeback).'</td>
						<td style="cursor: pointer; text-align: right;" onclick="javascript:openCloseLayerTr(\'pviewby'.$visitor['id_connections'].'\');">'.Tools::displayDate($visitor['date_add'], intval($cookie->id_lang), true).'</td>
						'.( preg_match("/^1.1/", _PS_VERSION_ ) ? '' : '<td style="text-align: center;">'.(empty($visitor['id_cart']) ? '' : '<a href="index.php?tab=AdminCarts&id_cart='.$visitor['id_cart'].'&viewcart&token='.Tools::getAdminToken('AdminCarts'.intval(Tab::getIdFromClassName('AdminCarts')).intval($cookie->id_employee)).'" target="_blank" style="color: red; font-weight:bold;"><img src="../modules/'.$this->name.'/img/cart.gif" />'));
						if ( !preg_match("/^1.1/", _PS_VERSION_ ) AND !empty($visitor['id_cart']) )
							$this->_html .= Cart::getTotalCart($visitor['id_cart']).'</a>';
						$this->_html .= '<td style="text-align: left;">'.$imgCountry.(empty($visitor['http_referer']) ? $this->l('None') : '<a href="'.$visitor['http_referer'].'" target="_blank" style=" color: #996633;"><b>'.parse_url($visitor['http_referer'], PHP_URL_HOST).'</b> <img src="../modules/'.$this->name.'/img/link.gif" />').($setting == 'yes' ? str_replace('http://'.parse_url($visitor['http_referer'], PHP_URL_HOST),'<br />',$visitor['http_referer']) : '').'</a>';
						$this->_html .= '</td>
					</tr>
					<tr id="pviewby'.$visitor['id_connections'].'" style="display: none;">
						<td colspan="7">
							<table cellpadding="0" cellspacing="0" style="margin-bottom: 10px; color: black;" class="table space">
								<tr><th style="width: 25px;">'.$this->l('ID').'</th><th style="width: 400px;">'.$this->l('View page(s)').'</th><th style="width: 150px;">'.$this->l('Date & Hour').'</th></tr>';
							$num = 0;
							$irow2 = 0;
							foreach ($nbpageview as $nbpageview)
							{
								$num = $num+1;
								$showname = $this->ShowName($nbpageview['name'], $nbpageview['id_object'], $cookie->id_lang, $nbpageview['id_page']);
								$this->_html .= '
								<tr'.($irow2++ % 2 ? ' class="alt_row"' : '').'>
									<td>'.$num.'</td>
									<td>'.$showname.'</td>
									<td>'.$nbpageview['time_start'].'</td>
								</tr>';
							}
							$this->_html .= '</table>
						</td>
					</tr>';
			}
			$this->_html .= '</table>';
		}
		else
			$this->_html .= $this->l('No Visitor has connected during the period chosen or with the criteria you selected.');
			$this->_html .= '</fieldset>';
	}
		$this->_html .= '
			<fieldset class="width3 space"><legend><img src="../modules/'.$this->name.'/img/setting.gif" /> '.$this->l('Pagination').'</legend>
				<p style="text-align: center; display: block; width:600px; border-top: 7px;">
					<input '.($page <= 1 ? 'style="display: none" ' : '').'name="firstpage" type="image" onclick="submit();" src="../modules/'.$this->name.'/img/list-prev2.gif"/>
					&nbsp;<input '.($page <= 1 ? 'style="display: none" ' : '').'name="pagedown" type="image" onclick="submit();" src="../modules/'.$this->name.'/img/list-prev.gif"/>
					&nbsp;'.$this->l('Page').' '.$page.' / '.$totalpage.'
					&nbsp;<input '.($page >= $totalpage ? 'style="display: none" ' : '').'name="pageup" type="image" onclick="submit();" src="../modules/'.$this->name.'/img/list-next.gif"/>
					&nbsp;<input '.($page >= $totalpage ? 'style="display: none" ' : '').'name="lastpage" type="image" onclick="submit();" src="../modules/'.$this->name.'/img/list-next2.gif"/>
					<input type="hidden" name="nblastpage" value="'.$totalpage.'">
				</p>
			</fieldset>
		</form>';
		return $this->_html;
	}
}

?>
