<?php
include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/../../init.php');

$_MODULES = array();
function tmFileExists($dir, $file, $var)
{
	${$var} = array();
	if (!file_exists($dir))
		if (!mkdir($dir, 0700))
			die('Please create the directory '.$dir);
	if (!file_exists($dir.'/'.$file))
		if (!file_put_contents($dir.'/'.$file, "<?php\n\nglobal \$".$var.";\n\$".$var." = array();\n\n?>"))
			die('Please create a "'.$file.'" file in '.$dir);
	if (!is_writable($dir.'/'.$file))
		$this->displayWarning(Tools::displayError('This file has to be writable:').' '.$dir.'/'.$file);
	include($dir.'/'.$file);
	return ${$var};
}

function tmFindAndFillTranslations($files, &$translationsArray, $themeName, $moduleName, $dir = false)
{
	global $_MODULES;
	$tplRegex = '/\{l s=\''._PS_TRANS_PATTERN_.'\'( mod=\'.+\')?( js=1)?\}/U';
	$phpRegex = '/->l\(\''._PS_TRANS_PATTERN_.'\'(, \'(.+)\')?(, (.+))?\)/U';
		$count = 0;
	if (!$dir)
		$dir = ($themeName == 'prestashop' ? _PS_MODULE_DIR_.$moduleName.'/' : _PS_ALL_THEMES_DIR_.$themeName.'/modules/'.$moduleName.'/');
	foreach ($files AS $templateFile)
		if ((preg_match('/^(.*).tpl$/', $templateFile) OR ($themeName == 'prestashop' AND preg_match('/^(.*).php$/', $templateFile))) AND file_exists($tpl = $dir.$templateFile))
		{
			/* Get translations key */
			$readFd = fopen($tpl, 'r');
			$content = (filesize($tpl) ? fread($readFd, filesize($tpl)) : '');
			preg_match_all(substr($templateFile, -4) == '.tpl' ? $tplRegex : $phpRegex, $content, $matches);
			fclose($readFd);
			/* Write each translation on its module file */
			$templateName = substr(basename($templateFile), 0, -4);
			foreach ($matches[1] as $key)
			{
				$moduleKey = '<{'.$moduleName.'}'.$themeName.'>'.$templateName.'_'.md5($key);
				$translationsArray[$themeName][$moduleName][$templateName][$key] = key_exists($moduleKey, $_MODULES) ? html_entity_decode($_MODULES[$moduleKey], ENT_COMPAT, 'UTF-8') : '';
			}
			$count += isset($translationsArray[$themeName][$moduleName][$templateName]) ? sizeof($translationsArray[$themeName][$moduleName][$templateName]) : 0;
		}
	return ($count);
}

function tmGetModuleTranslations()
{
	global $_MODULES, $_MODULE;
	if (!isset($_MODULE) AND !isset($_MODULES))
		$_MODULES = array();
	elseif (isset($_MODULE))
		$_MODULES = (is_array($_MODULES) AND is_array($_MODULE)) ? array_merge($_MODULES, $_MODULE) : $_MODULE;
}

function translateAll($src,$tgt,$source)
{
	$target = array();
	$tmp_source = array();
	foreach ($source AS $key => $value)
	{
		if (strlen($str) > 1000)
		{
			$target = array_merge(translateString($src,$tgt,$tmp_source,$tmp_target),$target);
			unset($str);
			unset($tmp_target);
			$tmp_source = array();
		}
		array_push($tmp_source,$value);
		$tmp_target[$key] = "";
		$str .= $value;
	}
	if (sizeof($tmp_target) > 0)
			$target = array_merge(translateString($src,$tgt,$tmp_source,$tmp_target),$target);
	return $target;
}

function translateString($src,$tgt,$tmp_source,$translations)
{
	//print "Need to translate " . sizeof($tmp_source) ."<br />";
	foreach ($tmp_source AS $key => $value)
			$batch .= "&q=".urlencode($value);
	$url = "http://ajax.googleapis.com/ajax/services/language/translate";
	$vars = "v=1.0".$batch."&langpair=".$src."%7C".$tgt;
	$ch = curl_init();
	curl_setopt($ch, CURLOPT_URL, $url);
	curl_setopt($ch, CURLOPT_POST, 1);
	curl_setopt($ch, CURLOPT_POSTFIELDS, $vars);
	curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
	curl_setopt($ch, CURLOPT_REFERER, "http://www.nationadiscount.com");
	$body = curl_exec($ch);
	curl_close($ch);
	$json = json_decode($body);
	if ($json->{'responseStatus'} == "200")
	{
		$results = array();
		if (is_array($json->{'responseData'}))
		{
			foreach ($json->{'responseData'} AS $result)
			{
				if ($result->{'responseStatus'} == "200")
					array_push($results,$result->{'responseData'}->{'translatedText'});
				else
					die("Error getting translations 1 ".print_r($json,true));
			}
		}
		else
		{
			if ($json->{'responseStatus'} == "200")
				array_push($results,$json->{'responseData'}->{'translatedText'});
			else
				die("Error getting translations 2 ".print_r($json,true));
		}
		if (sizeof($results) != sizeof($translations))
			die("Error getting translations, number sent and returned do not match." .sizeof($results)." != ".sizeof($translations)."-".print_r($results,true));
		$i = 0;
		foreach ($translations AS $key => $value)
		{
			$translations[$key] = trim($results[$i]);
			$i++;
		}
	}
	else
	{
		die("Error getting translations 3 ".print_r($json,true));
	}
	return $translations;
}

function getTranslationsFront($lang,$is_source)
{
	$_LANG = tmFileExists(_PS_THEME_DIR_.'lang', Tools::strtolower($lang).'.php', '_LANG');
	/* List templates to parse */
	$templates = scandir(_PS_THEME_DIR_);
	$count = 0;
	$files = array();
	foreach ($templates AS $template)
		if (preg_match('/^(.*).tpl$/', $template) AND file_exists($tpl = _PS_THEME_DIR_.$template))
		{
			$template = substr(basename($template), 0, -4);
			$newLang = array();
			$fd = fopen($tpl, 'r');
			$content = fread($fd, filesize($tpl));
			/* Search language tags (eg {l s='to translate'}) */
			$regex = '/\{l s=\''._PS_TRANS_PATTERN_.'\'( js=1)?\}/U';
			preg_match_all($regex, $content, $matches);
			/* Get string translation */
			foreach($matches[1] as $key)
			{
				$key2 = $template.'_'.md5($key);
				$newLang[$key] = (key_exists($key2, $_LANG)) ? html_entity_decode($_LANG[$key2], ENT_COMPAT, 'UTF-8') : '';
			}
			$files[$template] = $newLang;
			$count += sizeof($newLang);
		}
	
	foreach ($files as $k => $newLang)
		if (sizeof($newLang) > 0)
		{
			$countValues = array_count_values($newLang);
			$empty = isset($countValues['']) ? $countValues[''] : 0;
			foreach ($newLang as $key => $value)
				$source[$k.'_'.md5($key)] = $value||!$is_source?$value:$key;
		}
	return $source;
}

function getTranslationsModule($lang,$is_source)
{
	if (!file_exists(_PS_MODULE_DIR_))
		die($this->displayWarning(Tools::displayError('Fatal error: Module directory is not here anymore ').'('._PS_MODULE_DIR_.')'));
	if (!is_writable(_PS_MODULE_DIR_))
		$this->displayWarning(Tools::displayError('The module directory must be writable'));
	if (!$modules = scandir(_PS_MODULE_DIR_))
		$this->displayWarning(Tools::displayError('There are no modules in your copy of PrestaShop. Use the Modules tab to activate them or go to our Website to download additional Modules.'));
	else
	{
		$allfiles = array();
		$count = 0;
		foreach ($modules AS $module)
			if ($module{0} != '.' AND is_dir(_PS_MODULE_DIR_.$module))
			{
				include_once(_PS_MODULE_DIR_.$module.'/'.$lang.'.php');
				tmGetModuleTranslations();
				$content = scandir(_PS_MODULE_DIR_.$module);
				foreach ($content as $cont)
					if ($cont{0} != '.' AND $cont != 'img' AND $cont != 'mails' AND $cont != 'js' AND is_dir(_PS_MODULE_DIR_.$module.'/'.$cont))
						if ($files = @scandir(_PS_MODULE_DIR_.$module.'/'.$cont))
							$count += tmFindAndFillTranslations($files, $allfiles, 'prestashop', $module, 	_PS_MODULE_DIR_.$module.'/'.$cont.'/');
				if ($files = @scandir(_PS_MODULE_DIR_.$module.'/'))
					$count += tmFindAndFillTranslations($files, $allfiles, 'prestashop', $module);
			}
		if ($themes = scandir(_PS_ALL_THEMES_DIR_))
			foreach ($themes AS $theme)
				if ($theme{0} != '.' AND is_dir(_PS_ALL_THEMES_DIR_.$theme) AND file_exists(_PS_ALL_THEMES_DIR_.$theme.'/modules/'))
				{
					$modules = scandir(_PS_ALL_THEMES_DIR_.$theme.'/modules/');
					if ($modules)
						foreach ($modules AS $module)
							if ($module{0} != '.' AND is_dir(_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module))
							{
								@include_once(_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module.'/'.$lang.'.php');
								tmGetModuleTranslations();
								$files = scandir(_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module.'/');
								if ($files)
									$count += tmFindAndFillTranslations($files, $allfiles, $theme, $module);
							}
				}
		foreach ($allfiles AS $theme_name => $theme)
			foreach ($theme AS $module_name => $module)
				foreach ($module AS $template_name => $newLang)
					if (sizeof($newLang))
					{
						$countValues = array_count_values($newLang);
						$empty = isset($countValues['']) ? $countValues[''] : 0;
						foreach ($newLang as $key => $value)
							$source[md5($module_name.'_'.$theme_name.'_'.$template_name.'_'.md5($key))] = $value||!$is_source?$value:$key;
					}
	}
	return $source;
}
 
function writeGTranslationFile($path, $target)
{
	$mark = false;
	$fullmark = false;	
	if ($fd = fopen($path, 'w'))
	{
		$tab = ($fullmark ? Tools::strtoupper($fullmark) : 'LANG').($mark ? Tools::strtoupper($mark) : '');
		fwrite($fd, "<?php\n\nglobal \$_".$tab.";\n\$_".$tab." = array();\n");
		foreach($target as $key => $value)
			fwrite($fd, '$_'.$tab.'[\''.pSQL($key, true).'\'] = \''.pSQL($value, true).'\';'."\n");
		fwrite($fd, "\n?>");
		fclose($fd);
		print "Finished writing languages to file";
	}
	else
		die('Cannot write language file');
}

function writeModules($target,$lang)
{
	if (!$modules = scandir(_PS_MODULE_DIR_))
		$this->displayWarning(Tools::displayError('There are no modules in your copy of PrestaShop. Use the Modules tab to activate them or go to our Website to download additional Modules.'));
	else
	{
		foreach ($modules AS $module)
		if ($module{0} != '.' AND is_dir(_PS_MODULE_DIR_.$module))
		{
			$filename = _PS_MODULE_DIR_.$module.'/'.$lang.'.php';
			$content = scandir(_PS_MODULE_DIR_.$module);
			foreach ($content as $cont)
				if ($cont{0} != '.' AND $cont != 'img' AND $cont != 'mails' AND $cont != 'js' AND is_dir(_PS_MODULE_DIR_.$module.'/'.$cont))
					if ($files = scandir(_PS_MODULE_DIR_.$module.'/'.$cont))
						tmFindAndWriteTranslationsIntoFile($target,$filename, $files, 'prestashop', $module, _PS_MODULE_DIR_.$module.'/'.$cont.'/');
			if ($files = @scandir(_PS_MODULE_DIR_.$module.'/'))
				tmFindAndWriteTranslationsIntoFile($target,$filename, $files, 'prestashop', $module);
		}
	}
	/* Search language tags (eg {l s='to translate'}) */
	if ($themes = scandir(_PS_ALL_THEMES_DIR_))
		foreach ($themes AS $theme)
			if ($theme{0} != '.' AND is_dir(_PS_ALL_THEMES_DIR_.$theme) AND file_exists(_PS_ALL_THEMES_DIR_.$theme.'/modules/'))
			{
				if ($modules = scandir(_PS_ALL_THEMES_DIR_.$theme.'/modules/'))
					foreach ($modules AS $module)
						if ($module{0} != '.' AND is_dir(_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module) AND $files = scandir(_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module.'/'))
							tmFindAndWriteTranslationsIntoFile($target,_PS_ALL_THEMES_DIR_.$theme.'/modules/'.$module.'/'.$lang.'.php', $files, $theme, $module);
			}
}

function tmFindAndWriteTranslationsIntoFile($target,$filename, $files, $themeName, $moduleName, $dir = false)
{
	static $_cacheFile = array();
	if (!isset($_cacheFile[$filename]))
	{
		$_cacheFile[$filename] = true;
		if (!$fd = fopen($filename, 'w'))
			die ('Cannot write the theme\'s language file ('.$filename.') Please check write permissions.');
		fwrite($fd, "<?php\n\nglobal \$_MODULE;\n\$_MODULE = array();\n");
		fclose($fd);
	}
	$tplRegex = '/\{l s=\''._PS_TRANS_PATTERN_.'\'( mod=\'.+\')?( js=1)?\}/U';
	$phpRegex = '/->l\(\''._PS_TRANS_PATTERN_.'\'(, \'(.+)\')?(, (.+))?\)/U';
	if (!$dir)
		$dir = ($themeName == 'prestashop' ? _PS_MODULE_DIR_.$moduleName.'/' : _PS_ALL_THEMES_DIR_.$themeName.'/modules/'.$moduleName.'/');
	if (!$writeFd = fopen($filename, 'a+'))
		die ('Cannot write the theme\'s language file ('.$filename.') Please check write permissions.');
	else
	{
		$_tmp = array();
		foreach ($files AS $templateFile)
		{
			if ((preg_match('/^(.*).tpl$/', $templateFile) OR ($themeName == 'prestashop' AND preg_match('/^(.*).php$/', $templateFile))) AND file_exists($tpl = $dir.$templateFile))
			{
				/* Get translations key */
					$readFd = fopen($tpl, 'r');
					$content = (filesize($tpl) ? fread($readFd, filesize($tpl)) : '');
					preg_match_all(substr($templateFile, -4) == '.tpl' ? $tplRegex : $phpRegex, $content, $matches);
					fclose($readFd);
						/* Write each translation on its module file */
					$templateName = substr(basename($templateFile), 0, -4);
					foreach ($matches[1] as $key)
					{
						$postKey = md5($moduleName.'_'.$themeName.'_'.$templateName.'_'.md5($key));
						$pattern = '\'<{'.$moduleName.'}'.$themeName.'>'.$templateName.'_'.md5($key).'\'';
						if (array_key_exists($postKey, $target) AND !empty($target[$postKey]) AND !array_key_exists($pattern, $_tmp))
						{
							$_tmp[$pattern] = true;
							fwrite($writeFd, '$_MODULE['.$pattern.'] = \''.pSQL($target[$postKey]).'\';'."\n");
						}
					}
			}
		}
		fclose($writeFd);
	}
}


function getSourceGeneral($src_lang_id,$tgt_lang_id,$overwrite,$table,$id,$fields,$overwrite_field)
{
	$fields_txt = "a.$id";
	foreach ($fields AS $value)
		$fields_txt .= ",a.$value";
	if (!$overwrite)
	{
		$query = 'SELECT '.$fields_txt.'
			FROM `'._DB_PREFIX_.$table.'` AS a, `'._DB_PREFIX_.$table.'` AS b
			WHERE a.id_lang = '.$src_lang_id.' AND b.id_lang = '.$tgt_lang_id.' AND
			a.'.$id.' = b.'.$id.' AND a.'.$overwrite_field.' = b.'.$overwrite_field;
		$result = Db::getInstance()->ExecuteS($query);
	}
	else
	{
		$result = Db::getInstance()->ExecuteS('
			SELECT '.$fields_txt.'
			FROM `'._DB_PREFIX_.$table.'` AS a
			WHERE a.id_lang = '.$src_lang_id);
	}
	foreach ($result AS $row)
	{
		foreach ($row AS $key => $value)
			$key != $id?$source[$row[$id]."_".$key] = $value:"";
	}
	return $source;
}

function writeTargetGeneral($target,$tgt_lang_id,$table,$id)
{
	foreach ($target AS $key => $value)
	{
		$id_name = explode("_",$key,2);
		$translations[$id_name[0]][$id_name[1]] = $value;
	}
	$squery = 'UPDATE `'._DB_PREFIX_.$table.'` SET '; 
	foreach($translations AS $key => $info)
	{
		$mquery = "";
		foreach ($info AS $field => $value)
			$mquery .= ($mquery?" , ":"").$field." = '".addslashes($value)."'";
		$equery = ' WHERE '.$id.'='.$key.' and id_lang='.$tgt_lang_id;
		$query = $squery.$mquery.$equery;
		Db::getInstance()->Execute($query);
	}
}

print_r(Language::getLanguages());
exit;
$src = "en";
$tgt = "es";
$source = getTranslationsFront($src,true);
$target = getTranslationsFront($tgt,false);
$existing_target = array();
foreach ($target AS $key => $value)
	if ($value != "")
	{
		unset($source[$key]);
		$existing_target[$key] = $value;
	}
print_r($source);
print "<br /><br />";
print_r($existing_target);
$target = translateAll($src,$tgt,$source);
$target = array_merge($target,$existing_target);
$path = _PS_THEME_DIR_.'lang/'.$tgt.'.php';
writeGTranslationFile($path,$target);
exit;
$src_lang_id = Language::getIdByIso($src);
$tgt_lang_id = Language::getIdByIso($tgt);


$source = getTranslationsModule($src,true);
$target = getTranslationsModule($tgt,false);
//$existing_target = array();
//foreach ($target AS $key => $value)
//	if ($value != "")
//	{
//		unset($source[$key]);
//		$existing_target[$key] = $value;
//	}
//print_r($source);
//$target = translateAll($src,$tgt,$source);
//$target = array_merge($target,$existing_target);
//writeModules($target,$tgt);

// product_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"product_lang","id_product",array('description','description_short','meta_title','meta_description','meta_keywords'),"description");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"product_lang","id_product");

exit;

// attachment_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"attachment_lang","id_attachment",array('name','description'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"attachment_lang","id_attachment");

// attribute_group_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"attribute_group_lang","id_attribute_group",array('name','public_name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"attribute_group_lang","id_attribute_group");

// attribute_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"attribute_lang","id_attribute",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"attribute_lang","id_attribute");

// carrier_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"carrier_lang","id_carrier",array('delay'),"delay");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"carrier_lang","id_carrier");

// category_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"category_lang","id_category",array('name','description','meta_title','meta_keywords','meta_description'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"category_lang","id_category");

// cms_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"cms_lang","id_cms",array('meta_title','meta_description','meta_keywords','content'),"meta_title");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"cms_lang","id_cms");

// configuration_lang
//$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"attachment_lang","id_attachment",array('name','description'),"name");
//$target = translateAll($src,$tgt,$source);
//writeTargetGeneral($target,$tgt_lang_id,"attachment_lang","id_attachment");

// contact_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"contact_lang","id_contact",array('name','description'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"contact_lang","id_contact");

// country_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"country_lang","id_country",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"country_lang","id_country");

// customization_field_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"customization_field_lang","id_customization_field",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"customization_field_lang","id_customization_field");

// discount_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"discount_lang","id_discount",array('description'),"description");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"discount_lang","id_discount");

// discount_type_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"discount_type_lang","id_discount_type",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"discount_type_lang","id_discount_type");

// feature_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"feature_lang","id_feature",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"feature_lang","id_feature");

// feature_value_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"feature_value_lang","id_feature_value",array('value'),"value");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"feature_value_lang","id_feature_value");

// group_lang
//$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"attachment_lang","id_attachment",array('name','description'),"name");
//$target = translateAll($src,$tgt,$source);
//writeTargetGeneral($target,$tgt_lang_id,"attachment_lang","id_attachment");

// image_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"image_lang","id_image",array('legend'),"legend");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"image_lang","id_image");

// manufacturer_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"manufacturer_lang","id_manufacturer",array('description','short_description','meta_title','meta_description','meta_keywords'),"description");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"manufacturer_lang","id_manufacturer");

// meta_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"meta_lang","id_meta",array('title','description','keywords'),"title");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"meta_lang","id_meta");

// order_message_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"order_message_lang","id_order_message",array('name','message'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"order_message_lang","id_order_message");

// order_return_state_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"order_return_state_lang","id_order_return_state",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"order_return_state_lang","id_order_return_state");

// order_state_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"order_state_lang","id_order_state",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"order_state_lang","id_order_state");

// product_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"product_lang","id_product",array('description','description_short','meta_title','meta_description','meta_keywords'),"description");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"product_lang","id_product");

// profile_lang BO//
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"profile_lang","id_profile",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"profile_lang","id_profile");

// quick_access_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"quick_access_lang","id_quick_access",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"quick_access_lang","id_quick_access");

// scene_lang
//$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"scene_lang","id_scene",array('name'),"name");
//$target = translateAll($src,$tgt,$source);
//writeTargetGeneral($target,$tgt_lang_id,"scene_lang","id_scene");

// supplier_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"supplier_lang","id_supplier",array('description','meta_title','meta_description','meta_keywords'),"description");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"supplier_lang","id_supplier");

// tab_lang BO
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"tab_lang","id_tab",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"tab_lang","id_tab");

// tax_lang
$source = getSourceGeneral($src_lang_id,$tgt_lang_id,true,"tax_lang","id_tax",array('name'),"name");
$target = translateAll($src,$tgt,$source);
writeTargetGeneral($target,$tgt_lang_id,"tax_lang","id_tax");
?>