<!-- MODULE Home Featured Products -->

{assign var='sWidth' value=400}
{assign var='sHeight' value=300}
{assign var='sFadeTime' value=4000}
{literal}
<style type="text/css">
	#homeslideshow {
{/literal}
	   width: {$sWidth}px; 
	   height: {$sHeight}px; 
{literal}
	   position: relative;
	   overflow: hidden;
	}

	#homeslideshowContent{
	    width: 720px;
	    position: absolute;
		top: 0;
		margin-left: 0;
	}
	.homeslideshowImage{
	    float: left;
	    position: relative;
		display: none;
	}
	.homeslideshowImage span {
	    position: absolute;
		font: 10px/15px Arial, Helvetica, sans-serif;
	    padding: 10px 13px;
{/literal}
	    width: {$sWidth-16}px;
{literal}
	    background-color: #dedede;
	    filter: alpha(opacity=80);
	    -moz-opacity: 0.8;
		-khtml-opacity: 0.8;
	    opacity: 0.8;
	    color: #222222;
	    display: none;
	}

	.clear {
		clear: both;
	}
	
	.top {
		top: 0;
		left: 0;
	}
	.bottom {
		bottom: 0;
	    left: 0;
	}
	.left {
		top: 0;
	    left: 0;
		width: 110px !important;
		height: 280px;
	}
	.right {
		right: 0;
		bottom: 0;
		width: 90px !important;
		height: 290px;
	}
	ul, li{
		margin: 0;
		padding: 0;
		border: 0;
		outline: 0;
		font-size: 100%;
		vertical-align: baseline;
		background: transparent;
	}
	ul {
		list-style: none;
	}


</style>
{/literal}
<script src="{$base_dir}js/jquery/s3Slider.js" type="text/javascript"></script> 
{literal}
<script type="text/javascript">
	$(document).ready(function() {
	   $('#homeslideshow').s3Slider({
{/literal}
	      timeOut: {$sFadeTime}
{literal}
	   });
	});
</script>
{/literal}
<div id="featured-products_block_center" class="block products_block">
	<h4>{l s='featured products' mod='homefeatured'}</h4>
	{if isset($products) AND $products}
		<div id="homeslideshow" style="margin:auto;" >
			<ul id="homeslideshowContent">
			{foreach from=$products item=product name=homeFeaturedProducts}
				{assign var='productLink' value=$link->getProductLink($product.id_product, $product.link_rewrite)}
				<li class="homeslideshowImage ajax_block_product">
					<img src="{$img_prod_dir}{$product.id_image}-large.jpg" alt="{$product.legend}" height="300" width="400"onClick="javascript:location.href='{$productLink}';" />
					<span class="bottom">
						<a href="{$productLink}" title="{$product.name}" style="font-weight:bold; font-size:14px;">{$product.name|escape:htmlall:'UTF-8'|truncate:35}</a><br/>
						<a href="{$productLink}" title="More">{$product.description_short|strip_tags:'UTF-8'|truncate:130}</a>
						
							<div class="price">{displayWtPrice p=$product.price}</div>
							<a class="button" href="{$productLink}" style="float:left;" title="{l s='View' mod='homefeatured'}">{l s='View' mod='homefeatured'}</a>
							{if $allow_buy_when_out_of_stock OR ($product.quantity AND $product.quantity > 0) OR $product.allow_oosp}
							<a class="exclusive ajax_add_to_cart_button" style="float:right;" rel="ajax_id_product_{$product.id_product}" href="{$base_dir}cart.php?qty=1&amp;id_product={$product.id_product}&amp;token={$static_token}&amp;add" title="{l s='Add to cart' mod='homefeatured'}">{l s='Add to cart' mod='homefeatured'}</a>
							{else}
							<div class="exclusive" style="float:right;">{l s='Add to cart' mod='homefeatured'}</div>
							{/if}
					</span>
				</li>
			{/foreach}
			</ul>
		</div>
	{else}
		<p>{l s='No featured products' mod='homefeatured'}</p>
	{/if}
</div>
<!-- /MODULE Home Featured Products -->
