<?php

/**
  * Block Module, blockautosearch.php
  * BlockAutoSearch
  *
  * @author Johannes Teitge <info@tmedia.de>
  * @date 07/05/2008 03:20.09   
  * @copyright TMEDIA cross communications
  * @license http://www.opensource.org/licenses/osl-3.0.php Open-source licence 3.0
  * @version 1.0
  *
  */

class BlockAutoSearch extends Module
{
	function __construct()
	{
		$this->name = 'blockautosearch';
		$this->tab = 'Blocks';
		$this->version = 1.1;

		parent::__construct(); /* The parent construct is required for translations */

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Quick Autosearch block');
		$this->description = $this->l('Adds a block with a quick search field and autocomplete');
	}

	function install()
	{
			if
			(
				parent::install() == false
//				OR $this->registerHook('top') == false
				OR $this->registerHook('leftColumn') == false  // uncomment if you want show on the left Column				
//				OR $this->registerHook('rightColumn') == false  // uncomment if you want show on the right Column				
				OR Configuration::updateValue('BLOCK_AUTOSEARCH_MIN_INPUT', 3) == false
				OR Configuration::updateValue('BLOCK_AUTOSEARCH_SHOW_PRODUCT', 1) == false				
				OR Configuration::updateValue('BLOCK_AUTOSEARCH_ACTIVE', 1) == false				
				OR Configuration::updateValue('BLOCK_AUTOSEARCH_MAX_RESULTS', 10) == false				
			)
			return false;
		return true;
	}	
	
	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitBlockAutoSearch'))
    {
			$minChars = intval(Tools::getValue('minChars'));    
			if ($minChars < 0) $minChars=0;
			$showProduct = intval(Tools::getValue('showProduct'));			
			$maxResults = intval(Tools::getValue('maxResults'));			
			
			$active = intval(Tools::getValue('active'));			

    	Configuration::updateValue('BLOCK_AUTOSEARCH_ACTIVE', intval($active));			
			if ($active ==1) {
    	  Configuration::updateValue('BLOCK_AUTOSEARCH_MIN_INPUT', intval($minChars));
    	  Configuration::updateValue('BLOCK_AUTOSEARCH_SHOW_PRODUCT', intval($showProduct));
    	  Configuration::updateValue('BLOCK_AUTOSEARCH_MAX_RESULTS', intval($maxResults));    	  
      }      	         
    }
		return $output.$this->displayForm();    
  }  		
    
	public function displayForm()
	{
		$active = Tools::getValue('active', Configuration::get('BLOCK_AUTOSEARCH_ACTIVE'));
	
		$form = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>';
				
				
		if ($active == 1) {		
				
		$form .= '<label>'.$this->l('Result').'</label>
				<div class="margin-form">
					<input type="text" name="maxResults" value="'.Configuration::get('BLOCK_AUTOSEARCH_MAX_RESULTS').'" />
					<p class="clear">'.$this->l('Maximum of result rows').'</p>
				</div>
				
				<label>'.$this->l('Minimum Chars').'</label>
				<div class="margin-form">
					<input type="text" name="minChars" value="'.Configuration::get('BLOCK_AUTOSEARCH_MIN_INPUT').'" />
					<p class="clear">'.$this->l('Minimum count of chars to ativate searching.').'</p>
				</div>				
				
        <label>'.$this->l('Show product').'</label>				
				<div class="margin-form">
					<input type="radio" name="showProduct" id="showProduct_on" value="1" '.(Tools::getValue('showProduct', Configuration::get('BLOCK_AUTOSEARCH_SHOW_PRODUCT')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="showProduct_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>

					<input type="radio" name="showProduct" id="showProduct_off" value="0" '.(!Tools::getValue('showProduct', Configuration::get('BLOCK_AUTOSEARCH_SHOW_PRODUCT')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="showProduct_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>					
          <p class="clear">'.$this->l('If active, it show the products page from the selected result.').'</p>					
				</div>
				
				<br>';
		}
    		
		$form .= '<label>'.$this->l('Active').'</label>				
				<div class="margin-form">
					<input type="radio" name="active" id="active_on" value="1" '.(Tools::getValue('active', Configuration::get('BLOCK_AUTOSEARCH_ACTIVE')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="active_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>

					<input type="radio" name="active" id="active_off" value="0" '.(!Tools::getValue('active', Configuration::get('BLOCK_AUTOSEARCH_ACTIVE')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="active_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
          <p class="clear">'.$this->l('Activate or deactivate the search suggest').'</p>          					
				</div>
				
				

				<center><input type="submit" name="submitBlockAutoSearch" value="'.$this->l('Save').'" class="button" /></center>
				
        <div style="font-size:12px; color:gray;"><br><br>Developed 2008 by <a href="http://www.tmedia.de" target="_blank"><u>tmedia</u></a> Johannes Teitge. For comments send a e-mail to <a href="mailto:info@tmedia.de?subject=Prestashop-BlockAutoSearch"><u>info@tmedia.de</u></a><br></div>				
				
			</fieldset>			
		</form>';
		
		
		return $form;
	}    
		


	function hookLeftColumn($params)
	{
		global $smarty;
		$minChars = Configuration::get('BLOCK_AUTOSEARCH_MIN_INPUT');
		$activeAjaxSearch = Configuration::get('BLOCK_AUTOSEARCH_ACTIVE');
		$showProduct = Configuration::get('BLOCK_AUTOSEARCH_SHOW_PRODUCT');		    		
    $jsvars = "\n\n<script type= \"text/javascript\">\n\tvar minChars=".$minChars.";\n \tvar activeAjaxSearch=".$activeAjaxSearch.";\n \tvar showProduct=".$showProduct.";\n </script>\n";		
		
		$smarty->assign('ENT_QUOTES', ENT_QUOTES);
		return $jsvars.$this->display(__FILE__, 'blockautosearch.tpl');
	}

	function hookRightColumn($params)
	{
		global $smarty;
		$minChars = Configuration::get('BLOCK_AUTOSEARCH_MIN_INPUT');
		$activeAjaxSearch = Configuration::get('BLOCK_AUTOSEARCH_ACTIVE');
		$showProduct = Configuration::get('BLOCK_AUTOSEARCH_SHOW_PRODUCT');		    		
    $jsvars = "\n\n<script type= \"text/javascript\">\n\tvar minChars=".$minChars.";\n \tvar activeAjaxSearch=".$activeAjaxSearch.";\n \tvar showProduct=".$showProduct.";\n </script>\n";		
		
		$smarty->assign('ENT_QUOTES', ENT_QUOTES);
		return $jsvars.$this->display(__FILE__, 'blockautosearch.tpl');
	}

	function hookTop($params)
	{
		global $smarty;
		$minChars = Configuration::get('BLOCK_AUTOSEARCH_MIN_INPUT');
		$activeAjaxSearch = Configuration::get('BLOCK_AUTOSEARCH_ACTIVE');
		$showProduct = Configuration::get('BLOCK_AUTOSEARCH_SHOW_PRODUCT');		    		
    $jsvars = "\n\n<script type= \"text/javascript\">\n\tvar minChars=".$minChars.";\n \tvar activeAjaxSearch=".$activeAjaxSearch.";\n \tvar showProduct=".$showProduct.";\n </script>\n";
    		
		$smarty->assign('ENT_QUOTES', ENT_QUOTES);
		return $jsvars.$this->display(__FILE__, 'blockautosearch-header.tpl');
	}

}
