<?php	

class BlockMyAccount extends Module
{
	public function __construct()
	{
		$this->name = 'blockmyaccount';
		$this->tab = 'Blocks';
		$this->version = 1.4;

		/* The parent construct is required for translations */
		parent::__construct();

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('My Account block');
		$this->description = $this->l('Displays a block with links relative to user account');
	}

	function install()
	{
		if (!parent::install() OR !$this->registerHook('leftColumn'))
			return false;
		return true;
	}

	function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitBlockMyAccount'))
		{
			$displayconnexionbox = intval(Tools::getValue('displayconnexionbox'));
			Configuration::updateValue('DISPLAY_CONNEXION_BLOC', $displayconnexionbox);

			if (isset($errors) AND sizeof($errors))
				$output .= $this->displayError(implode('<br />', $errors));
			else
				$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		$output = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Display the connexion box if logout').'</label>
				<div class="margin-form">
					<input type="radio" name="displayconnexionbox" id="text_list_on" value="1" '.(Tools::getValue('text_list', Configuration::get('DISPLAY_CONNEXION_BLOC')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="text_list_on"> <img src="../img/admin/enabled.gif" alt="'.$this->l('Enabled').'" title="'.$this->l('Enabled').'" /></label>
					<input type="radio" name="displayconnexionbox" id="text_list_off" value="0" '.(!Tools::getValue('text_list', Configuration::get('DISPLAY_CONNEXION_BLOC')) ? 'checked="checked" ' : '').'/>
					<label class="t" for="text_list_off"> <img src="../img/admin/disabled.gif" alt="'.$this->l('Disabled').'" title="'.$this->l('Disabled').'" /></label>
				</div>

				<center><input type="submit" name="submitBlockMyAccount" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
		</form>';
		return $output;
	}


	function hookLeftColumn($params)
	{
		global $smarty, $cookie;
		
		$smarty->assign(array(
			'logged' => $cookie->isLogged(),
			'voucherAllowed' => intval(Configuration::get('PS_VOUCHERS')),
			'returnAllowed' => intval(Configuration::get('PS_ORDER_RETURN')),
			'HOOK_CUSTOMER_ACCOUNT' => Module::hookExec('customerAccount'),
			'displayconnexionbox' => Configuration::get('DISPLAY_CONNEXION_BLOC')
		));
		return $this->display(__FILE__, $this->name.'.tpl');
	}

	function hookRightColumn($params)
	{
		return $this->hookLeftColumn($params);
	}

}

?>
