<?php
class EWayAus extends PaymentModule
{
 	private $_html = '';
 	private $_ew_id = '';
 	private $_ew_payment_method = '';
 	private $_ew_live = '';
 	private $_ew_get_address = '';
 	private $_ew_get_cvm = '';
 	
	public function __construct()
	{
		$this->name = 'ewayaus';
        $this->tab = 'Payment';
		$this->version = '1.3';

		$this->_refreshProperties();
		
	 	parent::__construct();

	 	$this->displayName = $this->l('Eway Australia');
		$this->description = $this->l('Receive payments using EWay (Australia)');
	}

   	public function install()
   	{
		if (!parent::install()
			OR !$this->registerHook('payment')
			OR !$this->registerHook('paymentReturn'))
			return false;
		if (!Configuration::updateValue('EW_ID', "87654321")
			|| !Configuration::updateValue('EW_PAYMENT_METHOD', "REAL_TIME")
			|| !Configuration::updateValue('EW_LIVE', "false"))
			return false;
			return true;
	}

	public function uninstall()
	{
		parent::uninstall();
	}
	
	private function _refreshProperties()
	{
		$this->_ew_id =  intval(Configuration::get('EW_ID'));
		$this->_ew_payment_method =  Configuration::get('EW_PAYMENT_METHOD');
		$this->_ew_live =  Configuration::get('EW_LIVE');
		$this->_ew_get_address =  intval(Configuration::get('EW_GET_ADDRESS'));
		$this->_ew_get_cvm =  intval(Configuration::get('EW_GET_CVM'));
	}
	
	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';
		$this->_postProcess();
		$this->_displayForm();
		return $this->_html;
	}

    private function _displayForm()
    {
        $this->_html .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset class="width3"><legend>'.$this->l('EWay Settings').'</legend>
			<table>
			<tr>
				<td align="left" style="font-weight:bold;font-size:14px">
					'.$this->l('EWay ID').':
				</td>
				<td align="left">
					&nbsp;<input type="text" id="ew_id" name="ew_id" value="'.Tools::getValue('ew_id', $this->_ew_id).'" />&nbsp;'.$this->l('Only digits').'
				</td>
			</tr>
			<tr>
				<td align="left" valign="top" style="font-weight:bold;font-size:14px" nowrap>
					'.$this->l('Payment Gateway').':
				</td>
				<td align="left" nowrap>
					&nbsp;<select name="ew_payment_method">
						<option value="REAL_TIME" '.(Tools::getValue('ew_payment_method', $this->_ew_payment_method) == "REAL_TIME"?"selected":"").'>REAL_TIME</option>
						<option value="REAL_TIME_CVN" '.(Tools::getValue('ew_payment_method', $this->_ew_payment_method) == "REAL_TIME_CVN"?"selected":"").'>REAL_TIME_CVN</option>
						<option value="GEO_IP_ANTI_FRAUD" '.(Tools::getValue('ew_payment_method', $this->_ew_payment_method) == "GEO_IP_ANTI_FRAUD"?"selected":"").'>GEO_IP_ANTI_FRAUD</option>
					</select>
				</td>
			</tr>
			<tr>
				<td align="left" style="font-weight:bold;font-size:14px" valign="top">
					'.$this->l('Mode').':
				</td>
				<td align="left">
					&nbsp;'.$this->l('Test').' <input type="radio" id="ew_live" name="ew_live" value="" '.(Tools::getValue('ew_live', $this->_ew_live) != "true"?"checked":"").' />&nbsp;
					&nbsp;&nbsp;&nbsp;'.$this->l('Live').' <input type="radio" id="ew_live" name="ew_live" value="true" '.(Tools::getValue('ew_live', $this->_ew_live) == "true"?"checked":"").' />&nbsp;
					';
        			if ($this->_ew_live != "true")
					$this->_html .= '<br />
					'.$this->l('Only in Test Mode, the response code will depend on the cents amount (I.E $1.00 will be approved $1.01 will be denied)').'.
					<br />
					'.$this->l('For full list of response codes, check out').' <a href="http://www.eway.com.au/Developer/Downloads/ResponseCodes.aspx" target="_blank" style="color:blue">this Eway page</a>';
				$this->_html .= '</td>
			</tr>
			<tr>
				<td align="left" style="font-weight:bold;font-size:12px">
					<br />
				</td>
			</tr>
			<tr>
				<td align="left" style="font-weight:bold;font-size:12px" nowrap>
					'.$this->l('Require Address:').'
				</td>
				<td align="left" nowrap>
					&nbsp;<input type="checkbox" value="1" id="ew_get_address" name="ew_get_address" '.(Tools::getValue('ew_get_address', $this->_ew_get_address) == 1 ? 'checked' : '').' />&nbsp;
					'.$this->l('User must enter an address (Billing info will be the default)').'
				</td>
			</tr>
			<tr>
				<td align="left" style="font-weight:bold;font-size:12px">
					'.$this->l('Require CVN:').'
				</td>
				<td align="left" nowrap>
					&nbsp;<input type="checkbox" value="1" id="ew_get_cvm" name="ew_get_cvm" '.(Tools::getValue('ew_get_cvm', $this->_ew_get_cvm) == 1 ? 'checked' : '').' />&nbsp;
					'.$this->l('User must enter the 3-4 digit code from the back of the card.').'
				</td>
			</tr>
			<tr>
				<td colspan="3" align="center">
					<input type="submit" value="'.$this->l('   Update   ').'" name="submitChanges" class="button" />
				</td>
			</tr>
			</table>
			</fieldset>
        		</form>';
	}
	
	private function _postProcess()
	{
		if (Tools::isSubmit('submitChanges'))
		{
			if (!Configuration::updateValue('EW_ID', intval(Tools::getValue('ew_id')))
				|| !Configuration::updateValue('EW_PAYMENT_METHOD', Tools::getValue('ew_payment_method'))
				|| !Configuration::updateValue('EW_LIVE', Tools::getValue('ew_live'))
				|| !Configuration::updateValue('EW_GET_ADDRESS', Tools::getValue('ew_get_address'))
				|| !Configuration::updateValue('EW_GET_CVM', Tools::getValue('ew_get_cvm')))
				$this->_html .= '<div class="alert error">'.$this->l('Cannot update settings').'</div>';
			else
				$this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />'.$this->l('Settings updated').'</div>';
		}
		$this->_refreshProperties();
	}
	
	public function hookPayment($params)
	{
		if (!$this->active)
			return ;
		$address = new Address(intval($params['cart']->id_address_invoice));
		$customer = new Customer(intval($params['cart']->id_customer));
		global $smarty;
		$smarty->assign(array(
		'this_path' => $this->_path,
		'active' => $this->_ew_id != "87654321" && $this->_ew_live == "1"?true:false,
		'this_path' => __PS_BASE_URI__.'modules/'.$this->name.'/',
		'this_path_ssl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/'.$this->name.'/'));
		return $this->display(__FILE__, 'payment.tpl');
	}
	
	public function hookPaymentReturn($params)
	{
		if (!$this->active)
			return ;
		return $this->display(__FILE__, 'confirmation.tpl');
	}
}
?>