<?php
/* SSL Management */
$useSSL = true;
include(dirname(__FILE__).'/../../config/config.inc.php');
include(dirname(__FILE__).'/../../header.php');
include(dirname(__FILE__).'/ewayaus.php');

$confirm = Tools::getValue('confirm');

/* Validate order */
$time = time();
if ($confirm)
{
	require_once('EwayPaymentLive.php');
	
	// input customerID,  method (REAL_TIME, REAL_TIME_CVN, GEO_IP_ANTI_FRAUD) and liveGateway or not
	$eway = new EwayPaymentLive(intval(Configuration::get('EW_ID')), Configuration::get('EW_PAYMENT_METHOD'), Configuration::get('EW_LIVE'));


	$eway->setTransactionData("TotalAmount", number_format($cart->getOrderTotal(true, 3), 2, '', '')); //mandatory field
	$eway->setTransactionData("CustomerFirstName", strpos(Tools::getValue('fd_cc_name')," ")!==false?trim(substr(Tools::getValue('fd_cc_name'),0,strpos(Tools::getValue('fd_cc_name')," "))):"");
	$eway->setTransactionData("CustomerLastName", strpos(Tools::getValue('fd_cc_name')," ")!==false?trim(substr(Tools::getValue('fd_cc_name'),strpos(Tools::getValue('fd_cc_name')," "))):"");
	$eway->setTransactionData("CustomerEmail", Tools::getValue('fd_cc_email'));
	$eway->setTransactionData("CustomerAddress", Tools::getValue('fd_cc_address')." ".Tools::getValue('fd_cc_city'));
	$eway->setTransactionData("CustomerPostcode", Tools::getValue('fd_cc_zip'));
	$eway->setTransactionData("CustomerInvoiceDescription", "");
	$eway->setTransactionData("CustomerInvoiceRef", "");
	$eway->setTransactionData("CardHoldersName", Tools::getValue('fd_cc_name')); //mandatory field
	$eway->setTransactionData("CardNumber", Tools::getValue('fd_cc_number')); //mandatory field
	$eway->setTransactionData("CardExpiryMonth", Tools::getValue('fd_cc_Month')); //mandatory field
	$eway->setTransactionData("CardExpiryYear", substr(Tools::getValue('fd_cc_Year'),2)); //mandatory field
	$eway->setTransactionData("TrxnNumber", "");
	$eway->setTransactionData("Option1", "");
	$eway->setTransactionData("Option2", "");
	$eway->setTransactionData("Option3", "");
	
	//for REAL_TIME_CVN
	$eway->setTransactionData("CVN", Tools::getValue('fd_cc_cvm'));

	//for GEO_IP_ANTI_FRAUD
	if (Configuration::get('EW_PAYMENT_METHOD') == "GEO_IP_ANTI_FRAUD")
	{
		$address = new Address(intval($cart->id_address_invoice));
		$country = new Country($address->id_country);
		$eway->setTransactionData("CustomerIPAddress", $eway->getVisitorIP()); //mandatory field when using Geo-IP Anti-Fraud
		$eway->setTransactionData("CustomerBillingCountry",$country->iso_code); //mandatory field when using Geo-IP Anti-Fraud
	}
	
	
	//special preferences for php Curl
	$eway->setCurlPreferences(CURLOPT_SSL_VERIFYPEER, 0);  //pass a long that is set to a zero value to stop curl from verifying the peer's certificate 
	//$eway->setCurlPreferences(CURLOPT_CAINFO, "/usr/share/ssl/certs/my.cert.crt"); //Pass a filename of a file holding one or more certificates to verify the peer with. This only makes sense when used in combination with the CURLOPT_SSL_VERIFYPEER option. 
	//$eway->setCurlPreferences(CURLOPT_CAPATH, "/usr/share/ssl/certs/my.cert.path");
	//$eway->setCurlPreferences(CURLOPT_PROXYTYPE, CURLPROXY_HTTP); //use CURL proxy, for example godaddy.com hosting requires it
	//$eway->setCurlPreferences(CURLOPT_PROXY, "http://proxy.shr.secureserver.net:3128"); //use CURL proxy, for example godaddy.com hosting requires it
	
	$ewayResponseFields = $eway->doPayment();
	if ($ewayResponseFields["EWAYTRXNSTATUS"]=="True")    // transaction failed, print the reason
	{
		$customer = new Customer(intval($cart->id_customer));
		$eWayAus = new EWayAus();
		$total = $cart->getOrderTotal(true, 3);
		$eWayAus->validateOrder(intval($cart->id), _PS_OS_PAYMENT_, $total, $eWayAus->displayName);
		$order = new Order(intval($eWayAus->currentOrder));
		Tools::redirectLink(__PS_BASE_URI__.'order-confirmation.php?key='.$customer->secure_key.'&id_cart='.intval($cart->id).'&id_module='.intval($eWayAus->id).'&id_order='.intval($eWayAus->currentOrder));
	}
	$fd_cc_err = "<b style=\"font-size:14px;color:red\">&nbsp;&nbsp;The Credit Card Information you entered is incorrect.<br />&nbsp;&nbsp;Details: ".$ewayResponseFields["EWAYTRXNERROR"].".</b>";
	$time = mktime(0,0,0,Tools::getValue('fd_cc_Month'),1,Tools::getValue('fd_cc_Year'));
}
else
{
		$address = new Address(intval($cart->id_address_invoice));
		$customer = new Customer(intval($cart->id_customer));
		$state = new State($address->id_state);
}
/* or ask for confirmation */ 
$smarty->assign(array(
	'total' => number_format($cart->getOrderTotal(true, 3), 2, '.', ''),
	'this_path_ssl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/ewayaus/',
	'fd_cc_name' => $confirm?Tools::getValue('fd_cc_name'):"$address->firstname $address->lastname",
	'fd_cc_address' => $confirm?Tools::getValue('fd_cc_address'):$address->address1,
	'fd_cc_city' => $confirm?Tools::getValue('fd_cc_city'):$address->city,
	'fd_cc_state' => $confirm?Tools::getValue('fd_cc_state'):$state->iso_code,
	'fd_cc_zip' => $confirm?Tools::getValue('fd_cc_zip'):$address->postcode,
	'fd_cc_email' => $confirm?Tools::getValue('fd_cc_email'):$customer->email,
	'fd_cc_number' => Tools::getValue('fd_cc_number'),
	'fd_cc_cvm' => Tools::getValue('fd_cc_cvm'),
	'fd_cc_err' => $fd_cc_err,
	'ew_get_address' => Configuration::get('EW_GET_ADDRESS'),
	'ew_get_cvm' => Configuration::get('EW_GET_CVM'),
	'time' => $time
));

$smarty->assign('this_path', __PS_BASE_URI__.'modules/ewayaus/');
echo Module::display(__FILE__, 'validation.tpl');

include(dirname(__FILE__).'/../../footer.php');