<?php
/*
*  LEGAL NOTICE
* Prestaworks - http://www.prestaworks.com
Copyright (c) 2008
by Prestaworks
* Permission is hereby granted, to the buyer of this software to use it freely in association with prestashop.
* The buyer are free to use/edit/modify this software in anyway he/she see fit.
* The buyer are NOT allowed to redistribute this module in anyway or resell it or redistribute it to third party.
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/
class jjbypcCustomerFeedback extends Module
{
    public function __construct()
    {
        $this->name = 'jjbypcCustomerFeedback';
        $this->tab = 'Prestaworks.com';
        $this->version = '0.2';

        parent::__construct();

        /* The parent construct is required for translations */
        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Customer Feedback');
        $this->description = $this->l('Allow customers to send feed back to your store and display it on a front-end page.');
		$this->confirmUninstall = $this->l('Are you sure you want to delete all your feedback ?');
    }

	function install()
	{
       if (!parent::install() OR !$this->registerHook('leftColumn'))
	   return false;
	   $query = 'CREATE TABLE '._DB_PREFIX_.'prestaworks_feedback (`id_feedback` int(10) unsigned NOT NULL auto_increment,`id_lang` int(10) unsigned NOT NULL, `name` tinytext NOT NULL, `feedback` text NOT NULL, `feedbackdate` DATETIME NOT NULL, `is_approved` tinyint(1) NOT NULL default 0, PRIMARY KEY (`id_feedback`)) ENGINE=MyISAM DEFAULT CHARSET=utf8;';
	   if (!Db::getInstance()->Execute($query))
	 		return false;
       return true;
   }

	function uninstall()
	{
		if (!parent::uninstall())
		return false;
		$query = 'DROP TABLE '._DB_PREFIX_.'prestaworks_feedback';
		if (!Db::getInstance()->Execute($query))
	 		return false;

		return true;
	}

	function getFeedbacks()
	{
	 	$result = array();
	 	/* Get feedbacks */
		$query = 'SELECT `id_feedback`, `id_lang`, `name`, `feedback`, `feedbackdate`, `is_approved` FROM '._DB_PREFIX_.'prestaworks_feedback ORDER BY `feedbackdate` DESC';
	 	if (!$fedbacks = Db::getInstance()->ExecuteS($query))
	 		return false;
	 	$i = 0;

	 	foreach ($fedbacks AS $fedback)
	 	{
		 	$result[$i]['id'] = $fedback['id_feedback'];
			$result[$i]['id_lang'] = $fedback['id_lang'];
			$result[$i]['name'] = $fedback['name'];
			$result[$i]['feedback'] = $fedback['feedback'];
			$result[$i]['feedbackdate'] = $fedback['feedbackdate'];
			$result[$i]['is_approved'] = $fedback['is_approved'];
			$i++;
		}
	 	return $result;
	}

	function getTopFeedback($lang)
	{
	 	$result = array();
	 	/* Get feedbacks */
		$query = 'SELECT `id_feedback`, `id_lang`, `name`, `feedback`, `feedbackdate`, `is_approved` FROM `'._DB_PREFIX_.'prestaworks_feedback` WHERE `is_approved`=1 AND `id_lang`='.$lang.' ORDER BY `feedbackdate` DESC LIMIT 1';
	 	if (!$fedbacks = Db::getInstance()->ExecuteS($query))
	 		return false;
	 	$i = 0;

	 	foreach ($fedbacks AS $fedback)
	 	{
		 	$result[$i]['id'] = $fedback['id_feedback'];
			$result[$i]['id_lang'] = $fedback['id_lang'];
			$result[$i]['name'] = $fedback['name'];
			$result[$i]['feedback'] = $fedback['feedback'];
			$result[$i]['feedbackdate'] = $fedback['feedbackdate'];
			$result[$i]['is_approved'] = $fedback['is_approved'];
			$i++;
		}
	 	return $result;
	}



	function showFeedback()
	{
	 	/* Url registration */
	 	if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'prestaworks_feedback SET `is_approved`=1 WHERE `id_feedback`='.intval($_GET['showid'])))
	 		return false;

	 	return true;
	}

	function hideFeedback()
	{
	 	/* Url registration */
	 	if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'prestaworks_feedback SET `is_approved`=0 WHERE `id_feedback`='.intval($_GET['hideid'])))
	 		return false;

	 	return true;
	}

	function deleteFeedback()
	{
	 	if (!Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'prestaworks_feedback WHERE `id_feedback`='.intval($_GET['delid'])))
		return false;

		return true;
	}

	function getContent()
    {
		global $currentIndex, $cookie, $adminObj;
     	$this->_html = '<h2>'.$this->displayName.'</h2>';
		$this->_html .= '<script type="text/javascript" src="'.$this->_path.'jjbypcCustomerFeedback.js"></script>';

		$this->_html .= '<script type="text/javascript">
				var currentUrl = \''.$currentIndex.'&configure='.$this->name.'\';
				var token=\''.$adminObj->token.'\';
				</script>';



     	/* Delete a feedback*/
     	if (isset($_GET['delid']))
     	{
     	 	if (!is_numeric($_GET['delid']) OR !$this->deleteFeedback())
     	 	 	$this->_html .= $this->displayError($this->l('An error occurred during feedback deletion'));
     	 	else
     	 	 	$this->_html .= $this->displayConfirmation($this->l('The feedback has been deleted successfully'));
     	}

		/* Show a feedback*/
     	elseif (isset($_GET['showid']))
     	{
     	 	if (!is_numeric($_GET['showid']) OR !$this->showFeedback())
     	 	 	$this->_html .= $this->displayError($this->l('An error occurred during feedback approvement'));
     	 	else
     	 	 	$this->_html .= $this->displayConfirmation($this->l('The feedback has been approved'));
     	}

		/* Hide a feedback*/
     	elseif (isset($_GET['hideid']))
     	{
     	 	if (!is_numeric($_GET['hideid']) OR !$this->hideFeedback())
     	 	 	$this->_html .= $this->displayError($this->l('An error occurred during feedback cancelation'));
     	 	else
     	 	 	$this->_html .= $this->displayConfirmation($this->l('The feedback has been cancelled'));
     	}

     	$this->_displayForm();

        return $this->_html;
    }

	public function _displayForm()
	{
		global $cookie;
	 	/* Language */
		$languages = Language::getLanguages();

	 	$this->_html .= '
	 	<fieldset>
			<legend>'.$this->l('Feedbacks').'</legend>';

			$this->_list();

			$this->_html .= '</fieldset>';

		$this->_html .='<fieldset class="space">
			<legend><img src="../img/admin/unknown.gif" alt="" class="middle" />Info</legend>
			 <h4>This module lets your customer send feedback about your shop. The feedback is displayed on a separate page and latest feedback is displayed in a right or left block.</h4>
			 '.$this->l('User instructions:').'
			 <ol>
			 	<li>After installing the module, check this page from time to time as new feedbacks needs to be approved by the admin.</li>
			 	<li>Click the show (<img src="../img/admin/enabled.gif" alt="'.$this->l('Show').'" title="'.$this->l('Show').'" />) or hide (<img src="../img/admin/forbbiden.gif" alt="'.$this->l('Hided').'" title="'.$this->l('Hide').'"/>) button to show or hide a feedback entry.</li>
			 	<li>Click the delete button (<img src="../img/admin/delete.gif" alt="'.$this->l('Delete').'" title="'.$this->l('Delete').'"/>) to delete the feedback.</li>
			</ol>
			<h4>'.$this->l('Do you want more?').'</h4>

		</fieldset>';
	}

	private function _list()
	{
	 	$feedbacks = $this->getFeedbacks();

	 	global $currentIndex, $cookie, $adminObj;
	 	$languages = Language::getLanguages();

	 	$this->_html .= '
	 	<h3 class="blue space">'.$this->l('Feedbacks').'</h3>
		<table class="table">
			<tr>
				<th>'.$this->l('ID').'</th>
				<th>'.$this->l('Name').'</th>
				<th>'.$this->l('Feedback').'</th>
				<th>'.$this->l('Feedbackdate').'</th>
				<th>'.$this->l('Status').'</th>
				<th>'.$this->l('Action').'</th>
			</tr>';

		if (!$feedbacks)
			$this->_html .= '
			<tr>
				<td colspan="3">'.$this->l('There are no feedbacks yet').'</td>
			</tr>';
		else
			foreach ($feedbacks AS $feedback)
			{
				$this->_html .= '
				<tr>
					<td>'.$feedback['id'].'</td>
					<td>'.$feedback['name'].'</td>
					<td width="350">'.$feedback['feedback'].'</td>
					<td>'.$feedback['feedbackdate'].'</td>';

					if($feedback['is_approved']==1)
					{
					$feedbackStatus = '<img src="../img/admin/enabled.gif" alt="'.$this->l('Displayed').'" title="'.$this->l('Displayed').'" />';
					}
					else
					{
					$feedbackStatus = '<img src="../img/admin/forbbiden.gif" alt="'.$this->l('Not Displayed').'" title="'.$this->l('Not Displayed').'" />';
					}

					$this->_html .= '<td>'.$feedbackStatus.'</td>
					<td>
						<img src="../img/admin/enabled.gif" alt="'.$this->l('Show').'" title="'.$this->l('Show').'" onclick="feedbackDisplay('.$feedback['id'].')" style="cursor: pointer" />
						<img src="../img/admin/forbbiden.gif" alt="'.$this->l('Hided').'" title="'.$this->l('Hide').'" onclick="feedbackHide('.$feedback['id'].')" style="cursor: pointer" />
						<img src="../img/admin/delete.gif" alt="'.$this->l('Delete').'" title="'.$this->l('Delete').'" onclick="feedbackDeletion('.$feedback['id'].')" style="cursor: pointer" />
					</td>
				</tr>';
				}
		$this->_html .= '</table>';
	}

	function hookLeftColumn($params)
	{
	 	global $cookie, $smarty;
	 	$feedbacks = $this->getTopFeedback(intval($cookie->id_lang));

		$smarty->assign(array(
		'module_dir' => _MODULE_DIR_,
		'feedbacks' => $feedbacks
));

		return $this->display(__FILE__, 'blockcustomerfeedback.tpl');
	}

	function hookRightColumn($params)
	{
		return $this->hookLeftColumn($params);
	}

}
?>