<?php
/*
YOU CAN DO WHAT YOU WANT WITH THIS FILE AS LONG AS YOU LEAVE THIS COPYRIGHT NOTICE IN THE FILE
CREATED BY WWW.PRESTAWORKS.SE - HOSTING AND E-COMMERCE
INSTALLATION: COPY THE FILE TO YOUR PRESTASHOP ROOT FOLDER
Version 1.2
*/

function TruncateText($string, $limit, $break=" ", $pad="...") { 
// return with no change if string is shorter than $limit  
if(strlen($string) <= $limit) return $string; 
$string = substr($string, 0, $limit); 
if(false !== ($breakpoint = strrpos($string, $break))) { $string = substr($string, 0, $breakpoint); } return $string . $pad; 
}

include(dirname(__FILE__).'/config/config.inc.php');


function curPageURL() {
 $pageURL = 'http';
 if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
 $pageURL .= "://";
 if ($_SERVER["SERVER_PORT"] != "80") {
  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
 } else {
  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
 }
 return str_replace('/kelkoo.php','', $pageURL);
}



$lang = intval(Configuration::get('PS_LANG_DEFAULT'));
$productClass = new Product();
$id_currency = intval(Configuration::get('PS_CURRENCY_DEFAULT'));
$currency = new Currency(intval($id_currency));
header("content-type:text/xml;charset=utf-8");
echo "<?xml version='1.0' encoding='utf-8'?><products>";

$products = $productClass->getProducts($lang, 0, null, 'name', 'ASC', false);
foreach ($products as $key => $product)
		{
		$rebate = 0;
		$price = number_format(Tools::convertPrice($product['price'], $currency), 2, '.', '');
		//ADD TAX TO PRICE
		 $tax = $product['tax_rate'];
		 $tax = $tax/100;
		 $tax = $tax + 1;
		 $price = $price * $tax;
		 if($product['reduction_from']==$product['reduction_to'])
		 {
			//Is set to forever
			if($product['reduction_price']!='0.00')
			{
				//VALUE DISCOUNT
				$price = $price - number_format(Tools::convertPrice($product['reduction_price'], $currency), 2, '.', '');
				$rebate = 1;
			}
			else
			{
				if($product['reduction_percent']!='0')
				{
					//% DISCOUNT
					$deductproc = $product['reduction_percent'] / 100;
					$deductproc = $price * $deductproc;
					$price = $price - $deductproc;
					$rebate = 1;
				}
			}
		}
		 else
		 {
			//Is not set forever
			
			//convert dates
			$exp_date = $product['reduction_to'];
			$todays_date = date("Y-m-d");

			$today = strtotime($todays_date);
			$expiration_date = strtotime($exp_date);

			if($expiration_date > $today)
			{
				//DISCOUNT VALID
				if($product['reduction_price']!='0.00')
			{
				//VALUE DISCOUNT
				$price = $price - number_format(Tools::convertPrice($product['reduction_price'], $currency), 2, '.', '');
				$rebate = 1;
			}
			else
			{
				if($product['reduction_percent']!='0')
				{
					//% DISCOUNT
					$deductproc = $product['reduction_percent'] / 100;
					$deductproc = $price * $deductproc;
					$price = $price - $deductproc;
					$rebate = 1;
				}
			}
			}
		}
		
		$imageUrl = Product::getCover(intval($product['id_product']));
		
		$availible = 'Out of Stock';
		if($product['quantity']>0)
		{
		$availible = 'In Stock';
		}
		
		$product_manufacturer = new Manufacturer(intval($product['id_manufacturer']),intval(Configuration::get('PS_LANG_DEFAULT')));
		
		$id_carrier = Configuration::get('PS_CARRIER_DEFAULT');
		$carrier = new Carrier(intval($id_carrier));
		global $defaultCountry;
		$id_zone = intval($defaultCountry->id_zone);
		$shipping_cost = 0;
		if (intval(Configuration::get('PS_SHIPPING_METHOD')))
		{
			$shipping_cost = $carrier->getDeliveryPriceByWeight(intval($product['weight']), $id_zone);
		}
	    else
		{
			$shipping_cost = $carrier->getDeliveryPriceByPrice($price, $id_zone);
		}

		$category = new Category(intval($product['id_category_default']));
	
		echo "<product>";
		echo "<Category>".GetCategory($category)."</Category>";
		
		echo "<Productname>".htmlspecialchars($product['name'])."</Productname>";
		echo "<Price>".number_format($price,2,'.','')."</Price>";
		echo "<ProductURL>".curPageURL().'/product.php?id_product='.$product['id_product']."</ProductURL>";
		echo "<ImageURL>".curPageURL()._THEME_PROD_DIR_.$product['id_product']."-".$imageUrl['id_image']."-large.jpg"."</ImageURL>";
		echo "<Description>".TruncateText(htmlentities(utf8_decode(strip_tags($product['description_short']))),256)."</Description>";
         echo "<Deliverycost>".$shipping_cost."</Deliverycost>";
         echo "<Manufacturer>".$product_manufacturer->name."</Manufacturer>";
		echo "<Productcode>".$product['ean13']."</Productcode>";
		echo "<Availability>".$availible."</Availability>";
		echo "</product>"; 
		}
echo "</products>";

function GetCategory($category)
{
$retur = array();
$retur[0] = $category->name[1];
if($category->level_depth>0)
{
$i = $category->level_depth;
$s = 1;
do {
	$subcategory = new Category(intval($category->id_parent),$lang);
	$retur[$s] = $subcategory->name[1];
	$i = $subcategory->level_depth;
	$category = $subcategory;
	$s++;
} while ($i > 0);

}
$result = array_reverse($retur);
$categorystring = "";
foreach($result AS $str)
{
$categorystring.=$str.' | ';
}
return rtrim($categorystring,' | ');
}
?>
