<?php

class AddStuff extends Module
{
	function __construct()
	{
		$this->name = 'addstuff';
		$this->tab = 'AddStuff';
		$this->version = 0.5;

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('AddStuff');
		if (!Configuration::get('MYSTUFF'))
			$this->warning = $this->l('You have not yet configured your Stuff to Add!');
		$this->description = $this->l('Adds a block to display your code. Compliments of www.ecartservice.net');
	}

	function install()
	{
		if (!parent::install())
			return false;
		if (!$this->registerHook('leftColumn'))
			return false;
		return true;
	}

    function uninstall()
	{
		if (!Configuration::deleteByName('MYSTUFF') OR !Configuration::deleteByName('INBOX') OR !parent::uninstall())
			return false;
		return true;
	}
	
	public function getContent()
	{
		$output = '<h2>AddStuff</h2>';
		if (Tools::isSubmit('submitAddStuff') AND ($stuff = Tools::getValue('mystuff')))
		{
			Configuration::updateValue('MYSTUFF', $stuff);
			Configuration::updateValue('INBOX', Tools::getValue('inBox'));
			$output .= '
			<div class="conf confirm">
				<img src="../img/admin/ok.gif" alt="" title="" />
				'.$this->l('Settings updated').'
			</div>';
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		$output = '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<legend><img src="../img/admin/cog.gif" alt="" class="middle" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Stuff to Add').'</label>
				<div class="margin-form">
					<input type="text" name="mystuff" style="width: 300px;" value="'.Tools::getValue('mystuff', Configuration::get('MYSTUFF')).'" />
					<p class="clear">'.$this->l('Example:').' my_html.htm</p>
				</div>
				<label>'.$this->l('Display in standard box?').'</label>
				<div class="margin-form">	
					<input type="radio" name="inBox" value="1" '.(Configuration::get('INBOX') ? 'checked="checked" ' : '').'/>'.$this->l('yes').'
					<input type="radio" name="inBox" value="0" '.(!Configuration::get('INBOX') ? 'checked="checked" ' : '').'/>'.$this->l('no').'
				</div>
				<center><input type="submit" name="submitAddStuff" value="'.$this->l('Update Stuff').'" class="button" /></center>			
			</fieldset>
		</form>';

		$output .= '
		<fieldset class="space">
			<legend><img src="../img/admin/unknown.gif" alt="" class="middle" />'.$this->l('Help').'</legend>
			 <h3>'.$this->l('This module lets you add some custom stuff to you page in either the left or right column.').'</h3>
			 '.$this->l('To use, please follow these steps:').'
			 <ol>
			 	<li>'.$this->l('Create a file (or edit mystuff.html) in the module directory').'</li>
			 	<li>'.$this->l('Paste the code you want to add in this file').'</li>
			 	<li>'.$this->l('Upload it to your web server').'</li>
			</ol>
			<h3>'.$this->l('Tips').'</h3>
			<ol>
				<li>'.$this->l('If you want a "standard" box, then you need to enable it above').'</li>
				<li>'.$this->l('Be sure to wrap your html in a div with the class block_content').'</li>
				<li>'.$this->l('use an h4 tag to set the header at the top of your "box"').'</li>
			</ol>
			<h3><i>Like this module? Want more? Then why not consider donating to the author?</i></h3>
				<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">
					<input type="hidden" name="cmd" value="_donations">
					<input type="hidden" name="business" value="donations@ecartservice.net">
					<input type="hidden" name="item_name" value="Open Source Development and Support">
					<input type="hidden" name="no_shipping" value="0">
					<input type="hidden" name="no_note" value="1">
					<input type="hidden" name="currency_code" value="GBP">
					<input type="hidden" name="tax" value="0">
					<input type="hidden" name="lc" value="GB">
					<input type="hidden" name="bn" value="PP-DonationsBF">
					<input type="image" src="https://www.paypal.com/en_GB/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online.">
					<img alt="" border="0" src="https://www.paypal.com/en_GB/i/scr/pixel.gif" width="1" height="1">
				</form>
		</fieldset>';
				
		return $output;
	}

	/**
	* Returns module content
	*
	* @param array $params Parameters
	* @return string Content
	*/
	function hookRightColumn($params)
	{
	    global $smarty;
		
		$srcFile=Tools::getValue('mystuff', Configuration::get('MYSTUFF'));
		
		if ($srcFile=='') { 
		  $srcFile="mystuff.html";
		}
		
		if (!($fp = fopen(dirname(__FILE__).'/'.$srcFile, "r"))) {
		  $code=Tools::getValue('mystuff', Configuration::get('MYSTUFF'));
		  return $this->display(__FILE__, 'addstuff.tpl');
		}
		
        while ($data = fgets($fp, 4096)) {
		  $code.=$data;
		}
		
		$block_class='';
		if (Tools::getValue('inBox', Configuration::get('INBOX'))) $block_class="block";
		$smarty->assign('code', $code);
		$smarty->assign('block_class', $block_class);

		return $this->display(__FILE__, 'addstuff.tpl');
	}

	function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}
	
	function hookTop($params)
	{
		return $this->hookRightColumn($params);
	}
	
	function hookHome($params)
	{
		return $this->hookRightColumn($params);
	}
	
	function hookFooter($params)
	{
		return $this->hookRightColumn($params);
	}
}

?>