<?php

class BlockSpecialsCaroussel extends Module
{
    private $_html = '';
    private $_postErrors = array();

    function __construct()
    {
        $this->name = 'blockspecialscaroussel';
        $this->tab = 'Blocks';
        $this->version = 0.2;

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Specials block with caroussel');
        $this->description = $this->l('Adds a block with current product Specials');
    }

    function install()
    {
        parent::install();
        $this->registerHook('rightColumn');
		$this->registerHook('header');
    }

    function hookRightColumn($params)
    {
		global $smarty;
		//print_r(Product::getRandomSpecial(intval($params['cookie']->id_lang)));
		$smarty->assign(array(
		'products' => Product::getPricesDrop(intval($params['cookie']->id_lang))));		
	
		return $this->display(__FILE__, 'blockspecialscaroussel.tpl');
	}
	
	function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}
	
	function hookHeader($params)
	{
	 	global $smarty;
		
		ob_start();
		?>
        
		<link rel="stylesheet" href="<?php echo $this->_path;?>css/blockspecialscaroussel.css" type="text/css" media="screen" charset="utf-8" />
		<script src="<?php echo $this->_path;?>js/jquery.carousel.js" type="text/javascript"></script>
	
	<?php	
		$output = ob_get_contents();
		ob_end_clean();
		return $output;
	}
}

?>
