<?php
/*
 * BLOCKVOTE
 * by vinoalvino (9/2008)
 * Comunit italiana prestashop
 * bad english ;-)
 *
 * 1 to 5 vote for single product
 *
 * Configuration var:
 * VOTE_NUM_ROWS   : num of votes (eg: quality/price, look, ...)
 * VOTE_CALC_TOTAL : 1=calc total line, 0=no total line
 * VOTE_MAX_VOTE   : max rating for single vote  (string with "|" separator)
 * VOTE_IMG_EMPTY  : img (png) background (string with "|" separator)
 * VOTE_IMG_FILL   : img (png) foreground (string with "|" separator)
 * VOTE_NAME_#     : #=1 to 5
 *
 * ADD A TABLE VOTE:
 * id_vote              key autoincrement
 * id_product           FK product
 * id_customer          FK customer
 * vote1 to vote5       vote values
 * TotVote              calculated tot votes
 *
 * ALL VOTE ARE SAVED AS %
 * USE FUNCTION scaleNum TO CONVERT
 *
 * only log user can vote only 1 time for each product
 *
 * use 2 png image to display vote
 *
 * VERSIONS:
 * 0.1: add a warning for configuration
 * 0.2: SECURITY CAHNGE
 	  : check fileds before insert (intval or pSQL)
 *    : add fields 'date_add', 'date_upd' to table vote (for delete old votes in a future version)
 *    : added function safePath for security on path img (take only .png extension on module dir)
 * 0.3: fix error on fr.php file (tks to pdriss)
*/

class BlockVote  extends Module
{
	function __construct()
    {
    	$this->name = 'blockvote';
        $this->tab = 'Blocks';

        parent::__construct();

        /* The parent construct is required for translations */
        $this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Block vote');
        $this->description = $this->l('Adds a block for voting a product');
        $this->version = '0.3';
        $this->error = false;
        $this->valid = false;

        $this->confirmUninstall = $this->l('Are you sure you want to delete all votes?');

		if (!Configuration::get('VOTE_NUM_ROWS'))
			$this->warning = $this->l('You have not yet set your votes');

        /* default values */
        $this->num_rows=5;
        $this->max=100;
        $this->max_vote='100|100|100|100|5|100'; /* 5 + total line */
        $this->img_empty='sfa.png|sfa.png|sfb.png|sfa.png|q0.png|sfb.png';
        $this->img_fill='b1.png|b2.png|b3.png|b4.png|q1.png|b6.png';
        $this->calc_total=1; /* 0=false, 1=true */

     }

     function install()
     {
         if (parent::install() == false OR $this->registerHook('leftColumn') == false)
              return false;

		/**
		*	Create the table to store votes
		*/
		$db = Db::getInstance();

		$query= "DROP TABLE IF EXISTS `"._DB_PREFIX_."vote`";
		if( !$db->Execute($query) ) return false;

		$query= "CREATE TABLE `"._DB_PREFIX_."vote` (
				`id_vote` SMALLINT( 10 ) UNSIGNED NOT NULL AUTO_INCREMENT ,
				`id_customer` SMALLINT( 10 ) UNSIGNED NOT NULL ,
				`id_product` SMALLINT( 10 ) UNSIGNED NOT NULL ,
				`vote1` INT( 2 )  NULL DEFAULT '0' ,
				`vote2` INT( 2 )  NULL DEFAULT '0' ,
				`vote3` INT( 2 )  NULL DEFAULT '0' ,
				`vote4` INT( 2 )  NULL DEFAULT '0' ,
				`vote5` INT( 2 )  NULL DEFAULT '0' ,
				`TotVote` INT( 3 )  NULL DEFAULT '0' ,
				`date_add` DATETIME NOT NULL,
				`date_upd` DATETIME NOT NULL,
				PRIMARY KEY ( `id_vote` )
				) ENGINE=MyISAM DEFAULT CHARSET=utf8";

		if( !$db->Execute($query) ) return false;

		$query= "ALTER TABLE `"._DB_PREFIX_."vote` ADD UNIQUE `unique_vote` ( `id_customer` , `id_product` )";
		if( !$db->Execute($query) ) return false;

		if( !Configuration::updateValue('VOTE_NUM_ROWS',   $this->num_rows   ) ) return false;
		if( !Configuration::updateValue('VOTE_MAX_VOTE',   $this->max_vote   ) ) return false;
		if( !Configuration::updateValue('VOTE_IMG_EMPTY',  $this->img_empty  ) ) return false;
		if( !Configuration::updateValue('VOTE_IMG_FILL' ,  $this->img_fill   ) ) return false;
		if( !Configuration::updateValue('VOTE_CALC_TOTAL' ,$this->calc_total ) ) return false;

		for( $i=1; $i<$this->num_rows+1; ++$i)
		{
			if( !Configuration::updateValue('VOTE_NAME_'.$i , '' )) return false;
		}
		/* name of total line */
		if( !Configuration::updateValue('VOTE_NAME_'.$i , '' )) return false;

		return true;
    }

 	public function uninstall()
 	{
 	 	if (!parent::uninstall()) return false;
 	 	if(!Db::getInstance()->Execute('DROP TABLE '._DB_PREFIX_.'vote')) return false;
 	 	if( !Configuration::deleteByName('VOTE_NUM_ROWS')) return false;
 	 	if( !Configuration::deleteByName('VOTE_MAX_VOTE')) return false;
		if( !Configuration::deleteByName('VOTE_IMG_EMPTY')) return false;
		if( !Configuration::deleteByName('VOTE_IMG_FILL')) return false;
		if( !Configuration::deleteByName('VOTE_CALC_TOTAL')) return false;
		for( $i=1; $i<$this->num_rows+2; ++$i)
		{
			if( !Configuration::deleteByName('VOTE_NAME_'.$i)) return false;
		}
 	 	return true;

 	}

	public function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';

		if (!empty($_POST))
		{
			$this->_postValidation();
			if (!sizeof($this->_postErrors))
				$this->_postProcess();
			else
				foreach ($this->_postErrors AS $err)
					$this->_html .= '<div class="alert error">'. $err .'</div>';
		}
		else
			$this->_html .= '<br />';

		$this->_displayForm();

		return $this->_html;
	}

	private function _postValidation()
	{
		$languages = Language::getLanguages();

		$nm=intval($_POST['num_vote']);
		if( $nm < 1 ) $nm=1;
		if( $nm > 5 ) $nm=5;
		Configuration::updateValue('VOTE_NUM_ROWS', $nm);

		$ct=($_POST['calc_total'] == "on" ? 1 : 0);
		Configuration::updateValue('VOTE_CALC_TOTAL', $ct);

		$i0="";
		$i1="";
		$mx="";
		$i_0=explode("|",$this->img_empty);
		$i_1=explode("|",$this->img_fill);
		$max=explode("|",$this->max_vote);

		for( $i=1; $i<$this->num_rows+2; ++$i)
		{
			$imgE=( strlen("".$_POST['img_empty'.$i]) > 0 ? $_POST['img_empty'.$i] : $i_0[$i-1]);
			$imgE=$this->safePath($imgE); /* added for security */
			$imgF=( strlen("".$_POST['img_fill'.$i]) > 0 ? $_POST['img_fill'.$i] : $i_1[$i-1]);
			$imgF=$this->safePath($imgF); /* added for security */
			$i0 .= $imgE .'|';
			$i1 .= $imgF .'|';

			/* name of votes */
			$names=array();
			foreach ($languages as $language)
			{
				$f='fvote'.$i.'_'.$language['id_lang'];
				if( isset($_POST[$f]) )
				{
					$names[$language['id_lang']]=$_POST[$f];
				}
			}
			Configuration::updateValue('VOTE_NAME_'.$i, $names);

			$mx1=(intval($_POST['max_vote'.$i]) > 0 ? intval($_POST['max_vote'.$i]) : 100);
			if( $mx1 < 3 ) $mx1=3;
			if( $mx1 > 100 ) $mx1=100;
			$mx .= $mx1.'|';

		}
		Configuration::updateValue('VOTE_MAX_VOTE', $mx);
		Configuration::updateValue('VOTE_IMG_FILL', $i1);
		Configuration::updateValue('VOTE_IMG_EMPTY', $i0);

		if (isset($errors) AND sizeof($errors))
			$this->_html .= $this->displayError(implode('<br />', $errors));
		else
			$this->_html .= $this->displayConfirmation($this->l('Settings updated'));

	}

	private function _postProcess()
	{

		/* $this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('ok').'" /> '.$this->l('Settings updated').'</div>'; */
	}


	private function _displayForm()
	{
	 	global $cookie;

		/* Languages preliminaries */
		$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$iso = Language::getIsoById($defaultLanguage);

		/* get configuration */
		$max=explode("|",Configuration::get('VOTE_MAX_VOTE'));
		$i1=explode("|",Configuration::get('VOTE_IMG_FILL'));
		$i0=explode("|",Configuration::get('VOTE_IMG_EMPTY'));
		$nm=intval(Configuration::get('VOTE_NUM_ROWS'));
		$ct=intval(Configuration::get('VOTE_CALC_TOTAL'));

		/* save scale for total */
		if( $ct==1 )
		{
			$scale=intval($max[$nm]); /* total in last line */
			$total=0;
		}

		$dl="";
		$disp=array();

		for($i=1; $i<$this->num_rows+2; ++$i)
		{
			$dl .= ($dl=='' ? '' : '¤') . 'fvote' . $i;
			$disp[$i]=($i<$nm+1 ? 'table-row' : 'none');
		}
		$disp[$this->num_rows + 1]=($ct==1 ? 'table-row' : 'none');

		$divLangName = $dl;


		$this->_html .=
		'<script type="text/javascript">id_language = Number('.$defaultLanguage.');</script>
		<script type="text/javascript" src="'.$this->_path.'disprows.js"></script>
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post" enctype="multipart/form-data">
			<fieldset>
				<legend>'.$this->l('Please specify number of rows for vote').'</legend>';
				$this->_html .= '
				1 <input type="radio"'.($nm==1 ? 'checked="checked"' : '').' value="1" name="num_vote" onclick="displayRows(1);"/>&nbsp;&nbsp;&nbsp;&nbsp;
				2 <input type="radio"'.($nm==2 ? 'checked="checked"' : '').' value="2" name="num_vote" onclick="displayRows(2);"/>&nbsp;&nbsp;&nbsp;&nbsp;
				3 <input type="radio"'.($nm==3 ? 'checked="checked"' : '').' value="3" name="num_vote" onclick="displayRows(3);"/>&nbsp;&nbsp;&nbsp;&nbsp;
				4 <input type="radio"'.($nm==4 ? 'checked="checked"' : '').' value="4" name="num_vote" onclick="displayRows(4);"/>&nbsp;&nbsp;&nbsp;&nbsp;
				5 <input type="radio"'.($nm==5 ? 'checked="checked"' : '').' value="5" name="num_vote" onclick="displayRows(5);"/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<br /><br />';
				$this->_html .= $this->l('Total line:') . '
				&nbsp;&nbsp;'.$this->l('Yes').'&nbsp;<input type="radio" value="on"  onclick="displayTotal('.$this->num_rows.',1);" name="calc_total" '.($ct==1 ? 'checked="checked"' : '').'>
				&nbsp;&nbsp;'.$this->l('No').'&nbsp;<input type="radio" value="off"  onclick="displayTotal('.$this->num_rows.',0);" name="calc_total" '.($ct==0 ? 'checked="checked"' : '').'>
			</fieldset><p />';

				$this->_html .=
			'<fieldset>
				<legend>'.$this->l('Please specify a title for each vote').'</legend>
					<table border=0  cellpadding=1 cellspacing=0>';
				for( $i=1; $i<$this->num_rows+2; ++$i) /* if calc total $ct=1: one line more */
				{
					$total_line=($i==$this->num_rows+1 ? true : false );
					$d='style="display: '.$disp[$i].'" ';

					$this->_html .= '
					<tr  id="nm'.$i.'" '.$d.' ><td valign="top" width="50px">'.($total_line ? $this->l('Total') : $i).'</td><td>';

					foreach ($languages as $language)
					{
						$f='fvote'.$i;
						$fl=$f.'_'.$language['id_lang'];
						$v=Configuration::get('VOTE_NAME_'.$i,$language['id_lang']);
						$this->_html .= '
						<div id="'.$fl.'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').';float: left;">
							<input type="text" name="'.$fl.'" id="'.$fl.'" size="70" value="'.$v.'">
						</div>';
					}
					$this->_html .= $this->displayFlags($languages, $defaultLanguage, $divLangName, $f, true);
					$this->_html .= '</td></tr>';
			 	}

			$this->_html .=
			'</table></fieldset><p />
			<fieldset>
				<legend>'.$this->l('Configure votes').'</legend>
				<p><small>'.$this->l('Use only .png image on path'). ' '.$this->_path.'<br />'.$this->l('Press Update settings to recalc').'</small></p>
				<table border=0  cellpadding=1 cellspacing=0>
				<tr>
				  <th align="left">'.$this->l('row').'</th>
				  <th align="center">'.$this->l('max vote (3 to 100)').'</th>
				  <th>'.$this->l('img background').'</th>
				  <th>'.$this->l('img foreground').'</th>
				  <th>'.$this->l('random vote test').'</th>
				  <th></th>
				  <th></th>
				</tr>';
				for( $i=1; $i<$this->num_rows+2; ++$i) /* if calc total $ct=1: one line more */
				{
					$total_line=($i==$this->num_rows+1 ? true : false );
					$d='style="display: '.$disp[$i].'" ';
					$imgE=$this->safePath($i0[$i-1]);
					$imgF=$this->safePath($i1[$i-1]);
					$mx=intval($max[$i-1]);

					if( ! $total_line )
					{
						$rndvote=rand(1,$mx-1);
						if( $ct==1 && $i<$nm+1) $total += ($rndvote * $scale / $mx); /* vote : $mx = x : $scale */
					}
					else
						$rndvote=intval($total/($nm)); /* total average */

					$this->_html .=
					'<tr  id="vt'.$i.'" '.$d.' >
						<td width="40px" align="left">'.($total_line ? $this->l('Total') : $i).'</td>
						<td align="center" width="180"><input type="text" maxlength="3" name="max_vote'.$i.'" style="width:25px; text-align:right;" VALUE="'.$mx.'">
						<td><input type="text" name="img_empty'.$i.'" style="width:100px;" value="'.$imgE.'"></td>
						<td><input type="text" name="img_fill'.$i.'" style="width:100px;" value="'.$imgF.'"></td>
						<td><img src="'.$this->_path .'/vote.php?noa='.$mx.'&no='.$rndvote.'&i0='.$imgE.'&i1='.$imgF.'" id="imgvote"'.$i.'></td>
						<td width="40px">'.$rndvote.($mx==100 ? '%' : '/'.$mx).'</td>
						<td><sup>'.$this->imgFound($imgE, $imgF).'</sup></td>
					</tr>';
				}
			$this->_html .=
			'</table>
		</fieldset><p />
		<input class="button" name="voteSubmit" value="'.$this->l('Update settings').'" type="submit" />&nbsp;&nbsp;&nbsp;&nbsp;
	</form>';
 	}

   	function hookRightColumn($params)
    {
        return $this->hookLeftColumn($params);
    }

     function hookLeftColumn($params)
     {
    	global $smarty;

		$id_customer=0;     /* current customer                        */
		$id_product=0;      /* current product                         */
		$voted=false;       /* if customer vote this product           */
		$enableVote=false;  /* if can vote                             */
		$numvote=0;         /* num vote for this product               */
		$msg="";
		$debug="";

		/* get configuration */
		$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
		$nm=Configuration::get('VOTE_NUM_ROWS');
		$max=explode("|",Configuration::get('VOTE_MAX_VOTE'));             /* number of vote        */
		$i1=explode("|",Configuration::get('VOTE_IMG_FILL'));              /* img foreground array  */
		$i0=explode("|",Configuration::get('VOTE_IMG_EMPTY'));             /* img background array   */
		$ct=intval(Configuration::get('VOTE_CALC_TOTAL'));                 /* 1=calc total, 0=no    */

		/* get current product */
    	$id_product= intval( isset($_GET['id_product']) ? $_GET['id_product'] : 0);

		/* if no product exit (no display with if in tpl file) */
		$smarty->assign('id_product', $id_product);
    	if( $id_product == 0 ) return $this->display(__FILE__, 'blockvote.tpl');

		/* get current id_customer */
		$cookie = new Cookie('ps');
		$id_customer=intval($cookie->id_customer);

		/* save scale on total line */
		if( $ct==1 )
		{
			$scale=intval($max[$this->num_rows+1]); /* total in last line */
			$total=0;
		}

		/* added for security */
		$table=pSQL('`'._DB_PREFIX_.'vote`');
		$customer=pSQL($id_customer);
		$product=pSQL($id_product);

		/* test if voted and save votes values */
		/* (select votes where id_product and id_customer match current values) */
		if( $id_customer > 0 )
		{
			$sql='SELECT `vote1`, `vote2`, `vote3`, `vote4`, `vote5`  FROM '.$table.' WHERE `id_customer` ='.$customer.' AND `id_product`='.$product;
			if($row = Db::getInstance()->getRow($sql))
			{
				$voted=true;
				for( $i=1; $i<$this->num_rows+1; ++$i) $yourvote[$i]=$this->scaleNum(intval($row['vote'.$i]),100,$max[$i-1]);
			}
		}


		/* user has voted now ? */
		if( !$voted && isset($_POST['selvote1']) && $id_customer > 0 && $id_product > 0)
		{
			/* CHANGE SCALE TO 100!!! */
			$tot=0;
			$vt=array();
			for( $i=1; $i<$this->num_rows+1; ++$i)
			{
				$mx=intval($max[$i-1]);
				$vts[$i]=$this->scaleNum(intval($_POST['selvote'.$i]),$mx,100);
				$tot += intval($vts[$i]);
			}

			/* save votes in table vote  */
			$query= 'INSERT INTO '.$table.' (
			`id_vote`, `id_customer`, `id_product`, `vote1`, `vote2`, `vote3`, `vote4`, `vote5` , `totVote`, `date_add`, `date_upd`)
			VALUE (NULL , '.$customer.' , '.$product.' , '.intval($vts[1]).', '.intval($vts[2]).', '.intval($vts[3]).', '.intval($vts[4]).', '.intval($vts[5]).', '.intval($tot).', NOW(), NOW() )';
			Db::getInstance()->Execute($query);
			$voted=true;
			$msg=$this->l('Tanks for your vote');
		}


		/* COUNT VOTE */
		$sql='SELECT
			Count(`vote1`) AS numvote,
			Avg(`vote1`) AS avgvote1,
			Avg(`vote2`) AS avgvote2,
			Avg(`vote3`) AS avgvote3,
			Avg(`vote4`) AS avgvote4,
			Avg(`vote5`) AS avgvote5
			FROM '.$table.' GROUP BY `id_product` HAVING `id_product`='.$product;
		$row = Db::getInstance()->getRow($sql);
		$numvote=intval($row['numvote']);

		if($numvote==0) $ct=0; /* if no vote no calc */

		/* enable vote if user && not voted */
		$enableVote=($voted==0 && $customer !=0 ? true : false);

		/* make selects for vote (smarty is to hard for me ;-) */
		$dispRow=array();
		for($i=1; $i<$nm+1; ++$i) $dispRow[]=$i;
		if($ct==1) $dispRow[]=$this->num_rows+1; /* total on last line */

		$html_sel="";
		/* for($i=1; $i<$nm+1; ++$i){ */
		foreach( $dispRow as $i )
		{

			/* explode return 0 based array: i use base 1 array */

			$imgE = $i0[$i-1]; /* back img */
			$imgF = $i1[$i-1]; /* fore img */
			$mx=intval($max[$i-1]);
			$text=Configuration::get('VOTE_NAME_'.$i,$defaultLanguage);
			$total_line=($ct==1 && $i==$this->num_rows+1 ? true : false );

			if( ! $total_line )
			{
				/* CHANGE SCALE FROM 100 TO MX !!! */
				$v=intval($row['avgvote' . $i]);
				$vt=$this->scaleNum($v,100,$mx);
				if( $ct==1 ) $total += $v;
			}
			else
			{
				$vt=intval($total/($nm)); /* total average */
				$vt=$this->scaleNum($vt,100,$mx);
			}

			$debug .= "vt=" . $vt . "<br />";


			/* bestproduct */
			$bp=array();
			$bp=$this->bestProduct($id_product,($total_line ? 'TotVote' : 'vote'.$i),$mx);

		$html_sel .=
			'<tr><td align="'.($enableVote ? 'left' : 'center').'"><label for="selvote'.$i.'">'.$text;
			if( $numvote > 0 )
				$html_sel .= '&nbsp;('.$vt.($mx==100 ? '%' : '/' .$mx).')';
			$html_sel .= '
			</label><br />
			<img src="'.$this->_path .'vote.php?noa='.$mx.'&no='.$vt.'&i0='.$imgE.'&i1='.$imgF.'" ';
			if( $voted && !$total_line) $html_sel .= ' title="'.$this->l('your vote:').' '.$yourvote[$i].'"';
			$html_sel .= '>';

		$html_sel .= ($enableVote ? '' : $this->bestProduct($id_product,($total_line ? 'TotVote' : 'vote'.$i),$mx));


			if( $enableVote && ! $total_line ) /* not vote on total line */
			{
				$html_sel .= $this->makeSel($i,$mx);
			}
			$html_sel .=
			'</td></tr>';
		}

		/* voted? not login? */
		if( $msg=="")
		{
			if($voted==true) $msg=$this->l('You have already voted');
			if($id_customer==0) $msg='<a href="'.__PS_BASE_URI__.'my-account.php">'.$this->l('Login for vote').'</a>';
		}


		/* set TRUE for DEBUG */
		if( false )
		{
			$debug .= "<p>";
			$debug .= "id_product=" . $id_product . "<br />";
			$debug .= "id_customer=" . $id_customer . "<br />";
			$debug .= "voted=" . $this->b2s($voted) . "<br />";
			$debug .= "enableVote=" . $this->b2s($enableVote) . "<br />";
			$debug .= "</p>";
			$smarty->assign('debug', $debug);
		}


		/* smarties */
		$smarty->assign('title', $this->l('Vote this product'));
		$smarty->assign('enableVote', $enableVote);
		$smarty->assign('msg', $msg);
		$smarty->assign('html_sel', $html_sel);
		$smarty->assign('url', $this->page);
		$smarty->assign('voted', $voted);
		$smarty->assign('numvote', $numvote);
		$smarty->assign('this_path', $this->_path);

        return $this->display(__FILE__, 'blockvote.tpl');
     }

     private function b2s($value)
     {
     	return ($value ? "true" : "false" );
     }

     private function makeSel($numfield, $maxvote)
     {
		$html_sel = '<select name="selvote'.$numfield.'" style="width:45px;">';
		for($s=1; $s<$maxvote+1; ++$s) $html_sel .= '<option value="'.$s.'">'.$s.'</option>';
		$html_sel .= '</select>';
		return $html_sel;
     }

     private function imgFound($imgE, $imgF)
     {
     	if($imgE=="" || $imgF=="") return $this->l('required');
     	$ret="";
     	if( ! file_exists( dirname(__FILE__) . '/' . $imgE )) $ret=  $imgE  . ' ' .$this->l('not found');
     	if( file_exists( dirname(__FILE__) . '/' . $imgF )) return $ret;
     	if( $ret != "" ) $ret .= "<br />";
     	$ret .=  $imgF  . ' ' .$this->l('not found');
     	return $ret;
     }

     private function scaleNum($num, $from, $to=100)
     {
       	if( $from==$to) return $num;
     	/* $num : $from = $x : $to */
     	$x = $num * $to;
     	if( $x != 0 ) $x /= $from;
     	return round($x,0);

     }

     private function bestProduct($id_product,$field,$mx=100)
     {

   		$res="";
    	$sql='
     	SELECT id_product, Sum('.$field.') AS SumVote
	 	FROM '._DB_PREFIX_.'vote
	 	GROUP BY id_product
		ORDER BY SumVote DESC limit 0,3';
		if (!$rows = Db::getInstance()->ExecuteS($sql)) return $res;
  		$i=1;
 		foreach ($rows as $row )
  		{
  			if( $row['id_product']==$id_product )
  			{
				$tot=$this->scaleNum($row['SumVote'],100,$mx);
				$res = '<img src="'.$this->_path.'bp'.$i.'.png" title="'.$this->l('sum votes:').' '.$tot.'" style="margin-left:5px">';
				return $res;
			}
  			++$i;
  		}
  		return $res;
   }

   /* check if extension is .png and dir is module dir for security */
   private function safePath($f, $e=".png")
   {
   		$pt=pathinfo($f);
		return basename($pt['basename'],'.'.$pt['extension']) . $e;        // truncate all path and put .png extension
   }


}
?>