<?php
/*
 Vendredi 11 Avril 2008
 Wasium.fr - Julien Breux - julien@wasium.fr

 New version by vinoalvno
*/
class contactProduct extends Module
{
 	function __construct()
 	{
 	 	$this->name = 'contactproduct';
 	 	$this->version = '0.3';
 	 	$this->tab = 'Products';

		parent::__construct();
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Contact about a product');
		$this->description = $this->l('The visitors can you contact about a product');
 	}

	function install()
	{
    global $cookie;
	 	if (!parent::install())
	 		return false;

    $contact = new Contact(intval(1), intval($cookie->id_lang));
	 	Configuration::updateValue('PS_CONTACT_PRODUCT', $contact->email);
	 	return $this->registerHook('extraLeft');
	}

	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		if (Tools::isSubmit('submitContactProduct'))
		{
			$mail = Tools::getValue('mail');
			if (!Validate::isEmail($mail))
				$output .= '<div class="alert error">'.$this->l('Mail : Invalid.').'</div>';
			else
			{
				Configuration::updateValue('PS_CONTACT_PRODUCT', $mail);
			}
				$output .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />'.$this->l('Settings updated').'</div>';
		}
		return $output.$this->displayForm();
	}

	public function displayForm()
	{
		return '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
				<legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>

				<label>'.$this->l('Mail Contact').'</label>
				<div class="margin-form">
					<input type="text" name="mail" id="mail" value="'.Configuration::get('PS_CONTACT_PRODUCT').'" />
				</div>

				<center><input type="submit" name="submitContactProduct" value="'.$this->l('Save').'" class="button" /></center>
			</fieldset>
		</form>';
	}

	function hookExtraLeft($params)
	{
		global $smarty;
		$smarty->assign('this_path', $this->_path);
		return $this->display(__FILE__, 'product_page.tpl');
	}

	public function displayFrontForm()
	{
		global $smarty, $cookie, $link;
		$error = false;
		$confirm = false;

		/* get current email */
		$id_customer=intval($cookie->id_customer);
		$email_customer=$cookie->email;

		/* Product informations */
		$product = new Product(intval(Tools::getValue('id_product')), false, intval($cookie->id_lang));
		$goToProduct = $link->getProductLink($product);

		$smarty->assign('product', $product->name);
		$smarty->assign('goToProduct', $goToProduct);
		$smarty->assign('email_customer', $email_customer);
		$smarty->assign('id_customer', $id_customer);

             
		//$goToProduct = '<a href="'.$productLink.'" class="bold">'.$this->l('Go to').' "'.$product->name.'"</a>';

    if (Tools::isSubmit('submitMessage'))
    {
    	if (!($from = Tools::getValue('from')) OR !Validate::isEmail($from))
            $errors[] = Tools::displayError('invalid e-mail address');






        elseif (!($message = nl2br2(Tools::getValue('message'))))
            $errors[] = Tools::displayError('message cannot be blank');






        elseif (!Validate::isMessage($message))
            $errors[] = Tools::displayError('invalid message');
        else
        {
          $mail_value = Configuration::get('PS_CONTACT_PRODUCT');
          $message .= '<br><br><a href="'.Tools::getValue('goToProduct').'" class="bold">'.$this->l('Go to product').'</a>';
      		if (Mail::Send(intval($cookie->id_lang), 'contact', Tools::getValue('subject'), array('{email}' => $_POST['from'], '{message}' => stripslashes($message)), $mail_value))
      		{
            //$confirm = $this->l('Your message has been successfully sent to our team');
            //$smarty->assign(array('confirm', $confirm));
      			$smarty->assign('confirmation', 1);
          }
      		else
      			$errors[] = Tools::displayError('an error occurred while sending message');
        }
    		$smarty->assign('errors', $errors);
    }
    else
		{

		}

		return $this->display(__FILE__, 'contactproduct.tpl');
	}
}
?>
