/**
*	functions.js
*	Creates necessary JavaScript functions to aide in the processing of
*	credit card sales via the Offline Credit Card module produced for Prestashop.
*	Kevin Klika, 2008. All rights reserved.
*/

/**
*	modTenValue( cardNumber )
*	Returns true if the cardNumber has a valid mod10 check digit
*/
function modTenValid( cardNumber ){
	var clen = new Array(cardNumber.length);
	var n = 0, sum = 0;
	
	for(n = 0; n < cardNumber.length; n++ ){
		clen[n] = parseInt(cardNumber.charAt(n));
	}
	
	for(n = clen.length - 2; n >= 0; n -= 2){
		clen[n] *= 2;
		if(clen[n] > 9){
			clen[n] -= 9;}
	}
	
	for(n = 0; n < clen.length; n++){
		sum += clen[n];
	}
	
	return(((sum%10)===0)? true : false);
}


/**
*	makePopups()
*	Creates a centered popup window of a certian size (360x380) for every 
*	anchor in the document that has a class of 'popup'.
*/
function makePopups(){
	if (!document.getElementsByTagName){
		return false;}
	var links = document.getElementsByTagName("a");
	for (var i=0; i < links.length; i++) {
		if (links[i].className.match("popup")) {
			links[i].onclick = function() {
				window.open (this.href, this.name + "_window", "menubar=0,resizable=0,width=360,height=380,left=" + ((screen.availWidth - 360)/2) + ",top="+ ((screen.availHeight - 380)/2));
				return false;
			};
		}
	}
}

/**
*	doCreditCardValidation(cardnumber)
*	Returns card type name if everything is valid, else false
*/
function doCreditCardValidation(cardnumber, returnImg) {
  	cardnumber = cardnumber.replace (/\s/g, "");
		
	var cards = new Array();
  
  	//Assign Card Types: Names, Length, Prefixes, and check digit
		cards [0] = {name: "Visa",
			imgName: "visa.gif",
			length: "13,16", 
			prefixes: "4",
			checkdigit: true};
		cards [1] = {name: "MasterCard",
			imgName: "mastercard.gif", 
			length: "16", 
			prefixes: "51,52,53,54,55",
			checkdigit: true};
		cards [2] = {name: "DinersClub",
			imgName: "unknown.gif",
			length: "14,16", 
			prefixes: "300,301,302,303,304,305,36,38,55",
			checkdigit: true};
		cards [3] = {name: "CarteBlanche", 
			imgName: "unknown.gif",
			length: "14", 
			prefixes: "300,301,302,303,304,305,36,38",
			checkdigit: true};
		cards [4] = {name: "AmEx", 
			imgName: "amex.gif",
			length: "15", 
			prefixes: "34,37",
			checkdigit: true};
		cards [5] = {name: "Discover", 
			imgName: "discover.gif",
			length: "16", 
			prefixes: "6011,650",
			checkdigit: true};
		cards [6] = {name: "JCB", 
			imgName: "unknown.gif",
			length: "15,16", 
			prefixes: "3,1800,2131",
			checkdigit: true};
		cards [7] = {name: "enRoute", 
			imgName: "unknown.gif",
			length: "15", 
			prefixes: "2014,2149",
			checkdigit: true};
		cards [8] = {name: "Solo", 
			imgName: "solo.gif",
			length: "16,18,19", 
			prefixes: "6334, 6767",
			checkdigit: true};
		cards [9] = {name: "Switch", 
			imgName: "unknown.gif",
			length: "16,18,19", 
			prefixes: "4903,4905,4911,4936,564182,633110,6333,6759",
			checkdigit: true};
		cards [10] = {name: "Maestro", 
			imgName: "maestro.gif",
			length: "16,18", 
			prefixes: "5020,6",
			checkdigit: true};
		cards [11] = {name: "VisaElectron", 
			imgName: "visa.gif",
			length: "16", 
			prefixes: "417500,4917,4913",
			checkdigit: true};

	var cardexp = /^[0-9]{13,19}$/;
	if(cardnumber.length >0 && cardexp.exec(cardnumber))
	{
		for(var currentType in cards){  
			var prefix = new Array ();
			var lengths = new Array ();
			if(cards[currentType] && cards[currentType].prefixes){
				prefix = cards[currentType].prefixes.split(",");
	
				for (i=0; i<prefix.length; i++){
					var exp = new RegExp("^" + prefix[i]);
					if (exp.test(cardnumber)){
					  lengths = cards[currentType].length.split(",");
					  for (j=0; j<lengths.length; j++){
						if (cardnumber.length == lengths[j]){
							if (cards[currentType].checkdigit){
								if(modTenValid(cardnumber)){
									if(returnImg){
										return cards[currentType].imgName;
									}else{
										return true;}
								}
							}
						}
					  }
					}
				  }	
			}
		}
		if(returnImg){
			return "unknown.gif";
		}else{
			return false;}
	}else{
		if(returnImg){
			return "unknown.gif";
		}else{
			return false;}
	}
}

/**
*	checkForm()
*	Checks validity of entered data
*/
function checkForm(){
	var goOn = true;
	if(document.creditForm.cardName.value === ""){
		document.getElementById('errName').style.display = "block";
		goOn = false;
	} else {
		document.getElementById('errName').style.display = "none";}
		
	if(!doCreditCardValidation(document.creditForm.cardNumber.value, false)){
		document.getElementById('errNumber').style.display = "block";
		goOn = false;
	} else {
		document.getElementById('errNumber').style.display = "none";}
		
	if(document.creditForm.cardCVC.value === ""){
		document.getElementById('errCVC').style.display = "block";
		goOn = false;
	} else {
		document.getElementById('errCVC').style.display = "none";}
		
	return goOn == true ? true : false;
}

/**
*	doSetup()
*	Sets up javascript functions
*/
function doSetup()
{
		makePopups();
		document.getElementById('cardNumber').onkeyup = function(){
			var cardType = doCreditCardValidation(this.value, true);
				document.cardLogoImg.src = "modules/creditcard/img/" + cardType;
		};
		document.creditForm.onsubmit = checkForm;
}


window.onload = doSetup;