<?php
/**
 * Hot Price Module v0.9.2
 * Developed by Rod_ - 2009
 *
 * New version by vinoalvino
 * New version by whitelighter
**/

class HotPrice extends Module
{
    private $_html = '';
    private $_postErrors = array();

    function __construct()
    {
        $this->name = 'hotprice';
        $this->tab = 'Blocks';
        $this->version = 0.92;

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Special Countdown');
        $this->description = $this->l('Adds a hot price product countdown timer');
    }

    function install()
    {
        parent::install();
        $this->registerHook('rightColumn');
    }

    function hookRightColumn($params)
    {
		global $smarty;
		global $product_idx;

		$special_on=1;
		if ($special = Product::getRandomSpecial(intval($params['cookie']->id_lang))) {
			$product_idx = $special['id_product'];
			$smarty->assign(array(
			'special' => $special,
			'oldPrice' => number_format($special['price'] + $special['reduction'], 2, '.', '')
		));}

		if ($special === false ) $special_on=0;



		//******************************** START *********************************************
		//
		// MICRO COUNTDOWN  -  Version: 1.0
		//
		//*****************************************************************************

		// SQL QUERY


		$currentDate = date('Y-m-d');
		/**
		 ** VV001 **
		 * CHANGE THE REDUCTION PRICE OR PERCENT FOR PERSONALISED SPECIALS
		 * (Example: reduction_percent = 20). This will activate the module only for discounts over 20% off.
		 **/

		$min_reduction_price=0;
		$min_reduction_percent=0;

		/*************************/

		$result = db::getInstance()->ExecuteS(
			"SELECT * FROM `"._DB_PREFIX_."product`
		 	WHERE `id_product` = '".$product_idx."'
		  AND `reduction_to` >= '".$currentDate."'
		  AND `reduction_to` > `reduction_from`
		  AND `active` = 1
		  AND (`reduction_price` > ".$min_reduction_price." OR `reduction_percent` > ".$min_reduction_percent.")
			LIMIT 0,1");

		$superman=0;
		if (empty($result) === false AND $result != false AND sizeof($result))
		{
			$date_f = $result[0]['reduction_to'];
			$superman = 1;

			// String extraction
			$year_f = substr($date_f,0,4);
			$month_f = substr($date_f,5,2);
			$day_f = substr($date_f,8,2);

			// Define your target date here
			$targetYear  = $year_f;
			$targetMonth = $month_f;
			$targetDay   = $day_f;
			$targetHour  = 23;
			$targetMinute= 59;
			$targetSecond= 59;

			// Define date format
			$dateFormat = "Y-m-d H:i:s";

			$targetDate = mktime($targetHour,$targetMinute,$targetSecond,$targetMonth,$targetDay,$targetYear);
			$actualDate = time();

			$secondsDiff = $targetDate - $actualDate;
			$remainingDay = floor($secondsDiff/60/60/24);

			$remainingHour = floor(($secondsDiff-($remainingDay*60*60*24))/60/60);
			$remainingMinutes = floor(($secondsDiff-($remainingDay*60*60*24)-($remainingHour*60*60))/60);
			$remainingSeconds = floor(($secondsDiff-($remainingDay*60*60*24)-($remainingHour*60*60))-($remainingMinutes*60));

			#$targetDateDisplay = date($dateFormat,$targetDate);
			#$actualDateDisplay = date($dateFormat,$actualDate);

			// Smarty Assigns:
			$smarty->assign('remainingDay', $remainingDay);
			$smarty->assign('remainingHour', $remainingHour);
			$smarty->assign('remainingMinutes', $remainingMinutes);
			$smarty->assign('remainingSeconds', $remainingSeconds);

			/** Days translation **/
			$smarty->assign('dds', $this->l('days'));
			$smarty->assign('dd', $this->l('day'));

		}
		$smarty->assign('superman', $superman);
		$smarty->assign('special_on', $special_on);
		return $this->display(__FILE__, 'hotprice.tpl');
	}

	function hookLeftColumn($params)
	{
		return $this->hookRightColumn($params);
	}
}

?>