<?php

/**
 * Author: David T Baker
 * Web: http://dtbaker.com.au
 * Email: dtbaker@gmail.com
 * Created: 2009-02-26
 * 
 * File: massupdate.php
 * Provides:
 *  Ability to perform mass updates on products..
 * 
 */
class MassUpdate extends Module
{
	/* @var boolean error */
	protected $error = false;
	
	function __construct()
	{
	 	$this->name = 'massupdate';
	 	$this->tab = 'Products';
	 	$this->version = '1.1';

	 	parent::__construct();

	 	/* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('Mass Update');
        $this->description = $this->l('Perform mass updates on all your products (price, weight, and features)');
		$this->confirmUninstall = $this->l('Aww... are you sure you want to delete me?');
	}
	
	function install($try_again=true)
	{
	 	//if (!$this->addMassUpdateHook() || !parent::install() || !$this->registerHook('shippingCalculate') || !$this->registerHook('shippingCalculateDays')){
	 	if (!parent::install()){
 			return false;
	 	}
	 	
	 	return (Configuration::updateValue('PS_MASSUPDATE_TITLE', array('1' => 'Mass Update')) );
	}
	
	function uninstall()
	{
	 	if (parent::uninstall() == false)
	 		return false;
	 	
	 		
	 	return (Configuration::deleteByName('PS_MASSUPDATE_TITLE'));
	}
	

	function getConfig()
	{
		global $cookie;
		$weight_units = strtolower(Configuration::get('PS_WEIGHT_UNIT'));
		
	 	$main_product_fields = array(
	 		"name"=>array(
	 			"db_field"=>"name",
	 			"friendly"=>"Name",
	 			"isLang"  => 1,
	 			"input_size" => 20,
	 		),
	 		"price"=>array(
	 			"db_field"=>"price",
	 			"friendly"=>"Price",
	 			"isLang"  => 0,
	 			"prefix"=>'$',
	 			"input_size" => 4,
	 		),
	 		"weight"=>array(
	 			"db_field"=>"weight",
	 			"friendly"=>"Weight ($weight_units)",
	 			"isLang"  => 0,
	 			"input_size" => 3,
	 		),
	 		"quantity"=>array(
	 			"db_field"=>"quantity",
	 			"friendly"=>"Quantity",
	 			"isLang"  => 0,
	 			"input_size" => 3,
	 		),
	 		//add more, eg: quantity, here.
	 	);
	 	return $main_product_fields;
	}
	
	
	
	function updateProducts()
	{
	    global $cookie;
		$product_settings = $_POST['mup'];
		
		if(!is_array($product_settings)){
			return false;
		}
		
		$main_fields = $this->getConfig();
		
		foreach($product_settings as $product_id => $data){
			$product_id = (int)$product_id;
			if(!$product_id)continue;
			$sql = "UPDATE "._DB_PREFIX_."product SET date_upd = NOW() ";
			$do_update = false;
			// we're updating the product id. check and update the main fields.
			foreach($main_fields as $field){
			    if ($field['isLang'] == 0) {
    				$update_value = trim(pSQL($data[$field['db_field']]));
    				if($update_value!=''){
    					// we've found a main field to update!
    					$do_update = true;
    					$sql .= ", `".$field['db_field']."` = '$update_value' ";
    				}
    			}
			}
			if($do_update){
				$sql .= " WHERE `id_product` = '$product_id' LIMIT 1";
				if(!Db::getInstance()->Execute($sql)){
					// yer yer i know - dodgey - but this should never happen, all input is sanatised.
					// a "just in case" so we dont go and bork all our products if there's a coding error.
					echo "FAILED TO UPDATE: $sql ";
					echo mysql_error();
					exit;
				}
			}
            // update product_lang 
            // Product id is updated only do have "something" after SET, because additional fields 
            // are added with comma at the start (see $sql .= ", `".$field['db_field']."` = '$update_value' ";)
			$sql = "UPDATE "._DB_PREFIX_."product_lang SET `id_product` = $product_id";
			$do_update = false;
			foreach($main_fields as $field){
			    if ($field['isLang'] != 0) {
    				$update_value = trim(pSQL($data[$field['db_field']]));
    				if($update_value!=''){
    					// we've found a main field to update!
    					$do_update = true;
    					$sql .= ", `".$field['db_field']."` = '$update_value' ";
    				}
    			}
			}
			if($do_update){
				$sql .= " WHERE `id_product` = '$product_id' AND `id_lang` = ".intval($cookie->id_lang)." LIMIT 1";
				if(!Db::getInstance()->Execute($sql)){
					// yer yer i know - dodgey - but this should never happen, all input is sanatised.
					// a "just in case" so we dont go and bork all our products if there's a coding error.
					echo "FAILED TO UPDATE: $sql ";
					echo mysql_error();
					exit;
				}
			}

			// now we have to check the product features! trickeyness..
			// we grab a list of their current features, if any...
			$product_features = Product::getFeaturesStatic($product_id);
			//print_r($product_features);
			$new_features = array();
			$do_feature_update = false;
			if(isset($data['ff']) && is_array($data['ff'])){
				foreach($data['ff'] as $feature_id => $feature_value){
					$update_value = trim(pSQL($feature_value));
					if($update_value){
						//YEY! we can update this products feature value... 
						$do_feature_update = true;
						$new_features[$feature_id] = $update_value;
					}
				}
			}
			$language_id = intval($cookie->id_lang);
			if($do_feature_update){
				$product = new Product($product_id);
				$product->deleteFeatures();
				foreach($new_features as $feature_id => $feature_value){
					// add our new custom feature:
					//echo "Adding $feature_id as $feature_value <br>\n";
					$id_value = $product->addFeaturesToDB($feature_id, 0, true, $language_id);
					$product->addFeaturesCustomToDB($id_value, $language_id, $feature_value);
				}
			}
		}
		
		
		/*
		[product_id] => array(
			"price" => 123.45,
			"weight" => 3,
			"ff"=> array(
				[feature_id] => "value",
				[feature_id] => "value",
				[feature_id] => "value",
			)
		)
		*/
		
	 	return true;
	}
	
	
	
	function getContent()
    {
		global $cookie;
     	$this->_html = '<h2>'.$this->displayName.'</h2>';

     	/* Update the settings */
     	if (isset($_POST['mu_doupdate']))
     	{
     	 	if (!$this->updateProducts())
     	 		$this->_html .= $this->displayError($this->l('An error occurred during product updating, please try saving again.'));
     	 	else
     	 		$this->_html .= $this->displayConfirmation($this->l('Your products have been successfully updated!'));
     	}
     	

     	$this->_html .= '
	 	<fieldset>
			<legend><img src="'.$this->_path.'add.png" alt="" title="" /> '.$this->l('Mass Update Your Products').'</legend>
			<form method="post" action="'.$_SERVER['REQUEST_URI'].'">';
     	
     	$sql = 'SELECT *
				FROM `'._DB_PREFIX_.'feature` f
				LEFT JOIN `'._DB_PREFIX_.'feature_lang` fl ON ( f.`id_feature` = fl.`id_feature` AND fl.`id_lang` = '.intval($cookie->id_lang).')';
	 	$feature_results = Db::getInstance()->ExecuteS($sql);
	 	
	 	
	 	// all products
	 	$sql = 'SELECT *
				FROM `'._DB_PREFIX_.'product` p 
				LEFT JOIN `'._DB_PREFIX_.'product_lang` pl ON (p.`id_product` = pl.`id_product`) WHERE pl.`id_lang` = '.intval($cookie->id_lang);
	 	$all_products = Db::getInstance()->ExecuteS($sql); 
		foreach($all_products as &$product)$product['db_price']=$product['price'];
	 	$all_products = Product::getProductsProperties(1,$all_products);
	 	
	 	$main_fields = $this->getConfig();
	 	
     	ob_start();
     	
     	?>
     	<input type="hidden" name="mu_doupdate" value="go">
     	
		<input type="submit" class="button" name="go" value="Save All My Products" />
		<br><br>
     	<table cellspacing="0" cellpadding="0" class="table space" width="98%" align="center">
			<tbody>
				<tr>
					<th>Product</th>
					<? foreach($main_fields as $m=>$f){ ?>
					<th><?=$f['friendly'];?></th>
					<? } ?>
					<? foreach($feature_results as $k=>$v){ ?>
					<th><?=$v['name'];?></th>
					<? } ?>
				</tr>
				<?php foreach($all_products as $product){
					$product['price'] = $product['db_price']; // price hack
					?>  <tr> <td><a href="?tab=AdminCatalog&id_product=<?=$product['id_product'];?>&updateproduct&token=<?=Tools::getAdminToken('AdminCatalog11');?>"><?=$product['name'];?></a></td> <? foreach($main_fields as $m=>$f){ ?>
						<td><?=$f['prefix'];?><input type="text" size="<?=$f['input_size'];?>" value="<?=$product[$f['db_field']];?>" name="mup[<?=$product['id_product'];?>][<?=$f['db_field'];?>]"/><?=$f['suffix'];?></td> <? }  foreach($feature_results as $k=>$v){ 
							// what value is in this feature?
							$feature_value = '';
							foreach($product['features'] as $f){
								if($f['id_feature']==$v['id_feature']){
									$feature_value = $f['value'];
								}
							}
							?> <td><input type="text" style="width: 35px;" value="<?=$feature_value;?>" name="mup[<?=$product['id_product'];?>][ff][<?=$v['id_feature'];?>]"/></td> <?php 
						} 
						?> 	</tr> <? 
				} 
				?>
     		</tbody>
     	</table>
     	<br><br>
		<input type="submit" class="button" name="go" value="Save All My Products" />
		<br><br>
     	<?
     	
     	
     	$this->_html .= ob_get_clean();
     	
		     	$this->_html .= ' 
				
		     	
			</form>
		</fieldset>';
			
     	

        return $this->_html;
    }
	
	
}
?>
