<?php

class PayByPhone extends PaymentModule
{
	private $_html = '';
	private $_postErrors = array();

	public  $telephonenumber;
	public  $address;

	function __construct()
	{
		$this->name = 'paybyphone';
		$this->tab = 'Payment';
		$this->version = 0.9;
		
		$this->currencies = true;
		$this->currencies_mode = 'checkbox';
		$this->idOrderState = Configuration::get('PAYBYPHONE_ID_ORDER_STATE');

		$config = Configuration::get('TELEPHONE_NUMBER');
		if (isset($config))
			$this->telephonenumber = $config;
		parent::__construct();

		/* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Pay By Phone');
		$this->description = $this->l('Module for accepting payments by telephone');
		$this->confirmUninstall = $this->l('Are you sure you want to delete your details ?');
		
		if (!isset($this->telephonenumber) || $this->telephonenumber === '')
			$this->warning = $this->l('\'Telephone number\' must be configured in order to use this module correctly');
		if (!sizeof(Currency::checkPaymentCurrencies($this->id)))
			$this->warning = $this->l('No currency set for this module');
	}

	function install()
	{
		if (!parent::install() OR !$this->registerHook('payment') OR !$this->registerHook('paymentReturn'))
			return false;
		$this->_makeOrderState();
		return true;
}

	function uninstall()
	{
		if (!Configuration::deleteByName('TELEPHONE_NUMBER') OR !parent::uninstall())
			return false;
		return true;
	}

	private function _postValidation()
	{
		if (isset($_POST['btnSubmit']))
		{
			if (empty($_POST['telephonenumber']))
				$this->_postErrors[] = $this->l('\'Telephone Number\' field is required.');
		}
	}

	private function _postProcess()
	{
		if (isset($_POST['btnSubmit']))
		{
			Configuration::updateValue('TELEPHONE_NUMBER', $_POST['telephonenumber']);
		}
		$this->_html .= '<div class="conf confirm"><img src="../img/admin/ok.gif" alt="'.$this->l('OK').'" /> '.$this->l('Settings updated').'</div>';
	}

	private function _displayPayByPhone()
	{
		$os = new OrderState($this->idOrderState);
		$this->_html .= '<img src="../modules/paybyphone/paybyphone.jpg" style="float:left; margin-right:15px;"><b>'.$this->l('This module allows you to accept payments by Telephone.').'</b><br /><br />
		'.sprintf($this->l('If the client chooses this payment mode, the order will change its status into a \'%s\' status.'),$os->name[1]).'<br />
		'.$this->l('Therefore, you will need to manually confirm the order as soon as you clear the payment over the phone.').'<br /><br /><br />';
	}

	private function _displayForm()
	{
		$this->_html .=
		'<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset>
			<legend><img src="../img/admin/exchangesrate.gif" />'.$this->l('Contact details').'</legend>
				<table border="0" width="500" cellpadding="0" cellspacing="0" id="form">
					<tr><td colspan="2">'.$this->l('Please specify the telephone number which customers must call for payment.').'.<br /><br /></td></tr>
					<tr><td width="130" style="height: 35px;">'.$this->l('Telephone Number').'</td><td><input type="text" name="telephonenumber" value="'.htmlentities(Tools::getValue('telephonenumber', $this->telephonenumber), ENT_COMPAT, 'UTF-8').'" style="width: 300px;" /></td></tr>
					<tr><td colspan="2" align="center"><br /><input class="button" name="btnSubmit" value="'.$this->l('Update settings').'" type="submit" /></td></tr>
				</table>
			</fieldset>
		</form>';
	}

	function getContent()
	{
		$this->_html = '<h2>'.$this->displayName.'</h2>';

		if (!empty($_POST))
		{
			$this->_postValidation();
			if (!sizeof($this->_postErrors))
				$this->_postProcess();
			else
				foreach ($this->_postErrors AS $err)
					$this->_html .= '<div class="alert error">'. $err .'</div>';
		}
		else
			$this->_html .= '<br />';

		$this->_displayPayByPhone();
		$this->_displayForm();

		return $this->_html;
	}

	function execPayment($cart)
	{
		global $cookie, $smarty;
		
		$smarty->assign(array(
			'nbProducts' => $cart->nbProducts(),
			'cust_currency' => $cookie->id_currency,
			'currencies' => $this->getCurrency(),
			'total' => number_format($cart->getOrderTotal(true, 3), 2, '.', ''),
			'isoCode' => Language::getIsoById(intval($cookie->id_lang)),
			'telephonenumber' => $this->telephonenumber,
			'this_path' => $this->_path,
			'this_path_ssl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/'.$this->name.'/'
		));

		return $this->display(__FILE__, 'payment_execution.tpl');
	}

	function hookPayment($params)
	{
		global $smarty;

		$smarty->assign(array(
            'this_path' => $this->_path,
            'this_path_ssl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/'.$this->name.'/'
            ));
		return $this->display(__FILE__, 'payment.tpl');
	}

	function hookPaymentReturn($params)
	{
		global $smarty;
		$state = $params['objOrder']->getCurrentState();
		if ($state == $this->idOrderState OR $state == _PS_OS_OUTOFSTOCK_)
			$smarty->assign(array(
				'total_to_pay' => Tools::displayPrice($params['total_to_pay'], $params['currencyObj'], false, false),
				'telephoneNumber' => $this->telephonenumber,
				'status' => 'ok',
				'id_order' => $params['objOrder']->id
			));
		else
			$smarty->assign('status', 'failed');
		return $this->display(__FILE__, 'payment_return.tpl');
	}
	/**
	*	makeOrderState()
	*	An order state is necessary for this module to function.
	*	The id number of the order state is stored in a global configuration variable for use later
	*/
	private function _makeOrderState()
	{
		if(!(Configuration::get('PAYBYPHPNE_ID_ORDER_STATE') > 0))
		{				
			$os = new OrderState();
			$os->name = array_fill(0,10,$this->l("Awaiting Customner to Call"));
			$os->send_mail = true;
			$os->template = "paybyphone";
			$os->invoice = 0;
			$os->color = "#33FF99";
			$os->unremovable = false;
			$os->logable = 0;		
			$os->add();
			Configuration::updateValue('PAYBYPHONE_ID_ORDER_STATE',$os->id);
		}
	}

}

?>
