<?php

class Paypal extends PaymentModule
{
	private	$_html = '';
	private $_postErrors = array();

	public function __construct()
	{
		$this->name = 'paypal';
		$this->tab = 'Payment';
		$this->version = '2.1 BETA1';

        parent::__construct();

        /* The parent construct is required for translations */
		$this->page = basename(__FILE__, '.php');
        $this->displayName = $this->l('PayPal');
        $this->description = $this->l('Accepts payments by PayPal - v2.1 BETA1');
		$this->confirmUninstall = $this->l('Are you sure you want to delete your details ?');
	}

	public function getPaypalUrl()
	{
			return Configuration::get('PAYPAL_SANDBOX') ? 'https://www.sandbox.paypal.com/cgi-bin/webscr' : 'https://www.paypal.com/cgi-bin/webscr';
	}

	public function install()
	{
	        //Create Order Processing Status if it doesn't exist
			if (!Configuration::get('PS_PAYPALPROCESS')) {
            	$processPaypal = new OrderState();
            	$processPaypal ->name = array('Awaiting Paypal Payment','Awaiting Paypal Payment','Awaiting Paypal Payment','Awaiting Paypal Payment','Awaiting Paypal Payment','Awaiting Paypal Payment','Awaiting Paypal Payment','Awaiting Paypal Payment','Awaiting Paypal Payment','Awaiting Paypal Payment');
            	$processPaypal ->send_email = intval(1);
            	$processPaypal ->template = array ('preparation','preparation','preparation','preparation','preparation','preparation','preparation','preparation','preparation','preparation');
            	$processPaypal ->invoice = intval(0);
            	$processPaypal ->color = "lightblue";
            	$processPaypal ->unremovable = intval(0);
            	$processPaypal ->logable = intval(1);            
            	$processPaypal ->add();
            	Configuration::updateValue('PS_PAYPALPROCESS',$processPaypal ->id);
			}
		if (!parent::install() OR !$this->registerHook('payment') OR !$this->registerHook('paymentReturn') OR !Configuration::updateValue('PAYPAL_BUSINESS', 'your-paypal@address.com')
			OR !Configuration::updateValue('PAYPAL_SANDBOX', 1) OR !Configuration::updateValue('PAYPAL_CURRENCY', 'customer')
			OR !$this->registerHook('payment'))
			return false;
		return true;
	}

	public function uninstall()
	{
		if (!Configuration::deleteByName('PAYPAL_BUSINESS') OR !Configuration::deleteByName('PAYPAL_SANDBOX')
			OR !Configuration::deleteByName('PAYPAL_CURRENCY') OR !parent::uninstall())
			return false;
		return true;
	}

	public function getContent()
	{
		$this->_html = '<h2>Paypal</h2>';
		if (isset($_POST['submitPaypal']))
		{
			if (empty($_POST['business']))
				$this->_postErrors[] = $this->l('Paypal business e-mail address is required.');
			elseif (!Validate::isEmail($_POST['business']))
				$this->_postErrors[] = $this->l('Paypal business must be an e-mail address.');
			if (!isset($_POST['sandbox']))
				$_POST['sandbox'] = 1;
			if (empty($_POST['currency']))
				$_POST['currency'] = 'customer';
			if (!sizeof($this->_postErrors))
			{
				Configuration::updateValue('PAYPAL_BUSINESS', $_POST['business']);
				Configuration::updateValue('PAYPAL_SANDBOX', intval($_POST['sandbox']));
				Configuration::updateValue('PAYPAL_CURRENCY', $_POST['currency']);
				$this->displayConf();
			}
			else
				$this->displayErrors();
		}

		$this->displayPayPal();
		$this->displayFormSettings();
		return $this->_html;
	}

	public function displayConf()
	{
		$this->_html .= '
		<div class="conf confirm">
			<img src="../img/admin/ok.gif" alt="'.$this->l('Confirmation').'" />
			'.$this->l('Settings updated').'
		</div>';
	}

	public function displayErrors()
	{
		$nbErrors = sizeof($this->_postErrors);
		$this->_html .= '
		<div class="alert error">
			<h3>'.($nbErrors > 1 ? $this->l('There are') : $this->l('There is')).' '.$nbErrors.' '.($nbErrors > 1 ? $this->l('errors') : $this->l('error')).'</h3>
			<ol>';
		foreach ($this->_postErrors AS $error)
			$this->_html .= '<li>'.$error.'</li>';
		$this->_html .= '
			</ol>
		</div>';
	}
	
	
	public function displayPayPal()
	{
		$this->_html .= '
		<img src="../modules/paypal/paypal.gif" style="float:left; margin-right:15px;" />
		<b>'.$this->l('This module allows you to accept payments by PayPal.').'</b><br /><br />
		'.$this->l('If the client chooses this payment mode, your PayPal account will be automatically credited. ').'<b>
		'.$this->l('This is a BETA version and is not recommended for production use. ').'</b>
		'.$this->l('You <b>must</b> configure your PayPal account first before using this module.').'
		<br /><br /><br />';
	}

	public function displayFormSettings()
	{
		$conf = Configuration::getMultiple(array('PAYPAL_BUSINESS', 'PAYPAL_SANDBOX', 'PAYPAL_CURRENCY'));
		$business = array_key_exists('business', $_POST) ? $_POST['business'] : (array_key_exists('PAYPAL_BUSINESS', $conf) ? $conf['PAYPAL_BUSINESS'] : '');
		$sandbox = array_key_exists('sandbox', $_POST) ? $_POST['sandbox'] : (array_key_exists('PAYPAL_SANDBOX', $conf) ? $conf['PAYPAL_SANDBOX'] : '');
		$currency = array_key_exists('currency', $_POST) ? $_POST['currency'] : (array_key_exists('PAYPAL_CURRENCY', $conf) ? $conf['PAYPAL_CURRENCY'] : 'prestashop');

		$this->_html .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
		<fieldset>
			<legend><img src="../img/admin/contact.gif" />'.$this->l('Settings').'</legend>
			<label>'.$this->l('PayPal business e-mail').'</label>
			<div class="margin-form"><input type="text" size="33" name="business" value="'.htmlentities($business, ENT_COMPAT, 'UTF-8').'" /></div>
			<label>'.$this->l('Sandbox mode').'</label>
			<div class="margin-form">
				<input type="radio" name="sandbox" value="1" '.($sandbox ? 'checked="checked"' : '').' /> '.$this->l('Yes').'
				<input type="radio" name="sandbox" value="0" '.(!$sandbox ? 'checked="checked"' : '').' /> '.$this->l('No').'
			</div>
			<label>'.$this->l('Currency').'</label>
			<div class="margin-form">
				<input type="radio" name="currency" value="prestashop" '.($currency == 'prestashop' ? 'checked="checked"' : '').' /> '.$this->l('Use PrestaShop currency').'
				<br /><input type="radio" name="currency" value="customer" '.($currency == 'customer' ? 'checked="checked"' : '').' /> '.$this->l('Use customer currency').'
			</div>
			<br /><center><input type="submit" name="submitPaypal" value="'.$this->l('Update settings').'" class="button" /></center>
		</fieldset>
		</form><br /><br />
		<fieldset>
			<legend><img src="../img/admin/warning.gif" />'.$this->l('Information').'</legend>
			'.$this->l('In order to use your PayPal payment module, you have to configure your PayPal account (sandbox and/or live account). Log in to PayPal and follow these instructions.').'<br /><br />
			
			'.$this->l('In').' <i>'.$this->l('Profile > Selling Preferences > Website Payment Preferences').'</i>, '. $this->l('set:').'<br />
			- <b>'.$this->l('Auto Return').'</b> : '.$this->l('Off').',<br />
			- <b>'.$this->l('Payment Data Transfer').'</b> '.$this->l('to').' <b>Off</b>.<br /><br />
			'.$this->l('In').' <i>'.$this->l('Shipping Calculations').'</i>'.$this->l(', check <b>"Click here to allow transaction-based shipping values to override the profile shipping settings listed above"</b>').'<br /><br />
			
			<b style="color: red;">'.$this->l('** If you use the <i>"Use customer currency"</i> option above or the PrestaShop currency isn\'t your native currency in PayPal:').'</b><br />
			'.$this->l('In').' <i>'.$this->l('Payment Receiving Preferences').'</i>'.$this->l(', for <i>"Block payments sent to me in a currency I do not hold:"</i> select<br />- ').'<b>'.$this->l('No, accept them and convert them to...').'</b><br />'.
			$this->l('If you do not, then you will have to go to your PayPal Account and accept or decline them manually.').'
			<br /><br /><b><i>Do you find this useful? If so, then why not consider donating to support the author in providing continued support for this and other great PrestaShop modules and add-on features.</i></b><br /><br />
			<form action="https://www.paypal.com/cgi-bin/webscr" method="post" target="_blank">
				<input type="hidden" name="cmd" value="_donations">
				<input type="hidden" name="business" value="donations@ecartservice.net">
				<input type="hidden" name="item_name" value="Open Source Development and Support">
				<input type="hidden" name="no_shipping" value="0">
				<input type="hidden" name="no_note" value="1">
				<input type="hidden" name="currency_code" value="GBP">
				<input type="hidden" name="tax" value="0">
				<input type="hidden" name="lc" value="GB">
				<input type="hidden" name="bn" value="PP-DonationsBF">
				<input type="image" src="https://www.paypal.com/en_GB/i/btn/btn_donateCC_LG.gif" border="0" name="submit" alt="PayPal - The safer, easier way to pay online.">
				<img alt="" border="0" src="https://www.paypal.com/en_GB/i/scr/pixel.gif" width="1" height="1">
			</form>
		</fieldset>';
	}
	
	public function hookPayment($params)
	{
		global $smarty;
				
		$smarty->assign(array(
            'this_path' => $this->_path,
            'this_path_ssl' => (Configuration::get('PS_SSL_ENABLED') ? 'https://' : 'http://').htmlspecialchars($_SERVER['HTTP_HOST'], ENT_COMPAT, 'UTF-8').__PS_BASE_URI__.'modules/'.$this->name.'/', 
			'id_cart' => intval($params['cart']->id)
            ));
		return $this->display(__FILE__, 'payment.tpl');
    }

	public function hookPaymentReturn($order, $module)
	{	
		return $this->display(__FILE__, 'payment_return.tpl');
	}
	
	public function getL($key)
	{
		$translations = array(
		    'to_paypal' => $this->l('Customer redirected to paypal to complete payment.'),
			'mc_gross' => $this->l('Paypal key \'mc_gross\' not specified, can\'t control amount paid.'),
			'payment_status' => $this->l('Paypal key \'payment_status\' not specified, can\'t control payment validity'),
			'payment' => $this->l('Payment: '),
			'custom' => $this->l('Paypal key \'custom\' not specified, can\'t rely to cart'),
			'txn_id' => $this->l('Paypal key \'txn_id\' not specified, transaction unknown'),
			'mc_currency' => $this->l('Paypal key \'mc_currency\' not specified, currency unknown'),
			'cart' => $this->l('Cart not found'),
			'order' => $this->l('Order has already been placed'),
			'transaction' => $this->l('Paypal Transaction ID: '),
			'verified' => $this->l('The PayPal transaction could not be VERIFIED.'),
			'connect' => $this->l('Problem connecting to the PayPal server. '),
			'socketmethod' => $this->l('Verification failure (using fsockopen). Returned: '),
			'curlmethod' => $this->l('Verification failure (using cURL). Returned: '),
			'cURLFail' => $this->l('Connection using cURL failed.<br />'),
			'notransport' => $this->l('No communications transport available.<br />'),
			'orderhistory' => $this->l('Internal error updating Order History.'),
			'Sandbox' => $this->l('Sandbox test IPN sent and cart is in production mode. IPN discarded.<br/>'),
			'emailnotsent' => $this->l('an error occurred while changing status or was unable to send e-mail to the customer'),
			// Paypal IPN status/info messages for BackOffice
			'Cancelled_Reversal' => $this->l('Reversal has been canceled.'),
			'Completed' => $this->l('The payment has been completed with Transaction id/Type: '),
			'Denied' => $this->l('You denied payment which was pending (includes refund of uncleared funds).'),
			'Expired' => $this->l('This authorization has expired and cannot be captured. Transaction id/Type: '),
			'Failed' => $this->l('Payment from Bank Account has failed.'),			
			'Pending' => $this->l('Payment Pending. Type/Reason: '),			
			'Processed' => $this->l('A payment has been accepted Transaction id/Type: '),
			'Refunded' => $this->l('Payment has been refunded. Transaction id/Reason: '),
			'Reversed' => $this->l('A payment was reversed. Reason: '),
			'Voided' => $this->l('This authorisation has been voided.')
		);
		return $translations[$key];
	}
}
?>
