<?php

require( _PS_MODULE_DIR_ . '/productrating/rating/_drawrating.php');
require( _PS_MODULE_DIR_ . '/productrating/rating/_config-rating.php');


/**
 * Modulo para prestashop:
 * 
 * Este modulo permite ao usuario colocar um forma de avaliação
 * dos seus produtos pelo cliente.
 * @package PrestashopBR.com
 * @author Dlani [Mend's] <mends@prestashopbr.com>
 * @autor GCCSystem | Gleriston  <contato@prestashopbr.com>
 * @copyright 2009
 * @version 0.3
 */
class productrating extends Module
{
	function __construct()
	{
		$this->name 	= 'productrating';
		$this->tab 		= 'Products';
		$this->version = 0.1;
		
		/** Tradução **/
		$this->l_rating	= $this->l('Give your rating now');
		$this->l_rating	= $this->l('Rating');
		$this->l_cast	= $this->l('cast');
		$this->l_votes	= $this->l('votes');
		$this->l_vote	= $this->l('vote');
		$this->l_out	= $this->l('out of');
		$this->l_thank	= $this->l('Thanks for voting!');	

		parent::__construct(); // The parent construct is required for translations

		$this->page = basename(__FILE__, '.php');
		$this->displayName = $this->l('Product Rating');
		$this->description = $this->l('Rating products in AJAX');
	}
	
	function traduz($termo)
	{
		return $this->l($termo);
	}

	function install()
	{
		Configuration::updateValue('RATING_NUMBER', 10);
		Configuration::updateValue('RATING_STAR', '0001.gif');
		
		Db::getInstance()->Execute
			('
			CREATE TABLE `' . _DB_PREFIX_ . 'ratings` (
  			`id` varchar(11) NOT NULL,
  			`total_votes` int(11) NOT NULL default 0,
  			`total_value` int(11) NOT NULL default 0,
  			`used_ips` longtext,
  			PRIMARY KEY  (`id`)
			) TYPE=MyISAM AUTO_INCREMENT=3;');
		
		if (!parent::install())
			return false;
		if (!$this->registerHook('extraRight'))
			return false;
		if (!$this->registerHook('header'))
			return false;
		return true;
	}

	public function getContent()
	{
		$output = '<h2>'.$this->displayName.'</h2>';
		
		if (Tools::isSubmit('submitStar'))
		{
			$star_pic = Tools::getValue('star_pic');
						
			Configuration::updateValue('RATING_STAR', $star_pic);
		}
				
		if (Tools::isSubmit('submit'))
		{
			$nbr = intval(Tools::getValue('nbr'));
			if (!$nbr OR $nbr <= 0 OR !Validate::isInt($nbr))
				$errors[] = $this->l('Invalid number');
			else
				Configuration::updateValue('RATING_NUMBER', $nbr);
			if (isset($errors) AND count($errors))
				$output .= $this->displayError(implode('<br />', $errors));
			else
				$output .= $this->displayConfirmation($this->l('Settings updated'));
		}
		
		return $output.$this->displayForm();
	}
	
	public function displayForm()
	{
		$star_pic	= Tools::getValue('star_pic', Configuration::get('RATING_STAR'));

		$array	= array(1,2,3,4,5,6,7,8,9,10);
		
		$output = '
		<a href="http://www.prestashopbr.com" title="PrestashopBR.com&trade;" >
		<img src="http://laboratorio.prestashopbr.com/img/logo.jpg" 
		style="float:left; margin-right:15px;" alt="PrestashopBR.com&trade;" /></a>
		<br /><br />
		
		<p><b>'.$this->l('M&oacute;dulo que permite ao visitante avaliar o produto.').'</b></p>
		<p>Powered by <i><b><font size="3px"><font color="green">Prestashop<font color="blue">BR</font>.com
		</font></font></b></i></p><div class="clear">
		';
		
		$output .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
			<fieldset><legend><img src="'.$this->_path.'logo.gif" alt="" title="" />'.$this->l('Settings').'</legend>
				<label>'.$this->l('Number of Stars').'</label>
				<div class="margin-form">
					
				<select size="1" name="nbr">';
		
		foreach ( $array as $value )					
		$output .= "<option value=\"$value\" ".( Tools::getValue('nbr', Configuration::get('RATING_NUMBER')) == $value ?  ' SELECTED ' : false )." >$value</option>";
	
	
		$output .= '
				</select>
					
				<p class="clear">'.$this->l('The number of stars (default: 10)').'</p>
					
				</div>
				<center>
					<input type="submit" name="submit" value="'.$this->l('Save').'" class="button" />
				</center>
			</fieldset>
		</form><br />';
		
		/** STAR **/
		$output .= '
		<form action="'.$_SERVER['REQUEST_URI'].'" method="post">
		<fieldset>
			<legend><img src="../img/admin/themes.gif" />'.$this->l('Star').'</legend>';
			
		$star_pic	= Tools::getValue('star_pic', Configuration::get('RATING_STAR'));

		foreach ( $this->pegaArquivos() as $id => $value )
		{
			if ($star_pic ==  $value){
				$check = 'checked = "checked"'; 
			}else{
				$check = '';
			}
			
			$output .=  '

			<label style="width: 30px; float: left; margin-right: 7px; margin-bottom: 20px; padding: 0; text-align: center;">
			<input type="radio" name="star_pic" value="'.$value.'" '.$check.' >';
						
			$output .=  '<img src="../modules/productrating/rating/stars/'.$value.'" />';
			
			$output .=  '</label>
			';
			
		}

		$output .= '<div class="clear"></div><br /><center><input type="submit" name="submitStar" value="'.$this->l('Save').'" 
			class="button" />
		</center>
		</fieldset>
		</form>';
		
		return $output;
	}

	public function pegaArquivos()
	{

		$diretorio				=	dirname(__FILE__) . '/rating/stars/';
		
		$ponteiro 				= opendir( $diretorio  );

		while ( $nome_itens = readdir($ponteiro) )
		{
			$itens[] = $nome_itens ;
		}
		
		sort( $itens ) ;

		foreach ( $itens as $listar )
		{
			if ( $listar != "." && $listar != ".." && $listar != "Thumbs.db" )
			{
				if ( !is_dir($listar) )
				{
					$arquivos[] = $listar ;
				}
			}
		}
		
		return $arquivos;
		
	}

	function hookHeader($params)
	{
		global $smarty;
		
		$star_pic	= Tools::getValue('star_pic', Configuration::get('RATING_STAR'));
		
		$smarty->assign( 'star', $star_pic );
		
		return $this->display(__FILE__, 'productrating-header.tpl');
	}

	function hookextraRight($params)
	{
		global $smarty, $cookie, $page_name;

		return '<br>' . rating_bar( Tools::getValue('id_product'), Tools::getValue('nbr', Configuration::get('RATING_NUMBER')) );				
	}
	
}

?>