<?php
@ini_set('memory_limit','-1');

class TopMenu extends Module
{

	protected $maxImageSize = 3007200;
	protected $imageDir = 'slides/';
	/* @var boolean error */
	protected $error = false;
	
	public function __construct()
	{
	 	$this->name = 'topmenu';
	 	$this->tab = 'Home';
	 	$this->version = '1.0';

	 	parent::__construct();

        $this->displayName = $this->l('Top menu');
        $this->description = $this->l('Horizontal menu');
		$this->confirmUninstall = $this->l('Are you sure you want to delete all the data ?');
	}
	
	public function install()
	{
		
		if (parent::install() == false OR $this->registerHook('top') == false )
		return false;
	
		if (!Configuration::updateValue('TOPMENU_WIDTH', "980"))
		return false;
		if (!Configuration::updateValue('TOPMENU_HEIGHT', "312"))
		return false;
		if (!Configuration::updateValue('TOPMENU_WIDTH2', "130"))
		return false;
		if (!Configuration::updateValue('TOPMENU_OPACITY', "0.9"))
		return false;
		if (!Configuration::updateValue('TOPMENU_FONT', "12"))
		return false;
		if (!Configuration::updateValue('TOPMENU_BUT', "1"))
		return false;
		if (!Configuration::updateValue('TOPMENU_FONTFAMILY', "Verdana"))
		return false;
		if (!Configuration::updateValue('TOPMENU_COLOR', "000000"))
		return false;
		if (!Configuration::updateValue('TOPMENU_COLOR3', "000000"))
		return false;
		if (!Configuration::updateValue('TOPMENU_COLOR2', "000000"))
		return false;
		if (!Configuration::updateValue('TOPMENU_BGCOLOR', "10"))
		return false;
		if (!Configuration::updateValue('TOPMENU_SLICES', "no"))
		return false;
		if (!Configuration::updateValue('TOPMENU_EFFECT', "random"))
		return false;
		if (!Configuration::updateValue('TOPMENU_DELAY', 'yes'))
		return false;
		if (!Configuration::updateValue('TOPMENU_LEFT', "45"))
		return false;
		if (!Configuration::updateValue('TOPMENU_ORDER', "0"))
		return false;
		if (!Configuration::updateValue('TOPMENU_SHADOW', "yes"))
		return false;
		/*
		if (!Configuration::updateValue('TOPMENU_TOP', "0"))
		return false;
		if (!Configuration::updateValue('TOPMENU_FLOAT', "left"))
		return false;*/

		return true;
	}
	 public function installDb()
  {
   
 Db::getInstance()->Execute("INSERT INTO `"._DB_PREFIX_."topmenu` (`url`, `new_window`, `enabled`, `order`, `type`) VALUES ('index.php','0', '1', '1','1');");
 Db::getInstance()->Execute("INSERT INTO `"._DB_PREFIX_."topmenu` (`url`, `new_window`, `enabled`, `order`, `type`) VALUES ('new-products.php','0', '1', '2', '1');");
 Db::getInstance()->Execute("INSERT INTO `"._DB_PREFIX_."topmenu` (`url`, `new_window`, `enabled`, `order`, `type`) VALUES ('prices-drop.php','0', '1', '3','1');");
 Db::getInstance()->Execute("INSERT INTO `"._DB_PREFIX_."topmenu` (`url`, `new_window`, `enabled`, `order`, `type`) VALUES ('contact-form.php','0', '1', '4','1');");
			
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (1, 3, "Inicio");');
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (1, 2, "Accueil");');
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (1, 1, "Home");');
			
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (2, 1, "New products");');
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (2, 2, "Noveaux produits");');
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (2, 3, "Novedades");');
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (3, 1, "Prices drop");');
			
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (3, 2, "Promotions");');
			
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (3, 3, "Ofertas");');
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (4, 1, "Contact us");');
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (4, 2, "Contactez nous");');
			Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang
			(id_link, id_lang, text)
			VALUES (4, 3, "Contacto");');

    return true;
  }
	
	public function uninstall()
	{
	 if (parent::uninstall() == false)
	 return false;
	 	 	if (!Configuration::deleteByName('TOPMENU_OPACITY') OR 
	   !Configuration::deleteByName('TOPMENU_COLOR') OR 
	   !Configuration::deleteByName('TOPMENU_WIDTH') OR
	   !Configuration::deleteByName('TOPMENU_HEIGHT') OR
	   !Configuration::deleteByName('TOPMENU_WIDTH2') OR
	   !Configuration::deleteByName('TOPMENU_BUT') OR
	   !Configuration::deleteByName('TOPMENU_FONTFAMILY') OR
	   !Configuration::deleteByName('TOPMENU_BGCOLOR') OR
	   !Configuration::deleteByName('TOPMENU_SLICES') OR
	   !Configuration::deleteByName('TOPMENU_EFFECT') OR
	   !Configuration::deleteByName('TOPMENU_DELAY') OR
	   !Configuration::deleteByName('TOPMENU_LEFT') OR	   
	   !Configuration::deleteByName('TOPMENU_ORDER') OR	
	   !Configuration::deleteByName('TOPMENU_COLOR2') OR
	   !Configuration::deleteByName('TOPMENU_COLOR3') OR
	   !Configuration::deleteByName('TOPMENU_FONT') OR
	   !Configuration::deleteByName('TOPMENU_SHADOW') OR
       !parent::uninstall())
			return false;
	
	

return true;
	  
	
	}
	
	
	
	
	
	
	
	
	
	
	
	
	public  function _css(){
		global $width,$height,$but,$width2,$width3,$widthm,$widtht,$height3,$height33,$height4,$color, $color2,$color3,$font;
		$width = Configuration::get('TOPMENU_WIDTH', $width);
		$height = Configuration::get('TOPMENU_HEIGHT', $height);
		$but = Configuration::get('TOPMENU_BUT', $but);
		$color = Configuration::get('TOPMENU_COLOR', $color);
		$color2 = Configuration::get('TOPMENU_COLOR2', $color2);
		$color3 = Configuration::get('TOPMENU_COLOR3', $color3);
		$font = Configuration::get('TOPMENU_FONT', $font);
		
		$width2 = Configuration::get('TOPMENU_WIDTH2', $width2);
		
		$width3= $width/3;
		$widthm= round($width/2,0);
		$widtht= $width-20;
		
		$height3= $height/3;
		$height4= round($height/8,0);
	
		global $cookie, $smarty;
		$xml2 = fopen (_PS_ROOT_DIR_."/modules/topmenu/css/screen.css", "w");
		fwrite ($xml2, '
		#sli1{position:relative; float:left; width:35%;  padding:15px}
		#sli2{position:relative; float:left;width:60%; text-align:right}
		.descs{ font-size:'.$font.'px}
		.descs p{ font-size:'.$font.'px}
		#sli h1{ color:#'.$color.'}
		#slider2 h1{ color:#'.$color.'; padding-left:10px}
		#slider2 h1 a{ color:#'.$color.'}
		#slider2 p{ color:#'.$color2.'; padding-left:10px}
		#sli p{ color:#'.$color2.'}
		#slider2 .pricesd{  color: #'.$color3.';}
		.pricesd{
	 background: url("../images/circ.png") no-repeat scroll 0 0 transparent;
    color: #'.$color3.';
    font-size: 30px;
    font-weight: bolder;
    height: 100px;
    padding-left: 0px;
    padding-top: 35px;
    text-align: center;
    width: 299px;}
#contents{
	/*background: url("../images/pattern3.png") repeat scroll 0 0 #EEEEEE;*/
		clear: both;
   
    margin: 0 auto 0;
    padding: 10px;
    position: relative;
    text-align: left;
    width: 980px;
		}	
	#slider ul, #slider li,
	#slider2 ul, #slider2 li{
		margin:0;
		padding:0;
		list-style:none;
		}
	#slider2{margin-top:1em;}
	#slider li, #slider2 li{ 
		/* 
			define width and height of list item (slide)
			entire slider area will adjust according to the parameters provided here
		*/ 
		width:'.$width.'px;
		height:200px;
		overflow:hidden; 
		}	
		#slider2 li{width:980px;
		height:220px;}
		#slider3 {width:980px;}
			#slider3 li{width:100px;
		height:200px; overflow:visible}
	#prevBtn, #nextBtn,
	#slider1next, #slider1prev{ 
		display:block;
		width:30px;
		height:77px;
		position:absolute;
		left:-30px;
		top:'.$height3.'px;
		z-index:1000;
		}	
	#nextBtn, #slider1next{ 
		left:1000px;
		}														
	#prevBtn a, #nextBtn a,
	#slider1next a, #slider1prev a{  
		display:block;
		position:relative;
		width:30px;
		height:77px;
		background:url(../images/btn_prev.png) no-repeat 0 0;	
		}	
	#nextBtn a, #slider1next a{ 
		background:url(../images/btn_next.png) no-repeat 0 0;	
		}	
		
	/* numeric controls */	

	ol#controls{
		margin:1em 0;
		padding:0;
		height:28px;	
		}
	ol#controls li{
		margin:0 10px 0 0; 
		padding:0;
		float:left;
		list-style:none;
		height:28px;
		line-height:28px;
		}
	ol#controls li a{
		float:left;
		height:28px;
		line-height:28px;
		border:1px solid #ccc;
		background:#DAF3F8;
		color:#555;
		padding:0 10px;
		text-decoration:none;
		}
	ol#controls li.current a{
		background:#5DC9E1;
		color:#fff;
		}
	ol#controls li a:focus, #prevBtn a:focus, #nextBtn a:focus{outline:none;}
	
	.jcarousel-skin-tango .jcarousel-container {
   
  
   
}

.jcarousel-skin-tango .jcarousel-direction-rtl {
	direction: rtl;
}

.jcarousel-skin-tango .jcarousel-container-horizontal {
    width: 980px;
  
}

.jcarousel-skin-tango .jcarousel-container-vertical {
    width: 75px;
    height: 245px;
    padding: 40px 20px;
}

.jcarousel-skin-tango .jcarousel-clip {
    overflow: hidden;
}

.jcarousel-skin-tango .jcarousel-clip-horizontal {
    width:  980px;
    height: 135px;
}

.jcarousel-skin-tango .jcarousel-clip-vertical {
    width:  90px;
    height: 245px;
}

.jcarousel-skin-tango .jcarousel-item {
    width: 90px;
    height: 135px;
}

.jcarousel-skin-tango .jcarousel-item-horizontal {
	margin-left: 0;
    margin-right: 9px;
}

.jcarousel-skin-tango .jcarousel-direction-rtl .jcarousel-item-horizontal {
	margin-left: 10px;
    margin-right: 0;
}

.jcarousel-skin-tango .jcarousel-item-vertical {
    margin-bottom: 10px;
}

.jcarousel-skin-tango .jcarousel-item-placeholder {
    background: #fff;
    color: #000;
}

/**
 *  Horizontal Buttons
 */
.jcarousel-skin-tango .jcarousel-next-horizontal {
    position: absolute;
    top: 43px;
    right: -25px;
    width: 32px;
    height: 32px;
    cursor: pointer;
    background: transparent url(next-horizontal.png) no-repeat 0 0;
}

.jcarousel-skin-tango .jcarousel-direction-rtl .jcarousel-next-horizontal {
    left: 5px;
    right: auto;
    background-image: url(prev-horizontal.png);
}

.jcarousel-skin-tango .jcarousel-next-horizontal:hover,
.jcarousel-skin-tango .jcarousel-next-horizontal:focus {
    background-position: -32px 0;
}

.jcarousel-skin-tango .jcarousel-next-horizontal:active {
    background-position: -64px 0;
}

.jcarousel-skin-tango .jcarousel-next-disabled-horizontal,
.jcarousel-skin-tango .jcarousel-next-disabled-horizontal:hover,
.jcarousel-skin-tango .jcarousel-next-disabled-horizontal:focus,
.jcarousel-skin-tango .jcarousel-next-disabled-horizontal:active {
    cursor: default;
    background-position: -96px 0;
}

.jcarousel-skin-tango .jcarousel-prev-horizontal {
    position: absolute;
    top: 43px;
    left: -25px;
    width: 32px;
    height: 32px;
    cursor: pointer;
    background: transparent url(prev-horizontal.png) no-repeat 0 0;
}

.jcarousel-skin-tango .jcarousel-direction-rtl .jcarousel-prev-horizontal {
    left: auto;
    right: 5px;
    background-image: url(next-horizontal.png);
}

.jcarousel-skin-tango .jcarousel-prev-horizontal:hover, 
.jcarousel-skin-tango .jcarousel-prev-horizontal:focus {
    background-position: -32px 0;
}

.jcarousel-skin-tango .jcarousel-prev-horizontal:active {
    background-position: -64px 0;
}

.jcarousel-skin-tango .jcarousel-prev-disabled-horizontal,
.jcarousel-skin-tango .jcarousel-prev-disabled-horizontal:hover,
.jcarousel-skin-tango .jcarousel-prev-disabled-horizontal:focus,
.jcarousel-skin-tango .jcarousel-prev-disabled-horizontal:active {
    cursor: default;
    background-position: -96px 0;
}

/**
 *  Vertical Buttons
 */
.jcarousel-skin-tango .jcarousel-next-vertical {
    position: absolute;
    bottom: 5px;
    left: 43px;
    width: 32px;
    height: 32px;
    cursor: pointer;
    background: transparent url(next-vertical.png) no-repeat 0 0;
}

.jcarousel-skin-tango .jcarousel-next-vertical:hover,
.jcarousel-skin-tango .jcarousel-next-vertical:focus {
    background-position: 0 -32px;
}

.jcarousel-skin-tango .jcarousel-next-vertical:active {
    background-position: 0 -64px;
}

.jcarousel-skin-tango .jcarousel-next-disabled-vertical,
.jcarousel-skin-tango .jcarousel-next-disabled-vertical:hover,
.jcarousel-skin-tango .jcarousel-next-disabled-vertical:focus,
.jcarousel-skin-tango .jcarousel-next-disabled-vertical:active {
    cursor: default;
    background-position: 0 -96px;
}

.jcarousel-skin-tango .jcarousel-prev-vertical {
    position: absolute;
    top: 5px;
    left: 43px;
    width: 32px;
    height: 32px;
    cursor: pointer;
    background: transparent url(prev-vertical.png) no-repeat 0 0;
}

.jcarousel-skin-tango .jcarousel-prev-vertical:hover,
.jcarousel-skin-tango .jcarousel-prev-vertical:focus {
    background-position: 0 -32px;
}

.jcarousel-skin-tango .jcarousel-prev-vertical:active {
    background-position: 0 -64px;
}

.jcarousel-skin-tango .jcarousel-prev-disabled-vertical,
.jcarousel-skin-tango .jcarousel-prev-disabled-vertical:hover,
.jcarousel-skin-tango .jcarousel-prev-disabled-vertical:focus,
.jcarousel-skin-tango .jcarousel-prev-disabled-vertical:active {
    cursor: default;
    background-position: 0 -96px;
}
#mycarousel p{color:#'.$color3.'; font-weight:bolder; text-align:center; }
#mycarousel span a{color:#'.$color2.'; text-align:center; position:relative; float:left; width:100% }
/* Preview Slider Gallery Style */
.ps_container{
	display:none;
	clear:both;
	width:'.$width.'px;
	height:'.$height.'px;
	margin:20px auto 0px auto;
	position:relative;
}
.ps_image_wrapper{
	width:'.$width.'px;
	height:'.$height.'px;
	overflow:hidden;
	position:relative;
	margin:0 auto;
	-moz-box-shadow:0px 0px 5px #999;
	-webkit-box-shadow:0px 0px 5px #999;
	box-shadow:0px 0px 5px #999;
}
.ps_image_wrapper img{
	position:absolute;
	left:0px;
	top:0px;
}
.ps_prev,
.ps_next{
	width:30px;
	height:59px;
	position:absolute;
	top:50%;
	margin-top:-40px;
	cursor:pointer;
	opacity:0.5;
}
.ps_prev{
	background:transparent url(../images/prev.png) no-repeat top center;
	left:-50px;
}
.ps_next{
	background:transparent url(../images/next.png) no-repeat top center;
	right:-50px;
}
.ps_prev:hover,
.ps_next:hover{
	opacity:0.9;
}
ul.ps_nav{
	list-style:none;
	margin:0;
	padding:0;
	width:170px;
	margin:20px auto auto '.$widthm.'px;
	position:relative;
}
ul.ps_nav li{
	float:left;
}
ul.ps_nav li a{
	display:block;
	text-indent:-9000px;
	width:11px;
	height:11px;
	outline:none;
	padding:0px 3px;
	background:transparent url(../images/dot.png) no-repeat top center;
}
ul.ps_nav li a:hover,ul.ps_nav li.selected a{
	background-position:50% -11px;
}
ul.ps_nav li.ps_preview{
	display:none;
	width:85px;
	height:91px;
	top:-95px;
	left:-34.5px; /*First item, next ones is leftDot - 0.5*wThis + 0.5*wDot, i.e. second one is (16 - 42.5 + 8) = -18.5 */
	position:absolute;
}
ul.ps_nav li.ps_preview span{
	background:transparent url(../images/triangle.png) no-repeat top center;
	width:15px;
	height:6px;
	position:absolute;
	top:85px;
	left:35px;
}
.ps_preview_wrapper{
	width:75px;
	height:75px;
	border:5px solid #fff;
	overflow:hidden;
	position:relative;
	-moz-box-shadow:0px 0px 5px #999;
	-webkit-box-shadow:0px 0px 5px #999;
	box-shadow:0px 0px 5px #999;
}
.ps_preview_wrapper img{
	position:absolute;
	top:0px;
	left:0px;
}
.loader{
	width:70px;
	height:70px;
	position:fixed;
	top:50%;
	left:50%;
	margin:-35px 0px 0px -35px;
	opacity:0.7;
	z-index:1000;
	background:#fff url(../images/loader.gif) no-repeat center center;
	-moz-border-radius:15px;
	-webkit-border-radius:15px;
	border-radius:15px;
	-moz-box-shadow:0px 0px 5px #999;
	-webkit-box-shadow:0px 0px 5px #999;
	box-shadow:0px 0px 5px #999;
}
		');
		}
	
	public function hookTop($params)
	{
		global $smarty;

		
	
		
		return $this->display(__FILE__, 'topmenu.tpl');
}
	
	
	
	

	


	public function getLinks()
	{
		$result = array();
		/* Get id and url */
		if (!$links = Db::getInstance()->ExecuteS('SELECT `id_link`, `url`, `new_window`, `enabled`,`order` FROM '._DB_PREFIX_.'topmenu ORDER BY `order` ASC'))
		return false;
		$i = 0;
		foreach ($links AS $link)
		{
		$result[$i]['id'] = $link['id_link'];
		$result[$i]['url'] = $link['url'];
		$result[$i]['newWindow'] = $link['new_window'];
		$result[$i]['enabled'] = $link['enabled'];
		$result[$i]['order'] = $link['order'];
	
		/* Get multilingual text */
		if (!$texts = Db::getInstance()->ExecuteS('SELECT `id_lang`, `text`, `description`  FROM '._DB_PREFIX_.'topmenu_lang WHERE `id_link`='.intval($link['id_link'])))
		return false;
		foreach ($texts AS $text)
		$result[$i]['text_'.$text['id_lang']] = $text['text'];
		
		foreach ($texts AS $desc)
		
		$result[$i]['description_'.$desc['id_lang']] = $desc['description'];
		$i++;
		
		}
		
		return $result;
	}
	
		public function getLinks2()
	{
		global $urlb, $vara;
		$result = array();
		/* Get id and url */
		if (!$links = Db::getInstance()->ExecuteS('SELECT `id_link`, `url`, `new_window`, `enabled`,`order`,`type` FROM '._DB_PREFIX_.'topmenu WHERE enabled = 1 ORDER BY `order` ASC'))
		return false;
		$i = 0;
		foreach ($links AS $link)
		{
		$result[$i]['id'] = $link['id_link'];

			$result[$i]['url'] = $link['url'];

		$result[$i]['newWindow'] = $link['new_window'];
		$result[$i]['enabled'] = $link['enabled'];
		$result[$i]['order'] = $link['order'];
		$result[$i]['type'] = $link['type'];
		
		/* Get multilingual text */
		if (!$texts = Db::getInstance()->ExecuteS('SELECT `id_lang`, `text`, `description`  FROM '._DB_PREFIX_.'topmenu_lang WHERE `id_link`='.intval($link['id_link'])))
		return false;
		foreach ($texts AS $text)
		@$result[$i]['text_'.$text['id_lang']] = @$text['text'];
		
		foreach ($texts AS $desc)
		
		@$result[$i]['description_'.$desc['id_lang']] = @$desc['description'];
		$i++;
		
		}
		
		return $result;
	}
	
	
	
	
	
	
	public function addLink()
	{
			if($_POST['order'] == NULL){
			$ord = Configuration::get('TOPMENU_ORDER')+1;
			Configuration::updateValue('TOPMENU_ORDER', $ord);
			}
			else
			{
			$ord =$_POST['order'];
			}
			
		$find ="http://";
		$pos1 = stripos($_POST['url'], $find);
		if ($pos1 === false) {
	$type = 1;
		}
			else {
	$type = 0;
		}
			/* Url registration */
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu VALUES (\'\', \''.$_POST['url'].'\', '.((isset($_POST['newWindow']) AND $_POST['newWindow']) == 'on' ? 1 : 0).','.((isset($_POST['enabled']) AND $_POST['enabled']) == 'on' ? 1 : 0).', \''.$ord.'\', \''.$type.'\')') OR !$lastId = mysql_insert_id())
			return false;
			/* Multilingual text */
			
			
			$languages = Language::getLanguages();
			$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
			
			if (!$languages)
			return false;
			foreach ($languages AS $language)
			if (!empty($_POST['text_'.$language['id_lang']]) OR !empty($_POST['description_'.$language['id_lang']]))
			{
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang VALUES ('.intval($lastId).', '.intval($language['id_lang']).', \''.pSQL($_POST['text_'.$language['id_lang']]).'\', \''.pSQL($_POST['description_'.$defaultLanguage]).'\')'))
			return false;
			}
			else
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang VALUES ('.intval($lastId).', '.intval($language['id_lang']).', \''.pSQL($_POST['text_'.$defaultLanguage]).'\', \''.pSQL($_POST['description_'.$defaultLanguage]).'\')'))
			return false;
			if (isset($_FILES['item_1_img']) AND isset($_FILES['item_1_img']['tmp_name']) AND !empty($_FILES['item_1_img']['tmp_name']))
			{
			Configuration::set('PS_IMAGE_GENERATION_METHOD', 2);
			if ($error = checkImage($_FILES['item_1_img'], $this->maxImageSize))
			return $error;
			elseif (!$tmpName = tempnam(_PS_TMP_IMG_DIR_, 'PS') OR !move_uploaded_file($_FILES['item_1_img']['tmp_name'], $tmpName))
			return false;
			elseif (!imageResize($tmpName, dirname(__FILE__).'/'.$this->imageDir.'slide'.$lastId.'.jpg'))
			return $this->displayError($this->l('An error occurred during the image upload.'));
			@unlink($tmpName);
			}
			return true;
		
	}
	
	
	
	
	
	
	
	public function updateLink()
	{
			/* Url registration */
			if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'topmenu SET `url`=\''.pSQL($_POST['url']).'\', `new_window`='.(isset($_POST['newWindow']) ? 1 : 0).', `enabled`='.(isset($_POST['enabled']) ? 1 : 0).', `order`=\''.pSQL($_POST['order']).'\' WHERE `id_link`='.intval($_POST['id'])))
			return false;
			
			
			
			$languages = Language::getLanguages();
			$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
			if (!$languages)
			return false;
			if (!Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'topmenu_lang WHERE `id_link` = '.intval($_POST['id'])))
			return false ;
			foreach ($languages AS $language)
			if (!empty($_POST['text_'.$language['id_lang']]) OR !empty($_POST['description_'.$language['id_lang']]))
			{
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang VALUES ('.intval($_POST['id']).', '.intval($language['id_lang']).', \''.pSQL($_POST['text_'.$language['id_lang']]).'\', \''.pSQL(@$_POST['description_'.$language['id_lang']]).'\')'))
			
			return false;
			
			}
			else
			if (!Db::getInstance()->Execute('INSERT INTO '._DB_PREFIX_.'topmenu_lang VALUES ('.intval($_POST['id']).', '.$language['id_lang'].', \''.pSQL($_POST['text_'.$defaultLanguage]).'\', \''.pSQL($_POST['description_'.$defaultLanguage]).'\')'))
			return false;
			if (isset($_FILES['item_1_img']) AND isset($_FILES['item_1_img']['tmp_name']) AND !empty($_FILES['item_1_img']['tmp_name']))
			{
			Configuration::set('PS_IMAGE_GENERATION_METHOD', 1);
			if ($error = checkImage($_FILES['item_1_img'], $this->maxImageSize))
			return $error;
			elseif (!$tmpName = tempnam(_PS_TMP_IMG_DIR_, 'PS') OR !move_uploaded_file($_FILES['item_1_img']['tmp_name'], $tmpName))
			return false;
			elseif (!imageResize($tmpName, dirname(__FILE__).'/'.$this->imageDir.'slide'.intval($_POST['id']).'.jpg'))
			return $this->displayError($this->l('An error occurred during the image upload.'));
			unlink($tmpName);
			}
			return true;
	}
	
	
	
	
	public function deleteLink()
	{
		$mask = "../tools/smarty/compile/*topmenu.tpl.php";
		@array_map( "unlink", glob( $mask ) );
		@unlink('../modules/topmenu/slides/slide'.intval($_POST['id']).'.jpg');
		Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'topmenu WHERE `id_link`='.intval($_POST['id']));
		return Db::getInstance()->Execute('DELETE FROM '._DB_PREFIX_.'topmenu_lang WHERE `id_link`='.intval($_POST['id']));	
	}
	
	
	
	
	public function orderLink()
	{
		$ord = $_GET['order']+1;
		if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'topmenu SET `order`=\''.$ord.'\'  WHERE `id_link`='.intval($_GET['id2'])))
	 	return false;
	
	}
	public function orderLink2()
	{
		if($_GET['order2'] > 0)
		{
		$ord = $_GET['order2']-1;
		if (!Db::getInstance()->Execute('UPDATE '._DB_PREFIX_.'topmenu SET `order`=\''.$ord.'\'  WHERE `id_link`='.intval($_GET['id3'])))
	 	return false;
		}
	}
	
	public function getContent()
    {
		$this->_html = '<h2>'.$this->displayName.'</h2>
		<script type="text/javascript" src="'.$this->_path.'topmenu.js"></script>';
		
		/* Add a link */
		if (isset($_POST['submitLinkAdd']))
		{
		
		$mask = "../tools/smarty/compile/*topmenu.tpl.php";
		@array_map( "unlink", glob( $mask ) );	
		
		
		if (!Validate::isUrl(str_replace('http://', '', $_POST['url'])))
		$this->_html .= $this->displayError($this->l('Bad URL'));
		else
		if ($this->addLink())
		$this->_html .= $this->displayConfirmation($this->l('The link has been added successfully'));
		else
		$this->_html .= $this->displayError($this->l('An error occured during link creation'));
		}
		/* Update a link */
		elseif (isset($_POST['submitLinkUpdate']))
		{
		
		$mask = "../tools/smarty/compile/*topmenu.tpl.php";
		@array_map( "unlink", glob( $mask ) );	
		if (!Validate::isUrl(str_replace('http://', '', $_POST['url'])))
		$this->_html .= $this->displayError($this->l('Bad URL'));
		else
		if (empty($_POST['id']) OR !is_numeric($_POST['id']) OR !$this->updateLink())
		$this->_html .= $this->displayError($this->l('An error occured during link updating'));
		else
		$this->_html .= $this->displayConfirmation($this->l('The link has been updated successfully'));
		}
		/* Update the block title */
		elseif (isset($_POST['submitOrderWay']))
		{
		$width = Tools::getValue('width');
		$width2 = Tools::getValue('width2');
		$height = Tools::getValue('height');
		$opacity = Tools::getValue('opacity');
		$font = Tools::getValue('font');
		$fontfamily = Tools::getValue('fontfamily');
		$color = Tools::getValue('color');
		$color2 = Tools::getValue('color2');
		$color3 = Tools::getValue('color3');
		$bgcolor = Tools::getValue('bgcolor');
		$effect = Tools::getValue('effect');
		$slices = Tools::getValue('slices');
		$delay = Tools::getValue('delay');
		$but = Tools::getValue('but');
		$left = Tools::getValue('left');
		$top = Tools::getValue('top');
		$float = Tools::getValue('float');
			$shadow = Tools::getValue('shadow');
		Configuration::updateValue('TOPMENU_FONT', $font);
		Configuration::updateValue('TOPMENU_FONTFAMILY', $fontfamily);
		Configuration::updateValue('TOPMENU_COLOR', $color);
		Configuration::updateValue('TOPMENU_COLOR2', $color2);
		Configuration::updateValue('TOPMENU_COLOR3', $color3);
		Configuration::updateValue('TOPMENU_BGCOLOR', $bgcolor);
		Configuration::updateValue('TOPMENU_WIDTH', $width);
		Configuration::updateValue('TOPMENU_WIDTH2', $width2);
		Configuration::updateValue('TOPMENU_HEIGHT', $height);
		Configuration::updateValue('TOPMENU_OPACITY', $opacity);
		Configuration::updateValue('TOPMENU_SLICES', $slices);
		Configuration::updateValue('TOPMENU_EFFECT', $effect);
		Configuration::updateValue('TOPMENU_DELAY', $delay);
		Configuration::updateValue('TOPMENU_LEFT', $left);
		Configuration::updateValue('TOPMENU_TOP', $top);
			Configuration::updateValue('TOPMENU_SHADOW', $shadow);
			Configuration::updateValue('TOPMENU_BUT', $but);
		Configuration::updateValue('TOPMENU_FLOAT', $float);
		$this->_html .= $this->displayConfirmation($this->l('Updated'));
		
		}
		
		/* Delete a link*/
		
		elseif (Tools::isSubmit('submitDelete'))
		{
		if (!is_numeric($_POST['id']) OR !$this->deleteLink())
		$this->_html .= $this->displayError($this->l('An error occurred during link deletion'));
		else
		$this->_html .= $this->displayConfirmation($this->l('The link has been deleted successfully'));
		}
		elseif (isset($_GET['id2']))
		{
		if (!is_numeric($_GET['id2']) OR !$this->orderLink())
		$this->_html .= $this->displayConfirmation($this->l('Updated'));
		else
		$this->_html .= $this->displayConfirmation($this->l('..'));
		}
		elseif (isset($_GET['id3']))
		{
		if (!is_numeric($_GET['id3']) OR !$this->orderLink2())
		$this->_html .= $this->displayConfirmation($this->l('Updated'));
		else
		$this->_html .= $this->displayConfirmation($this->l('..'));
		}
		/*$this->_list();*/
		$this->_displayForm();
		
		
		return $this->_html;
    }
	
	private function _displayForm()
	{
		global $cookie, $title;
		/* Language */
		$defaultLanguage = intval(Configuration::get('PS_LANG_DEFAULT'));
		$languages = Language::getLanguages();
		$divLangName = 'text¤title¤description';
		/* Title */
		
		
		$this->_html .= '
		<fieldset><legend><img src="'.$this->_path.'logo.png" alt="" title="" />'.$this->l('Settings').'</legend>
		<legend><img src="'.$this->_path.'add.png" alt="" title="" /> '.$this->l('edit the tpl file to edit menu items').'</legend>
	
		
	
		</fieldset>';
	}

}
