<?php
/*
YOU CAN DO WHAT YOU WANT WITH THIS FILE AS LONG AS YOU LEAVE THIS COPYRIGHT NOTICE IN THE FILE
CREATED BY WWW.PRESTAWORKS.SE - HOSTING AND E-COMMERCE
INSTALLATION: COPY THE FILE TO YOUR PRESTASHOP ROOT FOLDER
Version 1.1
*/
include(dirname(__FILE__).'/config/config.inc.php');


function curPageURL() {
 $pageURL = 'http';
 if ($_SERVER["HTTPS"] == "on") {$pageURL .= "s";}
 $pageURL .= "://";
 if ($_SERVER["SERVER_PORT"] != "80") {
  $pageURL .= $_SERVER["SERVER_NAME"].":".$_SERVER["SERVER_PORT"].$_SERVER["REQUEST_URI"];
 } else {
  $pageURL .= $_SERVER["SERVER_NAME"].$_SERVER["REQUEST_URI"];
 }
 return str_replace('/prisjakt.php','', $pageURL);
}



$lang = intval(Configuration::get('PS_LANG_DEFAULT'));
$productClass = new Product();
$id_currency = intval(Configuration::get('PS_CURRENCY_DEFAULT'));
$currency = new Currency(intval($id_currency));

echo "SKU\tName\tPrice\tCategory\tProduct URL\tGraphic URL\tIn stock\n";

$products = $productClass->getProducts($lang, 0, null, 'name', 'ASC', false);
foreach ($products as $key => $product)
		{
		 $price = number_format(Tools::convertPrice($product['price'], $currency), 2, '.', '');
		//ADD TAX TO PRICE
		 $tax = $product['tax_rate'];
		 $tax = $tax/100;
		 $tax = $tax + 1;
		 $price = $price * $tax;
		 
		 if($product['reduction_from']==$product['reduction_to'])
		 {
			//Is set to forever
			if($product['reduction_price']!='0.00')
			{
				//VALUE DISCOUNT
				$price = $price - number_format(Tools::convertPrice($product['reduction_price'], $currency), 2, '.', '');
			}
			else
			{
				if($product['reduction_percent']!='0')
				{
					//% DISCOUNT
					$deductproc = $product['reduction_percent'] / 100;
					$deductproc = $price * $deductproc;
					$price = $price - $deductproc;
				}
			}
		}
		 else
		 {
			//Is not set forever
			
			//convert dates
			$exp_date = $product['reduction_to'];
			$todays_date = date("Y-m-d");

			$today = strtotime($todays_date);
			$expiration_date = strtotime($exp_date);

			if($expiration_date > $today)
			{
				//DISCOUNT VALID
				if($product['reduction_price']!='0.00')
			{
				//VALUE DISCOUNT
				$price = $price - number_format(Tools::convertPrice($product['reduction_price'], $currency), 2, '.', '');
			}
			else
			{
				if($product['reduction_percent']!='0')
				{
					//% DISCOUNT
					$deductproc = $product['reduction_percent'] / 100;
					$deductproc = $price * $deductproc;
					$price = $price - $deductproc;
				}
			}
			}
		}
		 
		 $category = new Category(intval($product['id_category_default']));
		 $imageUrl = Product::getCover(intval($product['id_product']));
		 
		 echo htmlentities(utf8_decode($product['name']))."\t".
		 number_format(Tools::convertPrice($price, $currency), 2, '.', '')."\t".
		 $category->name[1]."\t".
		 curPageURL().'/product.php?id_product='.$product['id_product']."\t". //PRINT PRODUCT DIRECT URl
		 curPageURL()._THEME_PROD_DIR_.$product['id_product']."-".$imageUrl['id_image']."-large.jpg\t". //PRINT IMAGE URL {$img_prod_dir}{$cover.id_image}-large.jpg
		 $product['quantity']."\n"; //IN STOCK STATUS 
		}




?>
