<?php
/**
* Smarty Internal Plugin Templateparser
*
* This is the template parser.
* It is generated from the internal.templateparser.y file
* @package Smarty
* @subpackage Compiler
* @author Uwe Tews
*/

class TP_yyToken implements ArrayAccess
{
    public $string = '';
    public $metadata = array();

    function __construct($s, $m = array())
    {
        if ($s instanceof TP_yyToken) {
            $this->string = $s->string;
            $this->metadata = $s->metadata;
        } else {
            $this->string = (string) $s;
            if ($m instanceof TP_yyToken) {
                $this->metadata = $m->metadata;
            } elseif (is_array($m)) {
                $this->metadata = $m;
            }
        }
    }

    function __toString()
    {
        return $this->_string;
    }

    function offsetExists($offset)
    {
        return isset($this->metadata[$offset]);
    }

    function offsetGet($offset)
    {
        return $this->metadata[$offset];
    }

    function offsetSet($offset, $value)
    {
        if ($offset === null) {
            if (isset($value[0])) {
                $x = ($value instanceof TP_yyToken) ?
                    $value->metadata : $value;
                $this->metadata = array_merge($this->metadata, $x);
                return;
            }
            $offset = count($this->metadata);
        }
        if ($value === null) {
            return;
        }
        if ($value instanceof TP_yyToken) {
            if ($value->metadata) {
                $this->metadata[$offset] = $value->metadata;
            }
        } elseif ($value) {
            $this->metadata[$offset] = $value;
        }
    }

    function offsetUnset($offset)
    {
        unset($this->metadata[$offset]);
    }
}

class TP_yyStackEntry
{
    public $stateno;       /* The state-number */
    public $major;         /* The major token value.  This is the code
                     ** number for the token at this stack level */
    public $minor; /* The user-supplied minor token value.  This
                     ** is the value of the token  */
};


#line 12 "smarty_internal_templateparser.y"
class Smarty_Internal_Templateparser#line 79 "smarty_internal_templateparser.php"
{
#line 14 "smarty_internal_templateparser.y"

    const Err1 = "Security error: Call to private object member not allowed";
    const Err2 = "Security error: Call to dynamic object member not allowed";
    const Err3 = "PHP in template not allowed. Use SmartyBC to enable it";
    // states whether the parse was successful or not
    public $successful = true;
    public $retvalue = 0;
    private $lex;
    private $internalError = false;
    private $strip = false;

    function __construct($lex, $compiler) {
        $this->lex = $lex;
        $this->compiler = $compiler;
        $this->smarty = $this->compiler->smarty;
        $this->template = $this->compiler->template;
        $this->compiler->has_variable_string = false;
        $this->compiler->prefix_code = array();
        $this->prefix_number = 0;
        $this->block_nesting_level = 0;
        if ($this->security = isset($this->smarty->security_policy)) {
            $this->php_handling = $this->smarty->security_policy->php_handling;
        } else {
            $this->php_handling = $this->smarty->php_handling;
        }
        $this->is_xml = false;
        $this->asp_tags = (ini_get('asp_tags') != '0');
        $this->current_buffer = $this->root_buffer = new _smarty_template_buffer($this);
    }

    public static function escape_start_tag($tag_text) {
        $tag = preg_replace('/\A<\?(.*)\z/', '<<?php ?>?\1', $tag_text, -1 , $count); //Escape tag
        return $tag;
    }

    public static function escape_end_tag($tag_text) {
        return '?<?php ?>>';
    }

    public function compileVariable($variable) {
        if (strpos($variable,'(') == 0) {
            // not a variable variable
            $var = trim($variable,'\'');
            $this->compiler->tag_nocache=$this->compiler->tag_nocache|$this->template->getVariable($var, null, true, false)->nocache;
            $this->template->properties['variables'][$var] = $this->compiler->tag_nocache|$this->compiler->nocache;
        }
//       return '(isset($_smarty_tpl->tpl_vars['. $variable .'])?$_smarty_tpl->tpl_vars['. $variable .']->value:$_smarty_tpl->getVariable('. $variable .')->value)';
        return '$_smarty_tpl->tpl_vars['. $variable .']->value';
    }
#line 132 "smarty_internal_templateparser.php"

    const TP_VERT                           =  1;
    const TP_COLON                          =  2;
    const TP_COMMENT                        =  3;
    const TP_PHPSTARTTAG                    =  4;
    const TP_PHPENDTAG                      =  5;
    const TP_ASPSTARTTAG                    =  6;
    const TP_ASPENDTAG                      =  7;
    const TP_FAKEPHPSTARTTAG                =  8;
    const TP_XMLTAG                         =  9;
    const TP_TEXT                           = 10;
    const TP_STRIPON                        = 11;
    const TP_STRIPOFF                       = 12;
    const TP_LITERALSTART                   = 13;
    const TP_LITERALEND                     = 14;
    const TP_LITERAL                        = 15;
    const TP_LDEL                           = 16;
    const TP_RDEL                           = 17;
    const TP_DOLLAR                         = 18;
    const TP_ID                             = 19;
    const TP_EQUAL                          = 20;
    const TP_PTR                            = 21;
    const TP_LDELIF                         = 22;
    const TP_LDELFOR                        = 23;
    const TP_SEMICOLON                      = 24;
    const TP_INCDEC                         = 25;
    const TP_TO                             = 26;
    const TP_STEP                           = 27;
    const TP_LDELFOREACH                    = 28;
    const TP_SPACE                          = 29;
    const TP_AS                             = 30;
    const TP_APTR                           = 31;
    const TP_LDELSETFILTER                  = 32;
    const TP_SMARTYBLOCKCHILD               = 33;
    const TP_LDELSLASH                      = 34;
    const TP_ATTR                           = 35;
    const TP_INTEGER                        = 36;
    const TP_COMMA                          = 37;
    const TP_OPENP                          = 38;
    const TP_CLOSEP                         = 39;
    const TP_MATH                           = 40;
    const TP_UNIMATH                        = 41;
    const TP_ANDSYM                         = 42;
    const TP_ISIN                           = 43;
    const TP_ISDIVBY                        = 44;
    const TP_ISNOTDIVBY                     = 45;
    const TP_ISEVEN                         = 46;
    const TP_ISNOTEVEN                      = 47;
    const TP_ISEVENBY                       = 48;
    const TP_ISNOTEVENBY                    = 49;
    const TP_ISODD                          = 50;
    const TP_ISNOTODD                       = 51;
    const TP_ISODDBY                        = 52;
    const TP_ISNOTODDBY                     = 53;
    const TP_INSTANCEOF                     = 54;
    const TP_QMARK                          = 55;
    const TP_NOT                            = 56;
    const TP_TYPECAST                       = 57;
    const TP_HEX                            = 58;
    const TP_DOT                            = 59;
    const TP_SINGLEQUOTESTRING              = 60;
    const TP_DOUBLECOLON                    = 61;
    const TP_AT                             = 62;
    const TP_HATCH                          = 63;
    const TP_OPENB                          = 64;
    const TP_CLOSEB                         = 65;
    const TP_EQUALS                         = 66;
    const TP_NOTEQUALS                      = 67;
    const TP_GREATERTHAN                    = 68;
    const TP_LESSTHAN                       = 69;
    const TP_GREATEREQUAL                   = 70;
    const TP_LESSEQUAL                      = 71;
    const TP_IDENTITY                       = 72;
    const TP_NONEIDENTITY                   = 73;
    const TP_MOD                            = 74;
    const TP_LAND                           = 75;
    const TP_LOR                            = 76;
    const TP_LXOR                           = 77;
    const TP_QUOTE                          = 78;
    const TP_BACKTICK                       = 79;
    const TP_DOLLARID                       = 80;
    const YY_NO_ACTION = 593;
    const YY_ACCEPT_ACTION = 592;
    const YY_ERROR_ACTION = 591;

    const YY_SZ_ACTTAB = 2453;
static public $yy_action = array(
 /*     0 */   210,  320,  317,  316,  312,  311,  313,  314,  315,  322,
 /*    10 */   323,  189,  191,  340,   43,  168,  292,  290,  161,   25,
 /*    20 */     3,  108,  284,   29,  294,  199,  146,  294,   15,   15,
 /*    30 */   244,  296,  243,  277,   18,   18,  285,   12,  127,   48,
 /*    40 */    52,   50,   44,    9,   14,  384,  385,   17,   16,  386,
 /*    50 */   283,   41,   39,  210,  592,   95,  260,  319,  321,    6,
 /*    60 */    21,  194,  135,  374,  193,  387,  383,  382,  378,  377,
 /*    70 */   379,  380,  381,  363,  362,  345,  344,   28,   31,   34,
 /*    80 */   370,   15,   19,  237,  137,  187,   25,   18,  203,  284,
 /*    90 */    29,  203,   48,   52,   50,   44,    9,   14,  384,  385,
 /*   100 */    17,   16,  386,  283,   41,   39,  329,  324,  326,  327,
 /*   110 */   325,   24,  288,    4,    4,  189,  332,  330,  387,  383,
 /*   120 */   382,  378,  377,  379,  380,  381,  363,  362,  345,  344,
 /*   130 */   210,  368,  231,  210,  251,  117,  139,  139,   84,  132,
 /*   140 */   278,   25,   10,  162,  284,  359,  338,  302,  346,  459,
 /*   150 */   226,  228,  369,  364,   15,  375,  230,   15,   15,  177,
 /*   160 */    18,  459,  240,   18,   18,  212,  257,  459,  294,   48,
 /*   170 */    52,   50,   44,    9,   14,  384,  385,   17,   16,  386,
 /*   180 */   283,   41,   39,  131,  101,  159,   47,  196,  340,  371,
 /*   190 */    25,  190,  340,  284,  294,  387,  383,  382,  378,  377,
 /*   200 */   379,  380,  381,  363,  362,  345,  344,  210,  368,  208,
 /*   210 */   210,  203,  140,  210,    8,   56,  123,  118,  210,  457,
 /*   220 */   366,  261,  234,  343,  302,  346,  453,  147,  228,  369,
 /*   230 */   364,  457,  375,   15,  342,   15,  231,  457,   15,   18,
 /*   240 */     4,   18,  307,   37,   18,  195,   48,   52,   50,   44,
 /*   250 */     9,   14,  384,  385,   17,   16,  386,  283,   41,   39,
 /*   260 */   210,   25,    2,  139,  284,   11,   47,  185,  210,   45,
 /*   270 */   266,   47,  387,  383,  382,  378,  377,  379,  380,  381,
 /*   280 */   363,  362,  345,  344,  286,  242,  104,  166,   15,  210,
 /*   290 */   276,  184,  188,   23,   18,  272,  294,   22,  162,   48,
 /*   300 */    52,   50,   44,    9,   14,  384,  385,   17,   16,  386,
 /*   310 */   283,   41,   39,  203,  106,  170,   13,   15,  203,  288,
 /*   320 */   318,  319,  321,   18,  294,  387,  383,  382,  378,  377,
 /*   330 */   379,  380,  381,  363,  362,  345,  344,  210,  131,  105,
 /*   340 */   210,  203,   23,  368,  268,  130,  249,  152,  355,   25,
 /*   350 */   197,  132,  284,  271,   32,  162,  287,  155,  354,  210,
 /*   360 */     3,  108,   15,  228,  369,  364,  146,  375,   18,  252,
 /*   370 */   244,  296,  243,  375,  303,  305,   48,   52,   50,   44,
 /*   380 */     9,   14,  384,  385,   17,   16,  386,  283,   41,   39,
 /*   390 */   103,  210,   36,  208,  109,  388,  303,  232,    8,    4,
 /*   400 */   248,  246,  387,  383,  382,  378,  377,  379,  380,  381,
 /*   410 */   363,  362,  345,  344,  198,   40,  361,   27,  353,  179,
 /*   420 */   175,   20,  139,  236,  239,  211,  116,   18,  294,  294,
 /*   430 */    48,   52,   50,   44,    9,   14,  384,  385,   17,   16,
 /*   440 */   386,  283,   41,   39,  178,  200,  200,   23,   25,  267,
 /*   450 */   351,  284,  186,  294,  285,  201,  387,  383,  382,  378,
 /*   460 */   377,  379,  380,  381,  363,  362,  345,  344,  210,  368,
 /*   470 */   200,  210,  210,  140,  301,  181,   69,  123,  238,   25,
 /*   480 */   210,  147,  284,  347,  202,  302,  346,  459,  304,  228,
 /*   490 */   369,  364,   15,  375,  241,   15,  297,  172,   18,  459,
 /*   500 */   235,   18,  203,  306,  129,  459,  294,   48,   52,   50,
 /*   510 */    44,    9,   14,  384,  385,   17,   16,  386,  283,   41,
 /*   520 */    39,  210,   25,  200,   47,  229,   25,  134,  210,  233,
 /*   530 */   120,  119,  210,  387,  383,  382,  378,  377,  379,  380,
 /*   540 */   381,  363,  362,  345,  344,  373,  373,  143,  308,  180,
 /*   550 */   236,  282,   25,   25,   42,  284,  216,  236,  238,  250,
 /*   560 */    48,   52,   50,   44,    9,   14,  384,  385,   17,   16,
 /*   570 */   386,  283,   41,   39,  210,   30,  203,  360,  182,   25,
 /*   580 */   285,   47,  222,  126,  167,  303,  387,  383,  382,  378,
 /*   590 */   377,  379,  380,  381,  363,  362,  345,  344,  245,  373,
 /*   600 */    15,  372,  160,  334,    6,  333,   18,  247,  254,   35,
 /*   610 */   255,  294,  114,   48,   52,   50,   44,    9,   14,  384,
 /*   620 */   385,   17,   16,  386,  283,   41,   39,  373,  192,  281,
 /*   630 */   253,  145,   38,  298,  300,  226,   94,  124,  102,  387,
 /*   640 */   383,  382,  378,  377,  379,  380,  381,  363,  362,  345,
 /*   650 */   344,  210,  368,  373,  210,  141,  140,  368,  336,   71,
 /*   660 */   132,  149,  136,    7,   10,  132,  165,  204,  302,  346,
 /*   670 */   456,   98,  228,  369,  364,  294,  375,  228,  369,  364,
 /*   680 */   279,  375,  456,  220,  232,  335,  373,  285,  456,  162,
 /*   690 */    48,   52,   50,   44,    9,   14,  384,  385,   17,   16,
 /*   700 */   386,  283,   41,   39,  210,  210,  309,   47,  285,  200,
 /*   710 */   371,   45,  162,  183,  144,   97,  387,  383,  382,  378,
 /*   720 */   377,  379,  380,  381,  363,  362,  345,  344,  285,  131,
 /*   730 */   373,  354,  331,  107,  110,  256,  376,  327,  327,  327,
 /*   740 */   327,  327,  115,   48,   52,   50,   44,    9,   14,  384,
 /*   750 */   385,   17,   16,  386,  283,   41,   39,  373,  327,  327,
 /*   760 */   327,  327,  327,  327,  327,  327,  327,  327,  356,  387,
 /*   770 */   383,  382,  378,  377,  379,  380,  381,  363,  362,  345,
 /*   780 */   344,  210,  352,  368,  327,  210,  327,  140,  327,  327,
 /*   790 */    71,  132,  327,  100,  339,  327,  138,  269,  337,  302,
 /*   800 */   346,  328,  327,  228,  369,  364,   15,  375,  373,  327,
 /*   810 */    15,  373,   18,   15,  219,  327,   18,  327,  327,   18,
 /*   820 */    48,   52,   50,   44,    9,   14,  384,  385,   17,   16,
 /*   830 */   386,  283,   41,   39,  210,  327,  327,  327,   47,  327,
 /*   840 */   327,  327,  327,  327,  327,  327,  387,  383,  382,  378,
 /*   850 */   377,  379,  380,  381,  363,  362,  345,  344,  327,  327,
 /*   860 */   327,  327,  327,  327,  327,  327,  327,  327,  327,  327,
 /*   870 */   327,  327,  274,   48,   52,   50,   44,    9,   14,  384,
 /*   880 */   385,   17,   16,  386,  283,   41,   39,  210,  327,  327,
 /*   890 */   327,  327,  327,  327,  327,  327,  327,  327,  327,  387,
 /*   900 */   383,  382,  378,  377,  379,  380,  381,  363,  362,  345,
 /*   910 */   344,  327,  327,  327,  327,  327,  327,  327,  327,  327,
 /*   920 */   327,  327,  327,  327,  327,  327,   48,   52,   50,   44,
 /*   930 */     9,   14,  384,  385,   17,   16,  386,  283,   41,   39,
 /*   940 */   210,  327,  327,  327,  327,  327,  327,  327,  327,  327,
 /*   950 */   327,  265,  387,  383,  382,  378,  377,  379,  380,  381,
 /*   960 */   363,  362,  345,  344,  327,  327,  327,  327,  327,  224,
 /*   970 */   327,  327,  327,  327,  327,  327,  327,  327,  327,   48,
 /*   980 */    52,   50,   44,    9,   14,  384,  385,   17,   16,  386,
 /*   990 */   283,   41,   39,  210,  327,  327,  327,  327,  327,  327,
 /*  1000 */   327,  327,  327,  327,  327,  387,  383,  382,  378,  377,
 /*  1010 */   379,  380,  381,  363,  362,  345,  344,  327,  327,  327,
 /*  1020 */   327,  327,  327,  327,  327,  327,  327,  327,  327,  327,
 /*  1030 */   327,  327,   48,   52,   50,   44,    9,   14,  384,  385,
 /*  1040 */    17,   16,  386,  283,   41,   39,  327,  327,  327,  327,
 /*  1050 */   327,  327,  327,  327,  327,  327,  327,  327,  387,  383,
 /*  1060 */   382,  378,  377,  379,  380,  381,  363,  362,  345,  344,
 /*  1070 */   327,  327,  327,   48,   52,   50,   44,    9,   14,  384,
 /*  1080 */   385,   17,   16,  386,  283,   41,   39,  327,  327,  327,
 /*  1090 */   327,  327,  327,  327,  327,  327,  327,  327,  327,  387,
 /*  1100 */   383,  382,  378,  377,  379,  380,  381,  363,  362,  345,
 /*  1110 */   344,  327,  327,  327,  327,  327,   43,  327,  142,  207,
 /*  1120 */   327,  327,    3,  108,  327,  264,  327,  368,  146,  327,
 /*  1130 */   327,  151,  244,  296,  243,  132,  227,   15,   33,  327,
 /*  1140 */   327,   51,  327,   18,  367,  327,  368,  228,  369,  364,
 /*  1150 */   150,  375,  327,  174,  132,  327,   49,   46,  299,  225,
 /*  1160 */   365,  327,  294,  103,    1,  280,  228,  369,  364,  262,
 /*  1170 */   375,  327,  327,   43,  285,  142,  218,  327,   96,    3,
 /*  1180 */   108,   15,  289,  327,  327,  146,  327,   18,  327,  244,
 /*  1190 */   296,  243,  327,  227,   15,   33,  327,  327,   51,  327,
 /*  1200 */    18,  327,  368,  327,  327,  327,  121,  327,  327,   54,
 /*  1210 */   132,  327,  327,   49,   46,  299,  225,  365,  302,  346,
 /*  1220 */   103,    1,  228,  369,  364,  327,  375,  350,  327,  327,
 /*  1230 */    43,  327,  142,  205,  327,   96,    3,  108,  327,   15,
 /*  1240 */   169,  327,  146,  327,  358,   18,  244,  296,  243,  294,
 /*  1250 */   227,  327,   33,  327,  327,   51,   15,  327,  327,  368,
 /*  1260 */   327,  285,   18,  140,  327,  327,   66,  132,  327,  327,
 /*  1270 */    49,   46,  299,  225,  365,  302,  346,  103,    1,  228,
 /*  1280 */   369,  364,  327,  375,  295,  327,  327,   43,  327,  130,
 /*  1290 */   218,  327,   96,    3,  108,  327,   15,  327,  327,  146,
 /*  1300 */   327,  293,   18,  244,  296,  243,  327,  227,  327,   26,
 /*  1310 */   327,  327,   51,   15,  327,  327,  368,  327,  327,   18,
 /*  1320 */   140,  327,  327,   60,  132,  327,  327,   49,   46,  299,
 /*  1330 */   225,  365,  302,  346,  103,    1,  228,  369,  364,  327,
 /*  1340 */   375,  258,  327,  327,   43,  327,  128,  218,  327,   96,
 /*  1350 */     3,  108,  327,   15,  327,  327,  146,  327,  291,   18,
 /*  1360 */   244,  296,  243,  327,  227,  327,    5,  327,  327,   51,
 /*  1370 */    15,  327,  327,  368,  327,  327,   18,  140,  327,  327,
 /*  1380 */    75,  132,  327,  327,   49,   46,  299,  225,  365,  302,
 /*  1390 */   346,  103,    1,  228,  369,  364,  327,  375,  259,  327,
 /*  1400 */   327,   43,  327,  142,  209,  327,   96,    3,  108,  327,
 /*  1410 */    15,  327,  327,  146,  327,  273,   18,  244,  296,  243,
 /*  1420 */   327,  227,  327,   33,  327,  327,   51,   15,  327,  327,
 /*  1430 */   368,  327,  327,   18,  140,  327,  327,   87,  132,  327,
 /*  1440 */   327,   49,   46,  299,  225,  365,  302,  346,  103,    1,
 /*  1450 */   228,  369,  364,  327,  375,  275,  327,  327,   43,  327,
 /*  1460 */   125,   92,  327,   96,    3,  108,  327,   15,  327,  327,
 /*  1470 */   146,  327,  310,   18,  244,  296,  243,  327,  227,  327,
 /*  1480 */    33,  327,  327,   51,   15,  327,  327,  368,  327,  327,
 /*  1490 */    18,  140,  327,  327,   58,  132,  327,  327,   49,   46,
 /*  1500 */   299,  225,  365,  302,  346,  103,    1,  228,  369,  364,
 /*  1510 */   327,  375,  341,  327,  327,   43,  327,  133,  218,  327,
 /*  1520 */    96,    3,  108,  327,   15,  327,  327,  146,  327,  348,
 /*  1530 */    18,  244,  296,  243,  327,  227,  327,   33,  327,  327,
 /*  1540 */    51,   15,  327,  327,  368,  327,  327,   18,  140,  327,
 /*  1550 */   327,   68,  132,  327,  327,   49,   46,  299,  225,  365,
 /*  1560 */   302,  346,  103,    1,  215,  369,  364,  327,  375,  327,
 /*  1570 */   327,  327,   43,  327,  142,  206,  327,   96,    3,  108,
 /*  1580 */   327,  327,  327,  327,  146,  327,  327,  327,  244,  296,
 /*  1590 */   243,  327,  213,  327,   33,  327,  327,   51,  327,  327,
 /*  1600 */   327,  368,  327,  327,  327,  140,  327,  327,   89,  132,
 /*  1610 */   327,  327,   49,   46,  299,  225,  365,  302,  346,  103,
 /*  1620 */     1,  228,  369,  364,  327,  375,  327,  327,  327,   43,
 /*  1630 */   327,  130,  214,  327,   96,    3,  108,  327,  327,  327,
 /*  1640 */   327,  146,  327,  327,  327,  244,  296,  243,  327,  227,
 /*  1650 */   327,   26,  327,  327,   51,  327,  327,  327,  368,  327,
 /*  1660 */   327,  327,   93,  327,  327,   53,  122,  327,  327,   49,
 /*  1670 */    46,  299,  225,  365,  302,  346,  103,  327,  221,  369,
 /*  1680 */   364,  327,  375,  327,  327,  327,   43,  327,  130,  218,
 /*  1690 */   327,   96,    3,  108,  327,  327,  327,  327,  146,  327,
 /*  1700 */   327,  327,  244,  296,  243,  327,  227,  327,   26,  327,
 /*  1710 */   327,   51,  327,  327,  327,  368,  327,  327,  327,  140,
 /*  1720 */   327,  327,   71,  132,  327,  327,   49,   46,  299,  225,
 /*  1730 */   365,  302,  346,  103,  327,  228,  369,  364,  327,  375,
 /*  1740 */   327,  327,  327,  327,  502,  327,  217,  327,   96,  327,
 /*  1750 */   327,  502,  327,  502,  502,  355,  502,  502,  327,  327,
 /*  1760 */   327,   32,  502,  327,  502,    4,  502,    3,  108,  327,
 /*  1770 */    99,  171,  327,  146,  327,  327,  327,  244,  296,  243,
 /*  1780 */   294,  502,  327,   28,   31,  327,  327,  327,  139,  327,
 /*  1790 */   327,  327,  502,  327,  368,  193,  163,  203,  117,  327,
 /*  1800 */   327,   84,  132,  327,  327,  294,  502,  327,   28,   31,
 /*  1810 */   302,  346,  327,  368,  228,  369,  364,  157,  375,  327,
 /*  1820 */   327,  132,  203,  357,   27,  353,  327,  327,  327,  263,
 /*  1830 */   270,  327,  368,  228,  369,  364,  140,  375,  327,   69,
 /*  1840 */   132,  327,  210,  368,  327,  327,  327,  140,  302,  346,
 /*  1850 */    79,  132,  228,  369,  364,  327,  375,  327,  349,  302,
 /*  1860 */   346,  327,  223,  228,  369,  364,  327,  375,  327,  327,
 /*  1870 */    15,  327,  327,  327,  368,  327,   18,  327,  140,    4,
 /*  1880 */   327,   91,  132,  327,  327,  327,  327,  327,  327,  327,
 /*  1890 */   302,  346,  327,  327,  228,  369,  364,  368,  375,  327,
 /*  1900 */   327,  140,  139,  368,   76,  132,  327,  153,  327,  327,
 /*  1910 */   327,  132,  327,  302,  346,  327,  327,  228,  369,  364,
 /*  1920 */   327,  375,  368,  228,  369,  364,  140,  375,  327,   63,
 /*  1930 */   132,  327,  327,  368,  327,  327,  327,  111,  302,  346,
 /*  1940 */    62,  132,  228,  369,  364,  327,  375,  327,  327,  302,
 /*  1950 */   346,  327,  327,  228,  369,  364,  327,  375,  327,  327,
 /*  1960 */   368,  193,  176,  327,  140,  327,  327,   78,  132,  327,
 /*  1970 */   327,  294,  327,  327,   28,   31,  302,  346,  327,  327,
 /*  1980 */   228,  369,  364,  368,  375,  327,  327,  140,  203,  368,
 /*  1990 */    64,  132,  327,  154,  327,  327,  327,  132,  327,  302,
 /*  2000 */   346,  327,  327,  228,  369,  364,  327,  375,  368,  228,
 /*  2010 */   369,  364,  140,  375,  327,   77,  132,  327,  327,  368,
 /*  2020 */   327,  327,  327,  140,  302,  346,   80,  132,  228,  369,
 /*  2030 */   364,  327,  375,  327,  327,  302,  346,  327,  327,  228,
 /*  2040 */   369,  364,  327,  375,  327,  327,  368,  327,  327,  327,
 /*  2050 */   140,  327,  327,   61,  132,  327,  327,  327,  327,  327,
 /*  2060 */   327,  327,  302,  346,  327,  327,  228,  369,  364,  368,
 /*  2070 */   375,  327,  327,  140,  327,  368,   65,  132,  327,  156,
 /*  2080 */   327,  327,  327,  132,  327,  302,  346,  327,  327,  228,
 /*  2090 */   369,  364,  327,  375,  368,  228,  369,  364,  140,  375,
 /*  2100 */   327,   81,  132,  327,  327,  368,  327,  327,  327,  113,
 /*  2110 */   302,  346,   88,  132,  228,  369,  364,  327,  375,  327,
 /*  2120 */   327,  302,  346,  327,  327,  228,  369,  364,  327,  375,
 /*  2130 */   327,  327,  368,  327,  327,  327,  140,  327,  327,   67,
 /*  2140 */   132,  327,  327,  327,  327,  327,  327,  327,  302,  346,
 /*  2150 */   327,  327,  228,  369,  364,  368,  375,  327,  327,  140,
 /*  2160 */   327,  368,   86,  132,  327,  148,  327,  327,  327,  132,
 /*  2170 */   327,  302,  346,  327,  327,  228,  369,  364,  327,  375,
 /*  2180 */   368,  228,  369,  364,  140,  375,  327,   85,  132,  327,
 /*  2190 */   327,  368,  327,  327,  327,  112,  302,  346,   73,  132,
 /*  2200 */   228,  369,  364,  327,  375,  327,  327,  302,  346,  327,
 /*  2210 */   327,  228,  369,  364,  327,  375,  327,  327,  368,  327,
 /*  2220 */   327,  327,  140,  327,  327,   70,  132,  327,  327,  327,
 /*  2230 */   327,  327,  327,  327,  302,  346,  327,  327,  228,  369,
 /*  2240 */   364,  368,  375,  327,  327,  140,  327,  327,   57,  132,
 /*  2250 */   327,  327,  327,  327,  327,  327,  327,  302,  346,  327,
 /*  2260 */   327,  228,  369,  364,  327,  375,  368,  327,  327,  327,
 /*  2270 */   140,  327,  327,   90,  132,  327,  327,  368,  327,  327,
 /*  2280 */   327,  140,  302,  346,   83,  132,  228,  369,  364,  327,
 /*  2290 */   375,  327,  327,  302,  346,  327,  327,  228,  369,  364,
 /*  2300 */   327,  375,  327,  327,  368,  327,  327,  327,  140,  327,
 /*  2310 */   327,   82,  132,  327,  327,  327,  327,  327,  327,  327,
 /*  2320 */   302,  346,  327,  327,  228,  369,  364,  368,  375,  327,
 /*  2330 */   327,  140,  327,  327,   55,  132,  327,  327,  327,  327,
 /*  2340 */   327,  327,  327,  302,  346,  327,  327,  228,  369,  364,
 /*  2350 */   327,  375,  368,  327,  327,  327,  140,  327,  327,   72,
 /*  2360 */   132,  327,  327,  368,  327,  327,  327,   93,  302,  346,
 /*  2370 */    59,  122,  228,  369,  364,  327,  375,  327,  327,  302,
 /*  2380 */   346,  327,  327,  228,  369,  364,  327,  375,  327,  327,
 /*  2390 */   368,  327,  327,  327,  140,  327,  327,   74,  132,  327,
 /*  2400 */   327,  327,  327,  193,  158,  327,  302,  346,  327,  327,
 /*  2410 */   228,  369,  364,  294,  375,  327,   28,   31,  193,  173,
 /*  2420 */   327,  327,  327,  327,  327,  193,  164,  327,  294,  327,
 /*  2430 */   203,   28,   31,  327,  327,  294,  327,  327,   28,   31,
 /*  2440 */   327,  327,  327,  327,  327,  203,  327,  327,  327,  327,
 /*  2450 */   327,  327,  203,
    );
    static public $yy_lookahead = array(
 /*     0 */     1,    3,    4,    5,    6,    7,    8,    9,   10,   11,
 /*    10 */    12,   13,  113,  114,   16,   91,   17,   17,   91,   16,
 /*    20 */    22,   23,   19,   20,  100,   24,   28,  100,   29,   29,
 /*    30 */    32,   33,   34,   29,   35,   35,  112,   16,   37,   40,
 /*    40 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*    50 */    51,   52,   53,    1,   82,   83,   84,   85,   86,   38,
 /*    60 */    16,   90,   18,   19,   90,   66,   67,   68,   69,   70,
 /*    70 */    71,   72,   73,   74,   75,   76,   77,  103,  104,   27,
 /*    80 */    36,   29,   16,   96,   18,   19,   16,   35,  117,   19,
 /*    90 */    20,  117,   40,   41,   42,   43,   44,   45,   46,   47,
 /*   100 */    48,   49,   50,   51,   52,   53,    4,    5,    6,    7,
 /*   110 */     8,   20,  118,   38,   38,   13,   14,   15,   66,   67,
 /*   120 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*   130 */     1,   85,   62,    1,   59,   89,   61,   61,   92,   93,
 /*   140 */    65,   16,   20,   21,   19,   17,   17,  101,  102,   17,
 /*   150 */    59,  105,  106,  107,   29,  109,   31,   29,   29,   91,
 /*   160 */    35,   29,   30,   35,   35,  119,  120,   35,  100,   40,
 /*   170 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   180 */    51,   52,   53,   61,   90,   91,   54,  113,  114,  111,
 /*   190 */    16,  113,  114,   19,  100,   66,   67,   68,   69,   70,
 /*   200 */    71,   72,   73,   74,   75,   76,   77,    1,   85,   59,
 /*   210 */     1,  117,   89,    1,   64,   92,   93,   94,    1,   17,
 /*   220 */   108,   17,   20,   17,  101,  102,   17,  115,  105,  106,
 /*   230 */   107,   29,  109,   29,   17,   29,   62,   35,   29,   35,
 /*   240 */    38,   35,   19,   31,   35,   99,   40,   41,   42,   43,
 /*   250 */    44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*   260 */     1,   16,   37,   61,   19,   20,   54,  110,    1,    2,
 /*   270 */    25,   54,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   280 */    74,   75,   76,   77,   17,   62,   90,   91,   29,    1,
 /*   290 */    65,   90,  110,   37,   35,   39,  100,   20,   21,   40,
 /*   300 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   310 */    51,   52,   53,  117,   90,   91,   96,   29,  117,  118,
 /*   320 */    84,   85,   86,   35,  100,   66,   67,   68,   69,   70,
 /*   330 */    71,   72,   73,   74,   75,   76,   77,    1,   61,   99,
 /*   340 */     1,  117,   37,   85,   39,   18,   19,   89,   10,   16,
 /*   350 */    99,   93,   19,   17,   16,   21,   17,   93,   85,    1,
 /*   360 */    22,   23,   29,  105,  106,  107,   28,  109,   35,  105,
 /*   370 */    32,   33,   34,  109,   25,   17,   40,   41,   42,   43,
 /*   380 */    44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*   390 */    63,    1,   31,   59,  121,  122,   25,    2,   64,   38,
 /*   400 */    18,   19,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   410 */    74,   75,   76,   77,   24,   20,   78,   79,   80,   91,
 /*   420 */    91,   29,   61,   93,   94,   95,   19,   35,  100,  100,
 /*   430 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*   440 */    50,   51,   52,   53,   91,  117,  117,   37,   16,   39,
 /*   450 */    79,   19,  110,  100,  112,   19,   66,   67,   68,   69,
 /*   460 */    70,   71,   72,   73,   74,   75,   76,   77,    1,   85,
 /*   470 */   117,    1,    1,   89,  108,   90,   92,   93,   94,   16,
 /*   480 */     1,  115,   19,   17,   17,  101,  102,   17,   17,  105,
 /*   490 */   106,  107,   29,  109,   31,   29,   17,   91,   35,   29,
 /*   500 */    21,   35,  117,   19,   18,   35,  100,   40,   41,   42,
 /*   510 */    43,   44,   45,   46,   47,   48,   49,   50,   51,   52,
 /*   520 */    53,    1,   16,  117,   54,   19,   16,   18,    1,   19,
 /*   530 */    97,   97,    1,   66,   67,   68,   69,   70,   71,   72,
 /*   540 */    73,   74,   75,   76,   77,  112,  112,   38,   17,   90,
 /*   550 */    93,   94,   16,   16,   26,   19,   19,   93,   94,   39,
 /*   560 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*   570 */    50,   51,   52,   53,    1,    2,  117,   17,  110,   16,
 /*   580 */   112,   54,   19,   18,   97,   25,   66,   67,   68,   69,
 /*   590 */    70,   71,   72,   73,   74,   75,   76,   77,   62,  112,
 /*   600 */    29,   19,   91,   86,   38,   88,   35,   19,   63,   55,
 /*   610 */    63,  100,   97,   40,   41,   42,   43,   44,   45,   46,
 /*   620 */    47,   48,   49,   50,   51,   52,   53,  112,   19,   65,
 /*   630 */    39,   18,    2,   36,   36,   59,   19,   18,   97,   66,
 /*   640 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   650 */    77,    1,   85,  112,    1,   18,   89,   85,   19,   92,
 /*   660 */    93,   89,   19,   38,   20,   93,   91,   17,  101,  102,
 /*   670 */    17,   97,  105,  106,  107,  100,  109,  105,  106,  107,
 /*   680 */    19,  109,   29,  116,    2,   19,  112,  112,   35,   21,
 /*   690 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*   700 */    50,   51,   52,   53,    1,    1,  100,   54,  112,  117,
 /*   710 */   111,    2,   21,  110,   98,   97,   66,   67,   68,   69,
 /*   720 */    70,   71,   72,   73,   74,   75,   76,   77,  112,   61,
 /*   730 */   112,   85,   14,  110,   87,  115,  114,  123,  123,  123,
 /*   740 */   123,  123,   97,   40,   41,   42,   43,   44,   45,   46,
 /*   750 */    47,   48,   49,   50,   51,   52,   53,  112,  123,  123,
 /*   760 */   123,  123,  123,  123,  123,  123,  123,  123,  122,   66,
 /*   770 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   780 */    77,    1,   79,   85,  123,    1,  123,   89,  123,  123,
 /*   790 */    92,   93,  123,   97,   17,  123,   97,   17,   17,  101,
 /*   800 */   102,   17,  123,  105,  106,  107,   29,  109,  112,  123,
 /*   810 */    29,  112,   35,   29,  116,  123,   35,  123,  123,   35,
 /*   820 */    40,   41,   42,   43,   44,   45,   46,   47,   48,   49,
 /*   830 */    50,   51,   52,   53,    1,  123,  123,  123,   54,  123,
 /*   840 */   123,  123,  123,  123,  123,  123,   66,   67,   68,   69,
 /*   850 */    70,   71,   72,   73,   74,   75,   76,   77,  123,  123,
 /*   860 */   123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*   870 */   123,  123,   39,   40,   41,   42,   43,   44,   45,   46,
 /*   880 */    47,   48,   49,   50,   51,   52,   53,    1,  123,  123,
 /*   890 */   123,  123,  123,  123,  123,  123,  123,  123,  123,   66,
 /*   900 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*   910 */    77,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*   920 */   123,  123,  123,  123,  123,  123,   40,   41,   42,   43,
 /*   930 */    44,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*   940 */     1,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*   950 */   123,   65,   66,   67,   68,   69,   70,   71,   72,   73,
 /*   960 */    74,   75,   76,   77,  123,  123,  123,  123,  123,   30,
 /*   970 */   123,  123,  123,  123,  123,  123,  123,  123,  123,   40,
 /*   980 */    41,   42,   43,   44,   45,   46,   47,   48,   49,   50,
 /*   990 */    51,   52,   53,    1,  123,  123,  123,  123,  123,  123,
 /*  1000 */   123,  123,  123,  123,  123,   66,   67,   68,   69,   70,
 /*  1010 */    71,   72,   73,   74,   75,   76,   77,  123,  123,  123,
 /*  1020 */   123,  123,  123,  123,  123,  123,  123,  123,  123,  123,
 /*  1030 */   123,  123,   40,   41,   42,   43,   44,   45,   46,   47,
 /*  1040 */    48,   49,   50,   51,   52,   53,  123,  123,  123,  123,
 /*  1050 */   123,  123,  123,  123,  123,  123,  123,  123,   66,   67,
 /*  1060 */    68,   69,   70,   71,   72,   73,   74,   75,   76,   77,
 /*  1070 */   123,  123,  123,   40,   41,   42,   43,   44,   45,   46,
 /*  1080 */    47,   48,   49,   50,   51,   52,   53,  123,  123,  123,
 /*  1090 */   123,  123,  123,  123,  123,  123,  123,  123,  123,   66,
 /*  1100 */    67,   68,   69,   70,   71,   72,   73,   74,   75,   76,
 /*  1110 */    77,  123,  123,  123,  123,  123,   16,  123,   18,   19,
 /*  1120 */   123,  123,   22,   23,  123,   17,  123,   85,   28,  123,
 /*  1130 */   123,   89,   32,   33,   34,   93,   36,   29,   38,  123,
 /*  1140 */   123,   41,  123,   35,  102,  123,   85,  105,  106,  107,
 /*  1150 */    89,  109,  123,   91,   93,  123,   56,   57,   58,   59,
 /*  1160 */    60,  123,  100,   63,   64,   65,  105,  106,  107,   17,
 /*  1170 */   109,  123,  123,   16,  112,   18,   19,  123,   78,   22,
 /*  1180 */    23,   29,   17,  123,  123,   28,  123,   35,  123,   32,
 /*  1190 */    33,   34,  123,   36,   29,   38,  123,  123,   41,  123,
 /*  1200 */    35,  123,   85,  123,  123,  123,   89,  123,  123,   92,
 /*  1210 */    93,  123,  123,   56,   57,   58,   59,   60,  101,  102,
 /*  1220 */    63,   64,  105,  106,  107,  123,  109,   17,  123,  123,
 /*  1230 */    16,  123,   18,   19,  123,   78,   22,   23,  123,   29,
 /*  1240 */    91,  123,   28,  123,   17,   35,   32,   33,   34,  100,
 /*  1250 */    36,  123,   38,  123,  123,   41,   29,  123,  123,   85,
 /*  1260 */   123,  112,   35,   89,  123,  123,   92,   93,  123,  123,
 /*  1270 */    56,   57,   58,   59,   60,  101,  102,   63,   64,  105,
 /*  1280 */   106,  107,  123,  109,   17,  123,  123,   16,  123,   18,
 /*  1290 */    19,  123,   78,   22,   23,  123,   29,  123,  123,   28,
 /*  1300 */   123,   17,   35,   32,   33,   34,  123,   36,  123,   38,
 /*  1310 */   123,  123,   41,   29,  123,  123,   85,  123,  123,   35,
 /*  1320 */    89,  123,  123,   92,   93,  123,  123,   56,   57,   58,
 /*  1330 */    59,   60,  101,  102,   63,   64,  105,  106,  107,  123,
 /*  1340 */   109,   17,  123,  123,   16,  123,   18,   19,  123,   78,
 /*  1350 */    22,   23,  123,   29,  123,  123,   28,  123,   17,   35,
 /*  1360 */    32,   33,   34,  123,   36,  123,   38,  123,  123,   41,
 /*  1370 */    29,  123,  123,   85,  123,  123,   35,   89,  123,  123,
 /*  1380 */    92,   93,  123,  123,   56,   57,   58,   59,   60,  101,
 /*  1390 */   102,   63,   64,  105,  106,  107,  123,  109,   17,  123,
 /*  1400 */   123,   16,  123,   18,   19,  123,   78,   22,   23,  123,
 /*  1410 */    29,  123,  123,   28,  123,   17,   35,   32,   33,   34,
 /*  1420 */   123,   36,  123,   38,  123,  123,   41,   29,  123,  123,
 /*  1430 */    85,  123,  123,   35,   89,  123,  123,   92,   93,  123,
 /*  1440 */   123,   56,   57,   58,   59,   60,  101,  102,   63,   64,
 /*  1450 */   105,  106,  107,  123,  109,   17,  123,  123,   16,  123,
 /*  1460 */    18,   19,  123,   78,   22,   23,  123,   29,  123,  123,
 /*  1470 */    28,  123,   17,   35,   32,   33,   34,  123,   36,  123,
 /*  1480 */    38,  123,  123,   41,   29,  123,  123,   85,  123,  123,
 /*  1490 */    35,   89,  123,  123,   92,   93,  123,  123,   56,   57,
 /*  1500 */    58,   59,   60,  101,  102,   63,   64,  105,  106,  107,
 /*  1510 */   123,  109,   17,  123,  123,   16,  123,   18,   19,  123,
 /*  1520 */    78,   22,   23,  123,   29,  123,  123,   28,  123,   17,
 /*  1530 */    35,   32,   33,   34,  123,   36,  123,   38,  123,  123,
 /*  1540 */    41,   29,  123,  123,   85,  123,  123,   35,   89,  123,
 /*  1550 */   123,   92,   93,  123,  123,   56,   57,   58,   59,   60,
 /*  1560 */   101,  102,   63,   64,  105,  106,  107,  123,  109,  123,
 /*  1570 */   123,  123,   16,  123,   18,   19,  123,   78,   22,   23,
 /*  1580 */   123,  123,  123,  123,   28,  123,  123,  123,   32,   33,
 /*  1590 */    34,  123,   36,  123,   38,  123,  123,   41,  123,  123,
 /*  1600 */   123,   85,  123,  123,  123,   89,  123,  123,   92,   93,
 /*  1610 */   123,  123,   56,   57,   58,   59,   60,  101,  102,   63,
 /*  1620 */    64,  105,  106,  107,  123,  109,  123,  123,  123,   16,
 /*  1630 */   123,   18,   19,  123,   78,   22,   23,  123,  123,  123,
 /*  1640 */   123,   28,  123,  123,  123,   32,   33,   34,  123,   36,
 /*  1650 */   123,   38,  123,  123,   41,  123,  123,  123,   85,  123,
 /*  1660 */   123,  123,   89,  123,  123,   92,   93,  123,  123,   56,
 /*  1670 */    57,   58,   59,   60,  101,  102,   63,  123,  105,  106,
 /*  1680 */   107,  123,  109,  123,  123,  123,   16,  123,   18,   19,
 /*  1690 */   123,   78,   22,   23,  123,  123,  123,  123,   28,  123,
 /*  1700 */   123,  123,   32,   33,   34,  123,   36,  123,   38,  123,
 /*  1710 */   123,   41,  123,  123,  123,   85,  123,  123,  123,   89,
 /*  1720 */   123,  123,   92,   93,  123,  123,   56,   57,   58,   59,
 /*  1730 */    60,  101,  102,   63,  123,  105,  106,  107,  123,  109,
 /*  1740 */   123,  123,  123,  123,   17,  123,  116,  123,   78,  123,
 /*  1750 */   123,   24,  123,   26,   27,   10,   29,   30,  123,  123,
 /*  1760 */   123,   16,   35,  123,   37,   38,   39,   22,   23,  123,
 /*  1770 */    90,   91,  123,   28,  123,  123,  123,   32,   33,   34,
 /*  1780 */   100,   54,  123,  103,  104,  123,  123,  123,   61,  123,
 /*  1790 */   123,  123,   65,  123,   85,   90,   91,  117,   89,  123,
 /*  1800 */   123,   92,   93,  123,  123,  100,   79,  123,  103,  104,
 /*  1810 */   101,  102,  123,   85,  105,  106,  107,   89,  109,  123,
 /*  1820 */   123,   93,  117,   78,   79,   80,  123,  123,  123,  120,
 /*  1830 */   102,  123,   85,  105,  106,  107,   89,  109,  123,   92,
 /*  1840 */    93,  123,    1,   85,  123,  123,  123,   89,  101,  102,
 /*  1850 */    92,   93,  105,  106,  107,  123,  109,  123,   17,  101,
 /*  1860 */   102,  123,   21,  105,  106,  107,  123,  109,  123,  123,
 /*  1870 */    29,  123,  123,  123,   85,  123,   35,  123,   89,   38,
 /*  1880 */   123,   92,   93,  123,  123,  123,  123,  123,  123,  123,
 /*  1890 */   101,  102,  123,  123,  105,  106,  107,   85,  109,  123,
 /*  1900 */   123,   89,   61,   85,   92,   93,  123,   89,  123,  123,
 /*  1910 */   123,   93,  123,  101,  102,  123,  123,  105,  106,  107,
 /*  1920 */   123,  109,   85,  105,  106,  107,   89,  109,  123,   92,
 /*  1930 */    93,  123,  123,   85,  123,  123,  123,   89,  101,  102,
 /*  1940 */    92,   93,  105,  106,  107,  123,  109,  123,  123,  101,
 /*  1950 */   102,  123,  123,  105,  106,  107,  123,  109,  123,  123,
 /*  1960 */    85,   90,   91,  123,   89,  123,  123,   92,   93,  123,
 /*  1970 */   123,  100,  123,  123,  103,  104,  101,  102,  123,  123,
 /*  1980 */   105,  106,  107,   85,  109,  123,  123,   89,  117,   85,
 /*  1990 */    92,   93,  123,   89,  123,  123,  123,   93,  123,  101,
 /*  2000 */   102,  123,  123,  105,  106,  107,  123,  109,   85,  105,
 /*  2010 */   106,  107,   89,  109,  123,   92,   93,  123,  123,   85,
 /*  2020 */   123,  123,  123,   89,  101,  102,   92,   93,  105,  106,
 /*  2030 */   107,  123,  109,  123,  123,  101,  102,  123,  123,  105,
 /*  2040 */   106,  107,  123,  109,  123,  123,   85,  123,  123,  123,
 /*  2050 */    89,  123,  123,   92,   93,  123,  123,  123,  123,  123,
 /*  2060 */   123,  123,  101,  102,  123,  123,  105,  106,  107,   85,
 /*  2070 */   109,  123,  123,   89,  123,   85,   92,   93,  123,   89,
 /*  2080 */   123,  123,  123,   93,  123,  101,  102,  123,  123,  105,
 /*  2090 */   106,  107,  123,  109,   85,  105,  106,  107,   89,  109,
 /*  2100 */   123,   92,   93,  123,  123,   85,  123,  123,  123,   89,
 /*  2110 */   101,  102,   92,   93,  105,  106,  107,  123,  109,  123,
 /*  2120 */   123,  101,  102,  123,  123,  105,  106,  107,  123,  109,
 /*  2130 */   123,  123,   85,  123,  123,  123,   89,  123,  123,   92,
 /*  2140 */    93,  123,  123,  123,  123,  123,  123,  123,  101,  102,
 /*  2150 */   123,  123,  105,  106,  107,   85,  109,  123,  123,   89,
 /*  2160 */   123,   85,   92,   93,  123,   89,  123,  123,  123,   93,
 /*  2170 */   123,  101,  102,  123,  123,  105,  106,  107,  123,  109,
 /*  2180 */    85,  105,  106,  107,   89,  109,  123,   92,   93,  123,
 /*  2190 */   123,   85,  123,  123,  123,   89,  101,  102,   92,   93,
 /*  2200 */   105,  106,  107,  123,  109,  123,  123,  101,  102,  123,
 /*  2210 */   123,  105,  106,  107,  123,  109,  123,  123,   85,  123,
 /*  2220 */   123,  123,   89,  123,  123,   92,   93,  123,  123,  123,
 /*  2230 */   123,  123,  123,  123,  101,  102,  123,  123,  105,  106,
 /*  2240 */   107,   85,  109,  123,  123,   89,  123,  123,   92,   93,
 /*  2250 */   123,  123,  123,  123,  123,  123,  123,  101,  102,  123,
 /*  2260 */   123,  105,  106,  107,  123,  109,   85,  123,  123,  123,
 /*  2270 */    89,  123,  123,   92,   93,  123,  123,   85,  123,  123,
 /*  2280 */   123,   89,  101,  102,   92,   93,  105,  106,  107,  123,
 /*  2290 */   109,  123,  123,  101,  102,  123,  123,  105,  106,  107,
 /*  2300 */   123,  109,  123,  123,   85,  123,  123,  123,   89,  123,
 /*  2310 */   123,   92,   93,  123,  123,  123,  123,  123,  123,  123,
 /*  2320 */   101,  102,  123,  123,  105,  106,  107,   85,  109,  123,
 /*  2330 */   123,   89,  123,  123,   92,   93,  123,  123,  123,  123,
 /*  2340 */   123,  123,  123,  101,  102,  123,  123,  105,  106,  107,
 /*  2350 */   123,  109,   85,  123,  123,  123,   89,  123,  123,   92,
 /*  2360 */    93,  123,  123,   85,  123,  123,  123,   89,  101,  102,
 /*  2370 */    92,   93,  105,  106,  107,  123,  109,  123,  123,  101,
 /*  2380 */   102,  123,  123,  105,  106,  107,  123,  109,  123,  123,
 /*  2390 */    85,  123,  123,  123,   89,  123,  123,   92,   93,  123,
 /*  2400 */   123,  123,  123,   90,   91,  123,  101,  102,  123,  123,
 /*  2410 */   105,  106,  107,  100,  109,  123,  103,  104,   90,   91,
 /*  2420 */   123,  123,  123,  123,  123,   90,   91,  123,  100,  123,
 /*  2430 */   117,  103,  104,  123,  123,  100,  123,  123,  103,  104,
 /*  2440 */   123,  123,  123,  123,  123,  117,  123,  123,  123,  123,
 /*  2450 */   123,  123,  117,
);
    const YY_SHIFT_USE_DFLT = -3;
    const YY_SHIFT_MAX = 252;
    static public $yy_shift_ofst = array(
 /*     0 */    -2, 1385, 1385, 1328, 1157, 1328, 1157, 1157, 1100, 1157,
 /*    10 */  1157, 1157, 1157, 1157, 1157, 1556, 1157, 1157, 1157, 1157,
 /*    20 */  1556, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157, 1157,
 /*    30 */  1157, 1157, 1442, 1157, 1157, 1499, 1157, 1157, 1214, 1157,
 /*    40 */  1157, 1157, 1157, 1442, 1271, 1271, 1670, 1613, 1670, 1670,
 /*    50 */  1670, 1670, 1670,  206,  129,   52,   -1,  259,  259,  259,
 /*    60 */   833,  886,  939,  780,  650,  390,  336,  467,  703,  520,
 /*    70 */   573,  992,  992,  992,  992,  992,  992,  992,  992,  992,
 /*    80 */   992,  992,  992,  992,  992,  992,  992,  992,  992,  992,
 /*    90 */  1033, 1033, 1841,  784,  288,   -2,  338,  125,  463,  209,
 /*   100 */   333,  209,  333,  327,  288,  267,  288,  334,  509, 1745,
 /*   110 */   102,  132,  470,  653,   70,  245,  479,  212,  204,    3,
 /*   120 */   174,  217,  277,  122,  432,  537,  432,  509,  510,  432,
 /*   130 */   432,  382,  668,  506,  432,  432,  531,  563,  432,  382,
 /*   140 */   527,  432,  510,  509,  571,  432,  392,  691,  704,  704,
 /*   150 */   704,  704,  704,  704,  704,  691,  704,   -3, 1341, 1381,
 /*   160 */  1284, 1267,   66, 1108, 1152, 1165, 1210,  536, 1438, 1398,
 /*   170 */  1495, 1512,  466,  777,    0,  128,  781, 1324, 1455, 1227,
 /*   180 */   471,  358,  150,  150,  339,  150,  150,   21,  150,  718,
 /*   190 */   691,  691,  625,  704,  704,  709,  691,  709,    4,    4,
 /*   200 */    -3,   -3,   -3,   -3,   -3, 1727,  202,   75,   44,  361,
 /*   210 */   223,    1,  225,   91,   76,  371,  395,  410,   76,  256,
 /*   220 */   305,  560,  625,  617,  619,  598,  597,  576,  349,  630,
 /*   230 */   637,  639,  666,  682,  661,  643,  644,  613,  591,  528,
 /*   240 */   565,  486,  484,  407,  436,  582,  566,  564,  609,  547,
 /*   250 */   554,  588,  545,
);
    const YY_REDUCE_USE_DFLT = -102;
    const YY_REDUCE_MAX = 204;
    static public $yy_reduce_ofst = array(
 /*     0 */   -28,   46, 1709,  123,  567,  384, 1630,  698, 1961, 1934,
 /*    10 */  1923, 1875, 1898, 1984, 2009, 2106, 2095, 2070, 2020, 2047,
 /*    20 */  1848, 1837, 1402, 1345, 1288, 1174, 1231, 1459, 1516, 1812,
 /*    30 */  1789, 1758, 1573, 1747, 2156, 2133, 2305, 2267, 2181, 2192,
 /*    40 */  1117, 2219, 2242, 2278, 1042, 1728,  258, 1061,  572, 2076,
 /*    50 */  1990, 1904, 1818, 1680, 1871, 1705, 2313, 2335, 2328, 1680,
 /*    60 */   -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,
 /*    70 */   -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,
 /*    80 */   -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,  -26,
 /*    90 */   -26,  -26,  224,   94,  196,  236,  273, 1149, 1062,  406,
 /*   100 */   -76,  353,  575,  264,  328,  201,  329,   78,  330,  646,
 /*   110 */   517,  -29,  -29,  -29,  342,  616,  385,  -29,   68,  342,
 /*   120 */   342,  -29,   74,   74,  618,  433,  574,  457,  515,  541,
 /*   130 */   433,  112,   74,  433,  434,  487,  459,  699,  468,  366,
 /*   140 */   -29,  696,  433,  464,  511,  645,  -73, -101,  -29,  -29,
 /*   150 */   -29,  -29,  -29,  -29,  -29,   74,  -29,  -29,  606,  606,
 /*   160 */   606,  606,  620,  606,  606,  606,  606,  596,  606,  606,
 /*   170 */   606,  606,  606,  606,  606,  606,  606,  606,  606,  606,
 /*   180 */   592,  592,  599,  599,  592,  599,  599,  603,  599,  647,
 /*   190 */   622,  622,  623,  592,  592,   -6,  622,   -6,  -13,  220,
 /*   200 */   251,  240,  182,  146,  157,
);
    static public $yyExpectedTokens = array(
        /* 0 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 22, 23, 28, 32, 33, 34, ),
        /* 1 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 2 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 3 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 4 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 5 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 6 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 7 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 8 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 65, 78, ),
        /* 9 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 10 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 11 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 12 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 13 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 14 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 15 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 16 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 17 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 18 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 19 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 20 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 21 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 22 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 23 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 24 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 25 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 26 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 27 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 28 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 29 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 30 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 31 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 32 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 33 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 34 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 35 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 36 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 37 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 38 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 39 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 40 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 41 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 42 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 43 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 44 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 45 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 64, 78, ),
        /* 46 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 47 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 48 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 49 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 50 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 51 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 52 */ array(16, 18, 19, 22, 23, 28, 32, 33, 34, 36, 38, 41, 56, 57, 58, 59, 60, 63, 78, ),
        /* 53 */ array(1, 17, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 54 */ array(1, 17, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 55 */ array(1, 27, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 56 */ array(1, 17, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 57 */ array(1, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 58 */ array(1, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 59 */ array(1, 29, 35, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 60 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 61 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 62 */ array(1, 30, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 63 */ array(1, 17, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 64 */ array(1, 17, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 65 */ array(1, 24, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 66 */ array(1, 17, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 67 */ array(1, 17, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 68 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 79, ),
        /* 69 */ array(1, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 70 */ array(1, 2, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 71 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 72 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 73 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 74 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 75 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 76 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 77 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 78 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 79 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 80 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 81 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 82 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 83 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 84 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 85 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 86 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 87 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 88 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 89 */ array(1, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 90 */ array(40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 91 */ array(40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, ),
        /* 92 */ array(1, 17, 21, 29, 35, 38, 61, ),
        /* 93 */ array(1, 17, 29, 35, 54, ),
        /* 94 */ array(1, 29, 35, ),
        /* 95 */ array(3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 16, 22, 23, 28, 32, 33, 34, ),
        /* 96 */ array(10, 16, 22, 23, 28, 32, 33, 34, 78, 79, 80, ),
        /* 97 */ array(16, 19, 29, 31, 35, ),
        /* 98 */ array(16, 19, 29, 31, 35, ),
        /* 99 */ array(1, 17, 29, 35, ),
        /* 100 */ array(16, 19, 29, 35, ),
        /* 101 */ array(1, 17, 29, 35, ),
        /* 102 */ array(16, 19, 29, 35, ),
        /* 103 */ array(18, 19, 63, ),
        /* 104 */ array(1, 29, 35, ),
        /* 105 */ array(1, 2, 17, ),
        /* 106 */ array(1, 29, 35, ),
        /* 107 */ array(21, 59, 64, ),
        /* 108 */ array(18, 38, ),
        /* 109 */ array(10, 16, 22, 23, 28, 32, 33, 34, 78, 79, 80, ),
        /* 110 */ array(4, 5, 6, 7, 8, 13, 14, 15, ),
        /* 111 */ array(1, 17, 29, 30, 35, 54, ),
        /* 112 */ array(1, 17, 29, 35, 54, ),
        /* 113 */ array(1, 17, 29, 35, 54, ),
        /* 114 */ array(16, 19, 20, 62, ),
        /* 115 */ array(16, 19, 20, 25, ),
        /* 116 */ array(1, 17, 21, ),
        /* 117 */ array(1, 31, 54, ),
        /* 118 */ array(17, 29, 35, ),
        /* 119 */ array(16, 19, 20, ),
        /* 120 */ array(16, 19, 62, ),
        /* 121 */ array(1, 17, 54, ),
        /* 122 */ array(20, 21, 61, ),
        /* 123 */ array(20, 21, 61, ),
        /* 124 */ array(16, 19, ),
        /* 125 */ array(16, 19, ),
        /* 126 */ array(16, 19, ),
        /* 127 */ array(18, 38, ),
        /* 128 */ array(16, 19, ),
        /* 129 */ array(16, 19, ),
        /* 130 */ array(16, 19, ),
        /* 131 */ array(18, 19, ),
        /* 132 */ array(21, 61, ),
        /* 133 */ array(16, 19, ),
        /* 134 */ array(16, 19, ),
        /* 135 */ array(16, 19, ),
        /* 136 */ array(1, 17, ),
        /* 137 */ array(16, 19, ),
        /* 138 */ array(16, 19, ),
        /* 139 */ array(18, 19, ),
        /* 140 */ array(1, 54, ),
        /* 141 */ array(16, 19, ),
        /* 142 */ array(16, 19, ),
        /* 143 */ array(18, 38, ),
        /* 144 */ array(29, 35, ),
        /* 145 */ array(16, 19, ),
        /* 146 */ array(29, 35, ),
        /* 147 */ array(21, ),
        /* 148 */ array(1, ),
        /* 149 */ array(1, ),
        /* 150 */ array(1, ),
        /* 151 */ array(1, ),
        /* 152 */ array(1, ),
        /* 153 */ array(1, ),
        /* 154 */ array(1, ),
        /* 155 */ array(21, ),
        /* 156 */ array(1, ),
        /* 157 */ array(),
        /* 158 */ array(17, 29, 35, ),
        /* 159 */ array(17, 29, 35, ),
        /* 160 */ array(17, 29, 35, ),
        /* 161 */ array(17, 29, 35, ),
        /* 162 */ array(16, 18, 19, ),
        /* 163 */ array(17, 29, 35, ),
        /* 164 */ array(17, 29, 35, ),
        /* 165 */ array(17, 29, 35, ),
        /* 166 */ array(17, 29, 35, ),
        /* 167 */ array(16, 19, 62, ),
        /* 168 */ array(17, 29, 35, ),
        /* 169 */ array(17, 29, 35, ),
        /* 170 */ array(17, 29, 35, ),
        /* 171 */ array(17, 29, 35, ),
        /* 172 */ array(17, 29, 35, ),
        /* 173 */ array(17, 29, 35, ),
        /* 174 */ array(17, 29, 35, ),
        /* 175 */ array(17, 29, 35, ),
        /* 176 */ array(17, 29, 35, ),
        /* 177 */ array(17, 29, 35, ),
        /* 178 */ array(17, 29, 35, ),
        /* 179 */ array(17, 29, 35, ),
        /* 180 */ array(1, 17, ),
        /* 181 */ array(1, 17, ),
        /* 182 */ array(59, 64, ),
        /* 183 */ array(59, 64, ),
        /* 184 */ array(1, 17, ),
        /* 185 */ array(59, 64, ),
        /* 186 */ array(59, 64, ),
        /* 187 */ array(16, 38, ),
        /* 188 */ array(59, 64, ),
        /* 189 */ array(14, ),
        /* 190 */ array(21, ),
        /* 191 */ array(21, ),
        /* 192 */ array(38, ),
        /* 193 */ array(1, ),
        /* 194 */ array(1, ),
        /* 195 */ array(2, ),
        /* 196 */ array(21, ),
        /* 197 */ array(2, ),
        /* 198 */ array(29, ),
        /* 199 */ array(29, ),
        /* 200 */ array(),
        /* 201 */ array(),
        /* 202 */ array(),
        /* 203 */ array(),
        /* 204 */ array(),
        /* 205 */ array(17, 24, 26, 27, 29, 30, 35, 37, 38, 39, 54, 61, 65, 79, ),
        /* 206 */ array(17, 20, 29, 35, 38, 61, ),
        /* 207 */ array(38, 59, 61, 65, ),
        /* 208 */ array(16, 18, 19, 36, ),
        /* 209 */ array(31, 38, 61, ),
        /* 210 */ array(19, 62, ),
        /* 211 */ array(24, 37, ),
        /* 212 */ array(37, 65, ),
        /* 213 */ array(20, 59, ),
        /* 214 */ array(38, 61, ),
        /* 215 */ array(25, 79, ),
        /* 216 */ array(2, 20, ),
        /* 217 */ array(37, 39, ),
        /* 218 */ array(38, 61, ),
        /* 219 */ array(37, 39, ),
        /* 220 */ array(37, 39, ),
        /* 221 */ array(17, 25, ),
        /* 222 */ array(38, ),
        /* 223 */ array(19, ),
        /* 224 */ array(18, ),
        /* 225 */ array(36, ),
        /* 226 */ array(36, ),
        /* 227 */ array(59, ),
        /* 228 */ array(25, ),
        /* 229 */ array(2, ),
        /* 230 */ array(18, ),
        /* 231 */ array(19, ),
        /* 232 */ array(19, ),
        /* 233 */ array(2, ),
        /* 234 */ array(19, ),
        /* 235 */ array(19, ),
        /* 236 */ array(20, ),
        /* 237 */ array(18, ),
        /* 238 */ array(39, ),
        /* 239 */ array(26, ),
        /* 240 */ array(18, ),
        /* 241 */ array(18, ),
        /* 242 */ array(19, ),
        /* 243 */ array(19, ),
        /* 244 */ array(19, ),
        /* 245 */ array(19, ),
        /* 246 */ array(38, ),
        /* 247 */ array(65, ),
        /* 248 */ array(19, ),
        /* 249 */ array(63, ),
        /* 250 */ array(55, ),
        /* 251 */ array(19, ),
        /* 252 */ array(63, ),
        /* 253 */ array(),
        /* 254 */ array(),
        /* 255 */ array(),
        /* 256 */ array(),
        /* 257 */ array(),
        /* 258 */ array(),
        /* 259 */ array(),
        /* 260 */ array(),
        /* 261 */ array(),
        /* 262 */ array(),
        /* 263 */ array(),
        /* 264 */ array(),
        /* 265 */ array(),
        /* 266 */ array(),
        /* 267 */ array(),
        /* 268 */ array(),
        /* 269 */ array(),
        /* 270 */ array(),
        /* 271 */ array(),
        /* 272 */ array(),
        /* 273 */ array(),
        /* 274 */ array(),
        /* 275 */ array(),
        /* 276 */ array(),
        /* 277 */ array(),
        /* 278 */ array(),
        /* 279 */ array(),
        /* 280 */ array(),
        /* 281 */ array(),
        /* 282 */ array(),
        /* 283 */ array(),
        /* 284 */ array(),
        /* 285 */ array(),
        /* 286 */ array(),
        /* 287 */ array(),
        /* 288 */ array(),
        /* 289 */ array(),
        /* 290 */ array(),
        /* 291 */ array(),
        /* 292 */ array(),
        /* 293 */ array(),
        /* 294 */ array(),
        /* 295 */ array(),
        /* 296 */ array(),
        /* 297 */ array(),
        /* 298 */ array(),
        /* 299 */ array(),
        /* 300 */ array(),
        /* 301 */ array(),
        /* 302 */ array(),
        /* 303 */ array(),
        /* 304 */ array(),
        /* 305 */ array(),
        /* 306 */ array(),
        /* 307 */ array(),
        /* 308 */ array(),
        /* 309 */ array(),
        /* 310 */ array(),
        /* 311 */ array(),
        /* 312 */ array(),
        /* 313 */ array(),
        /* 314 */ array(),
        /* 315 */ array(),
        /* 316 */ array(),
        /* 317 */ array(),
        /* 318 */ array(),
        /* 319 */ array(),
        /* 320 */ array(),
        /* 321 */ array(),
        /* 322 */ array(),
        /* 323 */ array(),
        /* 324 */ array(),
        /* 325 */ array(),
        /* 326 */ array(),
        /* 327 */ array(),
        /* 328 */ array(),
        /* 329 */ array(),
        /* 330 */ array(),
        /* 331 */ array(),
        /* 332 */ array(),
        /* 333 */ array(),
        /* 334 */ array(),
        /* 335 */ array(),
        /* 336 */ array(),
        /* 337 */ array(),
        /* 338 */ array(),
        /* 339 */ array(),
        /* 340 */ array(),
        /* 341 */ array(),
        /* 342 */ array(),
        /* 343 */ array(),
        /* 344 */ array(),
        /* 345 */ array(),
        /* 346 */ array(),
        /* 347 */ array(),
        /* 348 */ array(),
        /* 349 */ array(),
        /* 350 */ array(),
        /* 351 */ array(),
        /* 352 */ array(),
        /* 353 */ array(),
        /* 354 */ array(),
        /* 355 */ array(),
        /* 356 */ array(),
        /* 357 */ array(),
        /* 358 */ array(),
        /* 359 */ array(),
        /* 360 */ array(),
        /* 361 */ array(),
        /* 362 */ array(),
        /* 363 */ array(),
        /* 364 */ array(),
        /* 365 */ array(),
        /* 366 */ array(),
        /* 367 */ array(),
        /* 368 */ array(),
        /* 369 */ array(),
        /* 370 */ array(),
        /* 371 */ array(),
        /* 372 */ array(),
        /* 373 */ array(),
        /* 374 */ array(),
        /* 375 */ array(),
        /* 376 */ array(),
        /* 377 */ array(),
        /* 378 */ array(),
        /* 379 */ array(),
        /* 380 */ array(),
        /* 381 */ array(),
        /* 382 */ array(),
        /* 383 */ array(),
        /* 384 */ array(),
        /* 385 */ array(),
        /* 386 */ array(),
        /* 387 */ array(),
        /* 388 */ array(),
);
    static public $yy_default = array(
 /*     0 */   392,  574,  591,  591,  545,  591,  545,  545,  591,  591,
 /*    10 */   591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
 /*    20 */   591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
 /*    30 */   591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
 /*    40 */   591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
 /*    50 */   591,  591,  591,  591,  591,  453,  591,  453,  453,  453,
 /*    60 */   591,  591,  458,  591,  591,  591,  591,  591,  591,  591,
 /*    70 */   591,  544,  575,  458,  576,  460,  463,  464,  435,  477,
 /*    80 */   478,  479,  486,  487,  577,  483,  482,  543,  455,  474,
 /*    90 */   490,  491,  502,  466,  453,  389,  591,  453,  453,  473,
 /*   100 */   453,  510,  453,  591,  453,  591,  453,  557,  591,  591,
 /*   110 */   591,  466,  466,  466,  518,  591,  591,  466,  591,  518,
 /*   120 */   518,  466,  511,  511,  591,  591,  591,  591,  591,  591,
 /*   130 */   591,  591,  511,  591,  591,  591,  591,  591,  518,  591,
 /*   140 */   466,  591,  591,  591,  453,  591,  453,  554,  494,  469,
 /*   150 */   489,  476,  495,  470,  493,  511,  471,  552,  591,  591,
 /*   160 */   591,  591,  591,  591,  591,  591,  591,  519,  591,  591,
 /*   170 */   591,  591,  591,  591,  591,  591,  591,  591,  591,  591,
 /*   180 */   591,  591,  536,  535,  591,  538,  516,  518,  537,  408,
 /*   190 */   558,  555,  518,  473,  510,  547,  532,  546,  590,  590,
 /*   200 */   551,  551,  518,  551,  518,  468,  502,  502,  591,  502,
 /*   210 */   591,  591,  591,  498,  488,  492,  530,  591,  502,  591,
 /*   220 */   591,  492,  530,  591,  591,  591,  500,  498,  492,  530,
 /*   230 */   591,  591,  591,  530,  591,  591,  591,  591,  591,  461,
 /*   240 */   591,  591,  591,  591,  591,  591,  556,  591,  591,  591,
 /*   250 */   504,  591,  591,  465,  515,  514,  539,  572,  433,  418,
 /*   260 */   390,  432,  438,  573,  437,  526,  436,  541,  540,  523,
 /*   270 */   553,  531,  542,  442,  504,  443,  571,  589,  524,  454,
 /*   280 */   527,  525,  462,  485,  530,  529,  444,  445,  550,  441,
 /*   290 */   440,  431,  430,  434,  452,  439,  446,  447,  499,  497,
 /*   300 */   501,  507,  467,  496,  450,  448,  548,  549,  449,  451,
 /*   310 */   417,  399,  398,  400,  401,  402,  397,  396,  391,  393,
 /*   320 */   394,  395,  403,  404,  413,  412,  414,  415,  416,  411,
 /*   330 */   410,  405,  406,  407,  409,  468,  512,  423,  422,  424,
 /*   340 */   533,  425,  421,  586,  570,  569,  472,  419,  420,  426,
 /*   350 */   427,  582,  583,  584,  587,  588,  580,  579,  429,  428,
 /*   360 */   585,  578,  568,  567,  506,  505,  508,  475,  509,  503,
 /*   370 */   522,  517,  520,  528,  521,  513,  534,  563,  562,  564,
 /*   380 */   565,  566,  561,  560,  480,  481,  484,  559,  581,
);
    const YYNOCODE = 124;
    const YYSTACKDEPTH = 100;
    const YYNSTATE = 389;
    const YYNRULE = 202;
    const YYERRORSYMBOL = 81;
    const YYERRSYMDT = 'yy0';
    const YYFALLBACK = 0;
    static public $yyFallback = array(
    );
    static function Trace($TraceFILE, $zTracePrompt)
    {
        if (!$TraceFILE) {
            $zTracePrompt = 0;
        } elseif (!$zTracePrompt) {
            $TraceFILE = 0;
        }
        self::$yyTraceFILE = $TraceFILE;
        self::$yyTracePrompt = $zTracePrompt;
    }

    static function PrintTrace()
    {
        self::$yyTraceFILE = fopen('php://output', 'w');
        self::$yyTracePrompt = '<br>';
    }

    static public $yyTraceFILE;
    static public $yyTracePrompt;
    public $yyidx;                    /* Index of top element in stack */
    public $yyerrcnt;                 /* Shifts left before out of the error */
    public $yystack = array();  /* The parser's stack */

    public $yyTokenName = array(
  '$',             'VERT',          'COLON',         'COMMENT',
  'PHPSTARTTAG',   'PHPENDTAG',     'ASPSTARTTAG',   'ASPENDTAG',
  'FAKEPHPSTARTTAG',  'XMLTAG',        'TEXT',          'STRIPON',
  'STRIPOFF',      'LITERALSTART',  'LITERALEND',    'LITERAL',
  'LDEL',          'RDEL',          'DOLLAR',        'ID',
  'EQUAL',         'PTR',           'LDELIF',        'LDELFOR',
  'SEMICOLON',     'INCDEC',        'TO',            'STEP',
  'LDELFOREACH',   'SPACE',         'AS',            'APTR',
  'LDELSETFILTER',  'SMARTYBLOCKCHILD',  'LDELSLASH',     'ATTR',
  'INTEGER',       'COMMA',         'OPENP',         'CLOSEP',
  'MATH',          'UNIMATH',       'ANDSYM',        'ISIN',
  'ISDIVBY',       'ISNOTDIVBY',    'ISEVEN',        'ISNOTEVEN',
  'ISEVENBY',      'ISNOTEVENBY',   'ISODD',         'ISNOTODD',
  'ISODDBY',       'ISNOTODDBY',    'INSTANCEOF',    'QMARK',
  'NOT',           'TYPECAST',      'HEX',           'DOT',
  'SINGLEQUOTESTRING',  'DOUBLECOLON',   'AT',            'HATCH',
  'OPENB',         'CLOSEB',        'EQUALS',        'NOTEQUALS',
  'GREATERTHAN',   'LESSTHAN',      'GREATEREQUAL',  'LESSEQUAL',
  'IDENTITY',      'NONEIDENTITY',  'MOD',           'LAND',
  'LOR',           'LXOR',          'QUOTE',         'BACKTICK',
  'DOLLARID',      'error',         'start',         'template',
  'template_element',  'smartytag',     'literal',       'literal_elements',
  'literal_element',  'value',         'modifierlist',  'attributes',
  'expr',          'varindexed',    'statement',     'statements',
  'optspace',      'varvar',        'foraction',     'modparameters',
  'attribute',     'ternary',       'array',         'ifcond',
  'lop',           'variable',      'function',      'doublequoted_with_quotes',
  'static_class_access',  'object',        'arrayindex',    'indexdef',
  'varvarele',     'objectchain',   'objectelement',  'method',
  'params',        'modifier',      'modparameter',  'arrayelements',
  'arrayelement',  'doublequoted',  'doublequotedcontent',
    );

    static public $yyRuleName = array(
 /*   0 */ "start ::= template",
 /*   1 */ "template ::= template_element",
 /*   2 */ "template ::= template template_element",
 /*   3 */ "template ::=",
 /*   4 */ "template_element ::= smartytag",
 /*   5 */ "template_element ::= COMMENT",
 /*   6 */ "template_element ::= literal",
 /*   7 */ "template_element ::= PHPSTARTTAG",
 /*   8 */ "template_element ::= PHPENDTAG",
 /*   9 */ "template_element ::= ASPSTARTTAG",
 /*  10 */ "template_element ::= ASPENDTAG",
 /*  11 */ "template_element ::= FAKEPHPSTARTTAG",
 /*  12 */ "template_element ::= XMLTAG",
 /*  13 */ "template_element ::= TEXT",
 /*  14 */ "template_element ::= STRIPON",
 /*  15 */ "template_element ::= STRIPOFF",
 /*  16 */ "literal ::= LITERALSTART LITERALEND",
 /*  17 */ "literal ::= LITERALSTART literal_elements LITERALEND",
 /*  18 */ "literal_elements ::= literal_elements literal_element",
 /*  19 */ "literal_elements ::=",
 /*  20 */ "literal_element ::= literal",
 /*  21 */ "literal_element ::= LITERAL",
 /*  22 */ "literal_element ::= PHPSTARTTAG",
 /*  23 */ "literal_element ::= FAKEPHPSTARTTAG",
 /*  24 */ "literal_element ::= PHPENDTAG",
 /*  25 */ "literal_element ::= ASPSTARTTAG",
 /*  26 */ "literal_element ::= ASPENDTAG",
 /*  27 */ "smartytag ::= LDEL value RDEL",
 /*  28 */ "smartytag ::= LDEL value modifierlist attributes RDEL",
 /*  29 */ "smartytag ::= LDEL value attributes RDEL",
 /*  30 */ "smartytag ::= LDEL expr modifierlist attributes RDEL",
 /*  31 */ "smartytag ::= LDEL expr attributes RDEL",
 /*  32 */ "smartytag ::= LDEL DOLLAR ID EQUAL value RDEL",
 /*  33 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr RDEL",
 /*  34 */ "smartytag ::= LDEL DOLLAR ID EQUAL expr attributes RDEL",
 /*  35 */ "smartytag ::= LDEL varindexed EQUAL expr attributes RDEL",
 /*  36 */ "smartytag ::= LDEL ID attributes RDEL",
 /*  37 */ "smartytag ::= LDEL ID RDEL",
 /*  38 */ "smartytag ::= LDEL ID PTR ID attributes RDEL",
 /*  39 */ "smartytag ::= LDEL ID modifierlist attributes RDEL",
 /*  40 */ "smartytag ::= LDEL ID PTR ID modifierlist attributes RDEL",
 /*  41 */ "smartytag ::= LDELIF expr RDEL",
 /*  42 */ "smartytag ::= LDELIF expr attributes RDEL",
 /*  43 */ "smartytag ::= LDELIF statement RDEL",
 /*  44 */ "smartytag ::= LDELIF statement attributes RDEL",
 /*  45 */ "smartytag ::= LDELFOR statements SEMICOLON optspace expr SEMICOLON optspace DOLLAR varvar foraction attributes RDEL",
 /*  46 */ "foraction ::= EQUAL expr",
 /*  47 */ "foraction ::= INCDEC",
 /*  48 */ "smartytag ::= LDELFOR statement TO expr attributes RDEL",
 /*  49 */ "smartytag ::= LDELFOR statement TO expr STEP expr attributes RDEL",
 /*  50 */ "smartytag ::= LDELFOREACH attributes RDEL",
 /*  51 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar attributes RDEL",
 /*  52 */ "smartytag ::= LDELFOREACH SPACE value AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  53 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar attributes RDEL",
 /*  54 */ "smartytag ::= LDELFOREACH SPACE expr AS DOLLAR varvar APTR DOLLAR varvar attributes RDEL",
 /*  55 */ "smartytag ::= LDELSETFILTER ID modparameters RDEL",
 /*  56 */ "smartytag ::= LDELSETFILTER ID modparameters modifierlist RDEL",
 /*  57 */ "smartytag ::= SMARTYBLOCKCHILD",
 /*  58 */ "smartytag ::= LDELSLASH ID RDEL",
 /*  59 */ "smartytag ::= LDELSLASH ID modifierlist RDEL",
 /*  60 */ "smartytag ::= LDELSLASH ID PTR ID RDEL",
 /*  61 */ "smartytag ::= LDELSLASH ID PTR ID modifierlist RDEL",
 /*  62 */ "attributes ::= attributes attribute",
 /*  63 */ "attributes ::= attribute",
 /*  64 */ "attributes ::=",
 /*  65 */ "attribute ::= SPACE ID EQUAL ID",
 /*  66 */ "attribute ::= ATTR expr",
 /*  67 */ "attribute ::= ATTR value",
 /*  68 */ "attribute ::= SPACE ID",
 /*  69 */ "attribute ::= SPACE expr",
 /*  70 */ "attribute ::= SPACE value",
 /*  71 */ "attribute ::= SPACE INTEGER EQUAL expr",
 /*  72 */ "statements ::= statement",
 /*  73 */ "statements ::= statements COMMA statement",
 /*  74 */ "statement ::= DOLLAR varvar EQUAL expr",
 /*  75 */ "statement ::= varindexed EQUAL expr",
 /*  76 */ "statement ::= OPENP statement CLOSEP",
 /*  77 */ "expr ::= value",
 /*  78 */ "expr ::= ternary",
 /*  79 */ "expr ::= DOLLAR ID COLON ID",
 /*  80 */ "expr ::= expr MATH value",
 /*  81 */ "expr ::= expr UNIMATH value",
 /*  82 */ "expr ::= expr ANDSYM value",
 /*  83 */ "expr ::= array",
 /*  84 */ "expr ::= expr modifierlist",
 /*  85 */ "expr ::= expr ifcond expr",
 /*  86 */ "expr ::= expr ISIN array",
 /*  87 */ "expr ::= expr ISIN value",
 /*  88 */ "expr ::= expr lop expr",
 /*  89 */ "expr ::= expr ISDIVBY expr",
 /*  90 */ "expr ::= expr ISNOTDIVBY expr",
 /*  91 */ "expr ::= expr ISEVEN",
 /*  92 */ "expr ::= expr ISNOTEVEN",
 /*  93 */ "expr ::= expr ISEVENBY expr",
 /*  94 */ "expr ::= expr ISNOTEVENBY expr",
 /*  95 */ "expr ::= expr ISODD",
 /*  96 */ "expr ::= expr ISNOTODD",
 /*  97 */ "expr ::= expr ISODDBY expr",
 /*  98 */ "expr ::= expr ISNOTODDBY expr",
 /*  99 */ "expr ::= value INSTANCEOF ID",
 /* 100 */ "expr ::= value INSTANCEOF value",
 /* 101 */ "ternary ::= OPENP expr CLOSEP QMARK DOLLAR ID COLON expr",
 /* 102 */ "ternary ::= OPENP expr CLOSEP QMARK expr COLON expr",
 /* 103 */ "value ::= variable",
 /* 104 */ "value ::= UNIMATH value",
 /* 105 */ "value ::= NOT value",
 /* 106 */ "value ::= TYPECAST value",
 /* 107 */ "value ::= variable INCDEC",
 /* 108 */ "value ::= HEX",
 /* 109 */ "value ::= INTEGER",
 /* 110 */ "value ::= INTEGER DOT INTEGER",
 /* 111 */ "value ::= INTEGER DOT",
 /* 112 */ "value ::= DOT INTEGER",
 /* 113 */ "value ::= ID",
 /* 114 */ "value ::= function",
 /* 115 */ "value ::= OPENP expr CLOSEP",
 /* 116 */ "value ::= SINGLEQUOTESTRING",
 /* 117 */ "value ::= doublequoted_with_quotes",
 /* 118 */ "value ::= ID DOUBLECOLON static_class_access",
 /* 119 */ "value ::= varindexed DOUBLECOLON static_class_access",
 /* 120 */ "value ::= smartytag",
 /* 121 */ "value ::= value modifierlist",
 /* 122 */ "variable ::= varindexed",
 /* 123 */ "variable ::= DOLLAR varvar AT ID",
 /* 124 */ "variable ::= object",
 /* 125 */ "variable ::= HATCH ID HATCH",
 /* 126 */ "variable ::= HATCH variable HATCH",
 /* 127 */ "varindexed ::= DOLLAR varvar arrayindex",
 /* 128 */ "arrayindex ::= arrayindex indexdef",
 /* 129 */ "arrayindex ::=",
 /* 130 */ "indexdef ::= DOT DOLLAR varvar",
 /* 131 */ "indexdef ::= DOT DOLLAR varvar AT ID",
 /* 132 */ "indexdef ::= DOT ID",
 /* 133 */ "indexdef ::= DOT INTEGER",
 /* 134 */ "indexdef ::= DOT LDEL expr RDEL",
 /* 135 */ "indexdef ::= OPENB ID CLOSEB",
 /* 136 */ "indexdef ::= OPENB ID DOT ID CLOSEB",
 /* 137 */ "indexdef ::= OPENB expr CLOSEB",
 /* 138 */ "indexdef ::= OPENB CLOSEB",
 /* 139 */ "varvar ::= varvarele",
 /* 140 */ "varvar ::= varvar varvarele",
 /* 141 */ "varvarele ::= ID",
 /* 142 */ "varvarele ::= LDEL expr RDEL",
 /* 143 */ "object ::= varindexed objectchain",
 /* 144 */ "objectchain ::= objectelement",
 /* 145 */ "objectchain ::= objectchain objectelement",
 /* 146 */ "objectelement ::= PTR ID arrayindex",
 /* 147 */ "objectelement ::= PTR DOLLAR varvar arrayindex",
 /* 148 */ "objectelement ::= PTR LDEL expr RDEL arrayindex",
 /* 149 */ "objectelement ::= PTR ID LDEL expr RDEL arrayindex",
 /* 150 */ "objectelement ::= PTR method",
 /* 151 */ "function ::= ID OPENP params CLOSEP",
 /* 152 */ "method ::= ID OPENP params CLOSEP",
 /* 153 */ "method ::= DOLLAR ID OPENP params CLOSEP",
 /* 154 */ "params ::= params COMMA expr",
 /* 155 */ "params ::= expr",
 /* 156 */ "params ::=",
 /* 157 */ "modifierlist ::= modifierlist modifier modparameters",
 /* 158 */ "modifierlist ::= modifier modparameters",
 /* 159 */ "modifier ::= VERT AT ID",
 /* 160 */ "modifier ::= VERT ID",
 /* 161 */ "modparameters ::= modparameters modparameter",
 /* 162 */ "modparameters ::=",
 /* 163 */ "modparameter ::= COLON value",
 /* 164 */ "modparameter ::= COLON array",
 /* 165 */ "static_class_access ::= method",
 /* 166 */ "static_class_access ::= method objectchain",
 /* 167 */ "static_class_access ::= ID",
 /* 168 */ "static_class_access ::= DOLLAR ID arrayindex",
 /* 169 */ "static_class_access ::= DOLLAR ID arrayindex objectchain",
 /* 170 */ "ifcond ::= EQUALS",
 /* 171 */ "ifcond ::= NOTEQUALS",
 /* 172 */ "ifcond ::= GREATERTHAN",
 /* 173 */ "ifcond ::= LESSTHAN",
 /* 174 */ "ifcond ::= GREATEREQUAL",
 /* 175 */ "ifcond ::= LESSEQUAL",
 /* 176 */ "ifcond ::= IDENTITY",
 /* 177 */ "ifcond ::= NONEIDENTITY",
 /* 178 */ "ifcond ::= MOD",
 /* 179 */ "lop ::= LAND",
 /* 180 */ "lop ::= LOR",
 /* 181 */ "lop ::= LXOR",
 /* 182 */ "array ::= OPENB arrayelements CLOSEB",
 /* 183 */ "arrayelements ::= arrayelement",
 /* 184 */ "arrayelements ::= arrayelements COMMA arrayelement",
 /* 185 */ "arrayelements ::=",
 /* 186 */ "arrayelement ::= value APTR expr",
 /* 187 */ "arrayelement ::= ID APTR expr",
 /* 188 */ "arrayelement ::= expr",
 /* 189 */ "doublequoted_with_quotes ::= QUOTE QUOTE",
 /* 190 */ "doublequoted_with_quotes ::= QUOTE doublequoted QUOTE",
 /* 191 */ "doublequoted ::= doublequoted doublequotedcontent",
 /* 192 */ "doublequoted ::= doublequotedcontent",
 /* 193 */ "doublequotedcontent ::= BACKTICK variable BACKTICK",
 /* 194 */ "doublequotedcontent ::= BACKTICK expr BACKTICK",
 /* 195 */ "doublequotedcontent ::= DOLLARID",
 /* 196 */ "doublequotedcontent ::= LDEL variable RDEL",
 /* 197 */ "doublequotedcontent ::= LDEL expr RDEL",
 /* 198 */ "doublequotedcontent ::= smartytag",
 /* 199 */ "doublequotedcontent ::= TEXT",
 /* 200 */ "optspace ::= SPACE",
 /* 201 */ "optspace ::=",
    );

    function tokenName($tokenType)
    {
        if ($tokenType === 0) {
            return 'End of Input';
        }
        if ($tokenType > 0 && $tokenType < count($this->yyTokenName)) {
            return $this->yyTokenName[$tokenType];
        } else {
            return "Unknown";
        }
    }

    static function yy_destructor($yymajor, $yypminor)
    {
        switch ($yymajor) {
            default:  break;   /* If no destructor action specified: do nothing */
        }
    }

    function yy_pop_parser_stack()
    {
        if (!count($this->yystack)) {
            return;
        }
        $yytos = array_pop($this->yystack);
        if (self::$yyTraceFILE && $this->yyidx >= 0) {
            fwrite(self::$yyTraceFILE,
                self::$yyTracePrompt . 'Popping ' . $this->yyTokenName[$yytos->major] .
                    "\n");
        }
        $yymajor = $yytos->major;
        self::yy_destructor($yymajor, $yytos->minor);
        $this->yyidx--;
        return $yymajor;
    }

    function __destruct()
    {
        while ($this->yystack !== Array()) {
            $this->yy_pop_parser_stack();
        }
        if (is_resource(self::$yyTraceFILE)) {
            fclose(self::$yyTraceFILE);
        }
    }

    function yy_get_expected_tokens($token)
    {
        $state = $this->yystack[$this->yyidx]->stateno;
        $expected = self::$yyExpectedTokens[$state];
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return $expected;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return array_unique($expected);
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate])) {
		        $expected = array_merge($expected, self::$yyExpectedTokens[$nextstate]);
                            if (in_array($token,
                                  self::$yyExpectedTokens[$nextstate], true)) {
                            $this->yyidx = $yyidx;
                            $this->yystack = $stack;
                            return array_unique($expected);
                        }
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return array_unique($expected);
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return $expected;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
	$this->yyidx = $yyidx;
	$this->yystack = $stack;
        return array_unique($expected);
    }

    function yy_is_expected_token($token)
    {
        if ($token === 0) {
            return true; // 0 is not part of this
        }
        $state = $this->yystack[$this->yyidx]->stateno;
        if (in_array($token, self::$yyExpectedTokens[$state], true)) {
            return true;
        }
        $stack = $this->yystack;
        $yyidx = $this->yyidx;
        do {
            $yyact = $this->yy_find_shift_action($token);
            if ($yyact >= self::YYNSTATE && $yyact < self::YYNSTATE + self::YYNRULE) {
                // reduce action
                $done = 0;
                do {
                    if ($done++ == 100) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // too much recursion prevents proper detection
                        // so give up
                        return true;
                    }
                    $yyruleno = $yyact - self::YYNSTATE;
                    $this->yyidx -= self::$yyRuleInfo[$yyruleno]['rhs'];
                    $nextstate = $this->yy_find_reduce_action(
                        $this->yystack[$this->yyidx]->stateno,
                        self::$yyRuleInfo[$yyruleno]['lhs']);
                    if (isset(self::$yyExpectedTokens[$nextstate]) &&
                          in_array($token, self::$yyExpectedTokens[$nextstate], true)) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        return true;
                    }
                    if ($nextstate < self::YYNSTATE) {
                        // we need to shift a non-terminal
                        $this->yyidx++;
                        $x = new TP_yyStackEntry;
                        $x->stateno = $nextstate;
                        $x->major = self::$yyRuleInfo[$yyruleno]['lhs'];
                        $this->yystack[$this->yyidx] = $x;
                        continue 2;
                    } elseif ($nextstate == self::YYNSTATE + self::YYNRULE + 1) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        if (!$token) {
                            // end of input: this is valid
                            return true;
                        }
                        // the last token was just ignored, we can't accept
                        // by ignoring input, this is in essence ignoring a
                        // syntax error!
                        return false;
                    } elseif ($nextstate === self::YY_NO_ACTION) {
                        $this->yyidx = $yyidx;
                        $this->yystack = $stack;
                        // input accepted, but not shifted (I guess)
                        return true;
                    } else {
                        $yyact = $nextstate;
                    }
                } while (true);
            }
            break;
        } while (true);
        $this->yyidx = $yyidx;
        $this->yystack = $stack;
        return true;
    }

   function yy_find_shift_action($iLookAhead)
    {
        $stateno = $this->yystack[$this->yyidx]->stateno;

        /* if ($this->yyidx < 0) return self::YY_NO_ACTION;  */
        if (!isset(self::$yy_shift_ofst[$stateno])) {
            // no shift actions
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_shift_ofst[$stateno];
        if ($i === self::YY_SHIFT_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            if (count(self::$yyFallback) && $iLookAhead < count(self::$yyFallback)
                   && ($iFallback = self::$yyFallback[$iLookAhead]) != 0) {
                if (self::$yyTraceFILE) {
                    fwrite(self::$yyTraceFILE, self::$yyTracePrompt . "FALLBACK " .
                        $this->yyTokenName[$iLookAhead] . " => " .
                        $this->yyTokenName[$iFallback] . "\n");
                }
                return $this->yy_find_shift_action($iFallback);
            }
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_find_reduce_action($stateno, $iLookAhead)
    {
        /* $stateno = $this->yystack[$this->yyidx]->stateno; */

        if (!isset(self::$yy_reduce_ofst[$stateno])) {
            return self::$yy_default[$stateno];
        }
        $i = self::$yy_reduce_ofst[$stateno];
        if ($i == self::YY_REDUCE_USE_DFLT) {
            return self::$yy_default[$stateno];
        }
        if ($iLookAhead == self::YYNOCODE) {
            return self::YY_NO_ACTION;
        }
        $i += $iLookAhead;
        if ($i < 0 || $i >= self::YY_SZ_ACTTAB ||
              self::$yy_lookahead[$i] != $iLookAhead) {
            return self::$yy_default[$stateno];
        } else {
            return self::$yy_action[$i];
        }
    }

    function yy_shift($yyNewState, $yyMajor, $yypMinor)
    {
        $this->yyidx++;
        if ($this->yyidx >= self::YYSTACKDEPTH) {
            $this->yyidx--;
            if (self::$yyTraceFILE) {
                fprintf(self::$yyTraceFILE, "%sStack Overflow!\n", self::$yyTracePrompt);
            }
            while ($this->yyidx >= 0) {
                $this->yy_pop_parser_stack();
            }
#line 84 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->compiler->trigger_template_error("Stack overflow in template parser");
#line 1733 "smarty_internal_templateparser.php"
            return;
        }
        $yytos = new TP_yyStackEntry;
        $yytos->stateno = $yyNewState;
        $yytos->major = $yyMajor;
        $yytos->minor = $yypMinor;
        array_push($this->yystack, $yytos);
        if (self::$yyTraceFILE && $this->yyidx > 0) {
            fprintf(self::$yyTraceFILE, "%sShift %d\n", self::$yyTracePrompt,
                $yyNewState);
            fprintf(self::$yyTraceFILE, "%sStack:", self::$yyTracePrompt);
            for($i = 1; $i <= $this->yyidx; $i++) {
                fprintf(self::$yyTraceFILE, " %s",
                    $this->yyTokenName[$this->yystack[$i]->major]);
            }
            fwrite(self::$yyTraceFILE,"\n");
        }
    }

    static public $yyRuleInfo = array(
  array( 'lhs' => 82, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 1 ),
  array( 'lhs' => 83, 'rhs' => 2 ),
  array( 'lhs' => 83, 'rhs' => 0 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 84, 'rhs' => 1 ),
  array( 'lhs' => 86, 'rhs' => 2 ),
  array( 'lhs' => 86, 'rhs' => 3 ),
  array( 'lhs' => 87, 'rhs' => 2 ),
  array( 'lhs' => 87, 'rhs' => 0 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 88, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 7 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 7 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 12 ),
  array( 'lhs' => 98, 'rhs' => 2 ),
  array( 'lhs' => 98, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 85, 'rhs' => 8 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 8 ),
  array( 'lhs' => 85, 'rhs' => 11 ),
  array( 'lhs' => 85, 'rhs' => 8 ),
  array( 'lhs' => 85, 'rhs' => 11 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 1 ),
  array( 'lhs' => 85, 'rhs' => 3 ),
  array( 'lhs' => 85, 'rhs' => 4 ),
  array( 'lhs' => 85, 'rhs' => 5 ),
  array( 'lhs' => 85, 'rhs' => 6 ),
  array( 'lhs' => 91, 'rhs' => 2 ),
  array( 'lhs' => 91, 'rhs' => 1 ),
  array( 'lhs' => 91, 'rhs' => 0 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 2 ),
  array( 'lhs' => 100, 'rhs' => 4 ),
  array( 'lhs' => 95, 'rhs' => 1 ),
  array( 'lhs' => 95, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 4 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 94, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 4 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 1 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 2 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 92, 'rhs' => 3 ),
  array( 'lhs' => 101, 'rhs' => 8 ),
  array( 'lhs' => 101, 'rhs' => 7 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 3 ),
  array( 'lhs' => 89, 'rhs' => 1 ),
  array( 'lhs' => 89, 'rhs' => 2 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 4 ),
  array( 'lhs' => 105, 'rhs' => 1 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 105, 'rhs' => 3 ),
  array( 'lhs' => 93, 'rhs' => 3 ),
  array( 'lhs' => 110, 'rhs' => 2 ),
  array( 'lhs' => 110, 'rhs' => 0 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 111, 'rhs' => 4 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 5 ),
  array( 'lhs' => 111, 'rhs' => 3 ),
  array( 'lhs' => 111, 'rhs' => 2 ),
  array( 'lhs' => 97, 'rhs' => 1 ),
  array( 'lhs' => 97, 'rhs' => 2 ),
  array( 'lhs' => 112, 'rhs' => 1 ),
  array( 'lhs' => 112, 'rhs' => 3 ),
  array( 'lhs' => 109, 'rhs' => 2 ),
  array( 'lhs' => 113, 'rhs' => 1 ),
  array( 'lhs' => 113, 'rhs' => 2 ),
  array( 'lhs' => 114, 'rhs' => 3 ),
  array( 'lhs' => 114, 'rhs' => 4 ),
  array( 'lhs' => 114, 'rhs' => 5 ),
  array( 'lhs' => 114, 'rhs' => 6 ),
  array( 'lhs' => 114, 'rhs' => 2 ),
  array( 'lhs' => 106, 'rhs' => 4 ),
  array( 'lhs' => 115, 'rhs' => 4 ),
  array( 'lhs' => 115, 'rhs' => 5 ),
  array( 'lhs' => 116, 'rhs' => 3 ),
  array( 'lhs' => 116, 'rhs' => 1 ),
  array( 'lhs' => 116, 'rhs' => 0 ),
  array( 'lhs' => 90, 'rhs' => 3 ),
  array( 'lhs' => 90, 'rhs' => 2 ),
  array( 'lhs' => 117, 'rhs' => 3 ),
  array( 'lhs' => 117, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 2 ),
  array( 'lhs' => 99, 'rhs' => 0 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 118, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 2 ),
  array( 'lhs' => 108, 'rhs' => 1 ),
  array( 'lhs' => 108, 'rhs' => 3 ),
  array( 'lhs' => 108, 'rhs' => 4 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 103, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 104, 'rhs' => 1 ),
  array( 'lhs' => 102, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 1 ),
  array( 'lhs' => 119, 'rhs' => 3 ),
  array( 'lhs' => 119, 'rhs' => 0 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 3 ),
  array( 'lhs' => 120, 'rhs' => 1 ),
  array( 'lhs' => 107, 'rhs' => 2 ),
  array( 'lhs' => 107, 'rhs' => 3 ),
  array( 'lhs' => 121, 'rhs' => 2 ),
  array( 'lhs' => 121, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 3 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 122, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 1 ),
  array( 'lhs' => 96, 'rhs' => 0 ),
    );

    static public $yyReduceMap = array(
        0 => 0,
        1 => 1,
        2 => 1,
        4 => 4,
        5 => 5,
        6 => 6,
        7 => 7,
        8 => 8,
        9 => 9,
        10 => 10,
        11 => 11,
        12 => 12,
        13 => 13,
        14 => 14,
        15 => 15,
        16 => 16,
        19 => 16,
        201 => 16,
        17 => 17,
        76 => 17,
        18 => 18,
        104 => 18,
        106 => 18,
        107 => 18,
        128 => 18,
        166 => 18,
        20 => 20,
        21 => 20,
        47 => 20,
        69 => 20,
        70 => 20,
        77 => 20,
        78 => 20,
        83 => 20,
        103 => 20,
        108 => 20,
        109 => 20,
        114 => 20,
        116 => 20,
        117 => 20,
        124 => 20,
        139 => 20,
        165 => 20,
        167 => 20,
        183 => 20,
        188 => 20,
        200 => 20,
        22 => 22,
        23 => 22,
        24 => 24,
        25 => 25,
        26 => 26,
        27 => 27,
        28 => 28,
        29 => 29,
        31 => 29,
        30 => 30,
        32 => 32,
        33 => 32,
        34 => 34,
        35 => 35,
        36 => 36,
        37 => 37,
        38 => 38,
        39 => 39,
        40 => 40,
        41 => 41,
        42 => 42,
        44 => 42,
        43 => 43,
        45 => 45,
        46 => 46,
        48 => 48,
        49 => 49,
        50 => 50,
        51 => 51,
        52 => 52,
        53 => 53,
        54 => 54,
        55 => 55,
        56 => 56,
        57 => 57,
        58 => 58,
        59 => 59,
        60 => 60,
        61 => 61,
        62 => 62,
        63 => 63,
        72 => 63,
        155 => 63,
        159 => 63,
        163 => 63,
        164 => 63,
        64 => 64,
        156 => 64,
        162 => 64,
        65 => 65,
        66 => 66,
        67 => 66,
        68 => 68,
        71 => 71,
        73 => 73,
        74 => 74,
        75 => 74,
        79 => 79,
        80 => 80,
        81 => 80,
        82 => 80,
        84 => 84,
        121 => 84,
        85 => 85,
        88 => 85,
        99 => 85,
        86 => 86,
        87 => 87,
        89 => 89,
        90 => 90,
        91 => 91,
        96 => 91,
        92 => 92,
        95 => 92,
        93 => 93,
        98 => 93,
        94 => 94,
        97 => 94,
        100 => 100,
        101 => 101,
        102 => 102,
        105 => 105,
        110 => 110,
        111 => 111,
        112 => 112,
        113 => 113,
        115 => 115,
        118 => 118,
        119 => 119,
        120 => 120,
        122 => 122,
        123 => 123,
        125 => 125,
        126 => 126,
        127 => 127,
        129 => 129,
        185 => 129,
        130 => 130,
        131 => 131,
        132 => 132,
        133 => 133,
        134 => 134,
        137 => 134,
        135 => 135,
        136 => 136,
        138 => 138,
        140 => 140,
        141 => 141,
        142 => 142,
        143 => 143,
        144 => 144,
        145 => 145,
        146 => 146,
        147 => 147,
        148 => 148,
        149 => 149,
        150 => 150,
        151 => 151,
        152 => 152,
        153 => 153,
        154 => 154,
        157 => 157,
        158 => 158,
        160 => 160,
        161 => 161,
        168 => 168,
        169 => 169,
        170 => 170,
        171 => 171,
        172 => 172,
        173 => 173,
        174 => 174,
        175 => 175,
        176 => 176,
        177 => 177,
        178 => 178,
        179 => 179,
        180 => 180,
        181 => 181,
        182 => 182,
        184 => 184,
        186 => 186,
        187 => 187,
        189 => 189,
        190 => 190,
        191 => 191,
        192 => 192,
        193 => 193,
        194 => 193,
        196 => 193,
        195 => 195,
        197 => 197,
        198 => 198,
        199 => 199,
    );
#line 95 "smarty_internal_templateparser.y"
    function yy_r0(){
    $this->_retvalue = $this->root_buffer->to_smarty_php();
    }
#line 2165 "smarty_internal_templateparser.php"
#line 103 "smarty_internal_templateparser.y"
    function yy_r1(){
    $this->current_buffer->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2170 "smarty_internal_templateparser.php"
#line 119 "smarty_internal_templateparser.y"
    function yy_r4(){
    if ($this->compiler->has_code) {
        $tmp =''; foreach ($this->compiler->prefix_code as $code) {$tmp.=$code;} $this->compiler->prefix_code=array();
        $this->_retvalue = new _smarty_tag($this, $this->compiler->processNocacheCode($tmp.$this->yystack[$this->yyidx + 0]->minor,true));
    } else {
        $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
    $this->compiler->has_variable_string = false;
    $this->block_nesting_level = count($this->compiler->_tag_stack);
    }
#line 2182 "smarty_internal_templateparser.php"
#line 131 "smarty_internal_templateparser.y"
    function yy_r5(){
    $this->_retvalue = new _smarty_tag($this, '');
    }
#line 2187 "smarty_internal_templateparser.php"
#line 136 "smarty_internal_templateparser.y"
    function yy_r6(){
    $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 2192 "smarty_internal_templateparser.php"
#line 141 "smarty_internal_templateparser.y"
    function yy_r7(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if (!($this->smarty instanceof SmartyBC)) {
            $this->compiler->trigger_template_error (self::Err3);
        }
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<?php', true));
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        $this->_retvalue = new _smarty_text($this, '');
    }
    }
#line 2208 "smarty_internal_templateparser.php"
#line 157 "smarty_internal_templateparser.y"
    function yy_r8(){
    if ($this->is_xml) {
        $this->compiler->tag_nocache = true;
        $this->is_xml = false;
        $save = $this->template->has_nocache_code;
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '?>';?>\n", $this->compiler, true));
        $this->template->has_nocache_code = $save;
    } elseif ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '?<?php ?>>');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars('?>', ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('?>', true));
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        $this->_retvalue = new _smarty_text($this, '');
    }
    }
#line 2227 "smarty_internal_templateparser.php"
#line 176 "smarty_internal_templateparser.y"
    function yy_r9(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars($this->yystack[$this->yyidx + 0]->minor, ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if ($this->asp_tags) {
            if (!($this->smarty instanceof SmartyBC)) {
                $this->compiler->trigger_template_error (self::Err3);
            }
            $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('<%', true));
        } else {
            $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
        }
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, '');
        } else {
            $this->_retvalue = new _smarty_text($this, '<<?php ?>%');
        }
    }
    }
#line 2251 "smarty_internal_templateparser.php"
#line 200 "smarty_internal_templateparser.y"
    function yy_r10(){
    if ($this->php_handling == Smarty::PHP_PASSTHRU) {
        $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
    } elseif ($this->php_handling == Smarty::PHP_QUOTE) {
        $this->_retvalue = new _smarty_text($this, htmlspecialchars('%>', ENT_QUOTES));
    } elseif ($this->php_handling == Smarty::PHP_ALLOW) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode('%>', true));
        } else {
            $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
        }
    } elseif ($this->php_handling == Smarty::PHP_REMOVE) {
        if ($this->asp_tags) {
            $this->_retvalue = new _smarty_text($this, '');
        } else {
            $this->_retvalue = new _smarty_text($this, '%<?php ?>>');
        }
    }
    }
#line 2272 "smarty_internal_templateparser.php"
#line 220 "smarty_internal_templateparser.y"
    function yy_r11(){
    if ($this->strip) {
        $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor)));
    } else {
        $this->_retvalue = new _smarty_text($this, self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor));
    }
    }
#line 2281 "smarty_internal_templateparser.php"
#line 229 "smarty_internal_templateparser.y"
    function yy_r12(){
    $this->compiler->tag_nocache = true;
    $this->is_xml = true;
    $save = $this->template->has_nocache_code;
    $this->_retvalue = new _smarty_text($this, $this->compiler->processNocacheCode("<?php echo '<?xml';?>", $this->compiler, true));
    $this->template->has_nocache_code = $save;
    }
#line 2290 "smarty_internal_templateparser.php"
#line 238 "smarty_internal_templateparser.y"
    function yy_r13(){
    if ($this->strip) {
        $this->_retvalue = new _smarty_text($this, preg_replace('![\t ]*[\r\n]+[\t ]*!', '', $this->yystack[$this->yyidx + 0]->minor));
    } else {
        $this->_retvalue = new _smarty_text($this, $this->yystack[$this->yyidx + 0]->minor);
    }
    }
#line 2299 "smarty_internal_templateparser.php"
#line 247 "smarty_internal_templateparser.y"
    function yy_r14(){
    $this->strip = true;
    $this->_retvalue = new _smarty_text($this, '');
    }
#line 2305 "smarty_internal_templateparser.php"
#line 252 "smarty_internal_templateparser.y"
    function yy_r15(){
    $this->strip = false;
    $this->_retvalue = new _smarty_text($this, '');
    }
#line 2311 "smarty_internal_templateparser.php"
#line 258 "smarty_internal_templateparser.y"
    function yy_r16(){
    $this->_retvalue = '';
    }
#line 2316 "smarty_internal_templateparser.php"
#line 262 "smarty_internal_templateparser.y"
    function yy_r17(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 2321 "smarty_internal_templateparser.php"
#line 266 "smarty_internal_templateparser.y"
    function yy_r18(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2326 "smarty_internal_templateparser.php"
#line 274 "smarty_internal_templateparser.y"
    function yy_r20(){
    $this->_retvalue = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2331 "smarty_internal_templateparser.php"
#line 282 "smarty_internal_templateparser.y"
    function yy_r22(){
    $this->_retvalue = self::escape_start_tag($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2336 "smarty_internal_templateparser.php"
#line 290 "smarty_internal_templateparser.y"
    function yy_r24(){
    $this->_retvalue = self::escape_end_tag($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2341 "smarty_internal_templateparser.php"
#line 294 "smarty_internal_templateparser.y"
    function yy_r25(){
    $this->_retvalue = '<<?php ?>%';
    }
#line 2346 "smarty_internal_templateparser.php"
#line 298 "smarty_internal_templateparser.y"
    function yy_r26(){
    $this->_retvalue = '%<?php ?>>';
    }
#line 2351 "smarty_internal_templateparser.php"
#line 307 "smarty_internal_templateparser.y"
    function yy_r27(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2356 "smarty_internal_templateparser.php"
#line 311 "smarty_internal_templateparser.y"
    function yy_r28(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor, 'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2361 "smarty_internal_templateparser.php"
#line 315 "smarty_internal_templateparser.y"
    function yy_r29(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2366 "smarty_internal_templateparser.php"
#line 319 "smarty_internal_templateparser.y"
    function yy_r30(){
    $this->_retvalue = $this->compiler->compileTag('private_print_expression',$this->yystack[$this->yyidx + -1]->minor,array('value'=>$this->yystack[$this->yyidx + -3]->minor,'modifierlist'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2371 "smarty_internal_templateparser.php"
#line 332 "smarty_internal_templateparser.y"
    function yy_r32(){
    $this->_retvalue = $this->compiler->compileTag('assign',array(array('value'=>$this->yystack[$this->yyidx + -1]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -3]->minor."'")));
    }
#line 2376 "smarty_internal_templateparser.php"
#line 340 "smarty_internal_templateparser.y"
    function yy_r34(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>"'".$this->yystack[$this->yyidx + -4]->minor."'")),$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2381 "smarty_internal_templateparser.php"
#line 344 "smarty_internal_templateparser.y"
    function yy_r35(){
    $this->_retvalue = $this->compiler->compileTag('assign',array_merge(array(array('value'=>$this->yystack[$this->yyidx + -2]->minor),array('var'=>$this->yystack[$this->yyidx + -4]->minor['var'])),$this->yystack[$this->yyidx + -1]->minor),array('smarty_internal_index'=>$this->yystack[$this->yyidx + -4]->minor['smarty_internal_index']));
    }
#line 2386 "smarty_internal_templateparser.php"
#line 349 "smarty_internal_templateparser.y"
    function yy_r36(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor,$this->yystack[$this->yyidx + -1]->minor);
    }
#line 2391 "smarty_internal_templateparser.php"
#line 353 "smarty_internal_templateparser.y"
    function yy_r37(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor,array());
    }
#line 2396 "smarty_internal_templateparser.php"
#line 358 "smarty_internal_templateparser.y"
    function yy_r38(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2401 "smarty_internal_templateparser.php"
#line 363 "smarty_internal_templateparser.y"
    function yy_r39(){
    $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor,$this->yystack[$this->yyidx + -1]->minor).'<?php echo ';
    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
    }
#line 2407 "smarty_internal_templateparser.php"
#line 369 "smarty_internal_templateparser.y"
    function yy_r40(){
    $this->_retvalue = '<?php ob_start();?>'.$this->compiler->compileTag($this->yystack[$this->yyidx + -5]->minor,$this->yystack[$this->yyidx + -1]->minor,array('object_methode'=>$this->yystack[$this->yyidx + -3]->minor)).'<?php echo ';
    $this->_retvalue .= $this->compiler->compileTag('private_modifier',array(),array('modifierlist'=>$this->yystack[$this->yyidx + -2]->minor,'value'=>'ob_get_clean()')).'?>';
    }
#line 2413 "smarty_internal_templateparser.php"
#line 375 "smarty_internal_templateparser.y"
    function yy_r41(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2419 "smarty_internal_templateparser.php"
#line 380 "smarty_internal_templateparser.y"
    function yy_r42(){
    $tag = trim(substr($this->yystack[$this->yyidx + -3]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,$this->yystack[$this->yyidx + -1]->minor,array('if condition'=>$this->yystack[$this->yyidx + -2]->minor));
    }
#line 2425 "smarty_internal_templateparser.php"
#line 385 "smarty_internal_templateparser.y"
    function yy_r43(){
    $tag = trim(substr($this->yystack[$this->yyidx + -2]->minor,$this->lex->ldel_length));
    $this->_retvalue = $this->compiler->compileTag(($tag == 'else if')? 'elseif' : $tag,array(),array('if condition'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2431 "smarty_internal_templateparser.php"
#line 396 "smarty_internal_templateparser.y"
    function yy_r45(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -10]->minor),array('ifexp'=>$this->yystack[$this->yyidx + -7]->minor),array('var'=>$this->yystack[$this->yyidx + -3]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),1);
    }
#line 2436 "smarty_internal_templateparser.php"
#line 400 "smarty_internal_templateparser.y"
    function yy_r46(){
    $this->_retvalue = '='.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2441 "smarty_internal_templateparser.php"
#line 408 "smarty_internal_templateparser.y"
    function yy_r48(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -4]->minor),array('to'=>$this->yystack[$this->yyidx + -2]->minor))),0);
    }
#line 2446 "smarty_internal_templateparser.php"
#line 412 "smarty_internal_templateparser.y"
    function yy_r49(){
    $this->_retvalue = $this->compiler->compileTag('for',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('start'=>$this->yystack[$this->yyidx + -6]->minor),array('to'=>$this->yystack[$this->yyidx + -4]->minor),array('step'=>$this->yystack[$this->yyidx + -2]->minor))),0);
    }
#line 2451 "smarty_internal_templateparser.php"
#line 417 "smarty_internal_templateparser.y"
    function yy_r50(){
    $this->_retvalue = $this->compiler->compileTag('foreach',$this->yystack[$this->yyidx + -1]->minor);
    }
#line 2456 "smarty_internal_templateparser.php"
#line 422 "smarty_internal_templateparser.y"
    function yy_r51(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));
    }
#line 2461 "smarty_internal_templateparser.php"
#line 426 "smarty_internal_templateparser.y"
    function yy_r52(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));
    }
#line 2466 "smarty_internal_templateparser.php"
#line 430 "smarty_internal_templateparser.y"
    function yy_r53(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -5]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor))));
    }
#line 2471 "smarty_internal_templateparser.php"
#line 434 "smarty_internal_templateparser.y"
    function yy_r54(){
    $this->_retvalue = $this->compiler->compileTag('foreach',array_merge($this->yystack[$this->yyidx + -1]->minor,array(array('from'=>$this->yystack[$this->yyidx + -8]->minor),array('item'=>$this->yystack[$this->yyidx + -2]->minor),array('key'=>$this->yystack[$this->yyidx + -5]->minor))));
    }
#line 2476 "smarty_internal_templateparser.php"
#line 439 "smarty_internal_templateparser.y"
    function yy_r55(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array(array_merge(array($this->yystack[$this->yyidx + -2]->minor),$this->yystack[$this->yyidx + -1]->minor))));
    }
#line 2481 "smarty_internal_templateparser.php"
#line 443 "smarty_internal_templateparser.y"
    function yy_r56(){
    $this->_retvalue = $this->compiler->compileTag('setfilter',array(),array('modifier_list'=>array_merge(array(array_merge(array($this->yystack[$this->yyidx + -3]->minor),$this->yystack[$this->yyidx + -2]->minor)),$this->yystack[$this->yyidx + -1]->minor)));
    }
#line 2486 "smarty_internal_templateparser.php"
#line 448 "smarty_internal_templateparser.y"
    function yy_r57(){
    $this->_retvalue = SMARTY_INTERNAL_COMPILE_BLOCK::compileChildBlock($this->compiler);
    }
#line 2491 "smarty_internal_templateparser.php"
#line 454 "smarty_internal_templateparser.y"
    function yy_r58(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -1]->minor.'close',array());
    }
#line 2496 "smarty_internal_templateparser.php"
#line 458 "smarty_internal_templateparser.y"
    function yy_r59(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -2]->minor.'close',array(),array('modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2501 "smarty_internal_templateparser.php"
#line 463 "smarty_internal_templateparser.y"
    function yy_r60(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -3]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2506 "smarty_internal_templateparser.php"
#line 467 "smarty_internal_templateparser.y"
    function yy_r61(){
    $this->_retvalue = $this->compiler->compileTag($this->yystack[$this->yyidx + -4]->minor.'close',array(),array('object_methode'=>$this->yystack[$this->yyidx + -2]->minor, 'modifier_list'=>$this->yystack[$this->yyidx + -1]->minor));
    }
#line 2511 "smarty_internal_templateparser.php"
#line 475 "smarty_internal_templateparser.y"
    function yy_r62(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    $this->_retvalue[] = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2517 "smarty_internal_templateparser.php"
#line 481 "smarty_internal_templateparser.y"
    function yy_r63(){
    $this->_retvalue = array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2522 "smarty_internal_templateparser.php"
#line 486 "smarty_internal_templateparser.y"
    function yy_r64(){
    $this->_retvalue = array();
    }
#line 2527 "smarty_internal_templateparser.php"
#line 491 "smarty_internal_templateparser.y"
    function yy_r65(){
    if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'true');
    } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'false');
    } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>'null');
    } else {
        $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>"'".$this->yystack[$this->yyidx + 0]->minor."'");
    }
    }
#line 2540 "smarty_internal_templateparser.php"
#line 503 "smarty_internal_templateparser.y"
    function yy_r66(){
    $this->_retvalue = array(trim($this->yystack[$this->yyidx + -1]->minor," =\n\r\t")=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2545 "smarty_internal_templateparser.php"
#line 511 "smarty_internal_templateparser.y"
    function yy_r68(){
    $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";
    }
#line 2550 "smarty_internal_templateparser.php"
#line 523 "smarty_internal_templateparser.y"
    function yy_r71(){
    $this->_retvalue = array($this->yystack[$this->yyidx + -2]->minor=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2555 "smarty_internal_templateparser.php"
#line 536 "smarty_internal_templateparser.y"
    function yy_r73(){
    $this->yystack[$this->yyidx + -2]->minor[]=$this->yystack[$this->yyidx + 0]->minor;
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor;
    }
#line 2561 "smarty_internal_templateparser.php"
#line 541 "smarty_internal_templateparser.y"
    function yy_r74(){
    $this->_retvalue = array('var' => $this->yystack[$this->yyidx + -2]->minor, 'value'=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2566 "smarty_internal_templateparser.php"
#line 569 "smarty_internal_templateparser.y"
    function yy_r79(){
    $this->_retvalue = '$_smarty_tpl->getStreamVariable(\''. $this->yystack[$this->yyidx + -2]->minor .'://'. $this->yystack[$this->yyidx + 0]->minor . '\')';
    }
#line 2571 "smarty_internal_templateparser.php"
#line 574 "smarty_internal_templateparser.y"
    function yy_r80(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor . trim($this->yystack[$this->yyidx + -1]->minor) . $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2576 "smarty_internal_templateparser.php"
#line 593 "smarty_internal_templateparser.y"
    function yy_r84(){
    $this->_retvalue = $this->compiler->compileTag('private_modifier',array(),array('value'=>$this->yystack[$this->yyidx + -1]->minor,'modifierlist'=>$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2581 "smarty_internal_templateparser.php"
#line 599 "smarty_internal_templateparser.y"
    function yy_r85(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2586 "smarty_internal_templateparser.php"
#line 603 "smarty_internal_templateparser.y"
    function yy_r86(){
    $this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2591 "smarty_internal_templateparser.php"
#line 607 "smarty_internal_templateparser.y"
    function yy_r87(){
    $this->_retvalue = 'in_array('.$this->yystack[$this->yyidx + -2]->minor.',(array)'.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2596 "smarty_internal_templateparser.php"
#line 615 "smarty_internal_templateparser.y"
    function yy_r89(){
    $this->_retvalue = '!('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2601 "smarty_internal_templateparser.php"
#line 619 "smarty_internal_templateparser.y"
    function yy_r90(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -2]->minor.' % '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2606 "smarty_internal_templateparser.php"
#line 623 "smarty_internal_templateparser.y"
    function yy_r91(){
    $this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2611 "smarty_internal_templateparser.php"
#line 627 "smarty_internal_templateparser.y"
    function yy_r92(){
    $this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2616 "smarty_internal_templateparser.php"
#line 631 "smarty_internal_templateparser.y"
    function yy_r93(){
    $this->_retvalue = '!(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2621 "smarty_internal_templateparser.php"
#line 635 "smarty_internal_templateparser.y"
    function yy_r94(){
    $this->_retvalue = '(1 & '.$this->yystack[$this->yyidx + -2]->minor.' / '.$this->yystack[$this->yyidx + 0]->minor.')';
    }
#line 2626 "smarty_internal_templateparser.php"
#line 659 "smarty_internal_templateparser.y"
    function yy_r100(){
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->yystack[$this->yyidx + 0]->minor.';?>';
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.'$_tmp'.$this->prefix_number;
    }
#line 2633 "smarty_internal_templateparser.php"
#line 668 "smarty_internal_templateparser.y"
    function yy_r101(){
    $this->_retvalue = $this->yystack[$this->yyidx + -6]->minor.' ? '. $this->compileVariable("'".$this->yystack[$this->yyidx + -2]->minor."'") . ' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2638 "smarty_internal_templateparser.php"
#line 672 "smarty_internal_templateparser.y"
    function yy_r102(){
    $this->_retvalue = $this->yystack[$this->yyidx + -5]->minor.' ? '.$this->yystack[$this->yyidx + -2]->minor.' : '.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2643 "smarty_internal_templateparser.php"
#line 687 "smarty_internal_templateparser.y"
    function yy_r105(){
    $this->_retvalue = '!'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2648 "smarty_internal_templateparser.php"
#line 708 "smarty_internal_templateparser.y"
    function yy_r110(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2653 "smarty_internal_templateparser.php"
#line 712 "smarty_internal_templateparser.y"
    function yy_r111(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.';
    }
#line 2658 "smarty_internal_templateparser.php"
#line 716 "smarty_internal_templateparser.y"
    function yy_r112(){
    $this->_retvalue = '.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2663 "smarty_internal_templateparser.php"
#line 721 "smarty_internal_templateparser.y"
    function yy_r113(){
    if (preg_match('~^true$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'true';
    } elseif (preg_match('~^false$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'false';
    } elseif (preg_match('~^null$~i', $this->yystack[$this->yyidx + 0]->minor)) {
        $this->_retvalue = 'null';
    } else {
        $this->_retvalue = "'".$this->yystack[$this->yyidx + 0]->minor."'";
    }
    }
#line 2676 "smarty_internal_templateparser.php"
#line 739 "smarty_internal_templateparser.y"
    function yy_r115(){
    $this->_retvalue = "(". $this->yystack[$this->yyidx + -1]->minor .")";
    }
#line 2681 "smarty_internal_templateparser.php"
#line 754 "smarty_internal_templateparser.y"
    function yy_r118(){
    if (!$this->security || isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor]) || $this->smarty->security_policy->isTrustedStaticClass($this->yystack[$this->yyidx + -2]->minor, $this->compiler)) {
        if (isset($this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor])) {
            $this->_retvalue = $this->smarty->registered_classes[$this->yystack[$this->yyidx + -2]->minor].'::'.$this->yystack[$this->yyidx + 0]->minor;
        } else {
            $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'::'.$this->yystack[$this->yyidx + 0]->minor;
        }
    } else {
        $this->compiler->trigger_template_error ("static class '".$this->yystack[$this->yyidx + -2]->minor."' is undefined or not allowed by security setting");
    }
    }
#line 2694 "smarty_internal_templateparser.php"
#line 766 "smarty_internal_templateparser.y"
    function yy_r119(){
    if ($this->yystack[$this->yyidx + -2]->minor['var'] == '\'smarty\'') {
        $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index']).'::'.$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + -2]->minor['var']).$this->yystack[$this->yyidx + -2]->minor['smarty_internal_index'].'::'.$this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 2703 "smarty_internal_templateparser.php"
#line 775 "smarty_internal_templateparser.y"
    function yy_r120(){
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php ob_start();?>'.$this->yystack[$this->yyidx + 0]->minor.'<?php $_tmp'.$this->prefix_number.'=ob_get_clean();?>';
    $this->_retvalue = '$_tmp'.$this->prefix_number;
    }
#line 2710 "smarty_internal_templateparser.php"
#line 790 "smarty_internal_templateparser.y"
    function yy_r122(){
    if ($this->yystack[$this->yyidx + 0]->minor['var'] == '\'smarty\'') {
        $smarty_var = $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index']);
        $this->_retvalue = $smarty_var;
    } else {
        // used for array reset,next,prev,end,current
        $this->last_variable = $this->yystack[$this->yyidx + 0]->minor['var'];
        $this->last_index = $this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + 0]->minor['var']).$this->yystack[$this->yyidx + 0]->minor['smarty_internal_index'];
    }
    }
#line 2723 "smarty_internal_templateparser.php"
#line 803 "smarty_internal_templateparser.y"
    function yy_r123(){
    $this->_retvalue = '$_smarty_tpl->tpl_vars['. $this->yystack[$this->yyidx + -2]->minor .']->'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2728 "smarty_internal_templateparser.php"
#line 813 "smarty_internal_templateparser.y"
    function yy_r125(){
    $this->_retvalue = '$_smarty_tpl->getConfigVariable(\''. $this->yystack[$this->yyidx + -1]->minor .'\')';
    }
#line 2733 "smarty_internal_templateparser.php"
#line 817 "smarty_internal_templateparser.y"
    function yy_r126(){
    $this->_retvalue = '$_smarty_tpl->getConfigVariable('. $this->yystack[$this->yyidx + -1]->minor .')';
    }
#line 2738 "smarty_internal_templateparser.php"
#line 821 "smarty_internal_templateparser.y"
    function yy_r127(){
    $this->_retvalue = array('var'=>$this->yystack[$this->yyidx + -1]->minor, 'smarty_internal_index'=>$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2743 "smarty_internal_templateparser.php"
#line 834 "smarty_internal_templateparser.y"
    function yy_r129(){
    return;
    }
#line 2748 "smarty_internal_templateparser.php"
#line 840 "smarty_internal_templateparser.y"
    function yy_r130(){
    $this->_retvalue = '['.$this->compileVariable($this->yystack[$this->yyidx + 0]->minor).']';
    }
#line 2753 "smarty_internal_templateparser.php"
#line 844 "smarty_internal_templateparser.y"
    function yy_r131(){
    $this->_retvalue = '['.$this->compileVariable($this->yystack[$this->yyidx + -2]->minor).'->'.$this->yystack[$this->yyidx + 0]->minor.']';
    }
#line 2758 "smarty_internal_templateparser.php"
#line 848 "smarty_internal_templateparser.y"
    function yy_r132(){
    $this->_retvalue = "['". $this->yystack[$this->yyidx + 0]->minor ."']";
    }
#line 2763 "smarty_internal_templateparser.php"
#line 852 "smarty_internal_templateparser.y"
    function yy_r133(){
    $this->_retvalue = "[". $this->yystack[$this->yyidx + 0]->minor ."]";
    }
#line 2768 "smarty_internal_templateparser.php"
#line 856 "smarty_internal_templateparser.y"
    function yy_r134(){
    $this->_retvalue = "[". $this->yystack[$this->yyidx + -1]->minor ."]";
    }
#line 2773 "smarty_internal_templateparser.php"
#line 861 "smarty_internal_templateparser.y"
    function yy_r135(){
    $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\'][\'index\']').']';
    }
#line 2778 "smarty_internal_templateparser.php"
#line 865 "smarty_internal_templateparser.y"
    function yy_r136(){
    $this->_retvalue = '['.$this->compiler->compileTag('private_special_variable',array(),'[\'section\'][\''.$this->yystack[$this->yyidx + -3]->minor.'\'][\''.$this->yystack[$this->yyidx + -1]->minor.'\']').']';
    }
#line 2783 "smarty_internal_templateparser.php"
#line 875 "smarty_internal_templateparser.y"
    function yy_r138(){
    $this->_retvalue = '[]';
    }
#line 2788 "smarty_internal_templateparser.php"
#line 888 "smarty_internal_templateparser.y"
    function yy_r140(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor.'.'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2793 "smarty_internal_templateparser.php"
#line 893 "smarty_internal_templateparser.y"
    function yy_r141(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + 0]->minor.'\'';
    }
#line 2798 "smarty_internal_templateparser.php"
#line 898 "smarty_internal_templateparser.y"
    function yy_r142(){
    $this->_retvalue = '('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 2803 "smarty_internal_templateparser.php"
#line 905 "smarty_internal_templateparser.y"
    function yy_r143(){
    if ($this->yystack[$this->yyidx + -1]->minor['var'] == '\'smarty\'') {
        $this->_retvalue =  $this->compiler->compileTag('private_special_variable',array(),$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index']).$this->yystack[$this->yyidx + 0]->minor;
    } else {
        $this->_retvalue = $this->compileVariable($this->yystack[$this->yyidx + -1]->minor['var']).$this->yystack[$this->yyidx + -1]->minor['smarty_internal_index'].$this->yystack[$this->yyidx + 0]->minor;
    }
    }
#line 2812 "smarty_internal_templateparser.php"
#line 914 "smarty_internal_templateparser.y"
    function yy_r144(){
    $this->_retvalue  = $this->yystack[$this->yyidx + 0]->minor;
    }
#line 2817 "smarty_internal_templateparser.php"
#line 919 "smarty_internal_templateparser.y"
    function yy_r145(){
    $this->_retvalue  = $this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2822 "smarty_internal_templateparser.php"
#line 924 "smarty_internal_templateparser.y"
    function yy_r146(){
    if ($this->security && substr($this->yystack[$this->yyidx + -1]->minor,0,1) == '_') {
        $this->compiler->trigger_template_error (self::Err1);
    }
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2830 "smarty_internal_templateparser.php"
#line 931 "smarty_internal_templateparser.y"
    function yy_r147(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{'.$this->compileVariable($this->yystack[$this->yyidx + -1]->minor).$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2838 "smarty_internal_templateparser.php"
#line 938 "smarty_internal_templateparser.y"
    function yy_r148(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2846 "smarty_internal_templateparser.php"
#line 945 "smarty_internal_templateparser.y"
    function yy_r149(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->_retvalue = '->{\''.$this->yystack[$this->yyidx + -4]->minor.'\'.'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + 0]->minor.'}';
    }
#line 2854 "smarty_internal_templateparser.php"
#line 953 "smarty_internal_templateparser.y"
    function yy_r150(){
    $this->_retvalue = '->'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2859 "smarty_internal_templateparser.php"
#line 961 "smarty_internal_templateparser.y"
    function yy_r151(){
    if (!$this->security || $this->smarty->security_policy->isTrustedPhpFunction($this->yystack[$this->yyidx + -3]->minor, $this->compiler)) {
        if (strcasecmp($this->yystack[$this->yyidx + -3]->minor,'isset') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'empty') === 0 || strcasecmp($this->yystack[$this->yyidx + -3]->minor,'array') === 0 || is_callable($this->yystack[$this->yyidx + -3]->minor)) {
            $func_name = strtolower($this->yystack[$this->yyidx + -3]->minor);
            if ($func_name == 'isset') {
                if (count($this->yystack[$this->yyidx + -1]->minor) == 0) {
                    $this->compiler->trigger_template_error ('Illegal number of paramer in "isset()"');
                }
                $par = implode(',',$this->yystack[$this->yyidx + -1]->minor);
                if (strncasecmp($par,'$_smarty_tpl->getConfigVariable',strlen('$_smarty_tpl->getConfigVariable')) === 0) {
                    $this->prefix_number++;
                    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.str_replace(')',', false)',$par).';?>';
                    $isset_par = '$_tmp'.$this->prefix_number;
                } else {
                    $isset_par=str_replace("')->value","',null,true,false)->value",$par);
                }
                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". $isset_par .")";
            } elseif (in_array($func_name,array('empty','reset','current','end','prev','next'))){
                if (count($this->yystack[$this->yyidx + -1]->minor) != 1) {
                    $this->compiler->trigger_template_error ('Illegal number of paramer in "empty()"');
                }
                if ($func_name == 'empty') {
                    $this->_retvalue = $func_name.'('.str_replace("')->value","',null,true,false)->value",$this->yystack[$this->yyidx + -1]->minor[0]).')';
                } else {
                    $this->_retvalue = $func_name.'('.$this->yystack[$this->yyidx + -1]->minor[0].')';
                }
            } else {
                $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
            }
        } else {
            $this->compiler->trigger_template_error ("unknown function \"" . $this->yystack[$this->yyidx + -3]->minor . "\"");
        }
    }
    }
#line 2895 "smarty_internal_templateparser.php"
#line 999 "smarty_internal_templateparser.y"
    function yy_r152(){
    if ($this->security && substr($this->yystack[$this->yyidx + -3]->minor,0,1) == '_') {
        $this->compiler->trigger_template_error (self::Err1);
    }
    $this->_retvalue = $this->yystack[$this->yyidx + -3]->minor . "(". implode(',',$this->yystack[$this->yyidx + -1]->minor) .")";
    }
#line 2903 "smarty_internal_templateparser.php"
#line 1006 "smarty_internal_templateparser.y"
    function yy_r153(){
    if ($this->security) {
        $this->compiler->trigger_template_error (self::Err2);
    }
    $this->prefix_number++;
    $this->compiler->prefix_code[] = '<?php $_tmp'.$this->prefix_number.'='.$this->compileVariable("'".$this->yystack[$this->yyidx + -3]->minor."'").';?>';
    $this->_retvalue = '$_tmp'.$this->prefix_number.'('. implode(',',$this->yystack[$this->yyidx + -1]->minor) .')';
    }
#line 2913 "smarty_internal_templateparser.php"
#line 1017 "smarty_internal_templateparser.y"
    function yy_r154(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array($this->yystack[$this->yyidx + 0]->minor));
    }
#line 2918 "smarty_internal_templateparser.php"
#line 1034 "smarty_internal_templateparser.y"
    function yy_r157(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -2]->minor,array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor)));
    }
#line 2923 "smarty_internal_templateparser.php"
#line 1038 "smarty_internal_templateparser.y"
    function yy_r158(){
    $this->_retvalue = array(array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor));
    }
#line 2928 "smarty_internal_templateparser.php"
#line 1046 "smarty_internal_templateparser.y"
    function yy_r160(){
    $this->_retvalue =  array($this->yystack[$this->yyidx + 0]->minor);
    }
#line 2933 "smarty_internal_templateparser.php"
#line 1054 "smarty_internal_templateparser.y"
    function yy_r161(){
    $this->_retvalue = array_merge($this->yystack[$this->yyidx + -1]->minor,$this->yystack[$this->yyidx + 0]->minor);
    }
#line 2938 "smarty_internal_templateparser.php"
#line 1088 "smarty_internal_templateparser.y"
    function yy_r168(){
    $this->_retvalue = '$'.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2943 "smarty_internal_templateparser.php"
#line 1093 "smarty_internal_templateparser.y"
    function yy_r169(){
    $this->_retvalue = '$'.$this->yystack[$this->yyidx + -2]->minor.$this->yystack[$this->yyidx + -1]->minor.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 2948 "smarty_internal_templateparser.php"
#line 1099 "smarty_internal_templateparser.y"
    function yy_r170(){
    $this->_retvalue = '==';
    }
#line 2953 "smarty_internal_templateparser.php"
#line 1103 "smarty_internal_templateparser.y"
    function yy_r171(){
    $this->_retvalue = '!=';
    }
#line 2958 "smarty_internal_templateparser.php"
#line 1107 "smarty_internal_templateparser.y"
    function yy_r172(){
    $this->_retvalue = '>';
    }
#line 2963 "smarty_internal_templateparser.php"
#line 1111 "smarty_internal_templateparser.y"
    function yy_r173(){
    $this->_retvalue = '<';
    }
#line 2968 "smarty_internal_templateparser.php"
#line 1115 "smarty_internal_templateparser.y"
    function yy_r174(){
    $this->_retvalue = '>=';
    }
#line 2973 "smarty_internal_templateparser.php"
#line 1119 "smarty_internal_templateparser.y"
    function yy_r175(){
    $this->_retvalue = '<=';
    }
#line 2978 "smarty_internal_templateparser.php"
#line 1123 "smarty_internal_templateparser.y"
    function yy_r176(){
    $this->_retvalue = '===';
    }
#line 2983 "smarty_internal_templateparser.php"
#line 1127 "smarty_internal_templateparser.y"
    function yy_r177(){
    $this->_retvalue = '!==';
    }
#line 2988 "smarty_internal_templateparser.php"
#line 1131 "smarty_internal_templateparser.y"
    function yy_r178(){
    $this->_retvalue = '%';
    }
#line 2993 "smarty_internal_templateparser.php"
#line 1135 "smarty_internal_templateparser.y"
    function yy_r179(){
    $this->_retvalue = '&&';
    }
#line 2998 "smarty_internal_templateparser.php"
#line 1139 "smarty_internal_templateparser.y"
    function yy_r180(){
    $this->_retvalue = '||';
    }
#line 3003 "smarty_internal_templateparser.php"
#line 1143 "smarty_internal_templateparser.y"
    function yy_r181(){
    $this->_retvalue = ' XOR ';
    }
#line 3008 "smarty_internal_templateparser.php"
#line 1150 "smarty_internal_templateparser.y"
    function yy_r182(){
    $this->_retvalue = 'array('.$this->yystack[$this->yyidx + -1]->minor.')';
    }
#line 3013 "smarty_internal_templateparser.php"
#line 1158 "smarty_internal_templateparser.y"
    function yy_r184(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.','.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3018 "smarty_internal_templateparser.php"
#line 1166 "smarty_internal_templateparser.y"
    function yy_r186(){
    $this->_retvalue = $this->yystack[$this->yyidx + -2]->minor.'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3023 "smarty_internal_templateparser.php"
#line 1170 "smarty_internal_templateparser.y"
    function yy_r187(){
    $this->_retvalue = '\''.$this->yystack[$this->yyidx + -2]->minor.'\'=>'.$this->yystack[$this->yyidx + 0]->minor;
    }
#line 3028 "smarty_internal_templateparser.php"
#line 1182 "smarty_internal_templateparser.y"
    function yy_r189(){
    $this->_retvalue = "''";
    }
#line 3033 "smarty_internal_templateparser.php"
#line 1186 "smarty_internal_templateparser.y"
    function yy_r190(){
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor->to_smarty_php();
    }
#line 3038 "smarty_internal_templateparser.php"
#line 1191 "smarty_internal_templateparser.y"
    function yy_r191(){
    $this->yystack[$this->yyidx + -1]->minor->append_subtree($this->yystack[$this->yyidx + 0]->minor);
    $this->_retvalue = $this->yystack[$this->yyidx + -1]->minor;
    }
#line 3044 "smarty_internal_templateparser.php"
#line 1196 "smarty_internal_templateparser.y"
    function yy_r192(){
    $this->_retvalue = new _smarty_doublequoted($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3049 "smarty_internal_templateparser.php"
#line 1200 "smarty_internal_templateparser.y"
    function yy_r193(){
    $this->_retvalue = new _smarty_code($this, '(string)'.$this->yystack[$this->yyidx + -1]->minor);
    }
#line 3054 "smarty_internal_templateparser.php"
#line 1208 "smarty_internal_templateparser.y"
    function yy_r195(){
    $this->_retvalue = new _smarty_code($this, '(string)$_smarty_tpl->tpl_vars[\''. substr($this->yystack[$this->yyidx + 0]->minor,1) .'\']->value');
    }
#line 3059 "smarty_internal_templateparser.php"
#line 1216 "smarty_internal_templateparser.y"
    function yy_r197(){
    $this->_retvalue = new _smarty_code($this, '(string)('.$this->yystack[$this->yyidx + -1]->minor.')');
    }
#line 3064 "smarty_internal_templateparser.php"
#line 1220 "smarty_internal_templateparser.y"
    function yy_r198(){
    $this->_retvalue = new _smarty_tag($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3069 "smarty_internal_templateparser.php"
#line 1224 "smarty_internal_templateparser.y"
    function yy_r199(){
    $this->_retvalue = new _smarty_dq_content($this, $this->yystack[$this->yyidx + 0]->minor);
    }
#line 3074 "smarty_internal_templateparser.php"

    private $_retvalue;

    function yy_reduce($yyruleno)
    {
        $yymsp = $this->yystack[$this->yyidx];
        if (self::$yyTraceFILE && $yyruleno >= 0
              && $yyruleno < count(self::$yyRuleName)) {
            fprintf(self::$yyTraceFILE, "%sReduce (%d) [%s].\n",
                self::$yyTracePrompt, $yyruleno,
                self::$yyRuleName[$yyruleno]);
        }

        $this->_retvalue = $yy_lefthand_side = null;
        if (array_key_exists($yyruleno, self::$yyReduceMap)) {
            // call the action
            $this->_retvalue = null;
            $this->{'yy_r' . self::$yyReduceMap[$yyruleno]}();
            $yy_lefthand_side = $this->_retvalue;
        }
        $yygoto = self::$yyRuleInfo[$yyruleno]['lhs'];
        $yysize = self::$yyRuleInfo[$yyruleno]['rhs'];
        $this->yyidx -= $yysize;
        for($i = $yysize; $i; $i--) {
            // pop all of the right-hand side parameters
            array_pop($this->yystack);
        }
        $yyact = $this->yy_find_reduce_action($this->yystack[$this->yyidx]->stateno, $yygoto);
        if ($yyact < self::YYNSTATE) {
            if (!self::$yyTraceFILE && $yysize) {
                $this->yyidx++;
                $x = new TP_yyStackEntry;
                $x->stateno = $yyact;
                $x->major = $yygoto;
                $x->minor = $yy_lefthand_side;
                $this->yystack[$this->yyidx] = $x;
            } else {
                $this->yy_shift($yyact, $yygoto, $yy_lefthand_side);
            }
        } elseif ($yyact == self::YYNSTATE + self::YYNRULE + 1) {
            $this->yy_accept();
        }
    }

    function yy_parse_failed()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sFail!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $this->yy_pop_parser_stack();
        }
    }

    function yy_syntax_error($yymajor, $TOKEN)
    {
#line 77 "smarty_internal_templateparser.y"

    $this->internalError = true;
    $this->yymajor = $yymajor;
    $this->compiler->trigger_template_error();
#line 3137 "smarty_internal_templateparser.php"
    }

    function yy_accept()
    {
        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sAccept!\n", self::$yyTracePrompt);
        }
        while ($this->yyidx >= 0) {
            $stack = $this->yy_pop_parser_stack();
        }
#line 69 "smarty_internal_templateparser.y"

    $this->successful = !$this->internalError;
    $this->internalError = false;
    $this->retvalue = $this->_retvalue;
    //echo $this->retvalue."\n\n";
#line 3155 "smarty_internal_templateparser.php"
    }

    function doParse($yymajor, $yytokenvalue)
    {
        $yyerrorhit = 0;   /* True if yymajor has invoked an error */

        if ($this->yyidx === null || $this->yyidx < 0) {
            $this->yyidx = 0;
            $this->yyerrcnt = -1;
            $x = new TP_yyStackEntry;
            $x->stateno = 0;
            $x->major = 0;
            $this->yystack = array();
            array_push($this->yystack, $x);
        }
        $yyendofinput = ($yymajor==0);

        if (self::$yyTraceFILE) {
            fprintf(self::$yyTraceFILE, "%sInput %s\n",
                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
        }

        do {
            $yyact = $this->yy_find_shift_action($yymajor);
            if ($yymajor < self::YYERRORSYMBOL &&
                  !$this->yy_is_expected_token($yymajor)) {
                // force a syntax error
                $yyact = self::YY_ERROR_ACTION;
            }
            if ($yyact < self::YYNSTATE) {
                $this->yy_shift($yyact, $yymajor, $yytokenvalue);
                $this->yyerrcnt--;
                if ($yyendofinput && $this->yyidx >= 0) {
                    $yymajor = 0;
                } else {
                    $yymajor = self::YYNOCODE;
                }
            } elseif ($yyact < self::YYNSTATE + self::YYNRULE) {
                $this->yy_reduce($yyact - self::YYNSTATE);
            } elseif ($yyact == self::YY_ERROR_ACTION) {
                if (self::$yyTraceFILE) {
                    fprintf(self::$yyTraceFILE, "%sSyntax Error!\n",
                        self::$yyTracePrompt);
                }
                if (self::YYERRORSYMBOL) {
                    if ($this->yyerrcnt < 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $yymx = $this->yystack[$this->yyidx]->major;
                    if ($yymx == self::YYERRORSYMBOL || $yyerrorhit ){
                        if (self::$yyTraceFILE) {
                            fprintf(self::$yyTraceFILE, "%sDiscard input token %s\n",
                                self::$yyTracePrompt, $this->yyTokenName[$yymajor]);
                        }
                        $this->yy_destructor($yymajor, $yytokenvalue);
                        $yymajor = self::YYNOCODE;
                    } else {
                        while ($this->yyidx >= 0 &&
                                 $yymx != self::YYERRORSYMBOL &&
        ($yyact = $this->yy_find_shift_action(self::YYERRORSYMBOL)) >= self::YYNSTATE
                              ){
                            $this->yy_pop_parser_stack();
                        }
                        if ($this->yyidx < 0 || $yymajor==0) {
                            $this->yy_destructor($yymajor, $yytokenvalue);
                            $this->yy_parse_failed();
                            $yymajor = self::YYNOCODE;
                        } elseif ($yymx != self::YYERRORSYMBOL) {
                            $u2 = 0;
                            $this->yy_shift($yyact, self::YYERRORSYMBOL, $u2);
                        }
                    }
                    $this->yyerrcnt = 3;
                    $yyerrorhit = 1;
                } else {
                    if ($this->yyerrcnt <= 0) {
                        $this->yy_syntax_error($yymajor, $yytokenvalue);
                    }
                    $this->yyerrcnt = 3;
                    $this->yy_destructor($yymajor, $yytokenvalue);
                    if ($yyendofinput) {
                        $this->yy_parse_failed();
                    }
                    $yymajor = self::YYNOCODE;
                }
            } else {
                $this->yy_accept();
                $yymajor = self::YYNOCODE;
            }
        } while ($yymajor != self::YYNOCODE && $this->yyidx >= 0);
    }
}
?>