<?php
/*
* 2007-2015 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Open Software License (OSL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/osl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2015 PrestaShop SA
*  @license    http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class HelperKpiCore extends Helper
{
	public $base_folder = 'helpers/kpi/';
	public $base_tpl = 'kpi.tpl';
	
	public $id;
	public $icon;
	public $chart;
	public $color;
	public $title;
	public $subtitle;
	public $value;
	public $data;
	public $source;
	public $refresh = true;
	public $href;
	public $tooltip;

	public function generate()
	{
		$this->tpl = $this->createTemplate($this->base_tpl);

		$this->tpl->assign(array(
			'id' => $this->id,
			'icon' => $this->icon,
			'chart' => (bool)$this->chart,
			'color' => $this->color,
			'title' => $this->title,
			'subtitle' => $this->subtitle,
			'value' => $this->value,
			'data' => $this->data,
			'source' => $this->source,
			'refresh' => $this->refresh,
			'href' => $this->href,
			'tooltip' => $this->tooltip
		));
		return $this->tpl->fetch();
	}
}